/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.AbstractSchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.BindingContext;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronConstraintNode;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathFragment;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class SchematronSchemaOld
extends AbstractSchematronSchema
implements MessageSource {
    public SchematronSchemaOld(Model mdl, Options o, ShapeChangeResult r, PackageInfo schemaPackage, String schemaXsdBaseName, boolean segmentation) {
        super(mdl, o, r, schemaPackage, schemaXsdBaseName, segmentation);
    }

    @Override
    public void setQueryBinding(String qb) {
        this.addAttribute(this.document, this.root, "queryBinding", qb);
    }

    @Override
    public void addAssertion(ClassInfo ci, OclConstraint c) {
        if (c == null) {
            return;
        }
        if (ci.isAbstract()) {
            return;
        }
        this.currentOclConstraintName = c.name();
        this.currentOclConstraintClass = c.contextClass();
        ClassInfo stci = null;
        if (ci.suppressed() && (stci = ci.unsuppressedSupertype(this.trojanSuppressedType)) == null) {
            this.result.addError(this, 108, this.currentOclConstraintName, this.currentOclConstraintClass.name());
            return;
        }
        OclNode.Expression oclex = c.syntaxTree();
        SchematronConstraintNode scn = this.translateConstraintToSchematronNode(oclex, null, false);
        if (scn == null) {
            return;
        }
        BindingContext ctx = new BindingContext(BindingContext.CtxState.ATCURRENT);
        XpathFragment xpath = scn.translate(ctx);
        if (this.checkErrorsInXpathFragment(xpath)) {
            return;
        }
        Object text = c.name();
        String[] comments = c.comments();
        if (comments != null && comments.length > 0) {
            text = (String)text + ":";
            for (String cl : comments) {
                text = (String)text + " " + cl;
            }
        }
        if (stci == null) {
            this.addAssertion(ci, xpath, (String)text);
        } else if (!this.trojanSuppressedType) {
            this.addAssertion(stci, xpath, (String)text);
        } else {
            LinkedList<ClassInfo> eval = new LinkedList<ClassInfo>();
            eval.add(stci);
            while (!eval.isEmpty()) {
                ClassInfo cci = (ClassInfo)eval.removeFirst();
                if (cci.suppressed()) continue;
                if (!cci.isAbstract() && !cci.hasConstraint(this.currentOclConstraintName)) {
                    this.addAssertion(cci, xpath, (String)text);
                }
                SortedSet<String> subids = cci.subtypes();
                for (String subid : subids) {
                    eval.add(this.model.classById(subid));
                }
            }
        }
    }

    @Override
    public void addAssertionForPropertyConstraint(OclConstraint c, ClassInfo cib, boolean addToSubtypesInSelectedSchemas) {
        ClassInfo ci;
        OclNode.Expression oclex = c.syntaxTree();
        SchematronConstraintNode scn = this.translateConstraintToSchematronNode(oclex, null, false);
        if (scn == null) {
            return;
        }
        BindingContext ctx = new BindingContext(BindingContext.CtxState.ATCURRENT);
        XpathFragment xpath = scn.translate(ctx);
        if (this.checkErrorsInXpathFragment(xpath)) {
            return;
        }
        Object text = c.name();
        String[] comments = c.comments();
        if (comments != null && comments.length > 0) {
            text = (String)text + ":";
            for (String cl : comments) {
                text = (String)text + " " + cl;
            }
        }
        PropertyInfo pi = (PropertyInfo)c.contextModelElmt();
        ClassInfo classInfo = ci = cib != null ? cib : pi.inClass();
        if (!(ci.isAbstract() || ci.suppressed() || ci.matches("rule-xsd-all-propertyAssertion-ignoreProhibited") && "true".equalsIgnoreCase(ci.taggedValue("prohibitedInProfile")) || pi.matches("rule-xsd-all-propertyAssertion-ignoreProhibited") && "true".equalsIgnoreCase(pi.taggedValue("prohibitedInProfile")))) {
            String asserttext;
            this.registerNamespace(ci);
            this.registerNamespace(pi.inClass());
            String ruleContext = ci.qname();
            AbstractSchematronSchema.RuleCreationStatus rulecs = (AbstractSchematronSchema.RuleCreationStatus)this.ruleCreationStatusMap.get(ruleContext);
            if (rulecs == null) {
                Element rule = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "rule");
                this.pattern.appendChild(rule);
                this.addAttribute(this.document, rule, "context", ruleContext);
                rulecs = new AbstractSchematronSchema.RuleCreationStatus();
                rulecs.ruleElement = rule;
                rulecs.lastPathStatus = xpath;
                asserttext = xpath.fragment;
                this.ruleCreationStatusMap.put(ruleContext, rulecs);
            } else {
                asserttext = rulecs.lastPathStatus.merge(xpath);
            }
            if (xpath.lets != null) {
                for (Map.Entry entry : rulecs.lastPathStatus.lets.entrySet()) {
                    if (rulecs.letVarsAlreadyOutput.contains(entry.getKey())) continue;
                    Element let = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "let");
                    rulecs.ruleElement.insertBefore(let, rulecs.firstAssertElement);
                    this.addAttribute(this.document, let, "name", (String)entry.getKey());
                    this.addAttribute(this.document, let, "value", (String)entry.getValue());
                    rulecs.letVarsAlreadyOutput.add((String)entry.getKey());
                }
            }
            Element ass = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "assert");
            rulecs.ruleElement.appendChild(ass);
            if (rulecs.firstAssertElement == null) {
                rulecs.firstAssertElement = ass;
            }
            this.addAttribute(this.document, ass, "test", asserttext);
            ass.appendChild(this.document.createTextNode((String)text));
            this.assertion = true;
        }
        if (addToSubtypesInSelectedSchemas) {
            for (String subtypeId : ci.subtypes()) {
                ClassInfo subtype = this.model.classById(subtypeId);
                if (!this.model.isInSelectedSchemas(subtype)) continue;
                this.addAssertionForPropertyConstraint(c, subtype, true);
                if (this.schematronTitleExtended || subtype.pkg().targetNamespace().equalsIgnoreCase(ci.pkg().targetNamespace())) continue;
                this.schematronTitleHook.setTextContent(this.schematronTitleHook.getTextContent() + " and dependent schema(s)");
                this.schematronTitleExtended = true;
            }
        }
    }

    protected SchematronConstraintNode translateConstraintToSchematronNode(OclNode ocl, SchematronConstraintNode enclosing, boolean negate) {
        SchematronConstraintNode scn = null;
        if (ocl instanceof OclNode.Expression) {
            OclNode.Expression ex = (OclNode.Expression)ocl;
            scn = this.translateConstraintToSchematronNode(ex.expression, null, negate);
            if (scn.containsError()) {
                return null;
            }
        } else if (ocl instanceof OclNode.IterationCallExp) {
            OclNode.IterationCallExp iter = (OclNode.IterationCallExp)ocl;
            scn = this.translateConstraintIterationToSchematronNode(iter, enclosing, negate);
        } else if (ocl instanceof OclNode.OperationCallExp) {
            OclNode.OperationCallExp oper = (OclNode.OperationCallExp)ocl;
            scn = this.translateConstraintOperationToSchematronNode(oper, enclosing, negate);
        } else if (ocl instanceof OclNode.AttributeCallExp) {
            OclNode.AttributeCallExp attr = (OclNode.AttributeCallExp)ocl;
            scn = this.translateConstraintAttributeToSchematronNode(attr, enclosing, negate);
        } else if (ocl instanceof OclNode.LiteralExp) {
            OclNode.LiteralExp lit = (OclNode.LiteralExp)ocl;
            scn = this.translateConstraintLiteralToSchematronNode(lit, enclosing, negate);
        } else if (ocl instanceof OclNode.VariableExp) {
            OclNode.VariableExp var = (OclNode.VariableExp)ocl;
            scn = new SchematronConstraintNode.Variable(this, var.declaration, negate);
            if (enclosing != null) {
                enclosing.addChild(scn);
            }
        } else if (ocl instanceof OclNode.IfExp) {
            OclNode.IfExp ifex = (OclNode.IfExp)ocl;
            scn = this.translateConstraintIfExpToSchematronNode(ifex, enclosing, negate);
        } else if (ocl instanceof OclNode.LetExp) {
            OclNode.LetExp letex = (OclNode.LetExp)ocl;
            scn = this.translateConstraintLetExpToSchematronNode(letex, enclosing, negate);
        } else {
            if (ocl == null) {
                this.result.addError(this, 101, "<NULL>", this.currentOclConstraintName, this.currentOclConstraintClass.name());
            } else {
                String clname = ocl.getClass().getSimpleName();
                this.result.addError(this, 101, clname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
            }
            scn = new SchematronConstraintNode.Error(this);
        }
        return scn;
    }

    protected SchematronConstraintNode translateConstraintIterationToSchematronNode(OclNode.IterationCallExp iter, SchematronConstraintNode enclosing, boolean negate) {
        String opname = iter.selector.name;
        if (opname.equals("exists") || opname.equals("forAll")) {
            boolean isForAll = opname.equals("forAll");
            SchematronConstraintNode.Exists exists = new SchematronConstraintNode.Exists(this, iter.declarations[0], negate ^ isForAll);
            exists.addChild(this.translateConstraintToSchematronNode(iter.object, null, false));
            exists.addChild(this.translateConstraintToSchematronNode(iter.arguments[0], null, isForAll));
            if (enclosing != null) {
                enclosing.addChild(exists);
            }
            return exists;
        }
        if (opname.equals("isUnique")) {
            SchematronConstraintNode.Unique unique = new SchematronConstraintNode.Unique(this, iter.declarations[0], false);
            unique.addChild(this.translateConstraintToSchematronNode(iter.object, null, false));
            unique.addChild(this.translateConstraintToSchematronNode(iter.arguments[0], null, false));
            if (enclosing != null) {
                enclosing.addChild(unique);
            }
            return unique;
        }
        if (opname.equals("select")) {
            SchematronConstraintNode.Select select = new SchematronConstraintNode.Select(this, iter.declarations[0]);
            select.addChild(this.translateConstraintToSchematronNode(iter.object, null, false));
            select.addChild(this.translateConstraintToSchematronNode(iter.arguments[0], null, false));
            if (enclosing != null) {
                enclosing.addChild(select);
            }
            return select;
        }
        this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
        return new SchematronConstraintNode.Error(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected SchematronConstraintNode translateConstraintOperationToSchematronNode(OclNode.OperationCallExp oper, SchematronConstraintNode enclosing, boolean negate) {
        String name;
        block35: {
            String[] invops;
            String[] relops;
            String opname;
            block36: {
                block34: {
                    opname = oper.selector.name;
                    if (opname.equals("implies")) {
                        boolean passencl;
                        boolean and = false;
                        boolean neg1 = true;
                        boolean neg2 = false;
                        if (negate) {
                            and = !and;
                            neg1 = !neg1;
                            neg2 = !neg2;
                        }
                        boolean bl = passencl = enclosing != null && enclosing.isAndOrLogic(and);
                        SchematronConstraintNode scn = passencl ? enclosing : new SchematronConstraintNode.Logic(this, and ? SchematronConstraintNode.Logic.LogicType.AND : SchematronConstraintNode.Logic.LogicType.OR);
                        this.translateConstraintToSchematronNode(oper.object, scn, neg1);
                        this.translateConstraintToSchematronNode(oper.arguments[0], scn, neg2);
                        if (passencl) return scn;
                        if (enclosing == null) return scn;
                        enclosing.addChild(scn);
                        return scn;
                    }
                    if (opname.equals("and") || opname.equals("or")) {
                        boolean passencl;
                        boolean and = opname.equals("and");
                        boolean neg = false;
                        if (negate) {
                            and = !and;
                            neg = !neg;
                        }
                        boolean bl = passencl = enclosing != null && enclosing.isAndOrLogic(and);
                        SchematronConstraintNode scn = passencl ? enclosing : new SchematronConstraintNode.Logic(this, and ? SchematronConstraintNode.Logic.LogicType.AND : SchematronConstraintNode.Logic.LogicType.OR);
                        this.translateConstraintToSchematronNode(oper.object, scn, neg);
                        this.translateConstraintToSchematronNode(oper.arguments[0], scn, neg);
                        if (passencl) return scn;
                        if (enclosing == null) return scn;
                        enclosing.addChild(scn);
                        return scn;
                    }
                    if (opname.equals("xor")) {
                        SchematronConstraintNode.Logic.LogicType xor = SchematronConstraintNode.Logic.LogicType.XOR;
                        if (negate) {
                            xor = SchematronConstraintNode.Logic.LogicType.EQV;
                        }
                        SchematronConstraintNode.Logic fcn = new SchematronConstraintNode.Logic(this, xor);
                        fcn.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                        fcn.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                        if (enclosing == null) return fcn;
                        enclosing.addChild(fcn);
                        return fcn;
                    }
                    if (opname.equals("not")) {
                        boolean bl;
                        OclNode oclNode = oper.object;
                        if (!negate) {
                            bl = true;
                            return this.translateConstraintToSchematronNode(oclNode, enclosing, bl);
                        }
                        bl = false;
                        return this.translateConstraintToSchematronNode(oclNode, enclosing, bl);
                    }
                    if ("<>=<=".indexOf(opname) < 0) break block34;
                    relops = new String[]{"=", "<>", "<", "<=", ">", ">="};
                    invops = new String[]{"<>", "=", ">=", ">", "<=", "<"};
                    name = opname;
                    if (!negate) break block35;
                    break block36;
                }
                if (opname.equals("notEmpty") || opname.equals("isEmpty")) {
                    SchematronConstraintNode.Empty empty = new SchematronConstraintNode.Empty(this, opname.equals("notEmpty") ^ negate);
                    empty.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    if (enclosing == null) return empty;
                    enclosing.addChild(empty);
                    return empty;
                }
                if (opname.equals("size")) {
                    boolean setoper = oper.selector.category == OclNode.PropertyCategory.SETOPER;
                    SchematronConstraintNode.Size size = new SchematronConstraintNode.Size(this, setoper);
                    size.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    return size;
                }
                if (opname.equals("concat")) {
                    SchematronConstraintNode.Concatenate concat = new SchematronConstraintNode.Concatenate(this);
                    concat.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    concat.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    return concat;
                }
                if (opname.equals("substring")) {
                    SchematronConstraintNode.Substring substr = new SchematronConstraintNode.Substring(this);
                    substr.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    substr.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    substr.addChild(this.translateConstraintToSchematronNode(oper.arguments[1], null, false));
                    return substr;
                }
                if (opname.equals("matches")) {
                    if (this.extensionFunctions.get("matches") == null) {
                        this.result.addError(this, 107, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                        return new SchematronConstraintNode.Error(this);
                    }
                    SchematronConstraintNode.Matches matches = new SchematronConstraintNode.Matches(this);
                    matches.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    matches.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    if (enclosing == null) return matches;
                    enclosing.addChild(matches);
                    return matches;
                }
                if (opname.equals("length") || opname.equals("area")) {
                    this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                    return new SchematronConstraintNode.Error(this);
                }
                if (opname.equals("toUpper") || opname.equals("toLower")) {
                    this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                    return new SchematronConstraintNode.Error(this);
                }
                if ("+-*/".indexOf(opname) >= 0) {
                    SchematronConstraintNode.Arithmetic arith = new SchematronConstraintNode.Arithmetic(this, opname);
                    arith.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    if (oper.arguments.length <= 0) return arith;
                    arith.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    return arith;
                }
                if (opname.equals("oclIsKindOf") || opname.equals("oclIsTypeOf")) {
                    boolean exactType = opname.equals("oclIsTypeOf");
                    SchematronConstraintNode.KindOf kindOf = new SchematronConstraintNode.KindOf(this, exactType, negate);
                    kindOf.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    SchematronConstraintNode clex = this.translateConstraintToSchematronNode(oper.arguments[0], null, false);
                    boolean assumeError = true;
                    if (clex instanceof SchematronConstraintNode.Literal) {
                        SchematronConstraintNode.Literal cllit = (SchematronConstraintNode.Literal)clex;
                        OclNode.LiteralExp lex = cllit.literal;
                        if (lex instanceof OclNode.ClassLiteralExp) {
                            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lex;
                            ClassInfo ci = lcl.umlClass;
                            kindOf.setClass(ci);
                            assumeError = false;
                        }
                    }
                    kindOf.addChild(clex);
                    if (assumeError) {
                        this.result.addError(this, 104, this.currentOclConstraintName, this.currentOclConstraintClass.name(), "oclIsKindOf");
                        SchematronConstraintNode.Error err = new SchematronConstraintNode.Error(this);
                        if (enclosing == null) return err;
                        enclosing.addChild(err);
                        return err;
                    }
                    if (enclosing == null) return kindOf;
                    enclosing.addChild(kindOf);
                    return kindOf;
                }
                if (opname.equals("oclAsType")) {
                    SchematronConstraintNode.Cast cast = new SchematronConstraintNode.Cast(this);
                    cast.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    SchematronConstraintNode clex = this.translateConstraintToSchematronNode(oper.arguments[0], null, false);
                    boolean assumeError = true;
                    if (clex instanceof SchematronConstraintNode.Literal) {
                        SchematronConstraintNode.Literal cllit = (SchematronConstraintNode.Literal)clex;
                        OclNode.LiteralExp lex = cllit.literal;
                        if (lex instanceof OclNode.ClassLiteralExp) {
                            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lex;
                            ClassInfo ci = lcl.umlClass;
                            cast.setClass(ci);
                            assumeError = false;
                        }
                    }
                    cast.addChild(clex);
                    if (assumeError) {
                        this.result.addError(this, 104, this.currentOclConstraintName, this.currentOclConstraintClass.name(), "oclAsType");
                        SchematronConstraintNode.Error err = new SchematronConstraintNode.Error(this);
                        if (enclosing == null) return err;
                        enclosing.addChild(err);
                        return err;
                    }
                    if (enclosing == null) return cast;
                    enclosing.addChild(cast);
                    return cast;
                }
                if (opname.equals("allInstances")) {
                    SchematronConstraintNode clex = this.translateConstraintToSchematronNode(oper.object, null, false);
                    boolean assumeError = true;
                    ClassInfo ci = null;
                    if (clex instanceof SchematronConstraintNode.Literal) {
                        SchematronConstraintNode.Literal cllit = (SchematronConstraintNode.Literal)clex;
                        OclNode.LiteralExp lex = cllit.literal;
                        if (lex instanceof OclNode.ClassLiteralExp) {
                            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lex;
                            ci = lcl.umlClass;
                            if (ci != null) {
                                assumeError = false;
                            }
                        }
                    }
                    if (assumeError) {
                        this.result.addError(this, 105, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                        SchematronConstraintNode.Error err = new SchematronConstraintNode.Error(this);
                        if (enclosing == null) return err;
                        enclosing.addChild(err);
                        return err;
                    }
                    SchematronConstraintNode.AllInstances allinst = new SchematronConstraintNode.AllInstances(this, ci, negate);
                    if (enclosing == null) return allinst;
                    enclosing.addChild(allinst);
                    return allinst;
                }
                if (opname.equals("propertyMetadata")) {
                    SchematronConstraintNode.PropertyMetadata pm = new SchematronConstraintNode.PropertyMetadata(this, oper.object.dataType.metadataType, negate);
                    pm.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    if (enclosing == null) return pm;
                    enclosing.addChild(pm);
                    return pm;
                }
                if (!opname.startsWith("error_")) {
                    this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                    return new SchematronConstraintNode.Error(this);
                }
                SchematronConstraintNode.MessageComment msgcom = new SchematronConstraintNode.MessageComment(this, opname);
                OclNode[] oclNodeArray = oper.arguments;
                int n = oclNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OclNode arg = oclNodeArray[n2];
                    msgcom.addChild(this.translateConstraintToSchematronNode(arg, null, false));
                    ++n2;
                }
                return msgcom;
            }
            for (int i = 0; i < relops.length; ++i) {
                if (!relops[i].equals(opname)) continue;
                name = invops[i];
                break;
            }
        }
        SchematronConstraintNode.Comparison scn = new SchematronConstraintNode.Comparison(this, name);
        scn.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
        scn.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
        if (enclosing == null) return scn;
        enclosing.addChild(scn);
        return scn;
    }

    protected SchematronConstraintNode translateConstraintAttributeToSchematronNode(OclNode.AttributeCallExp attr, SchematronConstraintNode enclosing, boolean negate) {
        SchematronConstraintNode objnode;
        PropertyInfo pi;
        boolean nilreason;
        String attrname = attr.selector.name;
        int absorptionType = 0;
        Info info = attr.selector.modelProperty;
        if (info instanceof PropertyInfo && (nilreason = (pi = (PropertyInfo)info).implementedByNilReason())) {
            absorptionType = 2;
        }
        if ((objnode = this.translateConstraintToSchematronNode(attr.object, null, false)) instanceof SchematronConstraintNode.Variable || objnode instanceof SchematronConstraintNode.AllInstances || objnode instanceof SchematronConstraintNode.Select || objnode instanceof SchematronConstraintNode.PropertyMetadata) {
            SchematronConstraintNode.Attribute atn = objnode.generatingAttribute();
            if (atn != null && atn.isPropertyAbsorbing()) {
                if (absorptionType == 0) {
                    absorptionType = 1;
                }
                atn.appendAbsorbedAttribute(absorptionType, attr);
                return objnode;
            }
            atn = new SchematronConstraintNode.Attribute(this, attr, negate);
            atn.addChild(objnode);
            if (enclosing != null) {
                enclosing.addChild(atn);
            }
            return atn;
        }
        if (objnode instanceof SchematronConstraintNode.Attribute) {
            SchematronConstraintNode.Attribute atn = (SchematronConstraintNode.Attribute)objnode;
            if (atn.isPropertyAbsorbing()) {
                if (absorptionType == 0) {
                    absorptionType = 1;
                }
                atn.appendAbsorbedAttribute(absorptionType, attr);
            } else {
                atn.appendAttribute(attr);
            }
            if (enclosing != null) {
                enclosing.addChild(atn);
            }
            return atn;
        }
        if (objnode instanceof SchematronConstraintNode.Cast) {
            SchematronConstraintNode.Attribute atn = new SchematronConstraintNode.Attribute(this, attr, negate);
            atn.addChild(objnode);
            if (enclosing != null) {
                enclosing.addChild(atn);
            }
            return atn;
        }
        this.result.addError(this, 106, attrname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
        return new SchematronConstraintNode.Error(this);
    }

    protected SchematronConstraintNode translateConstraintLiteralToSchematronNode(OclNode.LiteralExp lit, SchematronConstraintNode enclosing, boolean negate) {
        if (lit instanceof OclNode.ClassLiteralExp) {
            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lit;
            ClassInfo ci = lcl.umlClass;
            if (ci.suppressed()) {
                this.result.addError(this, 109, this.currentOclConstraintName, this.currentOclConstraintClass.name(), ci.name());
                return new SchematronConstraintNode.Error(this);
            }
        }
        SchematronConstraintNode.Literal litn = new SchematronConstraintNode.Literal(this, lit, negate);
        if (enclosing != null) {
            enclosing.addChild(litn);
        }
        return litn;
    }

    protected SchematronConstraintNode translateConstraintIfExpToSchematronNode(OclNode.IfExp ifex, SchematronConstraintNode enclosing, boolean negate) {
        SchematronConstraintNode.IfThenElse ifthenelse = new SchematronConstraintNode.IfThenElse(this);
        ifthenelse.addChild(this.translateConstraintToSchematronNode(ifex.condition, null, false));
        OclNode[] branch = new OclNode[]{ifex.ifExpression, ifex.elseExpression};
        int is = negate ? 1 : 0;
        for (int i = 0; i < 2; ++i) {
            ifthenelse.addChild(this.translateConstraintToSchematronNode(branch[is], null, false));
            is = 1 - is;
        }
        if (enclosing != null) {
            enclosing.addChild(ifthenelse);
        }
        return ifthenelse;
    }

    protected SchematronConstraintNode translateConstraintLetExpToSchematronNode(OclNode.LetExp letex, SchematronConstraintNode enclosing, boolean negate) {
        SchematronConstraintNode.Let let = new SchematronConstraintNode.Let(this, letex.declarations);
        for (OclNode.Declaration dcl : letex.declarations) {
            OclNode val = dcl.initialValue;
            let.addChild(this.translateConstraintToSchematronNode(val, null, false));
        }
        let.addChild(this.translateConstraintToSchematronNode(letex.body, null, negate));
        if (enclosing != null) {
            enclosing.addChild(let);
        }
        return let;
    }

    private boolean checkErrorsInXpathFragment(XpathFragment xpath) {
        Object allofit = "";
        if (xpath.lets != null) {
            for (String let : xpath.lets.values()) {
                allofit = (String)allofit + let;
            }
        }
        allofit = (String)allofit + xpath.fragment;
        Pattern p = Pattern.compile("\\*\\*\\*ERROR\\[(.*?)\\]\\*\\*\\*");
        Matcher m = p.matcher((CharSequence)allofit);
        int count = 0;
        while (m.find()) {
            ++count;
            String argsl = m.group(1);
            String[] args = argsl.split(",");
            int mnr = Integer.parseInt(args[0]);
            if (args.length == 1) {
                this.result.addError(this, mnr, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                continue;
            }
            if (args.length < 2) continue;
            this.result.addError(this, mnr, this.currentOclConstraintName, this.currentOclConstraintClass.name(), args[1]);
        }
        return count > 0;
    }

    @Override
    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "Schematron Target: " + mess;
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 101: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Node class \"$1$\" not implemented.";
            }
            case 102: {
                return "Failure to compile OCL constraint named \"$1$\" in class \"$2$\". Codelist named \"$3$\" being translated according to GML 3.3 rules, but \"codeList\" tagged value is not present";
            }
            case 103: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Operation \"$1$\" not implemented.";
            }
            case 104: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\": the argument to operator \"$3$\" must be a class constant.";
            }
            case 105: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\": the object of operator \"allInstances\" must be a class constant.";
            }
            case 106: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Attribute construct named \"$1$\" not implemented.";
            }
            case 107: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Schematron extension operation \"$1$\" is not properly configured.";
            }
            case 108: {
                return "OCL constraint named \"$1$\" in suppressed class \"$2$\" cannot uniquely be attributed to any superclass.";
            }
            case 109: {
                return "OCL constraint named \"$1$\" in class \"$2$\" contains a class constant refering to a suppressed class \"$3$\".";
            }
            case 121: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" attribute access expressions in isUnique() bodies must not contain attributes with a cardinality > 1.";
            }
            case 122: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" isUnique bodies must not contain expressions other than constants, identity or attribute access.";
            }
            case 123: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" toUpper() or toLower() CharacterString operations are not supported by Xpath 1.0.";
            }
            case 124: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" variable \"$3$\" used in nested iterator construct cannot be resolved due to limitations of Xpath 1.0.";
            }
            case 125: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" 'current date' OCL extension cannot be expressed in Xpath 1.0.";
            }
            case 126: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" comparison between structured non-object types not supported.";
            }
            case 127: {
                return "??Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" nested byReference property \"$3$\" in iterator construct cannot be resolved due to limitations of Xpath 1.0 (variables inside XPath expression not supported).";
            }
            case 128: {
                return "??Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" propertyMetadata() in iterator construct cannot be resolved due to limitations of Xpath 1.0 (variables inside XPath expression not supported).";
            }
            case 131: {
                return "";
            }
        }
        return null;
    }
}

