/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.AbstractSchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.BindingContext;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathFragment;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathType;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SchematronConstraintNodeXslt2 {
    protected ArrayList<SchematronConstraintNodeXslt2> children = new ArrayList();
    protected boolean negated = false;
    protected SchematronConstraintNodeXslt2 parent = null;
    protected AbstractSchematronSchema schemaObject = null;

    public void addChild(SchematronConstraintNodeXslt2 child) {
        this.children.add(child);
        child.parent = this;
    }

    public boolean isAndOrLogic(boolean isAnd) {
        return false;
    }

    public boolean isDependentOn(OclNode.Declaration vardecl) {
        for (SchematronConstraintNodeXslt2 scn : this.children) {
            if (!scn.isDependentOn(vardecl)) continue;
            return true;
        }
        return false;
    }

    public SchematronConstraintNodeXslt2 nodeVariableIsBoundTo(OclNode.Declaration vardecl) {
        return null;
    }

    public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
        return false;
    }

    public Attribute generatingAttribute() {
        return null;
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean hasSimpleType() {
        return true;
    }

    public boolean hasIdentity() {
        return false;
    }

    private static boolean isInstantiable(ClassInfo ci) {
        return !ci.isAbstract() && (!ci.suppressed() || !ci.matches("rule-xsd-cls-suppress"));
    }

    protected boolean isAttributeWithVariableSelfAsSource(SchematronConstraintNodeXslt2 node) {
        if (node instanceof Attribute) {
            Attribute att = (Attribute)node;
            SchematronConstraintNodeXslt2 source = (SchematronConstraintNodeXslt2)att.children.get(0);
            if (source instanceof Variable && ((Variable)source).getName().equalsIgnoreCase("self")) {
                return true;
            }
        }
        return false;
    }

    protected boolean isSimpleType(ClassInfo ci, String ciName) {
        boolean isSimple = false;
        if (ci != null) {
            Boolean indicatorSimpleType = XmlSchema.indicatorForObjectElementWithSimpleContent(ci);
            isSimple = !XmlSchema.classHasObjectElement(ci) || indicatorSimpleType != null && indicatorSimpleType != false;
        } else {
            String tname = ciName;
            String er = this.schemaObject.currentOclConstraintClass.encodingRule("xsd");
            MapEntry me = this.schemaObject.options.typeMapEntry(tname, er);
            if (me != null) {
                isSimple = me.p2.equalsIgnoreCase("simple/simple") || me.p2.equalsIgnoreCase("complex/simple");
            }
        }
        return isSimple;
    }

    private static SortedSet<ClassInfo> getInstantiableSubtypesInCompleteHierarchy(ClassInfo ci) {
        TreeSet<ClassInfo> instantiableClasses = new TreeSet<ClassInfo>();
        for (ClassInfo st : ci.subtypesInCompleteHierarchy()) {
            if (!SchematronConstraintNodeXslt2.isInstantiable(st)) continue;
            instantiableClasses.add(st);
        }
        return instantiableClasses;
    }

    private static Pair<String, Integer> getExpressionForTypeRestriction(SortedSet<ClassInfo> cis) {
        Object fragment = "";
        Integer priority = -1;
        boolean surroundWithBrackets = cis.size() > 1;
        boolean first = true;
        for (ClassInfo ci : cis) {
            String xmlElement;
            String[] parts;
            if (!first) {
                fragment = (String)fragment + " or ";
            }
            first = false;
            String namespace = ci.pkg().targetNamespace();
            String localName = ci.name();
            MapEntry me = ci.options().elementMapEntry(ci.name(), ci.encodingRule("xsd"));
            if (me != null && StringUtils.isNotBlank((CharSequence)me.p1) && (parts = (xmlElement = me.p1).split(":")).length > 1) {
                String nspref = parts[0];
                String ns = ci.options().fullNamespace(nspref);
                if (ns != null) {
                    namespace = ns;
                    localName = parts[1];
                }
            }
            if (surroundWithBrackets) {
                fragment = (String)fragment + "(";
            }
            fragment = (String)fragment + "local-name()='" + localName + "' and namespace-uri()='" + namespace + "'";
            if (!surroundWithBrackets) continue;
            fragment = (String)fragment + ")";
        }
        if (cis.isEmpty()) {
            fragment = (String)fragment + "false()";
            priority = 20;
        } else {
            priority = cis.size() == 1 ? Integer.valueOf(5) : Integer.valueOf(4);
        }
        return new ImmutablePair(fragment, (Object)priority);
    }

    public boolean containsError() {
        if (this instanceof Error) {
            return true;
        }
        for (SchematronConstraintNodeXslt2 node : this.children) {
            if (!node.containsError()) continue;
            return true;
        }
        return false;
    }

    public abstract XpathFragment translate(BindingContext var1);

    public static class MessageComment
    extends SchematronConstraintNodeXslt2 {
        protected String name = null;

        public MessageComment(AbstractSchematronSchema schemaObject, String name) {
            this.schemaObject = schemaObject;
            this.name = name;
        }

        public String getErrorNumber() {
            return this.name.substring(6);
        }

        public String[] compileAsMessageArgumentList() {
            String[] arglist = new String[this.children.size()];
            int i = 0;
            for (SchematronConstraintNodeXslt2 arg : this.children) {
                XpathFragment sql = arg.translate(null);
                arglist[i++] = sql.fragment == null ? "*ERROR*" : sql.fragment;
            }
            return arglist;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class Error
    extends SchematronConstraintNodeXslt2 {
        public Error(AbstractSchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class Let
    extends SchematronConstraintNodeXslt2 {
        OclNode.Declaration[] vardecls;
        BindingContext letctx;

        public Let(AbstractSchematronSchema schemaObject, OclNode.Declaration[] vardecls) {
            this.schemaObject = schemaObject;
            this.vardecls = vardecls;
        }

        @Override
        public SchematronConstraintNodeXslt2 nodeVariableIsBoundTo(OclNode.Declaration vardecl) {
            int idx = 0;
            for (OclNode.Declaration dcl : this.vardecls) {
                if (dcl == vardecl) {
                    return (SchematronConstraintNodeXslt2)this.children.get(idx);
                }
                ++idx;
            }
            return null;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 body = (SchematronConstraintNodeXslt2)this.children.get(this.children.size() - 1);
            this.letctx = ctx;
            XpathFragment xpt = body.translate(ctx);
            return xpt;
        }
    }

    public static class IfThenElse
    extends SchematronConstraintNodeXslt2 {
        public IfThenElse(AbstractSchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public boolean hasSimpleType() {
            return ((SchematronConstraintNodeXslt2)this.children.get(1)).hasSimpleType() && ((SchematronConstraintNodeXslt2)this.children.get(2)).hasSimpleType();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 con = (SchematronConstraintNodeXslt2)this.children.get(0);
            SchematronConstraintNodeXslt2 thn = (SchematronConstraintNodeXslt2)this.children.get(1);
            SchematronConstraintNodeXslt2 els = (SchematronConstraintNodeXslt2)this.children.get(2);
            XpathFragment xptcon = con.translate(ctx);
            XpathFragment xptthn = thn.translate(ctx);
            XpathFragment xptels = els.translate(ctx);
            String elsepart = xptcon.merge(xptels);
            String thenpart = xptcon.merge(xptthn);
            xptcon.fragment = "if (" + xptcon.fragment + ") then " + thenpart + " else " + elsepart;
            xptcon.priority = 3;
            xptcon.type = xptthn.type == xptels.type ? xptthn.type : XpathType.UNDEFINED;
            return xptcon;
        }
    }

    public static class Literal
    extends SchematronConstraintNodeXslt2 {
        OclNode.LiteralExp literal;

        public Literal(AbstractSchematronSchema schemaObject, OclNode.LiteralExp lit, boolean neg) {
            this.schemaObject = schemaObject;
            this.literal = lit;
            this.negated = neg;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            Object value = this.literal.asString();
            XpathType type = XpathType.STRING;
            if (this.literal instanceof OclNode.StringLiteralExp) {
                value = "'" + (String)value + "'";
            } else if (this.literal instanceof OclNode.EnumerationLiteralExp) {
                OclNode.EnumerationLiteralExp litex = (OclNode.EnumerationLiteralExp)this.literal;
                ClassInfo ci = litex.dataType.umlClass;
                if (ci != null && ci.name().equals("Boolean")) {
                    boolean val = ((String)value).equalsIgnoreCase("TRUE");
                    if (this.negated) {
                        val = !val;
                    }
                    value = val ? "true()" : "false()";
                    type = XpathType.BOOLEAN;
                } else {
                    boolean iscodelist = ci != null && ci.category() == 2;
                    String clUri = "";
                    String clVPat = "{value}";
                    if (iscodelist) {
                        String uri = ci.taggedValue("codeList");
                        if (StringUtils.isNotBlank((CharSequence)uri)) {
                            clVPat = "{codeList}/{value}";
                            clUri = uri;
                        }
                        clVPat = this.schemaObject.determineCodeListValuePattern(ci, clVPat);
                    }
                    clVPat = clVPat.replace("{value}", (CharSequence)value);
                    value = clVPat.replace("{codeList}", clUri);
                    value = "'" + (String)value + "'";
                }
            } else if (this.literal instanceof OclNode.BooleanLiteralExp) {
                OclNode.BooleanLiteralExp lit = (OclNode.BooleanLiteralExp)this.literal;
                boolean val = lit.value;
                if (this.negated) {
                    val = !val;
                }
                value = val ? "true()" : "false()";
                type = XpathType.BOOLEAN;
            } else if (this.literal instanceof OclNode.IntegerLiteralExp || this.literal instanceof OclNode.RealLiteralExp) {
                type = XpathType.NUMBER;
            } else if (this.literal instanceof OclNode.DateTimeLiteralExp) {
                OclNode.DateTimeLiteralExp lt = (OclNode.DateTimeLiteralExp)this.literal;
                if (lt.current) {
                    value = "***ERROR[125]***";
                } else {
                    GregorianCalendar dt = lt.dateTime;
                    int y = dt.get(1);
                    int m = dt.get(2) + 1;
                    int d = dt.get(5);
                    value = String.format("'%04d-%02d-%02d'", y, m, d);
                }
                type = XpathType.BOOLEAN;
            } else if (this.literal instanceof OclNode.OclVoidLiteralExp) {
                value = "/*[false()]";
                type = XpathType.NODESET;
            }
            XpathFragment xpt = new XpathFragment(20, (String)value, type);
            return xpt;
        }
    }

    public static class Attribute
    extends SchematronConstraintNodeXslt2 {
        protected AttrComp[] attributes;

        public Attribute(AbstractSchematronSchema schemaObject, OclNode.AttributeCallExp attr, boolean negated) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[]{new AttrComp(attr)};
            this.negated = negated;
        }

        public Attribute(AbstractSchematronSchema schemaObject, AttrComp atc, boolean negated) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[]{new AttrComp(atc)};
            this.negated = negated;
        }

        public void appendAttribute(OclNode.AttributeCallExp aex) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(aex);
            this.attributes = attribs;
        }

        public void appendAttribute(AttrComp atc) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(atc);
            this.attributes = attribs;
        }

        public void appendAbsorbedAttribute(int absorptionType, OclNode.AttributeCallExp attr) {
            int last = this.attributes.length - 1;
            this.attributes[last].absAttr = attr;
            this.attributes[last].absType = absorptionType;
        }

        public Attribute splitBefore(int at) {
            if (at < 0 || at >= this.attributes.length) {
                return null;
            }
            Attribute atrite = new Attribute(this.schemaObject, this.attributes[at], this.negated);
            for (int i = at + 1; i < this.attributes.length; ++i) {
                this.appendAttribute(this.attributes[i]);
            }
            if (at == 0) {
                atrite.addChild((SchematronConstraintNodeXslt2)this.children.get(0));
            } else {
                Attribute atleft = new Attribute(this.schemaObject, this.attributes[0], this.negated);
                for (int i = 1; i < at; ++i) {
                    this.appendAttribute(this.attributes[i]);
                }
                atleft.addChild((SchematronConstraintNodeXslt2)this.children.get(0));
                atrite.addChild(atleft);
            }
            return atrite;
        }

        public boolean isPropertyAbsorbing() {
            AttrComp ac = this.attributes[this.attributes.length - 1];
            OclNode.AttributeCallExp acex = ac.absType == 0 ? ac.main : ac.absAttr;
            PropertyInfo pi = (PropertyInfo)acex.selector.modelProperty;
            Type t = pi.typeInfo();
            ClassInfo ci = this.schemaObject.model.classById(t.id);
            return ci != null && ci.isUnionDirect();
        }

        @Override
        public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
            return ((SchematronConstraintNodeXslt2)this.children.get(0)).isVarOrAttribBased(vardecl);
        }

        @Override
        public Attribute generatingAttribute() {
            return this;
        }

        @Override
        public boolean isMultiple() {
            for (AttrComp at : this.attributes) {
                if (at.main.multMapping != OclNode.MultiplicityMapping.ONE2MANY && (at.absType != 1 || at.absAttr.multMapping != OclNode.MultiplicityMapping.ONE2MANY)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasSimpleType() {
            int last = this.attributes.length - 1;
            return this.hasSimpleType(last);
        }

        public boolean hasSimpleType(int idx) {
            boolean result = true;
            OclNode.DataType dt = null;
            switch (this.attributes[idx].absType) {
                case 0: {
                    dt = this.attributes[idx].main.dataType;
                    result = this.isSimpleType(dt.umlClass, dt.name);
                    break;
                }
                case 1: {
                    dt = this.attributes[idx].absAttr.dataType;
                    result = this.isSimpleType(dt.umlClass, dt.name);
                    break;
                }
            }
            return result;
        }

        @Override
        public boolean hasIdentity() {
            int last = this.attributes.length - 1;
            return this.hasIdentity(last);
        }

        public boolean hasIdentity(int idx) {
            boolean result = false;
            switch (this.attributes[idx].absType) {
                case 0: {
                    ClassInfo ci = this.attributes[idx].main.dataType.umlClass;
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
                case 1: {
                    ClassInfo ci = this.attributes[idx].absAttr.dataType.umlClass;
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
            }
            return result;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            PropertyInfo[] props = new PropertyInfo[this.attributes.length];
            for (int i = 0; i < props.length; ++i) {
                props[i] = (PropertyInfo)this.attributes[i].main.selector.modelProperty;
            }
            SchematronConstraintNodeXslt2 objnode = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = objnode.translate(ctx);
            if (xpt.fragment.length() > 0 && xpt.priority < 18) {
                xpt.bracket();
            }
            String alpha = this.schemaObject.alpha;
            String beta = this.schemaObject.beta;
            boolean alphaEx = StringUtils.isNotBlank((CharSequence)alpha);
            boolean betaEx = StringUtils.isNotBlank((CharSequence)beta);
            boolean lastWasSimple = objnode.hasSimpleType();
            String forExprVariablePrefix = "VAR";
            int forExprVariableCounter = 0;
            Object lastForExprVariable = xpt.fragment.isEmpty() ? "current()" : xpt.fragment;
            Object fragmentForInlinePropertySequence = "";
            xpt.fragment = "";
            int countForExpr = 0;
            for (int idx = 0; idx < props.length && !lastWasSimple; ++idx) {
                PropertyInfo pi = props[idx];
                int conCode = this.getContainmentCode(idx, pi);
                boolean isPropertyMetadataAccess = ctx.propertyMetadataAccess && idx == props.length - 1;
                String typeCiId = pi.typeInfo().id;
                ClassInfo typeCi = null;
                if (typeCiId != null) {
                    typeCi = pi.model().classById(typeCiId);
                }
                if (this.attributes[idx].absType == 1) {
                    typeCi = this.attributes[idx].absAttr.dataType.umlClass;
                }
                if (!((String)fragmentForInlinePropertySequence).isEmpty()) {
                    if (isPropertyMetadataAccess || conCode == 0) {
                        xpt.fragment = xpt.fragment + (String)(((String)lastForExprVariable).isEmpty() ? "" : (String)lastForExprVariable + "/") + (String)fragmentForInlinePropertySequence;
                        lastForExprVariable = "";
                        fragmentForInlinePropertySequence = "";
                    } else if (conCode > 1) {
                        String newForExprVar = "$" + forExprVariablePrefix + ++forExprVariableCounter;
                        xpt.fragment = xpt.fragment + "(for " + newForExprVar + " in " + (String)(((String)lastForExprVariable).isEmpty() ? "" : (String)lastForExprVariable + "/") + (String)fragmentForInlinePropertySequence + " return ";
                        lastForExprVariable = newForExprVar;
                        fragmentForInlinePropertySequence = "";
                        ++countForExpr;
                    }
                } else if ((isPropertyMetadataAccess || conCode == 0) && !((String)lastForExprVariable).isEmpty()) {
                    xpt.fragment = xpt.fragment + (String)lastForExprVariable;
                    lastForExprVariable = "";
                }
                String propertyQName = this.schemaObject.getAndRegisterXmlName(pi);
                boolean is19139 = pi.matches("rule-xsd-all-naming-19139") || typeCi != null && typeCi.matches("rule-xsd-cls-standard-19139-property-types");
                boolean piIsGml33Encoded = pi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33");
                if (isPropertyMetadataAccess) {
                    xpt.fragment = xpt.fragment + "/" + propertyQName;
                    continue;
                }
                if (conCode == 0) {
                    if (xpt.fragment.length() > 0) {
                        xpt.fragment = xpt.fragment + "/";
                    }
                    xpt.fragment = xpt.fragment + propertyQName;
                    boolean iscodelist = typeCi != null && typeCi.category() == 2 && (typeCi.matches("rule-xsd-cls-codelist-asDictionaryGml33") && typeCi.asDictionaryGml33() || typeCi.matches("rule-xsd-cls-codelist-asDictionary") && typeCi.asDictionary() || typeCi.matches("rule-xsd-cls-standard-19139-property-types"));
                    Object clvpat = "{value}";
                    if (typeCi != null && iscodelist && !piIsGml33Encoded) {
                        String uri = typeCi.taggedValue("codeList");
                        if (StringUtils.isNotBlank((CharSequence)uri)) {
                            clvpat = "{codeList}/{value}";
                        }
                        clvpat = this.schemaObject.determineCodeListValuePattern(typeCi, (String)clvpat);
                        clvpat = ((String)clvpat).replace("{codeList}", "',{codeList},'");
                        if (((String)(clvpat = ((String)clvpat).replace("{value}", "',{value},'"))).startsWith("',")) {
                            clvpat = ((String)clvpat).substring(2);
                        }
                        if (((String)clvpat).endsWith(",'")) {
                            clvpat = ((String)clvpat).substring(0, ((String)clvpat).length() - 2);
                        }
                        if (!((String)clvpat).startsWith("{")) {
                            clvpat = "'" + (String)clvpat;
                        }
                        if (!((String)clvpat).endsWith("}")) {
                            clvpat = (String)clvpat + "'";
                        }
                        if (!((String)clvpat).equals("{value}")) {
                            clvpat = "concat(" + (String)clvpat + ")";
                        }
                    }
                    if (this.attributes[idx].absType == 2) {
                        if (is19139) {
                            xpt.fragment = xpt.fragment + "[not(*)]/@gco:nilReason";
                            this.schemaObject.registerNamespace("gco");
                        } else {
                            xpt.fragment = xpt.fragment + "[@xsi:nil='true']/@nilReason";
                            this.schemaObject.registerNamespace("xsi");
                        }
                        xpt.priority = 18;
                    }
                    if (this.attributes[idx].absType == 1 && typeCi.isUnionDirect()) {
                        xpt.fragment = xpt.fragment + "[not(@xsi:nil='true')]";
                        this.schemaObject.registerNamespace("xsi");
                    }
                    if (xpt.atEnd != null) {
                        xpt.atEnd.addStep();
                    }
                    if (this.attributes[idx].absType == 0) {
                        if (is19139) {
                            xpt.fragment = xpt.fragment + "/*";
                            if (xpt.atEnd != null) {
                                xpt.atEnd.addStep();
                            }
                            if (typeCi != null && typeCi.category() == 2) {
                                xpt.fragment = this.createCodeListValueExpression(xpt.fragment, (String)clvpat, "@codeList", "@codeListValue");
                            }
                        } else if (iscodelist) {
                            if (!piIsGml33Encoded) {
                                if (pi.voidable() && !((String)clvpat).equals("{value}")) {
                                    xpt.fragment = xpt.fragment + "[not(@xsi:nil='true')]";
                                    this.schemaObject.registerNamespace("xsi");
                                }
                                xpt.fragment = this.createCodeListValueExpression(xpt.fragment, (String)clvpat, "@codeSpace", "text()");
                            } else {
                                xpt.fragment = xpt.fragment + "/@xlink:href";
                                this.schemaObject.registerNamespace("xlink");
                            }
                        }
                    }
                    lastWasSimple = true;
                    continue;
                }
                Object frag_inl = "";
                Object frag_ref = "";
                if (conCode == 1 || conCode == 3) {
                    if (((String)fragmentForInlinePropertySequence).isEmpty()) {
                        if (!((String)lastForExprVariable).isEmpty()) {
                            frag_inl = (String)lastForExprVariable + "/";
                        }
                    } else {
                        frag_inl = (String)frag_inl + "/";
                    }
                    frag_inl = (String)frag_inl + propertyQName;
                    if (xpt.atEnd != null) {
                        xpt.atEnd.addStep();
                    }
                    frag_inl = (String)frag_inl + "/*";
                    if (xpt.atEnd != null) {
                        xpt.atEnd.addStep();
                    }
                }
                if (conCode == 2 || conCode == 3) {
                    Object attxlink = ((String)lastForExprVariable).isEmpty() ? "" : (String)lastForExprVariable + "/";
                    attxlink = (String)attxlink + propertyQName;
                    attxlink = (String)attxlink + "/@xlink:href";
                    Object refIdExpr = null;
                    refIdExpr = alphaEx && betaEx ? "substring-before(substring-after($BYREFVAR,'" + alpha + "'),'" + beta + "')" : (alphaEx ? "substring-after($BYREFVAR,'" + alpha + "')" : (betaEx ? "substring-before($BYREFVAR,'" + beta + "')" : "$BYREFVAR"));
                    frag_ref = "for $BYREFVAR in " + (String)attxlink + " return key('idKey'," + (String)refIdExpr + ")";
                    this.schemaObject.addIdKey();
                    this.schemaObject.registerNamespace("xlink");
                }
                lastForExprVariable = "";
                if (conCode == 1) {
                    fragmentForInlinePropertySequence = (String)fragmentForInlinePropertySequence + (String)frag_inl;
                } else {
                    Object inExpr = conCode == 2 ? frag_ref : "(" + (String)frag_inl + ", (" + (String)frag_ref + "))";
                    String newForExprVar = "$" + forExprVariablePrefix + ++forExprVariableCounter;
                    xpt.fragment = xpt.fragment + "(for " + newForExprVar + " in " + (String)inExpr + " return ";
                    lastForExprVariable = newForExprVar;
                    ++countForExpr;
                }
                if (xpt.atEnd == null) continue;
                xpt.atEnd.setState(BindingContext.CtxState.OTHER);
            }
            if (!((String)fragmentForInlinePropertySequence).isEmpty()) {
                xpt.fragment = xpt.fragment + (String)(((String)lastForExprVariable).isEmpty() ? "" : (String)lastForExprVariable + "/") + (String)fragmentForInlinePropertySequence;
            } else if (!((String)lastForExprVariable).isEmpty()) {
                xpt.fragment = xpt.fragment + (String)lastForExprVariable;
            }
            if (countForExpr > 0) {
                xpt.fragment = xpt.fragment + StringUtils.repeat((String)")", (int)(countForExpr - 1));
                xpt.fragment = xpt.fragment.substring(1);
                xpt.priority = 3;
            } else {
                xpt.priority = 18;
            }
            if (this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.priority = 20;
                xpt.type = XpathType.BOOLEAN;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            if (this.isAttributeWithVariableSelfAsSource(this)) {
                xpt.fragment = "$" + xpt.findOrAdd(xpt.fragment);
                xpt.priority = 20;
            }
            return xpt;
        }

        private int getContainmentCode(int idx, PropertyInfo pi) {
            int conCode = 0;
            String typeCiId = pi.typeInfo().id;
            ClassInfo typeCi = null;
            if (typeCiId != null) {
                typeCi = pi.model().classById(typeCiId);
            }
            if (this.attributes[idx].absType == 1) {
                typeCi = this.attributes[idx].absAttr.dataType.umlClass;
            }
            if (!this.hasSimpleType(idx)) {
                conCode = 1;
                if (typeCi != null && XmlSchema.classCanBeReferenced(typeCi)) {
                    String ref = pi.inlineOrByReference();
                    if ("byreference".equals(ref)) {
                        conCode = 2;
                    } else if (!"inline".equals(ref)) {
                        conCode = 3;
                    }
                }
            }
            return conCode;
        }

        private String createCodeListValueExpression(String xpathFragment, String codeListValuePattern, String codeListReplacementExpression, String valueReplacementExpression) {
            String clvp = codeListValuePattern.replace("{codeList}", codeListReplacementExpression).replace("{value}", valueReplacementExpression);
            String result = xpathFragment + "/" + clvp;
            return result;
        }

        protected static class AttrComp {
            protected OclNode.AttributeCallExp main = null;
            protected OclNode.AttributeCallExp absAttr = null;
            protected int absType = 0;

            protected AttrComp(OclNode.AttributeCallExp at) {
                this.main = at;
            }

            protected AttrComp(AttrComp atc) {
                this.main = atc.main;
                this.absAttr = atc.absAttr;
                this.absType = atc.absType;
            }
        }
    }

    public static class Variable
    extends SchematronConstraintNodeXslt2 {
        protected OclNode.Declaration vardecl;

        public Variable(AbstractSchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.vardecl = vardecl;
            this.negated = neg;
        }

        public String getName() {
            return this.vardecl.name;
        }

        @Override
        public boolean isDependentOn(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        @Override
        public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
            return this.isDependentOn(vardecl);
        }

        @Override
        public Attribute generatingAttribute() {
            SchematronConstraintNodeXslt2 binds = null;
            SchematronConstraintNodeXslt2 boundTo = null;
            SchematronConstraintNodeXslt2 scn = this.parent;
            while (scn != null) {
                boundTo = scn.nodeVariableIsBoundTo(this.vardecl);
                if (boundTo != null) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return null;
            }
            return boundTo.generatingAttribute();
        }

        @Override
        public boolean hasSimpleType() {
            SchematronConstraintNodeXslt2 binds = null;
            SchematronConstraintNodeXslt2 boundTo = null;
            SchematronConstraintNodeXslt2 scn = this.parent;
            while (scn != null) {
                boundTo = scn.nodeVariableIsBoundTo(this.vardecl);
                if (boundTo != null) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return false;
            }
            return boundTo.hasSimpleType();
        }

        @Override
        public boolean hasIdentity() {
            SchematronConstraintNodeXslt2 binds = null;
            SchematronConstraintNodeXslt2 boundTo = null;
            SchematronConstraintNodeXslt2 scn = this.parent;
            while (scn != null) {
                boundTo = scn.nodeVariableIsBoundTo(this.vardecl);
                if (boundTo != null) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return true;
            }
            return boundTo.hasIdentity();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt = new XpathFragment(20, "");
            SchematronConstraintNodeXslt2 binds = null;
            SchematronConstraintNodeXslt2 scn = this.parent;
            while (scn != null) {
                if (scn.nodeVariableIsBoundTo(this.vardecl) != null) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds != null && binds instanceof Let) {
                Let let = (Let)binds;
                SchematronConstraintNodeXslt2 expr = null;
                for (int i = 0; i < let.children.size() - 1; ++i) {
                    if (let.vardecls[i] != this.vardecl) continue;
                    expr = (SchematronConstraintNodeXslt2)let.children.get(i);
                    break;
                }
                if (let.letctx.state == BindingContext.CtxState.ATCURRENT) {
                    xpt = expr.translate(let.letctx);
                    String var = xpt.findOrAdd(xpt.fragment);
                    xpt.fragment = "$" + var;
                    xpt.priority = 20;
                } else {
                    xpt = expr.translate(ctx);
                }
            } else if (this.getName().equals("self")) {
                xpt.atEnd = new BindingContext(BindingContext.CtxState.ATCURRENT);
                if (ctx.state != BindingContext.CtxState.ATCURRENT) {
                    xpt.fragment = "current()";
                }
            } else if (binds != null && (binds instanceof Exists || binds instanceof ForAll || binds instanceof Select || binds instanceof Unique)) {
                xpt.fragment = "$" + this.vardecl.name;
            } else if (ctx.state != BindingContext.CtxState.OTHER) {
                xpt.fragment = "***ERROR[124," + this.getName() + "]***";
            } else {
                int i;
                int steps = 0;
                boolean found = false;
                if (ctx.vars != null) {
                    for (i = ctx.vars.size() - 1; i >= 0; --i) {
                        BindingContext.CtxElmt ce = ctx.vars.get(i);
                        steps += ce.noOfSteps;
                        if (ce.vardecl != this.vardecl) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    xpt.fragment = "***ERROR[124," + this.getName() + "]***";
                } else {
                    if (steps > 0) {
                        xpt.fragment = "..";
                        for (i = 2; i <= steps; ++i) {
                            xpt.fragment = xpt.fragment + "/..";
                        }
                    }
                    if (steps > 1) {
                        xpt.priority = 18;
                    }
                }
                xpt.atEnd = new BindingContext(BindingContext.CtxState.OTHER);
            }
            return xpt;
        }
    }

    public static class Arithmetic
    extends SchematronConstraintNodeXslt2 {
        String operation;

        public Arithmetic(AbstractSchematronSchema schemaObject, String oper) {
            this.schemaObject = schemaObject;
            this.operation = oper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt1 = ((SchematronConstraintNodeXslt2)this.children.get(0)).translate(ctx);
            if (this.children.size() == 1) {
                if (xpt1.priority <= 16) {
                    xpt1.bracket();
                }
                xpt1.priority = 16;
            } else {
                XpathFragment xpt2 = ((SchematronConstraintNodeXslt2)this.children.get(1)).translate(ctx);
                int prio = this.operation.equals("*") || this.operation.equals("/") ? 9 : 8;
                if (xpt1.priority < prio) {
                    xpt1.bracket();
                }
                if (this.operation.equals("/") || this.operation.equals("-")) {
                    if (xpt2.priority <= prio) {
                        xpt2.bracket();
                    }
                } else if (xpt2.priority < prio) {
                    xpt2.bracket();
                }
                xpt2.atEnd = null;
                String op2 = xpt1.merge(xpt2);
                xpt1.fragment = xpt1.fragment + " " + (this.operation.equals("/") ? "div" : this.operation) + " " + op2;
                xpt1.priority = prio;
            }
            xpt1.type = XpathType.NUMBER;
            xpt1.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt1;
        }
    }

    public static class Matches
    extends SchematronConstraintNodeXslt2 {
        public Matches(AbstractSchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((SchematronConstraintNodeXslt2)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptpat = ((SchematronConstraintNodeXslt2)this.children.get(1)).translate(ctx);
            if (xptpat.fragment.length() == 0) {
                xptpat.fragment = ".";
            }
            String patstring = xptobj.merge(xptpat);
            xptobj.fragment = "matches(" + xptobj.fragment + ", " + patstring + ")";
            xptobj.type = XpathType.BOOLEAN;
            xptobj.priority = 20;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            return xptobj;
        }
    }

    public static class Substring
    extends SchematronConstraintNodeXslt2 {
        public Substring(AbstractSchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((SchematronConstraintNodeXslt2)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptfr = ((SchematronConstraintNodeXslt2)this.children.get(1)).translate(ctx);
            if (xptfr.fragment.length() == 0) {
                xptfr.fragment = ".";
            }
            XpathFragment xptto = ((SchematronConstraintNodeXslt2)this.children.get(2)).translate(ctx);
            if (xptto.fragment.length() == 0) {
                xptto.fragment = ".";
            }
            String fr = xptobj.merge(xptfr);
            xptobj.fragment = "substring(" + xptobj.fragment + ", ";
            xptobj.fragment = xptobj.fragment + fr + ", ";
            if (xptto.priority < 8) {
                xptto.bracket();
            }
            if (xptfr.priority <= 8) {
                xptfr.bracket();
            }
            xptobj.fragment = xptobj.fragment + xptto.fragment + " - " + xptfr.fragment + " + 1)";
            xptobj.type = XpathType.STRING;
            xptobj.priority = 20;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            return xptobj;
        }
    }

    public static class Concatenate
    extends SchematronConstraintNodeXslt2 {
        public Concatenate(AbstractSchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment result = null;
            for (SchematronConstraintNodeXslt2 arg : this.children) {
                XpathFragment xptarg = arg.translate(ctx);
                if (result == null) {
                    result = xptarg;
                    continue;
                }
                String a1 = result.merge(xptarg);
                result.fragment = result.fragment + ", " + a1;
            }
            result.fragment = "concat(" + result.fragment + ")";
            result.type = XpathType.STRING;
            result.priority = 20;
            result.atEnd.setState(BindingContext.CtxState.NONE);
            return result;
        }
    }

    public static class Size
    extends SchematronConstraintNodeXslt2 {
        boolean setoper = false;

        public Size(AbstractSchematronSchema schemaObject, boolean set) {
            this.schemaObject = schemaObject;
            this.setoper = set;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 obj = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            if (xpt.fragment.length() == 0) {
                xpt.fragment = ".";
            }
            if (this.isAttributeWithVariableSelfAsSource(obj)) {
                xpt.fragment = "$" + xpt.findOrAdd(xpt.fragment);
                xpt.priority = 20;
            }
            xpt.fragment = !this.setoper ? "string-length(" + xpt.fragment + ")" : "count(" + xpt.fragment + ")";
            xpt.type = XpathType.NUMBER;
            xpt.priority = 20;
            xpt.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class Cast
    extends SchematronConstraintNodeXslt2 {
        protected ClassInfo argumentClass = null;
        protected String targetClassName;

        public Cast(AbstractSchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        @Override
        public boolean hasSimpleType() {
            return this.isSimpleType(this.argumentClass, this.argumentClass.name());
        }

        @Override
        public boolean hasIdentity() {
            return XmlSchema.classCanBeReferenced(this.argumentClass);
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 objnode = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xptobj = objnode.translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = "self::*";
                xptobj.priority = 19;
            }
            if (this.isAttributeWithVariableSelfAsSource(objnode)) {
                xptobj.fragment = "$" + xptobj.findOrAdd(xptobj.fragment);
                xptobj.priority = 20;
            }
            SortedSet<ClassInfo> relevantClasses = SchematronConstraintNodeXslt2.getInstantiableSubtypesInCompleteHierarchy(this.argumentClass);
            if (SchematronConstraintNodeXslt2.isInstantiable(this.argumentClass)) {
                relevantClasses.add(this.argumentClass);
            }
            if (xptobj.priority < 19) {
                xptobj.bracket();
            }
            xptobj.fragment = xptobj.fragment + "[" + (String)SchematronConstraintNodeXslt2.getExpressionForTypeRestriction(relevantClasses).getLeft() + "]";
            xptobj.priority = 19;
            if (this.argumentClass.category() == 2 && (this.argumentClass.matches("rule-xsd-all-naming-19139") || this.argumentClass.matches("rule-xsd-cls-codelist-asDictionaryGml33") && this.argumentClass.asDictionaryGml33() || this.argumentClass.matches("rule-xsd-cls-codelist-asDictionary") && this.argumentClass.asDictionary())) {
                boolean atcurr;
                Attribute att = objnode.generatingAttribute();
                PropertyInfo pip = (PropertyInfo)att.attributes[att.attributes.length - 1].main.selector.modelProperty;
                boolean is19139 = this.argumentClass.matches("rule-xsd-all-naming-19139");
                boolean isgml33 = pip != null && pip.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33");
                Object clvpat = "{value}";
                int nsubst = 1;
                if (!isgml33) {
                    String uri = this.argumentClass.taggedValue("codeList");
                    if (StringUtils.isNotBlank((CharSequence)uri)) {
                        clvpat = "{codeList}/{value}";
                    }
                    clvpat = this.schemaObject.determineCodeListValuePattern(this.argumentClass, (String)clvpat);
                    clvpat = ((String)clvpat).replace("{codeList}", "',{codeList},'");
                    if (((String)(clvpat = ((String)clvpat).replace("{value}", "',{value},'"))).startsWith("',")) {
                        clvpat = ((String)clvpat).substring(2);
                    }
                    if (((String)clvpat).endsWith(",'")) {
                        clvpat = ((String)clvpat).substring(0, ((String)clvpat).length() - 2);
                    }
                    if (!((String)clvpat).startsWith("{")) {
                        clvpat = "'" + (String)clvpat;
                    }
                    if (!((String)clvpat).endsWith("}")) {
                        clvpat = (String)clvpat + "'";
                    }
                    if (!((String)clvpat).equals("{value}")) {
                        clvpat = "concat(" + (String)clvpat + ")";
                        nsubst = 2;
                    }
                }
                boolean bl = atcurr = ctx.state == BindingContext.CtxState.ATCURRENT;
                if (is19139) {
                    if (nsubst == 2 && atcurr) {
                        String v = xptobj.findOrAdd(xptobj.fragment);
                        xptobj.fragment = "$" + v;
                    }
                    String clvp = ((String)clvpat).replace("{codeList}", xptobj.fragment + "/@codeList");
                    xptobj.fragment = clvp.replace("{value}", xptobj.fragment + "/@codeListValue");
                } else if (!isgml33) {
                    if (nsubst == 2 && atcurr) {
                        String v = xptobj.findOrAdd(xptobj.fragment);
                        xptobj.fragment = "$" + v;
                    }
                    String clvp = ((String)clvpat).replace("{codeList}", xptobj.fragment + "/@codeSpace");
                    xptobj.fragment = clvp.replace("{value}", xptobj.fragment);
                } else {
                    xptobj.fragment = xptobj.fragment + "/@xlink:href";
                    this.schemaObject.registerNamespace("xlink");
                }
            }
            return xptobj;
        }
    }

    public static class KindOf
    extends SchematronConstraintNodeXslt2 {
        protected ClassInfo argumentClass = null;
        protected boolean exact = false;

        public KindOf(AbstractSchematronSchema schemaObject, boolean exact, boolean neg) {
            this.schemaObject = schemaObject;
            this.exact = exact;
            this.negated = neg;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 objnode = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xptobj = objnode.translate(ctx);
            boolean emptyobject = xptobj.fragment.length() == 0;
            SortedSet<Object> relevantClasses = new TreeSet();
            if (!this.exact) {
                relevantClasses = SchematronConstraintNodeXslt2.getInstantiableSubtypesInCompleteHierarchy(this.argumentClass);
            }
            if (SchematronConstraintNodeXslt2.isInstantiable(this.argumentClass)) {
                relevantClasses.add(this.argumentClass);
            }
            if (relevantClasses.size() == 0) {
                xptobj.fragment = this.negated ? "true()" : "false()";
                xptobj.priority = 20;
                xptobj.type = XpathType.BOOLEAN;
                xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            } else {
                Pair<String, Integer> pair = SchematronConstraintNodeXslt2.getExpressionForTypeRestriction(relevantClasses);
                Object expression = (String)pair.getLeft();
                int expressionPriority = (Integer)pair.getRight();
                if (this.negated) {
                    expression = "not(" + (String)expression + ")";
                }
                if (!emptyobject) {
                    if (xptobj.priority < 19) {
                        xptobj.bracket();
                    }
                    xptobj.fragment = xptobj.fragment + "[" + (String)expression + "]";
                    xptobj.priority = 19;
                } else {
                    xptobj.fragment = expression;
                    xptobj.priority = this.negated ? 20 : expressionPriority;
                }
            }
            return xptobj;
        }
    }

    public static class PropertyMetadata
    extends SchematronConstraintNodeXslt2 {
        protected ClassInfo metadataType;

        public PropertyMetadata(AbstractSchematronSchema schemaObject, ClassInfo metadataType, boolean negated) {
            this.schemaObject = schemaObject;
            this.metadataType = metadataType;
            this.negated = negated;
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public boolean hasSimpleType() {
            return false;
        }

        @Override
        public boolean hasIdentity() {
            return XmlSchema.classCanBeReferenced(this.metadataType);
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 objnode = (SchematronConstraintNodeXslt2)this.children.get(0);
            ctx.propertyMetadataAccess = true;
            XpathFragment obj = objnode.translate(ctx);
            ctx.propertyMetadataAccess = false;
            if (objnode instanceof Variable) {
                obj.fragment = "***ERROR[128]***";
            } else {
                Object metalink;
                String alpha = this.schemaObject.alpha;
                String beta = this.schemaObject.beta;
                boolean alphaEx = StringUtils.isNotBlank((CharSequence)alpha);
                boolean betaEx = StringUtils.isNotBlank((CharSequence)beta);
                Object object = metalink = obj.fragment.isEmpty() ? "current()" : obj.fragment;
                if (obj.priority < 18) {
                    metalink = "(" + (String)metalink + ")";
                }
                metalink = (String)metalink + "/@metadata";
                Object refIdExpr = null;
                refIdExpr = alphaEx && betaEx ? "substring-before(substring-after($METAREFVAR,'" + alpha + "'),'" + beta + "')" : (alphaEx ? "substring-after($METAREFVAR,'" + alpha + "')" : (betaEx ? "substring-before($METAREFVAR,'" + beta + "')" : "$METAREFVAR"));
                obj.fragment = "for $METAREFVAR in " + (String)metalink + " return key('idKey'," + (String)refIdExpr + ")";
                this.schemaObject.addIdKey();
                obj.priority = 3;
                if (this.negated) {
                    obj.fragment = "not(" + obj.fragment + ")";
                    obj.priority = 20;
                    obj.atEnd.setState(BindingContext.CtxState.NONE);
                }
            }
            return obj;
        }
    }

    public static class AllInstances
    extends SchematronConstraintNodeXslt2 {
        protected ClassInfo objectClass;

        public AllInstances(AbstractSchematronSchema schemaObject, ClassInfo ci, boolean negated) {
            this.schemaObject = schemaObject;
            this.objectClass = ci;
            this.negated = negated;
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public boolean hasSimpleType() {
            return false;
        }

        @Override
        public boolean hasIdentity() {
            return XmlSchema.classCanBeReferenced(this.objectClass);
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SortedSet<ClassInfo> relevantClasses = SchematronConstraintNodeXslt2.getInstantiableSubtypesInCompleteHierarchy(this.objectClass);
            if (SchematronConstraintNodeXslt2.isInstantiable(this.objectClass)) {
                relevantClasses.add(this.objectClass);
            }
            Object fragment = "//*[";
            fragment = (String)fragment + (String)SchematronConstraintNodeXslt2.getExpressionForTypeRestriction(relevantClasses).getLeft();
            fragment = (String)fragment + "]";
            XpathFragment xpt = new XpathFragment(19, (String)fragment);
            xpt.atEnd = new BindingContext(BindingContext.CtxState.OTHER);
            String var = xpt.findOrAdd((String)fragment);
            xpt.fragment = "$" + var;
            xpt.priority = 20;
            return xpt;
        }
    }

    public static class Select
    extends SchematronConstraintNodeXslt2 {
        protected OclNode.Declaration vardecl;
        protected SchematronConstraintNodeXslt2 generatorBody = null;

        public Select(AbstractSchematronSchema schemaObject, OclNode.Declaration vardecl) {
            this.schemaObject = schemaObject;
            this.vardecl = vardecl;
        }

        @Override
        public SchematronConstraintNodeXslt2 nodeVariableIsBoundTo(OclNode.Declaration vardecl) {
            if (this.vardecl == vardecl) {
                return (SchematronConstraintNodeXslt2)this.children.get(0);
            }
            return null;
        }

        @Override
        public Attribute generatingAttribute() {
            return ((SchematronConstraintNodeXslt2)this.children.get(0)).generatingAttribute();
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public boolean hasSimpleType() {
            return ((SchematronConstraintNodeXslt2)this.children.get(0)).hasSimpleType();
        }

        @Override
        public boolean hasIdentity() {
            return ((SchematronConstraintNodeXslt2)this.children.get(0)).hasIdentity();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 obj = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            bodyctx.inPredicateExpression = true;
            SchematronConstraintNodeXslt2 pred = (SchematronConstraintNodeXslt2)this.children.get(1);
            XpathFragment prd = pred.translate(bodyctx);
            prd.atEnd = null;
            String filter = xpt.merge(prd);
            if (xpt.priority < 19) {
                xpt.bracket();
            }
            xpt.fragment = xpt.fragment + "[";
            if (!this.vardecl.name.equalsIgnoreCase("(noname)")) {
                xpt.fragment = xpt.fragment + "for $" + this.vardecl.name + " in . return ";
            }
            xpt.fragment = xpt.fragment + filter + "]";
            xpt.priority = 19;
            return xpt;
        }
    }

    public static class Unique
    extends SchematronConstraintNodeXslt2 {
        public static final String IS_UNIQUE_EMPTY_TOKEN = "SC_EMPTY_ISU_BODY";
        OclNode.Declaration vardecl;

        public Unique(AbstractSchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        @Override
        public SchematronConstraintNodeXslt2 nodeVariableIsBoundTo(OclNode.Declaration vardecl) {
            if (this.vardecl == vardecl) {
                return (SchematronConstraintNodeXslt2)this.children.get(0);
            }
            return null;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            boolean neg = this.negated;
            SchematronConstraintNodeXslt2 obj = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            SchematronConstraintNodeXslt2 body = (SchematronConstraintNodeXslt2)this.children.get(1);
            if (!body.isDependentOn(this.vardecl)) {
                xpt.fragment = "count(" + xpt.fragment + ") " + (neg ? ">" : "<=") + " 1";
                neg = false;
                xpt.priority = 6;
            } else if (body.isVarOrAttribBased(this.vardecl) && body instanceof Variable) {
                boolean simple = false;
                boolean hasIdentity = false;
                Attribute obat = null;
                String objAttNameOfLastClass = null;
                if (obj instanceof Attribute) {
                    obat = (Attribute)obj;
                } else if (obj instanceof Variable) {
                    obat = obj.generatingAttribute();
                }
                if (obat != null) {
                    simple = obat.hasSimpleType();
                    hasIdentity = obat.hasIdentity();
                    objAttNameOfLastClass = obat.attributes[obat.attributes.length - 1].main.dataType.name;
                }
                Object objXpt = xpt.fragment;
                if (this.isAttributeWithVariableSelfAsSource(obj)) {
                    objXpt = "$" + xpt.findOrAdd(xpt.fragment);
                }
                if (simple) {
                    xpt.fragment = "count(" + (String)objXpt + ") = count(distinct-values(" + (String)objXpt;
                    if ("Boolean".equalsIgnoreCase(objAttNameOfLastClass)) {
                        xpt.fragment = xpt.fragment + "/xs:boolean(.)";
                    }
                    xpt.fragment = xpt.fragment + "))";
                    xpt.priority = 6;
                } else if (hasIdentity) {
                    xpt.fragment = "count(" + (String)objXpt + ") = count(distinct-values(" + (String)objXpt + "/@*:id))";
                    xpt.priority = 6;
                } else {
                    xpt.fragment = "for $COUNT1 in count(" + (String)objXpt + "), $COUNT2 in sum(for $ISUVAR1 in " + (String)objXpt + ", $ISUVAR2 in " + (String)objXpt + " return (if(empty($ISUVAR1) and empty($ISUVAR2)) then 0 else if ((empty($ISUVAR1) and not(empty($ISUVAR2))) or (not(empty($ISUVAR1)) and empty($ISUVAR2))) then 1 else if (generate-id($ISUVAR1) = generate-id($ISUVAR2)) then 0 else if (deep-equal($ISUVAR1,$ISUVAR2)) then 0 else 1)) return $COUNT1 * ($COUNT1 - 1) = $COUNT2";
                    xpt.priority = 3;
                }
            } else if (body.isVarOrAttribBased(this.vardecl)) {
                if (body.isMultiple()) {
                    return new XpathFragment(20, "***ERROR[121]***");
                }
                Attribute bodyAtt = (Attribute)body;
                String objAttNameOfLastClass = bodyAtt.attributes[bodyAtt.attributes.length - 1].main.dataType.name;
                boolean simple = bodyAtt.hasSimpleType();
                boolean hasIdentity = bodyAtt.hasIdentity();
                Object objXpt = xpt.fragment;
                if (this.isAttributeWithVariableSelfAsSource(obj)) {
                    objXpt = "$" + xpt.findOrAdd(xpt.fragment);
                }
                BindingContext bodyctx = xpt.atEnd.clone();
                bodyctx.pushDeclaration(this.vardecl);
                bodyctx.inPredicateExpression = false;
                XpathFragment bodyXpt = body.translate(bodyctx);
                bodyXpt.atEnd = null;
                String iterVar = "$" + this.vardecl.name;
                if (simple) {
                    xpt.fragment = "count(" + (String)objXpt + ") = count(distinct-values(";
                    xpt.fragment = xpt.fragment + "for " + iterVar + " in " + (String)objXpt + " return (if (empty(" + bodyXpt.fragment + ")) then 'SC_EMPTY_ISU_BODY' else " + bodyXpt.fragment;
                    if ("Boolean".equalsIgnoreCase(objAttNameOfLastClass)) {
                        xpt.fragment = xpt.fragment + "/xs:boolean(.)";
                    }
                    xpt.fragment = xpt.fragment + ")))";
                    xpt.priority = 6;
                } else if (hasIdentity) {
                    xpt.fragment = "count(" + (String)objXpt + ") = count(distinct-values(for " + iterVar + " in " + (String)objXpt + " return (if (empty(" + bodyXpt.fragment + ")) then 'SC_EMPTY_ISU_BODY' else " + bodyXpt.fragment + "/@*:id)))";
                    xpt.priority = 6;
                } else {
                    xpt.fragment = "for $COUNT1 in count(" + (String)objXpt + "), $COUNT2 in sum(for " + iterVar + " in " + (String)objXpt + ", $ISUVAR1 in " + bodyXpt.fragment + ", $ISUVAR2 in " + bodyXpt.fragment + " return (if(empty($ISUVAR1) and empty($ISUVAR2)) then 0 else if ((empty($ISUVAR1) and not(empty($ISUVAR2))) or (not(empty($ISUVAR1)) and empty($ISUVAR2))) then 1 else if (generate-id($ISUVAR1) = generate-id($ISUVAR2)) then 0 else if (deep-equal($ISUVAR1,$ISUVAR2)) then 0 else 1)) return $COUNT1 * ($COUNT1 - 1) = $COUNT2";
                    xpt.priority = 3;
                }
            } else {
                return new XpathFragment(20, "***ERROR[122]***");
            }
            xpt.type = XpathType.BOOLEAN;
            xpt.atEnd.setState(BindingContext.CtxState.NONE);
            if (neg) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.priority = 20;
            }
            return xpt;
        }
    }

    public static class ForAll
    extends SchematronConstraintNodeXslt2 {
        OclNode.Declaration vardecl;

        public ForAll(AbstractSchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        @Override
        public SchematronConstraintNodeXslt2 nodeVariableIsBoundTo(OclNode.Declaration vardecl) {
            if (this.vardecl == vardecl) {
                return (SchematronConstraintNodeXslt2)this.children.get(0);
            }
            return null;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 selection = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = selection.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            bodyctx.inPredicateExpression = false;
            SchematronConstraintNodeXslt2 condition = (SchematronConstraintNodeXslt2)this.children.get(1);
            XpathFragment cond = condition.translate(bodyctx);
            cond.atEnd = null;
            String filter = xpt.merge(cond);
            if (xpt.priority < 3) {
                xpt.bracket();
            }
            xpt.fragment = "every $" + this.vardecl.name + " in " + xpt.fragment + " satisfies " + filter;
            xpt.priority = 3;
            xpt.type = XpathType.BOOLEAN;
            if (this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.priority = 20;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Exists
    extends SchematronConstraintNodeXslt2 {
        OclNode.Declaration vardecl;

        public Exists(AbstractSchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        @Override
        public SchematronConstraintNodeXslt2 nodeVariableIsBoundTo(OclNode.Declaration vardecl) {
            if (this.vardecl == vardecl) {
                return (SchematronConstraintNodeXslt2)this.children.get(0);
            }
            return null;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 selection = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = selection.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            bodyctx.inPredicateExpression = false;
            SchematronConstraintNodeXslt2 condition = (SchematronConstraintNodeXslt2)this.children.get(1);
            XpathFragment cond = condition.translate(bodyctx);
            cond.atEnd = null;
            String filter = xpt.merge(cond);
            if (xpt.priority < 3) {
                xpt.bracket();
            }
            xpt.fragment = "some $" + this.vardecl.name + " in " + xpt.fragment + " satisfies " + filter;
            xpt.priority = 3;
            xpt.type = XpathType.BOOLEAN;
            if (this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.priority = 20;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Empty
    extends SchematronConstraintNodeXslt2 {
        public Empty(AbstractSchematronSchema schemaObject, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNodeXslt2 obj = (SchematronConstraintNodeXslt2)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            if (xpt.fragment.length() == 0) {
                xpt.fragment = ".";
            }
            if (!this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.type = XpathType.BOOLEAN;
                xpt.priority = 20;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Comparison
    extends SchematronConstraintNodeXslt2 {
        String opname;

        public Comparison(AbstractSchematronSchema schemaObject, String name) {
            this.schemaObject = schemaObject;
            this.opname = name.equals("<>") ? "!=" : name;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            int refprio = 6;
            XpathFragment[] child_xpt = new XpathFragment[2];
            for (int i = 0; i < 2; ++i) {
                SchematronConstraintNodeXslt2 child = (SchematronConstraintNodeXslt2)this.children.get(i);
                if (!child.hasSimpleType() && !child.hasIdentity()) {
                    return new XpathFragment(20, "***ERROR[126]***");
                }
                child_xpt[i] = child.translate(ctx);
                if (child.hasIdentity()) {
                    child_xpt[i].fragment = "generate-id(" + child_xpt[i].fragment + ")";
                    child_xpt[i].priority = 20;
                }
                if (child_xpt[i].fragment.length() == 0) {
                    child_xpt[i].fragment = ".";
                }
                if (child_xpt[i].priority <= refprio) {
                    child_xpt[i].bracket();
                }
                child_xpt[i].atEnd.setState(BindingContext.CtxState.NONE);
            }
            String op2 = child_xpt[0].merge(child_xpt[1]);
            child_xpt[0].fragment = child_xpt[0].fragment + " " + this.opname + " " + op2;
            child_xpt[0].type = XpathType.BOOLEAN;
            child_xpt[0].priority = refprio;
            return child_xpt[0];
        }
    }

    public static class Logic
    extends SchematronConstraintNodeXslt2 {
        protected LogicType logic;

        public Logic(AbstractSchematronSchema schemaObject, LogicType logic) {
            this.schemaObject = schemaObject;
            this.logic = logic;
        }

        @Override
        public boolean isAndOrLogic(boolean isAnd) {
            if (this.logic == LogicType.XOR || this.logic == LogicType.EQV) {
                return false;
            }
            return this.logic == LogicType.AND == isAnd;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            int refprio;
            if (this.children.size() == 1) {
                return ((SchematronConstraintNodeXslt2)this.children.get(0)).translate(ctx);
            }
            String particle = null;
            if (this.logic == LogicType.AND) {
                particle = "and";
                refprio = 5;
            } else if (this.logic == LogicType.OR) {
                particle = "or";
                refprio = 4;
            } else if (this.logic == LogicType.XOR) {
                particle = "!=";
                refprio = 6;
            } else {
                particle = "=";
                refprio = 6;
            }
            XpathFragment result = null;
            for (SchematronConstraintNodeXslt2 ocn : this.children) {
                XpathFragment child_xpt = ocn.translate(ctx);
                if ((this.logic == LogicType.XOR || this.logic == LogicType.EQV) && child_xpt.type != XpathType.BOOLEAN) {
                    child_xpt.fragment = "boolean(" + child_xpt.fragment + ")";
                    child_xpt.type = XpathType.BOOLEAN;
                    child_xpt.priority = 20;
                } else if (child_xpt.priority <= refprio) {
                    child_xpt.bracket();
                }
                child_xpt.atEnd.setState(BindingContext.CtxState.NONE);
                if (result == null) {
                    result = child_xpt;
                    continue;
                }
                String mrge = result.merge(child_xpt);
                result.fragment = result.fragment + " " + particle + " ";
                result.fragment = result.fragment + mrge;
            }
            result.priority = refprio;
            result.type = XpathType.BOOLEAN;
            result.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return result;
        }

        protected static enum LogicType {
            AND,
            OR,
            XOR,
            EQV;

        }
    }
}

