/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import java.util.ArrayList;

public class BindingContext {
    public CtxState state;
    public boolean inPredicateExpression = false;
    public boolean propertyMetadataAccess = false;
    ArrayList<CtxElmt> vars = null;

    BindingContext(CtxState state) {
        this.state = state;
    }

    public BindingContext clone() {
        BindingContext copy = new BindingContext(this.state);
        if (this.vars != null) {
            for (CtxElmt ce : this.vars) {
                copy.pushDeclaration(ce.vardecl);
                copy.vars.get((int)(copy.vars.size() - 1)).noOfSteps = ce.noOfSteps;
            }
        }
        copy.inPredicateExpression = this.inPredicateExpression;
        return copy;
    }

    public void setState(CtxState state) {
        this.state = state;
        this.vars = null;
    }

    public void setStateKeepingVariables(CtxState state) {
        this.state = state;
    }

    public void pushDeclaration(OclNode.Declaration vd) {
        if (this.vars == null) {
            this.vars = new ArrayList();
        }
        this.vars.add(new CtxElmt(vd));
        this.state = CtxState.OTHER;
    }

    public void addStep() {
        if (this.vars == null || this.vars.size() == 0) {
            return;
        }
        ++this.vars.get((int)(this.vars.size() - 1)).noOfSteps;
    }

    public void popDeclaration() {
        if (this.vars == null || this.vars.size() == 0) {
            return;
        }
        this.vars.remove(this.vars.size() - 1);
    }

    public void merge(BindingContext ctx) {
        if (ctx == null) {
            return;
        }
        if (this.state == CtxState.NONE) {
            return;
        }
        if (ctx.state == CtxState.NONE) {
            this.setState(CtxState.NONE);
            return;
        }
        if (ctx.state == CtxState.ATCURRENT && this.state == CtxState.ATCURRENT) {
            return;
        }
        if (ctx.state == CtxState.OTHER && this.state == CtxState.OTHER) {
            int thissize = this.vars == null ? 0 : this.vars.size();
            int ctxsize = ctx.vars == null ? 0 : ctx.vars.size();
            int i = thissize - 1;
            for (int j = ctxsize - 1; i >= 0 && j >= 0; --i, --j) {
                CtxElmt cei = this.vars.get(i);
                CtxElmt cej = ctx.vars.get(j);
                if (cei.vardecl != cej.vardecl || cei.noOfSteps != cej.noOfSteps) break;
            }
            while (i >= 0) {
                this.vars.remove(i--);
            }
            if (this.vars != null && this.vars.size() == 0) {
                this.vars = null;
            }
        } else {
            this.state = CtxState.OTHER;
            this.vars = null;
        }
    }

    public class CtxElmt {
        public OclNode.Declaration vardecl;
        public int noOfSteps = 0;

        CtxElmt(OclNode.Declaration vd) {
            this.vardecl = vd;
        }
    }

    public static enum CtxState {
        NONE,
        ATCURRENT,
        OTHER;

    }
}

