/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathFragment;
import de.interactive_instruments.ShapeChange.TargetXmlSchemaConfiguration;
import de.interactive_instruments.ShapeChange.XsdPropertyMapEntry;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractSchematronSchema
implements SchematronSchema {
    protected boolean addIdKey = false;
    HashMap<String, RuleCreationStatus> ruleCreationStatusMap = new HashMap();
    Model model;
    Options options;
    TargetXmlSchemaConfiguration config;
    ShapeChangeResult result;
    PackageInfo schemaPackage;
    String schemaXsdBaseName;
    Document document;
    Element pattern;
    Element root;
    Text schematronTitleHook;
    boolean schematronTitleExtended = false;
    boolean printed = false;
    boolean assertion = false;
    String currentOclConstraintName = null;
    ClassInfo currentOclConstraintClass = null;
    HashSet<String> namespaces = new HashSet();
    String alpha = "#";
    String beta = "";
    boolean trojanSuppressedType = false;
    String classname = null;
    String schematronFilename;
    HashMap<String, ExtensionFunctionTemplate> extensionFunctions = new HashMap();

    public AbstractSchematronSchema(Model mdl, Options o, ShapeChangeResult r, PackageInfo schemaPackage, String schemaXsdBaseName, boolean segmentation) {
        this.model = mdl;
        this.schemaPackage = schemaPackage;
        this.schemaXsdBaseName = schemaXsdBaseName;
        this.options = o;
        this.result = r;
        this.document = null;
        this.classname = XmlSchema.class.getName();
        this.config = (TargetXmlSchemaConfiguration)this.options.getCurrentProcessConfig();
        String s = this.options.parameter(this.classname, "schematronXlinkHrefPrefix");
        if (s != null) {
            this.alpha = s;
        }
        if ((s = this.options.parameter(this.classname, "schematronXlinkHrefPostfix")) != null) {
            this.beta = s;
        }
        if ((s = this.options.parameter(this.classname, "suppressedTypeInterpretation")) != null) {
            if (s.equals("strictUML")) {
                this.trojanSuppressedType = false;
            } else if (s.equals("trojanType")) {
                this.trojanSuppressedType = true;
            } else {
                this.result.addError(null, 140, "suppressedTypeInterpretation", s);
            }
        }
        String schematronFilenameTemplate = this.options.parameterAsString(XmlSchema.class.getName(), "schematronFileNameTemplate", "[[SCHEMA_XSD_BASENAME]].xsd_SchematronSchema.xml", false, true);
        this.schematronFilename = schematronFilenameTemplate.replaceAll("\\[\\[SCHEMA_XSD_BASENAME\\]\\]", schemaXsdBaseName);
        String pats = "^schematronExtension\\.(\\w+?)\\.function";
        String[] extdecls = this.options.parameterNamesByRegex(this.classname, pats);
        Pattern pat = Pattern.compile(pats);
        for (String ext : extdecls) {
            Matcher mat = pat.matcher(ext);
            mat.matches();
            String fctname = mat.group(1);
            String fcts = this.options.parameter(this.classname, ext);
            String nss = this.options.parameter(this.classname, "schematronExtension." + fctname + ".namespace");
            if (nss == null || nss.length() == 0) {
                nss = "java:java";
            }
            int col = nss.indexOf(":");
            String nspx = "java";
            String ns = nss;
            if (col >= 0) {
                nspx = nss.substring(0, col);
                ns = nss.substring(col + 1);
            }
            this.extensionFunctions.put(fctname, new ExtensionFunctionTemplate(nspx, ns, fcts));
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.root = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns:sch", "http://purl.oclc.org/dsdl/schematron");
        Element e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "title");
        this.root.appendChild(e1);
        this.schematronTitleHook = this.document.createTextNode("Schematron constraints for " + (segmentation ? "a part of " : "") + "schema '" + schemaPackage.name() + "'");
        e1.appendChild(this.schematronTitleHook);
        e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
        this.root.appendChild(e1);
        this.namespaces.add("sch");
        this.addAttribute(this.document, e1, "prefix", "sch");
        this.addAttribute(this.document, e1, "uri", "http://purl.oclc.org/dsdl/schematron");
        e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
        this.root.appendChild(e1);
        this.namespaces.add(schemaPackage.xmlns());
        this.addAttribute(this.document, e1, "prefix", schemaPackage.xmlns());
        this.addAttribute(this.document, e1, "uri", schemaPackage.targetNamespace());
        this.pattern = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "pattern");
        this.root.appendChild(this.pattern);
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    @Override
    public void addAssertion(ClassInfo ci, XpathFragment xpath, String text) {
        this.addAssertion(ci, false, xpath, text);
    }

    @Override
    public void addAssertion(ClassInfo ci, boolean addToSubtypesInSelectedSchemas, XpathFragment xpath, String text) {
        String asserttext;
        if (ci.isAbstract()) {
            return;
        }
        String ruleContext = ci.qname();
        RuleCreationStatus rulecs = this.ruleCreationStatusMap.get(ruleContext);
        if (rulecs == null) {
            Element rule = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "rule");
            this.pattern.appendChild(rule);
            this.addAttribute(this.document, rule, "context", ruleContext);
            rulecs = new RuleCreationStatus();
            rulecs.ruleElement = rule;
            rulecs.lastPathStatus = xpath;
            asserttext = xpath.fragment;
            this.ruleCreationStatusMap.put(ruleContext, rulecs);
        } else {
            asserttext = rulecs.lastPathStatus.merge(xpath);
        }
        if (xpath.lets != null) {
            for (Map.Entry entry : rulecs.lastPathStatus.lets.entrySet()) {
                if (rulecs.letVarsAlreadyOutput.contains(entry.getKey())) continue;
                Element let = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "let");
                rulecs.ruleElement.insertBefore(let, rulecs.firstAssertElement);
                this.addAttribute(this.document, let, "name", (String)entry.getKey());
                this.addAttribute(this.document, let, "value", (String)entry.getValue());
                rulecs.letVarsAlreadyOutput.add((String)entry.getKey());
            }
        }
        Element ass = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "assert");
        rulecs.ruleElement.appendChild(ass);
        if (rulecs.firstAssertElement == null) {
            rulecs.firstAssertElement = ass;
        }
        this.addAttribute(this.document, ass, "test", asserttext);
        ass.appendChild(this.document.createTextNode(text));
        this.assertion = true;
        if (addToSubtypesInSelectedSchemas) {
            for (String subtypeId : ci.subtypes()) {
                ClassInfo subtype = this.model.classById(subtypeId);
                if (!this.model.isInSelectedSchemas(subtype)) continue;
                this.addAssertion(subtype, true, xpath, text);
                if (this.schematronTitleExtended || subtype.pkg().targetNamespace().equalsIgnoreCase(ci.pkg().targetNamespace())) continue;
                this.schematronTitleHook.setTextContent(this.schematronTitleHook.getTextContent() + " and dependent schema(s)");
                this.schematronTitleExtended = true;
            }
        }
    }

    @Override
    public void addAssertionForExplicitProperty(ClassInfo cib, PropertyInfo pi, boolean addToSubtypesInSelectedSchemas, XpathFragment xpath, String text) {
        ClassInfo ci;
        ClassInfo classInfo = ci = cib != null ? cib : pi.inClass();
        if (!(ci.isAbstract() || ci.suppressed() || ci.matches("rule-xsd-all-propertyAssertion-ignoreProhibited") && "true".equalsIgnoreCase(ci.taggedValue("prohibitedInProfile")) || pi.matches("rule-xsd-all-propertyAssertion-ignoreProhibited") && "true".equalsIgnoreCase(pi.taggedValue("prohibitedInProfile")))) {
            String asserttext;
            this.registerNamespace(ci);
            this.registerNamespace(pi.inClass());
            String ruleContext = ci.qname() + "/" + this.getAndRegisterXmlName(pi);
            RuleCreationStatus rulecs = this.ruleCreationStatusMap.get(ruleContext);
            if (rulecs == null) {
                Element rule = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "rule");
                this.pattern.appendChild(rule);
                this.addAttribute(this.document, rule, "context", ruleContext);
                rulecs = new RuleCreationStatus();
                rulecs.ruleElement = rule;
                rulecs.lastPathStatus = xpath;
                asserttext = xpath.fragment;
                this.ruleCreationStatusMap.put(ruleContext, rulecs);
            } else {
                asserttext = rulecs.lastPathStatus.merge(xpath);
            }
            if (xpath.lets != null) {
                for (Map.Entry entry : rulecs.lastPathStatus.lets.entrySet()) {
                    if (rulecs.letVarsAlreadyOutput.contains(entry.getKey())) continue;
                    Element let = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "let");
                    rulecs.ruleElement.insertBefore(let, rulecs.firstAssertElement);
                    this.addAttribute(this.document, let, "name", (String)entry.getKey());
                    this.addAttribute(this.document, let, "value", (String)entry.getValue());
                    rulecs.letVarsAlreadyOutput.add((String)entry.getKey());
                }
            }
            Element ass = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "assert");
            rulecs.ruleElement.appendChild(ass);
            if (rulecs.firstAssertElement == null) {
                rulecs.firstAssertElement = ass;
            }
            this.addAttribute(this.document, ass, "test", asserttext);
            ass.appendChild(this.document.createTextNode(text));
            this.assertion = true;
        }
        if (addToSubtypesInSelectedSchemas) {
            for (String subtypeId : ci.subtypes()) {
                ClassInfo subtype = this.model.classById(subtypeId);
                if (!this.model.isInSelectedSchemas(subtype)) continue;
                this.addAssertionForExplicitProperty(subtype, pi, true, xpath, text);
                if (this.schematronTitleExtended || subtype.pkg().targetNamespace().equalsIgnoreCase(ci.pkg().targetNamespace())) continue;
                this.schematronTitleHook.setTextContent(this.schematronTitleHook.getTextContent() + " and dependent schema(s)");
                this.schematronTitleExtended = true;
            }
        }
    }

    @Override
    public String getAndRegisterXmlName(PropertyInfo pi) {
        XsdPropertyMapEntry xpme = this.config.getPropertyMapEntry(pi);
        if (xpme != null && xpme.hasTargetElement()) {
            String qname = xpme.getTargetElement();
            String nspref = qname.split(":")[0];
            this.registerNamespace(nspref);
            return qname;
        }
        String nspref = pi.inClass().pkg().xmlns();
        String proper = nspref + ":" + pi.name();
        this.registerNamespace(nspref, pi.inClass());
        return proper;
    }

    @Override
    public String getAndRegisterXmlName(ClassInfo ci) {
        String nspref = null;
        Object fulnam = null;
        MapEntry me = ci.options().elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            if (me.p1 == null || me.p1.length() == 0) {
                return null;
            }
            fulnam = me.p1;
            String[] parts = ((String)fulnam).split(":");
            if (parts.length > 1) {
                nspref = parts[0];
            }
            this.registerNamespace(nspref);
        } else {
            nspref = ci.pkg().xmlns();
            fulnam = nspref + ":" + ci.name();
            this.registerNamespace(nspref, ci);
        }
        return fulnam;
    }

    @Override
    public void registerNamespace(String xmlns, String ns) {
        if (!this.namespaces.contains(xmlns)) {
            Element e = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
            this.addAttribute(this.document, e, "prefix", xmlns);
            if (ns == null) {
                ns = "FIXME";
            }
            this.addAttribute(this.document, e, "uri", ns);
            this.root.insertBefore(e, this.pattern);
            this.namespaces.add(xmlns);
            if (ns.equals("http://www.w3.org/2005/xpath-functions")) {
                this.setQueryBinding("xslt2");
            }
        }
    }

    @Override
    public void registerNamespace(String xmlns) {
        if (!this.namespaces.contains(xmlns)) {
            String ns = this.options.fullNamespace(xmlns);
            this.registerNamespace(xmlns, ns);
        }
    }

    @Override
    public void registerNamespace(String xmlns, ClassInfo ci) {
        if (!this.namespaces.contains(xmlns)) {
            String ns = ci.pkg().targetNamespace();
            if (ns == null || ns.length() == 0) {
                this.registerNamespace(xmlns);
            } else {
                this.registerNamespace(xmlns, ns);
            }
        }
    }

    @Override
    public void registerNamespace(ClassInfo ci) {
        String xmlns = ci.pkg().xmlns();
        if (!this.namespaces.contains(xmlns)) {
            String ns = ci.pkg().targetNamespace();
            if (ns == null || ns.length() == 0) {
                this.registerNamespace(xmlns);
            } else {
                this.registerNamespace(xmlns, ns);
            }
        }
    }

    @Override
    public String determineCodeListValuePattern(ClassInfo codelist, String defaultPattern) {
        String vp = codelist.taggedValue("codeListValuePattern");
        if (StringUtils.isBlank((CharSequence)vp)) {
            vp = this.options.parameterAsString(XmlSchema.class.getName(), "defaultCodeListValuePattern", defaultPattern, false, true);
        }
        return vp;
    }

    public void addIdKey() {
        this.addIdKey = true;
    }

    @Override
    public String getFileName() {
        return this.schematronFilename;
    }

    @Override
    public boolean hasRules() {
        return !this.ruleCreationStatusMap.isEmpty();
    }

    @Override
    public void write(String outputDirectory) {
        if (this.printed || !this.assertion) {
            return;
        }
        if (this.addIdKey) {
            this.addAttribute(this.document, this.root, "xmlns:xsl", "http://www.w3.org/1999/XSL/Transform");
            Element e = this.document.createElementNS("http://www.w3.org/1999/XSL/Transform", "xsl:key");
            this.addAttribute(this.document, e, "name", "idKey");
            this.addAttribute(this.document, e, "match", "*[@*:id]");
            this.addAttribute(this.document, e, "use", "@*:id");
            this.root.insertBefore(e, this.pattern);
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            FileOutputStream fout = new FileOutputStream(outputDirectory + "/" + this.schematronFilename);
            OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    public static class ExtensionFunctionTemplate {
        public String nsPrefix;
        public String namespace;
        public String function;

        public ExtensionFunctionTemplate(String nsp, String ns, String fct) {
            this.nsPrefix = nsp;
            this.namespace = ns;
            this.function = fct;
        }
    }

    public static class RuleCreationStatus {
        public XpathFragment lastPathStatus;
        public Element ruleElement;
        public Element firstAssertElement = null;
        HashSet<String> letVarsAlreadyOutput = new HashSet();
    }
}

