/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;

public class TargetUtil {
    private static final String PARAM_MAIN_APP_SCHEMA = "mainAppSchema";

    private TargetUtil() {
    }

    public static PackageInfo findMainSchemaForSingleTargets(SortedSet<? extends PackageInfo> selectedSchemas, Options options, ShapeChangeResult result) {
        PackageInfo mainAppSchema;
        final String mainAppSchemaName = options.parameter(PARAM_MAIN_APP_SCHEMA);
        if (StringUtils.isBlank((CharSequence)mainAppSchemaName)) {
            mainAppSchema = selectedSchemas.size() == 1 ? selectedSchemas.first() : null;
        } else {
            Optional tryFindMainAppSchemaResult = Iterables.tryFind(selectedSchemas, (Predicate)new Predicate<PackageInfo>(){

                public boolean apply(PackageInfo packageInfo) {
                    return mainAppSchemaName.equalsIgnoreCase(packageInfo.name());
                }
            });
            if (tryFindMainAppSchemaResult.isPresent()) {
                mainAppSchema = (PackageInfo)tryFindMainAppSchemaResult.get();
            } else {
                result.addError("Parameter mainAppSchema set to " + mainAppSchemaName + " but no schema with this name was selected in the configuration");
                mainAppSchema = null;
            }
        }
        return mainAppSchema;
    }
}

