/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.Util.XsltWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TargetOutputProcessor
implements MessageSource {
    public static final String PARAM_APPLY_XSLT = "processOutput_applyXslt";
    public static final String PARAM_XSLT_OUTPUT_SUFFIX = "processOutput_xslt_outputSuffix";
    public static final String DEFAULT_XSLT_OUTPUT_SUFFIX = "_transformed.xml";
    public static final String PARAM_XSLT_DELETE_INPUT_AFTER_TRANSFORM = "processOutput_xslt_deleteInputFilesAfterTransformation";
    public static final String PARAM_PATH_TO_XSLT_DIRECTORY = "processOutput_pathToXsltDirectory";
    public static final String PARAM_XSLT_FILENAME = "processOutput_xsltFileName";
    public static final String PARAM_XSL_TRANSFORMER_FACTORY = "xslTransformerFactory";
    public static final String PARAM_ADD_COMMENT = "processOutput_addComment";
    public static final String PARAM_COMMENT = "processOutput_comment";
    public static final String PARAM_MODIFY_FILE_NAME = "processOutput_modifyFileName";
    public static final String PARAM_FILENAME_PREFIX = "processOutput_fileNamePrefix";
    ShapeChangeResult result;

    public TargetOutputProcessor(ShapeChangeResult result) {
        this.result = result;
    }

    public void process(List<File> outputFiles, TargetConfiguration tgt, PackageInfo schema) {
        boolean modifyFileName = tgt.parameterAsBoolean(PARAM_MODIFY_FILE_NAME, false);
        boolean addComment = tgt.parameterAsBoolean(PARAM_ADD_COMMENT, false);
        boolean applyXslt = tgt.parameterAsBoolean(PARAM_APPLY_XSLT, false);
        if (!(applyXslt || addComment || modifyFileName)) {
            return;
        }
        if (outputFiles == null || outputFiles.isEmpty()) {
            this.result.addProcessFlowInfo(this, 105);
        }
        this.result.addProcessFlowInfo(this, 100);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        List<File> filesToProcess = outputFiles;
        if (modifyFileName) {
            this.result.addProcessFlowInfo(this, 102);
            ArrayList<File> modifiedFiles = new ArrayList<File>();
            for (File file : filesToProcess) {
                Date lastModified = new Date(file.lastModified());
                String defaultFileNamePrefix = dateFormat.format(lastModified);
                String fileNamePrefix = tgt.parameterAsString(PARAM_FILENAME_PREFIX, defaultFileNamePrefix, false, true);
                StringBuilder newFileName = new StringBuilder();
                newFileName.append(fileNamePrefix);
                newFileName.append(".");
                if (schema != null && schema.version() != null) {
                    newFileName.append("v");
                    newFileName.append(schema.version());
                    newFileName.append(".");
                }
                newFileName.append(file.getName());
                Path from = file.toPath();
                Path to = from.getParent().resolve(newFileName.toString());
                try {
                    Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
                    modifiedFiles.add(to.toFile());
                    this.result.updateResult(from.toFile(), to.toFile());
                }
                catch (IOException e) {
                    this.result.addProcessFlowError(this, 10, from.toAbsolutePath().toString(), to.toAbsolutePath().toString(), e.getMessage());
                    modifiedFiles.add(file);
                }
            }
            filesToProcess = modifiedFiles;
        }
        if (addComment) {
            this.result.addProcessFlowInfo(this, 103);
            for (File file : filesToProcess) {
                Date lastModified = new Date(file.lastModified());
                Object defaultComment = "Created by ShapeChange on ";
                defaultComment = (String)defaultComment + dateFormat.format(lastModified);
                if (schema != null && StringUtils.isNotBlank((CharSequence)schema.version())) {
                    defaultComment = (String)defaultComment + " from application schema version ";
                    defaultComment = (String)defaultComment + schema.version();
                }
                defaultComment = (String)defaultComment + " - http://shapechange.net/";
                String comment = tgt.parameterAsString(PARAM_COMMENT, (String)defaultComment, false, true);
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (fileExtension.matches("(?i)(xml|xsd|rdf|owl|sch|trix)")) {
                    this.addCommentToXmlFile(file, comment);
                    continue;
                }
                if (fileExtension.matches("(?i)(sql|ddl)")) {
                    this.addCommentToTextFile(file, "-- " + comment);
                    continue;
                }
                if (!fileExtension.matches("(?i)(ttl|nt|trig|nq)")) continue;
                this.addCommentToTextFile(file, "# " + comment);
            }
        }
        if (applyXslt) {
            this.result.addProcessFlowInfo(this, 104);
            for (File file : filesToProcess) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (!fileExtension.matches("(?i)(xml|xsd|rdf|owl|sch|trix|html|sql|ddl|ttl|nt|trig|nq)")) continue;
                String pathToXsltDirectory = tgt.parameterAsString(PARAM_PATH_TO_XSLT_DIRECTORY, ".", false, true);
                String xsltFileName = tgt.parameterAsString(PARAM_XSLT_FILENAME, null, false, true);
                String xslTransformerFactory = tgt.parameterAsString(PARAM_XSL_TRANSFORMER_FACTORY, null, false, true);
                String outputSuffix = tgt.parameterAsString(PARAM_XSLT_OUTPUT_SUFFIX, DEFAULT_XSLT_OUTPUT_SUFFIX, false, true);
                boolean deleteInputAfterTransform = tgt.parameterAsBoolean(PARAM_XSLT_DELETE_INPUT_AFTER_TRANSFORM, false);
                File transformationTargetFile = new File(file.getParentFile(), FilenameUtils.getBaseName((String)file.getName()) + outputSuffix);
                try {
                    URI xsltMainFileUri = null;
                    if (pathToXsltDirectory.toLowerCase().startsWith("http")) {
                        URL url = new URL(pathToXsltDirectory + "/" + xsltFileName);
                        xsltMainFileUri = url.toURI();
                    } else {
                        File xsl = new File(pathToXsltDirectory + "/" + xsltFileName);
                        if (xsl.exists()) {
                            xsltMainFileUri = xsl.toURI();
                        } else {
                            this.result.addProcessFlowError(this, 18, xsl.getAbsolutePath());
                        }
                    }
                    XsltWriter writer = new XsltWriter(xslTransformerFactory, null, null, this.result);
                    writer.xsltWrite(file, xsltMainFileUri, transformationTargetFile);
                    if (file.toPath().equals(transformationTargetFile.toPath())) continue;
                    if (deleteInputAfterTransform) {
                        FileUtils.deleteQuietly((File)file);
                        this.result.updateResult(file, transformationTargetFile);
                        continue;
                    }
                    this.result.copyResultAndUpdateFileReference(file, transformationTargetFile);
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) continue;
                    this.result.addProcessFlowError(m);
                }
            }
        }
        this.result.addProcessFlowInfo(this, 101);
    }

    public void addCommentToTextFile(File txtFile, String comment) {
        File directory = txtFile.getParentFile();
        File tmpFile = new File(directory, txtFile.getName() + ".tmp");
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF8"));
             BufferedReader in = new BufferedReader(new FileReader(txtFile));){
            out.write(comment);
            out.newLine();
            String line = null;
            while ((line = in.readLine()) != null) {
                out.write(line);
                out.newLine();
            }
        }
        catch (IOException e) {
            this.result.addProcessFlowError(this, 15, txtFile.getAbsolutePath(), e.getMessage());
        }
        if (tmpFile.exists()) {
            try {
                Files.move(tmpFile.toPath(), txtFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.result.addProcessFlowError(this, 10, tmpFile.getAbsolutePath(), txtFile.getAbsolutePath(), e.getMessage());
            }
        }
    }

    public void addCommentToXmlFile(File xmlFile, String comment) {
        File directory = xmlFile.getParentFile();
        File tmpFile = new File(directory, xmlFile.getName() + ".tmp");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            Comment com = doc.createComment(comment);
            Element root = doc.getDocumentElement();
            root.insertBefore(com, root.getFirstChild());
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult output = new StreamResult(tmpFile);
            DOMSource input = new DOMSource(doc);
            transformer.transform(input, output);
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            this.result.addProcessFlowError(this, 20, xmlFile.getAbsolutePath(), e.getMessage());
        }
        if (tmpFile.exists()) {
            try {
                Files.move(tmpFile.toPath(), xmlFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.result.addProcessFlowError(this, 10, tmpFile.getAbsolutePath(), xmlFile.getAbsolutePath(), e.getMessage());
            }
        }
    }

    public static SortedSet<String> getRecognizedParameters() {
        return new TreeSet<String>(Stream.of(PARAM_APPLY_XSLT, PARAM_ADD_COMMENT, PARAM_COMMENT, PARAM_FILENAME_PREFIX, PARAM_MODIFY_FILE_NAME, PARAM_PATH_TO_XSLT_DIRECTORY, PARAM_XSL_TRANSFORMER_FACTORY, PARAM_XSLT_DELETE_INPUT_AFTER_TRANSFORM, PARAM_XSLT_FILENAME, PARAM_XSLT_OUTPUT_SUFFIX).collect(Collectors.toSet()));
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 10: {
                return "Exception occurred while moving file from '$1$' to '$2$'. Exception message is: '$3$'.";
            }
            case 15: {
                return "Exception occurred while writing comment to text file located at '$1$'. Exception message is: '$2$'.";
            }
            case 18: {
                return "XSLT stylesheet $1$ not found.";
            }
            case 20: {
                return "Exception occurred while writing comment to XML file located at '$1$'. Exception message is: '$2$'.";
            }
            case 100: {
                return "---------- Processing output: START ----------";
            }
            case 101: {
                return "---------- Processing output: COMPLETE ----------";
            }
            case 102: {
                return "--- Modifying file names ...";
            }
            case 103: {
                return "--- Adding comments ...";
            }
            case 104: {
                return "--- Applying XSL transformation ...";
            }
            case 105: {
                return "---------- Processing output: no output files produced by target ----------";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

