/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Statistics;

import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Target.Statistics.ClassStatistic;
import java.util.ArrayList;
import java.util.List;

public class SchemaStatistic {
    private String schemaName;
    private PackageInfo schemaPackage;
    private int numProps;
    private int numFeatureRels;
    private double percentFeatureRelationships;
    private List<ClassStatistic> classStats = new ArrayList<ClassStatistic>();

    public SchemaStatistic(String schemaName, PackageInfo schemaPackage) {
        this.schemaName = schemaName;
        this.schemaPackage = schemaPackage;
    }

    public void add(ClassStatistic cs) {
        this.classStats.add(cs);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public List<ClassStatistic> getClassStatistics() {
        return this.classStats;
    }

    public void computeStatistics() {
        for (ClassStatistic cs : this.classStats) {
            this.numProps += cs.numberOfProperties();
            this.numFeatureRels += cs.numberOfFeatureRelationships();
        }
        if (this.numProps > 0) {
            this.percentFeatureRelationships = (double)this.numFeatureRels / (double)this.numProps * 100.0;
        }
    }

    public double percentOfFeatureRelationships() {
        return this.percentFeatureRelationships;
    }

    public int numberOfProperties() {
        return this.numProps;
    }

    public int numberOfFeatureRelationships() {
        return this.numFeatureRels;
    }
}

