/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Statistics;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;

public class ClassStatistic {
    private ClassInfo ci;
    private int numProps;
    private int numFeatureRels;
    private double percentFeatureRelationships;

    public ClassStatistic(ClassInfo ci) {
        this.ci = ci;
        this.computeStatistics();
    }

    private void computeStatistics() {
        int n = this.numProps = this.ci.properties().isEmpty() ? 0 : this.ci.properties().size();
        if (this.numProps > 0) {
            this.numFeatureRels = 0;
            for (PropertyInfo pi : this.ci.properties().values()) {
                if (pi.categoryOfValue() != 1) continue;
                ++this.numFeatureRels;
            }
            this.percentFeatureRelationships = (double)this.numFeatureRels / (double)this.numProps * 100.0;
        }
    }

    public ClassInfo getClassInfo() {
        return this.ci;
    }

    public double percentOfFeatureRelationships() {
        return this.percentFeatureRelationships;
    }

    public int numberOfProperties() {
        return this.numProps;
    }

    public int numberOfFeatureRelationships() {
        return this.numFeatureRels;
    }
}

