/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Statistics;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.Statistics.ClassStatistic;
import de.interactive_instruments.ShapeChange.Target.Statistics.SchemaStatistic;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ApplicationSchemaStatistic
implements SingleTarget,
MessageSource {
    private ShapeChangeResult result = null;
    private PackageInfo schema = null;
    private Model model = null;
    private Options options = null;
    private static String outputDirectory = null;
    private static String outputFilename = null;
    private static final String indent1 = "  ";
    private static final String indent2 = "    ";
    private int streamBufferSize = 8686112;
    private static boolean initialised = false;
    private static boolean printed = false;
    private static List<SchemaStatistic> schemaStats = null;
    private static SchemaStatistic schemaStat = null;
    private static Map<String, Integer> encounteredAppSchemasByName = null;

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schema = pi;
        this.model = m;
        this.options = o;
        this.result = r;
        if (!initialised) {
            initialised = true;
            encounteredAppSchemasByName = new HashMap<String, Integer>();
            schemaStats = new ArrayList<SchemaStatistic>();
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = ".";
            }
            if ((outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename")) == null) {
                outputFilename = "ModelStatistic";
            }
        }
        Object nameForAppSchema = null;
        if (encounteredAppSchemasByName.containsKey(pi.name())) {
            int count = encounteredAppSchemasByName.get(pi.name());
            nameForAppSchema = pi.name() + " (" + ++count + ")";
            encounteredAppSchemasByName.put(pi.name(), count);
        } else {
            nameForAppSchema = pi.name();
            encounteredAppSchemasByName.put(pi.name(), 1);
        }
        schemaStat = new SchemaStatistic((String)nameForAppSchema, pi);
        schemaStats.add(schemaStat);
    }

    @Override
    public void process(ClassInfo ci) {
        ClassStatistic cs = new ClassStatistic(ci);
        schemaStat.add(cs);
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "Application Schema Statistics";
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        if (printed) {
            return;
        }
        this.result = r;
        for (SchemaStatistic sc : schemaStats) {
            sc.computeStatistics();
        }
        this.printTextFile();
    }

    public void printTextFile() {
        String fileName = outputFilename + ".txt";
        File outputDirectoryFile = new File(outputDirectory);
        if (!outputDirectoryFile.exists()) {
            try {
                FileUtils.forceMkdir((File)outputDirectoryFile);
            }
            catch (Exception e) {
                this.result.addError(this, 100, e.getMessage());
                e.printStackTrace();
            }
        }
        File file = new File(outputDirectory, fileName);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), this.streamBufferSize));){
            for (SchemaStatistic ss : schemaStats) {
                writer.println("----------");
                writer.println(ss.getSchemaName());
                writer.println("  Number of properties in schema: " + ss.numberOfProperties());
                writer.println("  Number of relationships to features in schema: " + ss.numberOfFeatureRelationships());
                writer.println("  Percent of relationships to features: " + String.format("%.2f", ss.percentOfFeatureRelationships()));
                writer.println("----------");
                for (ClassStatistic cs : ss.getClassStatistics()) {
                    writer.println(indent1 + this.categoryAsString(cs.getClassInfo()) + " " + cs.getClassInfo().name());
                    writer.println("    Number of properties: " + cs.numberOfProperties());
                    writer.println("    Number of relationships to features: " + cs.numberOfFeatureRelationships());
                    writer.println("    Percent of relationships to features: " + String.format("%.2f", cs.percentOfFeatureRelationships()));
                }
            }
            writer.close();
            this.result.addResult(this.getTargetName(), outputDirectory, fileName, null);
            printed = true;
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    private String categoryAsString(ClassInfo classInfo) {
        switch (classInfo.category()) {
            case 1: {
                return "<<featureType>>";
            }
            case 6: {
                return "<<type>>";
            }
            case 5: {
                return "<<dataType>>";
            }
            case 3: {
                return "<<enumeration>>";
            }
            case 2: {
                return "<<codeList>>";
            }
            case 14: {
                return "<<attributeConcept>>";
            }
            case 17: {
                return "<<roleConcept>>";
            }
            case 13: {
                return "<<featureConcept";
            }
            case 7: {
                return "<<basicType>>";
            }
            case 4: {
                return "<<type>> (mixin)";
            }
            case 8: {
                return "<<union>>";
            }
            case 12: {
                return "<<fachId>>";
            }
            case 11: {
                return "<<schluesseltabelle>>";
            }
            case 15: {
                return "<<valueConcept>>";
            }
        }
        return "<unknown stereotyped> class";
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetIdentifier() {
        return "asstat";
    }

    @Override
    public void reset() {
        initialised = false;
        outputDirectory = null;
        outputFilename = null;
        printed = false;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class ApplicationSchemaStatistic";
            }
            case 100: {
                return "Could not create output directory. Exception message is: $1$";
            }
        }
        return "(" + ApplicationSchemaStatistic.class.getName() + ") Unknown message with number: " + mnr;
    }
}

