/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.structure;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SqlConstraint;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Table {
    private String schemaName = null;
    private String name = null;
    private String documentation = null;
    private List<Column> columns = new ArrayList<Column>();
    private List<SqlConstraint> constraints = new ArrayList<SqlConstraint>();
    private boolean isAssociativeTable = false;
    private ClassInfo representedClass = null;
    private AssociationInfo representedAssociation = null;
    private PropertyInfo representedProperty = null;
    private boolean representsCodeStatusCLType = false;
    private boolean isUsageSpecific = false;

    public Table(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.name = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.name;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns != null ? columns : new ArrayList<Column>();
    }

    public void removeColumns(List<Column> columnsToRemove) {
        if (columnsToRemove != null) {
            for (Column ctr : columnsToRemove) {
                this.columns.remove(ctr);
            }
        }
    }

    public List<SqlConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<SqlConstraint> constraints) {
        this.constraints = constraints == null ? new ArrayList<SqlConstraint>() : constraints;
    }

    public void addConstraint(SqlConstraint constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(List<SqlConstraint> constraints) {
        this.constraints.addAll(constraints);
    }

    public String toString() {
        return this.name;
    }

    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    public boolean isAssociativeTable() {
        return this.isAssociativeTable;
    }

    public void setAssociativeTable(boolean isAssociativeTable) {
        this.isAssociativeTable = isAssociativeTable;
    }

    public ClassInfo getRepresentedClass() {
        return this.representedClass;
    }

    public void setRepresentedClass(ClassInfo representedClass) {
        this.representedClass = representedClass;
    }

    public AssociationInfo getRepresentedAssociation() {
        return this.representedAssociation;
    }

    public void setRepresentedAssociation(AssociationInfo representedAssociation) {
        this.representedAssociation = representedAssociation;
    }

    public PropertyInfo getRepresentedProperty() {
        return this.representedProperty;
    }

    public void setRepresentedProperty(PropertyInfo representedProperty) {
        this.representedProperty = representedProperty;
    }

    public boolean representsClass(ClassInfo ci) {
        return ci != null && this.representedClass != null && ci == this.representedClass;
    }

    public String getGlobalId() {
        Object globalId = null;
        if (this.representedClass != null) {
            globalId = this.representedClass.globalIdentifier();
        } else if (this.representedProperty != null && this.representedProperty.inClass().globalIdentifier() != null && this.representedProperty.globalIdentifier() != null) {
            globalId = this.representedProperty.inClass().globalIdentifier() + "." + this.representedProperty.globalIdentifier();
        } else if (this.representedAssociation != null) {
            globalId = this.representedAssociation.globalIdentifier();
        }
        return globalId;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public boolean representsCodeStatusCLType() {
        return this.representsCodeStatusCLType;
    }

    public void setRepresentsCodeStatusCLType(boolean representsCodeStatusCLType) {
        this.representsCodeStatusCLType = representsCodeStatusCLType;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public boolean hasSchemaName() {
        return StringUtils.isNotBlank((CharSequence)this.schemaName);
    }

    public String getFullName() {
        if (this.hasSchemaName()) {
            return this.schemaName + "." + this.name;
        }
        return this.name;
    }

    public boolean isUsageSpecificTable() {
        return this.isUsageSpecific;
    }

    public void setUsageSpecificTable(boolean isUsageSpecific) {
        this.isUsageSpecific = isUsageSpecific;
    }
}

