/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.structure;

import com.google.common.base.Joiner;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteCreateSpatialIndexExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.StatementFilter;
import java.util.ArrayList;
import java.util.List;

public class SpatialIndexStatementFilter
implements StatementFilter {
    @Override
    public List<Statement> filter(List<Statement> statements) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        Joiner specJoiner = Joiner.on((String)" ").skipNulls();
        for (Statement stmt : statements) {
            CreateIndex cIndex;
            Index index;
            if (stmt instanceof Select) {
                Select select = (Select)stmt;
                if (!select.hasExpression() || !(select.getExpression() instanceof SpatiaLiteCreateSpatialIndexExpression)) continue;
                result.add(select);
                continue;
            }
            if (stmt instanceof Insert) {
                Insert ins = (Insert)stmt;
                if (!ins.getTable().getName().equalsIgnoreCase("USER_SDO_GEOM_METADATA")) continue;
                result.add(stmt);
                continue;
            }
            if (!(stmt instanceof CreateIndex) || (!(index = (cIndex = (CreateIndex)stmt).getIndex()).hasSpecs() || !specJoiner.join(index.getSpecs()).contains("MDSYS.SPATIAL_INDEX")) && !"GIST".equals(index.getProperties().getProperty("method")) && !"SPATIAL".equals(index.getType())) continue;
            result.add(stmt);
        }
        return result;
    }
}

