/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.structure;

import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SqlConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ForeignKeyConstraint
extends SqlConstraint {
    private Table referenceTable = null;
    private List<Column> referenceColumns = new ArrayList<Column>();
    private Option onDelete = null;
    private Option onUpdate = null;

    public ForeignKeyConstraint(String name, Table referenceTable) {
        super(name);
        this.referenceTable = referenceTable;
    }

    public Table getReferenceTable() {
        return this.referenceTable;
    }

    public void setReferenceTable(Table referenceTable) {
        this.referenceTable = referenceTable;
    }

    public List<Column> getReferenceColumns() {
        return this.referenceColumns;
    }

    public void setReferenceColumns(List<Column> referenceColumns) {
        this.referenceColumns = referenceColumns;
    }

    public void addReferenceColumn(Column refColumn) {
        this.referenceColumns.add(refColumn);
    }

    public Option getOnDelete() {
        return this.onDelete;
    }

    public boolean hasOnDelete() {
        return this.onDelete != null;
    }

    public void setOnDelete(Option o) {
        this.onDelete = o;
    }

    public boolean hasOnUpdate() {
        return this.onUpdate != null;
    }

    public Option getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(Option o) {
        this.onUpdate = o;
    }

    public String toString() {
        return (String)(this.hasName() ? "CONSTRAINT " + this.getName() + " " : "") + "FOREIGN KEY " + SqlUtil.getStringList(this.getColumns(), true, true) + " REFERENCES " + this.referenceTable.getFullName() + (this.referenceColumns != null && !this.referenceColumns.isEmpty() ? SqlUtil.getStringList(this.referenceColumns, true, true) : "") + (String)(this.onDelete != null ? " ON DELETE " + this.onDelete.toString() : "") + (String)(this.onUpdate != null ? " ON UPDATE " + this.onUpdate.toString() : "");
    }

    public static enum Option {
        NO_ACTION("NO ACTION"),
        CASCADE("CASCADE"),
        RESTRICT("RESTRICT"),
        SET_NULL("SET NULL"),
        SET_DEFAULT("SET DEFAULT");

        private final String sqlExpr;

        private Option(String sqlExpr) {
            this.sqlExpr = sqlExpr;
        }

        public String toString() {
            return this.sqlExpr;
        }

        public static Option fromString(String s) {
            if (StringUtils.isNotBlank((CharSequence)s)) {
                if (s.matches("(?i)\\s*no\\s*action\\s*")) {
                    return NO_ACTION;
                }
                if (s.matches("(?i)\\s*restrict\\s*")) {
                    return RESTRICT;
                }
                if (s.matches("(?i)\\s*set\\s*null\\s*")) {
                    return SET_NULL;
                }
                if (s.matches("(?i)\\s*set\\s*default\\s*")) {
                    return SET_DEFAULT;
                }
                if (s.matches("(?i)\\s*cascade\\s*")) {
                    return CASCADE;
                }
                throw new IllegalArgumentException("Cannot determine enum from: " + s);
            }
            throw new IllegalArgumentException("Cannot determine enum from blank string (null, empty, or whitespace only).");
        }
    }
}

