/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.structure;

import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.StatementVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;

public class Comment
implements Statement {
    private Table table = null;
    private Column column = null;
    private String text;

    public Comment(Table table, String text) {
        this.table = table;
        this.text = text;
    }

    public Comment(Column column, String text) {
        this.column = column;
        this.text = text;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Column getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public String computeTargetName() {
        if (this.column == null) {
            return this.table.getFullName();
        }
        return this.column.getInTable().getFullName() + "." + this.column.getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("COMMENT ON ");
        sb.append(this.column == null ? "TABLE " : "COLUMN ");
        sb.append(this.computeTargetName());
        sb.append(" IS '");
        sb.append(this.text.replaceAll("'", "''"));
        sb.append("'");
        return sb.toString();
    }
}

