/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.structure;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class Column {
    private String name = null;
    private List<String> specifications = new ArrayList<String>();
    private ColumnDataType dataType = null;
    private Expression defaultValue = null;
    private Table inTable = null;
    private PropertyInfo representedProperty = null;
    private ClassInfo enumerationValueType = null;
    private String documentation = null;
    private Table referencedTable = null;
    private boolean isObjectIdentifierColumn = false;
    private boolean isForeignKeyColumn = false;

    public Column(String name, String documentation, Table inTable) {
        this.name = name;
        this.documentation = documentation;
        this.inTable = inTable;
    }

    public Column(String name, PropertyInfo representedProperty, String documentation, Table inTable) {
        this.name = name;
        this.representedProperty = representedProperty;
        this.documentation = documentation;
        this.inTable = inTable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSpecifications() {
        return this.specifications;
    }

    public void setSpecifications(List<String> specifications) {
        this.specifications = specifications != null ? specifications : new ArrayList<String>();
    }

    public void addSpecification(String spec) {
        this.specifications.add(spec);
    }

    public ColumnDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ColumnDataType dataType) {
        this.dataType = dataType;
    }

    public String toString() {
        return this.name;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public PropertyInfo getRepresentedProperty() {
        return this.representedProperty;
    }

    public void setRepresentedProperty(PropertyInfo representedProperty) {
        this.representedProperty = representedProperty;
    }

    public Table getInTable() {
        return this.inTable;
    }

    public void setInTable(Table inTable) {
        this.inTable = inTable;
    }

    public void setObjectIdentifierColumn(boolean isObjectIdentifierColumn) {
        this.isObjectIdentifierColumn = isObjectIdentifierColumn;
    }

    public boolean isObjectIdentifierColumn() {
        return this.isObjectIdentifierColumn;
    }

    public boolean isForeignKeyColumn() {
        return this.isForeignKeyColumn;
    }

    public boolean isPrimaryKeyColumn() {
        return this.hasSpecificationIgnoringCase("primary key");
    }

    public boolean isNotNull() {
        String columnSpec = this.getSpecifications() == null ? "" : StringUtils.join(this.getSpecifications(), (String)" ");
        return columnSpec.toLowerCase(Locale.ENGLISH).contains("not null");
    }

    public void setForeignKeyColumn(boolean isForeignKeyColumn) {
        this.isForeignKeyColumn = isForeignKeyColumn;
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    public void setReferencedTable(Table refTable) {
        this.referencedTable = refTable;
    }

    public void removeSpecification(String specIn) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.specifications) {
            if (s.equalsIgnoreCase(specIn)) continue;
            result.add(s);
        }
        this.specifications = result;
    }

    public boolean hasSpecificationIgnoringCase(String specIn) {
        String specInLower = specIn.toLowerCase(Locale.ENGLISH);
        for (String specification : this.specifications) {
            String specificationLower = specification.toLowerCase(Locale.ENGLISH);
            if (!specificationLower.contains(specInLower)) continue;
            return true;
        }
        return false;
    }

    public ClassInfo getEnumerationValueType() {
        return this.enumerationValueType;
    }

    public void setEnumerationValueType(ClassInfo enumerationValueType) {
        this.enumerationValueType = enumerationValueType;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

