/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.naming;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.ForeignKeyNamingStrategy;
import java.util.HashMap;
import java.util.Map;

public class OracleStyleForeignKeyNamingStrategy
implements ForeignKeyNamingStrategy,
MessageSource {
    private Map<String, Integer> countByForeignKeyOracleStyle = new HashMap<String, Integer>();
    private ShapeChangeResult result;

    public OracleStyleForeignKeyNamingStrategy(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public String nameForForeignKeyConstraint(String tableName, String fieldName, String targetTableName) {
        String res;
        String tableNameForFK = tableName.length() > 8 ? tableName.substring(0, 8) : tableName;
        String fieldNameForFK = fieldName.length() > 8 ? fieldName.substring(0, 8) : fieldName;
        String targetTableNameForFK = targetTableName.length() > 8 ? targetTableName.substring(0, 8) : targetTableName;
        String fk = "fk_" + tableNameForFK + "_" + targetTableNameForFK + "_" + fieldNameForFK;
        if (this.countByForeignKeyOracleStyle.containsKey(fk)) {
            Integer count = this.countByForeignKeyOracleStyle.get(fk);
            if (count > 9) {
                this.result.addWarning(this, 1, fk);
            }
            res = fk + count;
            this.countByForeignKeyOracleStyle.put(fk, count + 1);
        } else {
            res = fk;
            this.countByForeignKeyOracleStyle.put(fk, 0);
        }
        return res;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "??More than eleven occurrences of foreign key '$1$'.";
            }
        }
        return "(" + OracleStyleForeignKeyNamingStrategy.class.getName() + ") Unknown message with number: " + mnr;
    }
}

