/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.naming;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UpperCaseNameNormalizer;
import org.apache.commons.lang3.StringUtils;

public class OracleNameNormalizer
extends UpperCaseNameNormalizer
implements MessageSource {
    private ShapeChangeResult result;

    public OracleNameNormalizer(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public String normalize(String stringToNormalize) {
        String normalizedName = StringUtils.substring((String)super.normalize(stringToNormalize), (int)0, (int)30);
        if (stringToNormalize.length() != normalizedName.length()) {
            this.result.addWarning(this, 1, stringToNormalize, normalizedName);
        }
        return normalizedName;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Name '$1$' is truncated to '$2$'";
            }
        }
        return "(" + OracleNameNormalizer.class.getName() + ") Unknown message with number: " + mnr;
    }
}

