/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.naming;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.CheckConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.ForeignKeyNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.NameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.SqlNamingScheme;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UniqueConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UniqueNamingStrategy;

public class DefaultNamingScheme
implements SqlNamingScheme,
MessageSource {
    private NameNormalizer normalizer;
    private ForeignKeyNamingStrategy fkNaming;
    private CheckConstraintNamingStrategy ckNaming;
    private UniqueConstraintNamingStrategy ukNaming;
    private ShapeChangeResult result;
    private UniqueNamingStrategy uniqueNaming;

    public DefaultNamingScheme(ShapeChangeResult result, NameNormalizer normalizer, ForeignKeyNamingStrategy fkNaming, CheckConstraintNamingStrategy ckNaming, UniqueConstraintNamingStrategy ukNaming, UniqueNamingStrategy uniqueNaming) {
        this.result = result;
        this.normalizer = normalizer;
        this.fkNaming = fkNaming;
        this.ckNaming = ckNaming;
        this.ukNaming = ukNaming;
        this.uniqueNaming = uniqueNaming;
    }

    @Override
    public String nameForCheckConstraint(String tableName, String propertyName) {
        String nonNormalizedConstraintName = this.ckNaming.nameForCheckConstraint(tableName, propertyName);
        String normalizedConstraintName = this.normalizer.normalize(nonNormalizedConstraintName);
        String constraintName = this.uniqueNaming.makeUnique(normalizedConstraintName);
        if (constraintName.length() != nonNormalizedConstraintName.length()) {
            this.result.addWarning(this, 1, nonNormalizedConstraintName, constraintName);
        }
        return constraintName;
    }

    @Override
    public String nameForForeignKeyConstraint(String tableName, String fieldName, String targetTableName) {
        String nonNormalizedConstraintName = this.fkNaming.nameForForeignKeyConstraint(tableName, fieldName, targetTableName);
        String normalizedConstraintName = this.normalizer.normalize(nonNormalizedConstraintName);
        String constraintName = this.uniqueNaming.makeUnique(normalizedConstraintName);
        if (constraintName.length() != nonNormalizedConstraintName.length()) {
            this.result.addWarning(this, 2, nonNormalizedConstraintName, constraintName);
        }
        return constraintName;
    }

    @Override
    public String nameForUniqueConstraint(String tableName, String columnName) {
        String nonNormalizedConstraintName = this.ukNaming.nameForUniqueConstraint(tableName, columnName);
        String normalizedConstraintName = this.normalizer.normalize(nonNormalizedConstraintName);
        String constraintName = this.uniqueNaming.makeUnique(normalizedConstraintName);
        if (constraintName.length() != nonNormalizedConstraintName.length()) {
            this.result.addWarning(this, 3, nonNormalizedConstraintName, constraintName);
        }
        return constraintName;
    }

    @Override
    public NameNormalizer getNameNormalizer() {
        return this.normalizer;
    }

    @Override
    public String nameForGeometryIndex(String tableName, String columnName) {
        return "idx_" + tableName + "_" + columnName;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Name '$1$' for check constraint is truncated to '$2$'";
            }
            case 2: {
                return "Name '$1$' for foreign key constraint is truncated to '$2$'";
            }
            case 3: {
                return "Name '$1$' for unique constraint is truncated to '$2$'";
            }
        }
        return "(" + DefaultNamingScheme.class.getName() + ") Unknown message with number: " + mnr;
    }
}

