/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.naming;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UniqueNamingStrategy;
import java.util.HashSet;
import java.util.Set;

public class CountSuffixUniqueNamingStrategy
implements UniqueNamingStrategy,
MessageSource {
    private Set<String> names = new HashSet<String>();
    private ShapeChangeResult result;

    public CountSuffixUniqueNamingStrategy(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public String makeUnique(String proposedName) {
        Object newProposedName = proposedName;
        int suffix = 0;
        String suffixAsString = String.valueOf(suffix);
        while (this.names.contains(newProposedName) && suffix <= 9999 && suffixAsString.length() <= ((String)newProposedName).length() - 1) {
            newProposedName = ((String)newProposedName).substring(0, ((String)newProposedName).length() - suffixAsString.length()) + suffixAsString;
            suffixAsString = String.valueOf(++suffix);
        }
        if (this.names.contains(newProposedName)) {
            this.result.addError(this, 1, proposedName, (String)newProposedName);
            return proposedName;
        }
        this.names.add((String)newProposedName);
        return newProposedName;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Could not make name '$1$' unique. Last possible name '$2$' is already taken.";
            }
        }
        return "(" + CountSuffixUniqueNamingStrategy.class.getName() + ") Unknown message with number: " + mnr;
    }
}

