/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.naming;

import de.interactive_instruments.ShapeChange.Target.SQL.naming.NameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.AlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Comment;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ConstraintAlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.DropSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PostgreSQLAlterRole;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SQLitePragma;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.List;

public abstract class AbstractNameNormalizer
implements NameNormalizer {
    private boolean isIgnoreCaseWhenNormalizing = false;

    @Override
    public void setIgnoreCaseWhenNormalizing(boolean isIgnoreCaseWhenNormalizing) {
        this.isIgnoreCaseWhenNormalizing = isIgnoreCaseWhenNormalizing;
    }

    @Override
    public boolean isIgnoreCaseWhenNormalizing() {
        return this.isIgnoreCaseWhenNormalizing;
    }

    @Override
    public void visit(Insert insert) {
    }

    @Override
    public void visit(Select select) {
    }

    @Override
    public void visit(CreateIndex createIndex) {
        createIndex.getIndex().setName(this.normalize(createIndex.getIndex().getName()));
    }

    @Override
    public void visit(CreateTable createTable) {
        Table table = createTable.getTable();
        table.setName(this.normalize(table.getName()));
        if (table.hasSchemaName()) {
            table.setSchemaName(this.normalize(table.getSchemaName()));
        }
        for (Column column : createTable.getTable().getColumns()) {
            column.setName(this.normalize(column.getName()));
        }
    }

    @Override
    public void visit(Alter alter) {
        ConstraintAlterExpression cae;
        AlterExpression expr = alter.getExpression();
        if (expr instanceof ConstraintAlterExpression && (cae = (ConstraintAlterExpression)expr).getConstraint().hasName()) {
            cae.getConstraint().setName(this.normalize(cae.getConstraint().getName()));
        }
    }

    @Override
    public void visit(List<Statement> stmts) {
        for (Statement stmt : stmts) {
            stmt.accept(this);
        }
    }

    @Override
    public void visit(Comment comment) {
    }

    @Override
    public void postprocess() {
    }

    @Override
    public void visit(SQLitePragma pragma) {
    }

    @Override
    public void visit(PostgreSQLAlterRole postgreSQLAlterRole) {
    }

    @Override
    public void visit(DropSchema dropSchema) {
    }

    @Override
    public void visit(CreateSchema createSchema) {
        createSchema.setSchemaName(this.normalize(createSchema.getSchemaName()));
    }

    @Override
    public String normalize(String stringToNormalize) {
        return stringToNormalize.replace(".", "_").replace("-", "_");
    }
}

