/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.expressions;

import de.interactive_instruments.ShapeChange.Target.SQL.expressions.BetweenExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ColumnExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.DoubleValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.EqualsExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ExpressionList;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ExpressionVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.InExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.IsNullExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.LongValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.NullValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.OrExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SdoDimArrayExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteAddGeometryColumn;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteCreateSpatialIndexExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.StringValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ToCharExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.UnquotedStringExpression;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ToStringExpressionVisitor
implements ExpressionVisitor {
    protected StringBuffer sb = new StringBuffer();
    private List<String> expressions = new ArrayList<String>();

    @Override
    public void visit(ExpressionList expressionList) {
        for (Expression expression : expressionList.getExpressions()) {
            expression.accept(this);
        }
    }

    public String getResult() {
        this.sb.append("(");
        this.sb.append(StringUtils.join(this.expressions, (String)","));
        this.sb.append(")");
        return this.sb.toString();
    }

    @Override
    public void visit(NullValueExpression nullValue) {
        this.expressions.add("NULL");
    }

    @Override
    public void visit(StringValueExpression stringValue) {
        this.expressions.add(stringValue.getQuotedValue());
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.expressions.add(orExpression.toString());
    }

    @Override
    public void visit(InExpression inExpression) {
        this.expressions.add(inExpression.toString());
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        this.expressions.add(isNullExpression.toString());
    }

    @Override
    public void visit(ColumnExpression columnExpression) {
        this.expressions.add(columnExpression.toString());
    }

    @Override
    public void visit(SdoDimArrayExpression sdoDimArrayExpression) {
        this.expressions.add(sdoDimArrayExpression.toString());
    }

    @Override
    public void visit(LongValueExpression longValue) {
        this.expressions.add(longValue.toString());
    }

    @Override
    public void visit(ToCharExpression toCharExpression) {
        this.expressions.add(toCharExpression.toString());
    }

    @Override
    public void visit(EqualsExpression equalsExpression) {
        this.expressions.add(equalsExpression.toString());
    }

    @Override
    public void visit(UnquotedStringExpression unquotedStringExpression) {
        this.expressions.add(unquotedStringExpression.toString());
    }

    @Override
    public void visit(BetweenExpression betweenExpression) {
        this.expressions.add(betweenExpression.toString());
    }

    @Override
    public void visit(DoubleValueExpression doubleValueExpression) {
        this.expressions.add(doubleValueExpression.toString());
    }

    @Override
    public void visit(SpatiaLiteCreateSpatialIndexExpression spatiaLiteCreateSpatialIndexExpression) {
        this.expressions.add(spatiaLiteCreateSpatialIndexExpression.toString());
    }

    @Override
    public void visit(SpatiaLiteAddGeometryColumn spatiaLiteAddGeometryColumn) {
        this.expressions.add(spatiaLiteAddGeometryColumn.toString());
    }
}

