/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL.expressions;

import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ExpressionVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;

public class SpatiaLiteAddGeometryColumn
implements Expression {
    protected Table table;
    protected Column column;
    protected int srid;
    protected String geometryDimension;

    public SpatiaLiteAddGeometryColumn(Table table, Column column, int srid, String geometryDimension) {
        this.table = table;
        this.column = column;
        this.srid = srid;
        this.geometryDimension = geometryDimension;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Column getColumn() {
        return this.column;
    }

    public int getSrid() {
        return this.srid;
    }

    public String getGeometryDimension() {
        return this.geometryDimension;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AddGeometryColumn('");
        sb.append(this.table.getFullName());
        sb.append("', '");
        sb.append(this.column.getName());
        sb.append("', ");
        sb.append(this.srid);
        sb.append(", '");
        sb.append(this.column.getDataType().getName());
        sb.append("'");
        if (this.geometryDimension != null) {
            try {
                int dim = Integer.parseInt(this.geometryDimension);
                sb.append(", ");
                sb.append(dim);
            }
            catch (NumberFormatException e) {
                sb.append(", '");
                sb.append(this.geometryDimension);
                sb.append("'");
            }
        }
        if (this.column.isNotNull()) {
            sb.append(", -1");
        } else {
            sb.append(", 0");
        }
        sb.append(")");
        return sb.toString();
    }
}

