/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ExpressionList;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteAddGeometryColumn;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteCreateSpatialIndexExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ToStringExpressionVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.AlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Comment;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ConstraintAlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SQLitePragma;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SqlConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.Comparator;

public class StatementSortAlphabetic
implements Comparator<Statement> {
    @Override
    public int compare(Statement o1, Statement o2) {
        int typePriority_o2;
        if (o1 == o2) {
            return 0;
        }
        int typePriority_o1 = this.typePriority(o1);
        if (typePriority_o1 < (typePriority_o2 = this.typePriority(o2))) {
            return -1;
        }
        if (typePriority_o1 > typePriority_o2) {
            return 1;
        }
        if (o1 instanceof SQLitePragma) {
            String p1Name = ((SQLitePragma)o1).getName();
            String p2Name = ((SQLitePragma)o2).getName();
            return p1Name.compareTo(p2Name);
        }
        if (o1 instanceof CreateTable) {
            String tableName_o1 = ((CreateTable)o1).getTable().getFullName();
            String tableName_o2 = ((CreateTable)o2).getTable().getFullName();
            return tableName_o1.compareTo(tableName_o2);
        }
        if (o1 instanceof Select) {
            Select s1 = (Select)o1;
            Select s2 = (Select)o2;
            if (s1.hasExpression() && s2.hasExpression()) {
                Expression e1 = s1.getExpression();
                Expression e2 = s2.getExpression();
                if (e1 instanceof SpatiaLiteAddGeometryColumn && e2 instanceof SpatiaLiteCreateSpatialIndexExpression) {
                    return -1;
                }
                if (e1 instanceof SpatiaLiteCreateSpatialIndexExpression && e2 instanceof SpatiaLiteAddGeometryColumn) {
                    return 1;
                }
                if (e1 instanceof SpatiaLiteCreateSpatialIndexExpression && e2 instanceof SpatiaLiteCreateSpatialIndexExpression) {
                    SpatiaLiteCreateSpatialIndexExpression csie1 = (SpatiaLiteCreateSpatialIndexExpression)e1;
                    SpatiaLiteCreateSpatialIndexExpression csie2 = (SpatiaLiteCreateSpatialIndexExpression)e2;
                    int tableNameComp = csie1.getTable().getFullName().compareTo(csie2.getTable().getFullName());
                    if (tableNameComp == 0) {
                        return csie1.getColumn().getName().compareTo(csie2.getColumn().getName());
                    }
                    return tableNameComp;
                }
                if (e1 instanceof SpatiaLiteAddGeometryColumn && e2 instanceof SpatiaLiteAddGeometryColumn) {
                    SpatiaLiteAddGeometryColumn agc1 = (SpatiaLiteAddGeometryColumn)e1;
                    SpatiaLiteAddGeometryColumn agc2 = (SpatiaLiteAddGeometryColumn)e2;
                    int tableNameComp = agc1.getTable().getFullName().compareTo(agc2.getTable().getFullName());
                    if (tableNameComp == 0) {
                        return agc1.getColumn().getName().compareTo(agc2.getColumn().getName());
                    }
                    return tableNameComp;
                }
                return 0;
            }
            return 0;
        }
        if (o1 instanceof Alter) {
            String tableName_o2;
            Alter a1 = (Alter)o1;
            Alter a2 = (Alter)o2;
            String tableName_o1 = ((Alter)o1).getTable().getFullName();
            int compareTableName = tableName_o1.compareTo(tableName_o2 = ((Alter)o2).getTable().getFullName());
            if (compareTableName != 0) {
                return compareTableName;
            }
            AlterExpression ae1 = a1.getExpression();
            AlterExpression ae2 = a2.getExpression();
            if (ae1 instanceof ConstraintAlterExpression && ae2 instanceof ConstraintAlterExpression) {
                int compareIndexNames;
                ConstraintAlterExpression cae1 = (ConstraintAlterExpression)ae1;
                ConstraintAlterExpression cae2 = (ConstraintAlterExpression)ae2;
                SqlConstraint scae1 = cae1.getConstraint();
                SqlConstraint scae2 = cae2.getConstraint();
                if (scae1.hasName() && scae2.hasName() && (compareIndexNames = scae1.getName().compareTo(scae2.getName())) != 0) {
                    return compareIndexNames;
                }
            }
            return 0;
        }
        if (o1 instanceof CreateIndex) {
            CreateIndex ci1 = (CreateIndex)o1;
            CreateIndex ci2 = (CreateIndex)o2;
            Index ind1 = ci1.getIndex();
            Index ind2 = ci2.getIndex();
            int compareIndexName = ind1.getName().compareTo(ind2.getName());
            if (compareIndexName != 0) {
                return compareIndexName;
            }
            String tableName_o1 = ((CreateTable)o1).getTable().getFullName();
            String tableName_o2 = ((CreateTable)o2).getTable().getFullName();
            return tableName_o1.compareTo(tableName_o2);
        }
        if (o1 instanceof Insert) {
            String tableName_o2;
            Insert ins1 = (Insert)o1;
            Insert ins2 = (Insert)o2;
            Table tins1 = ins1.getTable();
            Table tins2 = ins2.getTable();
            if (tins1.representsCodeStatusCLType()) {
                return -1;
            }
            if (tins2.representsCodeStatusCLType()) {
                return 1;
            }
            String tableName_o1 = tins1.getFullName();
            int compareTableName = tableName_o1.compareTo(tableName_o2 = tins2.getFullName());
            if (compareTableName != 0) {
                return compareTableName;
            }
            ExpressionList il1 = ins1.getExpressionList();
            ExpressionList il2 = ins2.getExpressionList();
            ToStringExpressionVisitor ilv1 = new ToStringExpressionVisitor();
            ToStringExpressionVisitor ilv2 = new ToStringExpressionVisitor();
            il1.accept(ilv1);
            il2.accept(ilv2);
            return ilv1.getResult().compareTo(ilv2.getResult());
        }
        if (o1 instanceof Comment) {
            Comment comment1 = (Comment)o1;
            Comment comment2 = (Comment)o2;
            return comment1.computeTargetName().compareTo(comment2.computeTargetName());
        }
        return 0;
    }

    private int typePriority(Statement o1) {
        if (o1 instanceof SQLitePragma) {
            return 5;
        }
        if (o1 instanceof CreateTable) {
            return 10;
        }
        if (o1 instanceof Alter) {
            return 20;
        }
        if (o1 instanceof Select) {
            return 25;
        }
        if (o1 instanceof Insert) {
            return 30;
        }
        if (o1 instanceof CreateIndex) {
            return 40;
        }
        if (o1 instanceof Comment) {
            return 50;
        }
        return 1000;
    }
}

