/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ExpressionList;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.StringValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SqlUtil {
    public static boolean isGeometryTypedProperty(PropertyInfo pi) {
        String valueTypeName = pi.typeInfo().name;
        String piEncodingRule = pi.encodingRule("sql");
        ProcessMapEntry pme = pi.options().targetMapEntry(valueTypeName, piEncodingRule);
        return pme != null && SqlDdl.mapEntryParamInfos.hasParameter(valueTypeName, piEncodingRule, "geometry");
    }

    public static List<StringValueExpression> toStringValueList(String ... strings) {
        ArrayList<StringValueExpression> result = new ArrayList<StringValueExpression>();
        for (String string : strings) {
            result.add(new StringValueExpression(string));
        }
        return result;
    }

    public static List<Column> toColumnList(Table inTable, String ... columnNames) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (String name : columnNames) {
            result.add(new Column(name, null, inTable));
        }
        return result;
    }

    public static ExpressionList toExpressionList(List<? extends Expression> list) {
        ExpressionList result = new ExpressionList();
        ArrayList<Expression> tmp = new ArrayList<Expression>();
        result.setExpressions(tmp);
        for (Expression expression : list) {
            tmp.add(expression);
        }
        return result;
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets) {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            String separator = ", ";
            if (!useComma) {
                separator = " ";
            }
            if (useBrackets) {
                sb.append("(");
            }
            sb.append(StringUtils.join(list, (String)separator));
            if (useBrackets) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static String determineName(Table table, boolean useShortName) {
        String result = table.getFullName();
        if (useShortName) {
            Info representedInfo = table.getRepresentedClass();
            if (representedInfo == null) {
                representedInfo = table.getRepresentedAssociation();
            }
            if (representedInfo == null) {
                representedInfo = table.getRepresentedProperty();
            }
            if (representedInfo != null && StringUtils.isNotBlank((CharSequence)representedInfo.taggedValue(SqlDdl.shortNameByTaggedValue))) {
                result = representedInfo.taggedValue(SqlDdl.shortNameByTaggedValue).trim();
            }
        }
        return result;
    }

    public static String determineName(Column col, boolean useShortName) {
        PropertyInfo representedInfo;
        String result = col.getName();
        if (useShortName && (representedInfo = col.getRepresentedProperty()) != null && StringUtils.isNotBlank((CharSequence)representedInfo.taggedValue(SqlDdl.shortNameByTaggedValue))) {
            result = representedInfo.taggedValue(SqlDdl.shortNameByTaggedValue).trim();
        }
        return result;
    }

    public static String determineName(PropertyInfo pi, boolean useShortName) {
        String result = pi.name();
        if (useShortName && StringUtils.isNotBlank((CharSequence)pi.taggedValue(SqlDdl.shortNameByTaggedValue))) {
            result = pi.taggedValue(SqlDdl.shortNameByTaggedValue).trim();
        }
        return result;
    }
}

