/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.OracleStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.PostgreSQLStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLServerStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlConstants;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SqlDdlConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("dataModelEapPath", "dbOwner", "dbVersion", "deletePreExistingDataModelPackage", "dataModelPatternPath", "eaAuthor", "eaStatus", "dataModelEstablishPackageHierarchy", "tablespace", "replicationSchemaDocumentationForFieldWithUnlimitedLengthCharacterDataType", "replicationSchemaForeignKeyFieldType", "replicationSchemaObjectIdentifierFieldType", "replicationSchemaTargetNamespace", "replicationSchemaTargetNamespaceSuffix", "replicationSchemaTargetVersion", "replicationSchemaTargetXmlns", "applyForeignKeyColumnSuffixesInAssociativeTables", "eaAuthor", "codeNameColumnDocumentation", "codeNameColumnName", "codeNameSize", "codeSupercedesColumnDocumentation", "codeStatusCLColumnDocumentation", "codeStatusNotesColumnDocumentation", "codeStatusCLLength", "codeStatusCLType", "createDocumentation", "createReferences", "databaseSystem", "descriptorsForCodelist", "documentationNoValue", "documentationTemplate", "fileDdlBottom", "fileDdlTop", "foreignKeyColumnDataType", "foreignKeyColumnDatatype", "foreignKeyColumnSuffix", "foreignKeyColumnSuffixCodelist", "foreignKeyColumnSuffixDatatype", "geometryDimension", "idColumnName", "identifierColumnSuffix", "lengthQualifier", "maxNameLength", "nameForCodeStatusCLColumn", "nameForCodeStatusNotesColumn", "nameForCodeSupercedesColumn", "oneToManyReferenceColumnName", "postgreSqlRole", "primaryKeySpecification", "primaryKeySpecificationCodelist", "reflexiveRelationshipFieldSuffix", "removeEmptyLinesInDdlOutput", "sdoDimElements", "separateCodeInsertStatementsByCodelistType", "separateSpatialIndexStatements", "shortNameByTaggedValue", "size", "srid", "eaStatus", "taggedValuesToKeep").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;
    private ProcessConfiguration config = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        String lengthQualifier;
        File ddlBottom;
        String fileDdlBottom;
        File ddlTop;
        DatabaseStrategy databaseStrategy;
        this.config = config;
        this.options = options;
        this.result = result;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        TreeMap<String, ProcessMapEntry> mapEntryByType = new TreeMap<String, ProcessMapEntry>();
        for (ProcessMapEntry pme : config.getMapEntries()) {
            mapEntryByType.put(pme.getType(), pme);
        }
        MapEntryParamInfos mepis = new MapEntryParamInfos(result, mapEntryByType.values());
        isValid = isValid && mepis.isValid();
        String databaseSystem = config.getParameterValue("databaseSystem");
        if (databaseSystem == null || "postgresql".equalsIgnoreCase(databaseSystem)) {
            databaseStrategy = new PostgreSQLStrategy();
        } else if ("oracle".equalsIgnoreCase(databaseSystem)) {
            databaseStrategy = new OracleStrategy(result);
        } else if ("sqlserver".equalsIgnoreCase(databaseSystem)) {
            databaseStrategy = new SQLServerStrategy(result);
        } else if ("sqlite".equalsIgnoreCase(databaseSystem)) {
            databaseStrategy = new SQLServerStrategy(result);
        } else {
            databaseStrategy = new PostgreSQLStrategy();
            result.addError(this, 100, "databaseSystem", databaseSystem);
            isValid = false;
        }
        if (config.getAllRules().contains("rule-sql-all-schemas") && !(databaseStrategy instanceof PostgreSQLStrategy)) {
            isValid = false;
            result.addError(this, 107, databaseSystem);
        }
        isValid = isValid && this.checkCommonMapEntryParameters(mepis);
        isValid = isValid && databaseStrategy.validate(mapEntryByType, mepis);
        isValid = isValid && this.checkLengthPrecisionScalePattern(config.getMapEntries(), mepis);
        isValid = isValid && this.checkDescriptorsForCodeList(config, options, result);
        isValid = isValid && this.checkIntegerParameter("size");
        isValid = isValid && this.checkIntegerParameter("codeNameSize");
        String fileDdlTop = config.parameterAsString("fileDdlTop", null, false, true);
        if (!(fileDdlTop == null || (ddlTop = new File(fileDdlTop)).exists() && !ddlTop.isDirectory() && ddlTop.canRead())) {
            isValid = false;
            result.addError(this, 5, "fileDdlTop", fileDdlTop);
        }
        if (!((fileDdlBottom = config.parameterAsString("fileDdlBottom", null, false, true)) == null || (ddlBottom = new File(fileDdlBottom)).exists() && !ddlBottom.isDirectory() && ddlBottom.canRead())) {
            isValid = false;
            result.addError(this, 5, "fileDdlBottom", fileDdlBottom);
        }
        if ((lengthQualifier = config.parameterAsString("lengthQualifier", null, false, true)) != null && !"BYTE".equalsIgnoreCase(lengthQualifier) && !"CHAR".equalsIgnoreCase(lengthQualifier)) {
            isValid = false;
            result.addError(this, 100, "lengthQualifier", lengthQualifier);
        }
        return isValid;
    }

    private boolean checkLengthPrecisionScalePattern(List<ProcessMapEntry> mapEntries, MapEntryParamInfos mapEntryParamInfos) {
        boolean isValid = true;
        for (ProcessMapEntry me : mapEntries) {
            Matcher lengthPrecisionScale;
            String typeRuleKey = me.getType() + "#" + me.getRule();
            if (mapEntryParamInfos.hasParameter(me, "length") && mapEntryParamInfos.hasParameter(me, "precision")) {
                isValid = false;
                this.result.addError(this, 105, typeRuleKey, "length", "precision");
                continue;
            }
            if (!mapEntryParamInfos.hasParameter(me, "length") && !mapEntryParamInfos.hasParameter(me, "precision") || !(lengthPrecisionScale = SqlConstants.PATTERN_ME_TARGETTYPE_LENGTH_PRECISION_SCALE.matcher(me.getTargetType().trim())).matches()) continue;
            String group2 = lengthPrecisionScale.group(2);
            String group3 = lengthPrecisionScale.group(3);
            if (mapEntryParamInfos.hasParameter(me, "length")) {
                boolean bl = isValid = isValid && this.checkNonNegativeInteger(group2, typeRuleKey);
                if (group3 == null) continue;
                isValid = false;
                this.result.addError(this, 104, typeRuleKey, "length");
                continue;
            }
            if (!mapEntryParamInfos.hasParameter(me, "precision")) continue;
            boolean bl = isValid = isValid && this.checkNonNegativeInteger(group2, typeRuleKey);
            if (group3 == null) continue;
            isValid = isValid && this.checkNonNegativeInteger(group3, typeRuleKey);
        }
        return isValid;
    }

    private boolean checkNonNegativeInteger(String number, String typeRuleKey) {
        try {
            Integer i = Integer.parseInt(number);
            if (i < 0) {
                this.result.addError(this, 103, typeRuleKey);
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.result.addError(this, 103, typeRuleKey);
            return false;
        }
        return true;
    }

    private boolean checkCommonMapEntryParameters(MapEntryParamInfos mepp) {
        boolean isValid = true;
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : mepp.getParameterCache().entrySet()) {
            String lengthQualifier;
            Map<String, String> lengthCharacteristics;
            Map<String, String> tableCharacteristics;
            String typeRuleKey = entry.getKey();
            Map<String, Map<String, String>> characteristicsByParameter = entry.getValue();
            if (characteristicsByParameter.containsKey("table") && (tableCharacteristics = characteristicsByParameter.get("table")).containsKey("representedCategory")) {
                String representedCategory = tableCharacteristics.get("representedCategory");
                if (representedCategory == null) {
                    isValid = false;
                    this.result.addError(this, 101, typeRuleKey, "representedCategory", "table");
                } else if (!representedCategory.matches("(?i:(datatype|codelist))")) {
                    isValid = false;
                    this.result.addError(this, 102, typeRuleKey, "representedCategory", "table", "(?i:(datatype|codelist))");
                }
            }
            if (!characteristicsByParameter.containsKey("length") || !(lengthCharacteristics = characteristicsByParameter.get("length")).containsKey("lengthQualifier") || "BYTE".equalsIgnoreCase(lengthQualifier = lengthCharacteristics.get("lengthQualifier")) || "CHAR".equalsIgnoreCase(lengthQualifier) || "NONE".equalsIgnoreCase(lengthQualifier)) continue;
            isValid = false;
            this.result.addError(this, 106, typeRuleKey, lengthQualifier == null ? "<null>" : lengthQualifier, "lengthQualifier", "length");
        }
        return isValid;
    }

    private boolean checkIntegerParameter(String paramName) {
        boolean isValid = true;
        String valueByConfig = this.config.getParameterValue(paramName);
        if (valueByConfig != null) {
            try {
                Integer.parseInt(valueByConfig);
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 4, paramName, e.getMessage());
                mc.addDetail(this, 0);
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean checkDescriptorsForCodeList(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        String descriptorsForCodelistByConfig = config.getParameterValue("descriptorsForCodelist");
        if (StringUtils.isNotBlank((CharSequence)descriptorsForCodelistByConfig)) {
            String fullRegex = "(name|documentation|alias|definition|description|example|legalBasis|dataCaptureStatement|primaryCode)(\\(((columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)(;(columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)*\\))?(,(name|documentation|alias|definition|description|example|legalBasis|dataCaptureStatement|primaryCode)(\\(((columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)(;(columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)*\\))?)*";
            if (descriptorsForCodelistByConfig.matches(fullRegex)) {
                TreeSet<String> descriptorsForCodelist = new TreeSet<String>();
                String[] descriptorsForCodelistFromConfig = descriptorsForCodelistByConfig.trim().split("(?<!\\\\),");
                boolean unknownDescriptorFound = false;
                for (String tmp : descriptorsForCodelistFromConfig) {
                    if (tmp.matches("(name|documentation|alias|definition|description|example|legalBasis|dataCaptureStatement|primaryCode)(\\(((columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)(;(columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)*\\))?")) {
                        descriptorsForCodelist.add(tmp);
                        continue;
                    }
                    unknownDescriptorFound = true;
                }
                if (unknownDescriptorFound) {
                    result.addError(this, 2, descriptorsForCodelistByConfig, "(name|documentation|alias|definition|description|example|legalBasis|dataCaptureStatement|primaryCode)(\\(((columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)(;(columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)*\\))?");
                    isValid = false;
                }
                if (descriptorsForCodelist.isEmpty()) {
                    result.addError(this, 3);
                    isValid = false;
                }
            } else {
                result.addError(this, 6, fullRegex);
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: SqlDdl target configuration element with 'inputs'='$1$'.";
            }
            case 1: {
                return "For further details, see the documentation of parameter '$1$' on http://shapechange.net/targets/sql-ddl/";
            }
            case 2: {
                return "At least one of the descriptor identifiers in configuration parameter 'descriptorsForCodelist' - the parameter value is '$1$' - does not match the regular expression '$2$'. Correct the parameter value.";
            }
            case 3: {
                return "Configuration parameter 'descriptorsForCodelist' did not contain a well-known identifier. Use well-known identifiers or omit the parameter.";
            }
            case 4: {
                return "Number format exception while converting the value of configuration parameter '$1$' to an integer. Exception message: $2$.";
            }
            case 5: {
                return "Value of configuration parameter '$1$' is '$2$'. The file does not exist, is a directory, or cannot be read.";
            }
            case 6: {
                return "Configuration parameter 'descriptorsForCodelist' does not match the following regular expression: $1$";
            }
            case 100: {
                return "Parameter '$1$' is set to '$2$'. This is not a valid value.";
            }
            case 101: {
                return "Invalid map entry for type#rule '$1$': no value is provided for the characteristic '$2$' of parameter '$3$'.";
            }
            case 102: {
                return "Invalid map entry for type#rule '$1$': value provided for characteristic '$2$' of parameter '$3$' is invalid. Check that the value matches the regular expression: $4$.";
            }
            case 103: {
                return "Invalid map entry for type#rule '$1$': the targetType contains a parameterization that is not a non-negative integer.";
            }
            case 104: {
                return "Invalid map entry for type#rule '$1$': the map entry has paramter '$2$' but the targetType has a parameterization with two numbers. With parameter '$2$', the targetType of the map entry may only have a single number.";
            }
            case 105: {
                return "Invalid map entry for type#rule '$1$': the map entry has both parameter '$2$' and '$3$'. Only one of these parameters is allowed per map entry.";
            }
            case 106: {
                return "Invalid map entry for type#rule '$1$': value '$2$' provided for characteristic '$3$' of parameter '$4$' is invalid.";
            }
            case 107: {
                return "rule-sql-all-schemas is currently only supported for the PostgreSQL database system. The database system is configured as '$1$'. Either change the database system to PostgreSQL or ensure that the conversion rule is not configured for this target.";
            }
        }
        return "(" + SqlDdlConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

