/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseModelVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.DdlVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.DescriptorForCodeList;
import de.interactive_instruments.ShapeChange.Target.SQL.OracleStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.PostgreSQLDdlVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.PostgreSQLStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.ReplicationSchemaVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLServerStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLiteDdlFixer;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLiteStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlBuilder;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdlException;
import de.interactive_instruments.ShapeChange.Target.SQL.StatementSortAlphabetic;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SdoDimArrayExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SdoDimElement;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.AbstractNameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.CheckConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.CountSuffixUniqueNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultForeignKeyNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultNamingScheme;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultOracleCheckConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultOracleUniqueConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultPostgreSQLCheckConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultPostgreSQLUniqueConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultSQLServerCheckConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.DefaultSQLServerUniqueConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.ForeignKeyNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.LowerCaseNameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.LowerCaseNameWithLimitedLengthNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.OracleNameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.OracleStyleForeignKeyNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.PearsonHashCheckConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.PearsonHashForeignKeyNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.SQLServerNameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.SqlNamingScheme;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UniqueConstraintNamingStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UpperCaseNameNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.UpperCaseNameWithLimitedLengthNormalizer;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CodeByCategoryInsertStatementFilter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SpatialIndexStatementFilter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.TargetUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.sparx.Repository;
import org.w3c.dom.Node;

public class SqlDdl
implements SingleTarget,
MessageSource {
    public static final String PLATFORM = "sql";
    protected static Model model = null;
    private static String[] descriptorsForCodelistFromConfig = new String[]{"documentation"};
    protected static List<DescriptorForCodeList> descriptorsForCodelist = new ArrayList<DescriptorForCodeList>();
    protected static String codeNameColumnName = "name";
    protected static String codeNameColumnDocumentation = null;
    protected static int codeNameSize = 0;
    private static boolean initialised = false;
    protected static boolean diagnosticsOnly = false;
    protected static int numberOfEncodedSchemas = 0;
    protected static String documentationTemplate = null;
    protected static String documentationNoValue = null;
    private static String outputDirectory = null;
    private static String outputFilename = null;
    protected static SortedSet<String> categoriesForSeparatingCodeInsertStatements = new TreeSet<String>();
    protected static String codeStatusCLType;
    protected static int codeStatusCLLength;
    protected static String idColumnName;
    protected static String lengthQualifier;
    protected static String oneToManyReferenceColumnName;
    protected static String foreignKeyColumnSuffix;
    protected static String reflexiveRelationshipFieldSuffix;
    protected static String foreignKeyColumnSuffixDatatype;
    protected static String foreignKeyColumnSuffixCodelist;
    protected static ColumnDataType foreignKeyColumnDataType;
    protected static String primaryKeySpec;
    protected static String primaryKeySpecCodelist;
    protected static boolean separateSpatialIndexStatements;
    protected static String nameCodeStatusCLColumn;
    protected static String codeStatusCLColumnDocumentation;
    protected static String nameCodeStatusNotesColumn;
    protected static String codeStatusNotesColumnDocumentation;
    protected static String nameCodeSupercedesColumn;
    protected static String codeSupercedesColumnDocumentation;
    protected static int defaultSize;
    protected static int srid;
    protected static String geometryDimension;
    protected static String shortNameByTaggedValue;
    protected static boolean constraintNameUsingShortName;
    protected static boolean indexNameUsingShortName;
    protected static boolean createReferences;
    protected static boolean createDocumentation;
    protected static boolean createExplicitComments;
    protected static boolean createAssociativeTables;
    protected static boolean removeEmptyLinesInDdlOutput;
    protected static boolean representTaggedValues;
    protected static SortedSet<String> taggedValuesToRepresent;
    protected static String postgreSqlRole;
    protected static boolean applyForeignKeyColumnSuffixesInAssociativeTables;
    protected static String identifierColumnSuffix;
    protected static MapEntryParamInfos mapEntryParamInfos;
    protected static DatabaseStrategy databaseStrategy;
    protected static SqlNamingScheme namingScheme;
    protected static List<ClassInfo> cisToProcess;
    protected static SdoDimArrayExpression sdoDimArrayExpression;
    protected static boolean createRepSchema;
    protected static String repSchemaDocumentationUnlimitedLengthCharacterDataType;
    protected static String repSchemaTargetNamespace;
    protected static String repSchemaTargetNamespaceSuffix;
    protected static String repSchemaTargetVersion;
    protected static String repSchemaTargetXmlns;
    protected static String repSchemaObjectIdentifierFieldType;
    protected static String repSchemaForeignKeyFieldType;
    protected static Multiplicity repSchemaMultiplicity1;
    protected static boolean createDatabaseModel;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    private PackageInfo schema = null;
    private boolean schemaNotEncoded = false;
    private PackageInfo mainAppSchema;

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schema = pi;
        model = m;
        this.options = o;
        this.result = r;
        this.mainAppSchema = TargetUtil.findMainSchemaForSingleTargets(model.selectedSchemas(), o, r);
        diagnosticsOnly = diagOnly;
        if (!SqlDdl.isEncoded(this.schema)) {
            this.schemaNotEncoded = true;
            this.result.addInfo(this, 7, this.schema.name());
            return;
        }
        ++numberOfEncodedSchemas;
        if (!initialised) {
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            if (!diagnosticsOnly) {
                String repSchemaOutputFilename;
                File repSchemaOutputFile;
                File outputDirectoryFile = new File(outputDirectory);
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 3, outputDirectory);
                    return;
                }
                outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename");
                if (outputFilename == null) {
                    outputFilename = this.mainAppSchema == null ? this.schema.name() : this.mainAppSchema.name();
                }
                if (exi = (repSchemaOutputFile = new File(outputDirectoryFile, repSchemaOutputFilename = (outputFilename = outputFilename.replace("/", "_").replace(" ", "_")) + ".xsd")).exists()) {
                    this.result.addInfo(this, 503, repSchemaOutputFilename, outputDirectory);
                    try {
                        FileUtils.forceDelete((File)repSchemaOutputFile);
                        this.result.addInfo(this, 504);
                    }
                    catch (IOException e) {
                        this.result.addInfo(null, 600, e.getMessage());
                        e.printStackTrace(System.err);
                    }
                }
            }
            postgreSqlRole = this.options.parameterAsString(this.getClass().getName(), "postgreSqlRole", "postgres", false, true);
            if (pi.matches("rule-sql-all-associativetables")) {
                createAssociativeTables = true;
            }
            if (pi.matches("rule-sql-all-constraintNameUsingShortName")) {
                constraintNameUsingShortName = true;
            }
            if (pi.matches("rule-sql-all-indexNameUsingShortName")) {
                indexNameUsingShortName = true;
            }
            String databaseSystem = this.options.parameter(this.getClass().getName(), "databaseSystem");
            AbstractNameNormalizer normalizer = null;
            ForeignKeyNamingStrategy fkNaming = null;
            CheckConstraintNamingStrategy ckNaming = null;
            UniqueConstraintNamingStrategy ukNaming = null;
            CountSuffixUniqueNamingStrategy uniqueNaming = new CountSuffixUniqueNamingStrategy(this.result);
            int maxNameLength = this.options.parameterAsInteger(this.getClass().getName(), "maxNameLength", -1);
            if (pi.matches("rule-sql-all-normalizing-lower-case")) {
                normalizer = maxNameLength > 0 ? new LowerCaseNameWithLimitedLengthNormalizer(this.result, maxNameLength) : new LowerCaseNameNormalizer();
            } else if (pi.matches("rule-sql-all-normalizing-upper-case")) {
                normalizer = maxNameLength > 0 ? new UpperCaseNameWithLimitedLengthNormalizer(this.result, maxNameLength) : new UpperCaseNameNormalizer();
            } else if (pi.matches("rule-sql-all-normalizing-oracle")) {
                normalizer = new OracleNameNormalizer(this.result);
            } else if (pi.matches("rule-sql-all-normalizing-sqlserver")) {
                normalizer = new SQLServerNameNormalizer(this.result);
            }
            fkNaming = pi.matches("rule-sql-all-foreign-key-pearsonhash-naming") ? new PearsonHashForeignKeyNamingStrategy() : (pi.matches("rule-sql-all-foreign-key-oracle-naming-style") ? new OracleStyleForeignKeyNamingStrategy(this.result) : new DefaultForeignKeyNamingStrategy());
            if (pi.matches("rule-sql-all-check-constraint-naming-oracle-default")) {
                ckNaming = new DefaultOracleCheckConstraintNamingStrategy();
            } else if (pi.matches("rule-sql-all-check-constraint-naming-pearsonhash")) {
                ckNaming = new PearsonHashCheckConstraintNamingStrategy();
            } else if (pi.matches("rule-sql-all-check-constraint-naming-postgresql-default")) {
                ckNaming = new DefaultPostgreSQLCheckConstraintNamingStrategy();
            } else if (pi.matches("rule-sql-all-check-constraint-naming-sqlserver-default")) {
                ckNaming = new DefaultSQLServerCheckConstraintNamingStrategy();
            }
            if (databaseSystem != null && "oracle".equalsIgnoreCase(databaseSystem)) {
                databaseStrategy = new OracleStrategy(this.result);
                if (normalizer == null) {
                    normalizer = new OracleNameNormalizer(this.result);
                }
                if (ckNaming == null) {
                    ckNaming = new DefaultOracleCheckConstraintNamingStrategy();
                }
                if (ukNaming == null) {
                    ukNaming = new DefaultOracleUniqueConstraintNamingStrategy();
                }
            } else if (databaseSystem != null && "sqlserver".equalsIgnoreCase(databaseSystem)) {
                databaseStrategy = new SQLServerStrategy(this.result);
                if (normalizer == null) {
                    normalizer = new SQLServerNameNormalizer(this.result);
                }
                if (ckNaming == null) {
                    ckNaming = new DefaultSQLServerCheckConstraintNamingStrategy();
                }
                if (ukNaming == null) {
                    ukNaming = new DefaultSQLServerUniqueConstraintNamingStrategy();
                }
            } else if (databaseSystem != null && "sqlite".equalsIgnoreCase(databaseSystem)) {
                databaseStrategy = new SQLiteStrategy(this.result);
                if (normalizer == null) {
                    normalizer = new LowerCaseNameNormalizer();
                }
                if (ckNaming == null) {
                    ckNaming = new DefaultPostgreSQLCheckConstraintNamingStrategy();
                }
                if (ukNaming == null) {
                    ukNaming = new DefaultPostgreSQLUniqueConstraintNamingStrategy();
                }
            } else {
                if (databaseSystem != null && !"postgresql".equalsIgnoreCase(databaseSystem)) {
                    this.result.addError(this, 6, databaseSystem);
                }
                databaseStrategy = new PostgreSQLStrategy();
                if (normalizer == null) {
                    normalizer = new LowerCaseNameWithLimitedLengthNormalizer(this.result, 63);
                }
                if (ckNaming == null) {
                    ckNaming = new DefaultPostgreSQLCheckConstraintNamingStrategy();
                }
                if (ukNaming == null) {
                    ukNaming = new DefaultPostgreSQLUniqueConstraintNamingStrategy();
                }
            }
            this.result.addInfo(this, 9, databaseStrategy.name());
            if (this.schema.matches("rule-sql-all-normalizing-ignore-case")) {
                normalizer.setIgnoreCaseWhenNormalizing(true);
            }
            namingScheme = new DefaultNamingScheme(this.result, normalizer, fkNaming, ckNaming, ukNaming, uniqueNaming);
            categoriesForSeparatingCodeInsertStatements.addAll(this.options.parameterAsStringList(this.getClass().getName(), "separateCodeInsertStatementsByCodelistType", null, true, true));
            codeStatusCLType = this.options.parameterAsString(this.getClass().getName(), "codeStatusCLType", "CodeStatusCL", false, true);
            codeStatusCLLength = this.options.parameterAsInteger(this.getClass().getName(), "codeStatusCLLength", 50);
            idColumnName = this.options.parameterAsString(this.getClass().getName(), "idColumnName", "_id", false, true);
            String lengthQualifier_tmp = this.options.parameterAsString(this.getClass().getName(), "lengthQualifier", null, false, true);
            if (lengthQualifier_tmp != null) {
                if (lengthQualifier_tmp.equalsIgnoreCase("BYTE")) {
                    lengthQualifier = "BYTE";
                } else if (lengthQualifier_tmp.equalsIgnoreCase("CHAR")) {
                    lengthQualifier = "CHAR";
                }
            }
            oneToManyReferenceColumnName = this.options.parameterAsString(this.getClass().getName(), "oneToManyReferenceColumnName", "dataTypeOwner", false, true);
            foreignKeyColumnSuffix = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnSuffix", "", true, false);
            reflexiveRelationshipFieldSuffix = this.options.parameterAsString(this.getClass().getName(), "reflexiveRelationshipFieldSuffix", null, true, true);
            foreignKeyColumnSuffixCodelist = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnSuffixCodelist", foreignKeyColumnSuffix, true, false);
            foreignKeyColumnSuffixDatatype = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnSuffixDatatype", "", true, false);
            String foreignKeyColumnDataTypeFromConfig = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnDataType", null, false, true);
            if (foreignKeyColumnDataTypeFromConfig == null) {
                foreignKeyColumnDataTypeFromConfig = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnDatatype", null, false, true);
            }
            foreignKeyColumnDataType = foreignKeyColumnDataTypeFromConfig == null ? databaseStrategy.primaryKeyDataType() : new ColumnDataType(foreignKeyColumnDataTypeFromConfig);
            primaryKeySpec = this.options.parameterAsString(this.getClass().getName(), "primaryKeySpecification", "NOT NULL PRIMARY KEY", true, true);
            primaryKeySpecCodelist = this.options.parameterAsString(this.getClass().getName(), "primaryKeySpecificationCodelist", "NOT NULL PRIMARY KEY", true, true);
            separateSpatialIndexStatements = this.options.parameterAsBoolean(this.getClass().getName(), "separateSpatialIndexStatements", false);
            nameCodeStatusCLColumn = this.options.parameterAsString(this.getClass().getName(), "nameForCodeStatusCLColumn", "CODE_STATUS_CL", false, true);
            codeStatusCLColumnDocumentation = this.options.parameterAsString(this.getClass().getName(), "codeStatusCLColumnDocumentation", null, false, true);
            nameCodeStatusNotesColumn = this.options.parameterAsString(this.getClass().getName(), "nameForCodeStatusNotesColumn", "CODE_STATUS_NOTES", false, true);
            codeStatusNotesColumnDocumentation = this.options.parameterAsString(this.getClass().getName(), "codeStatusNotesColumnDocumentation", null, false, true);
            nameCodeSupercedesColumn = this.options.parameterAsString(this.getClass().getName(), "nameForCodeSupercedesColumn", "CODE_SUPERCEDES", false, true);
            codeSupercedesColumnDocumentation = this.options.parameterAsString(this.getClass().getName(), "codeSupercedesColumnDocumentation", null, false, true);
            identifierColumnSuffix = this.options.parameterAsString(this.getClass().getName(), "identifierColumnSuffix", "", false, true);
            String sdoDimElement_value = this.options.parameterAsString(this.getClass().getName(), "sdoDimElements", null, false, true);
            this.parseSdoDimElementValue(sdoDimElement_value);
            defaultSize = this.options.parameterAsInteger(this.getClass().getName(), "size", 1024);
            srid = this.options.parameterAsInteger(this.getClass().getName(), "srid", 4326);
            geometryDimension = this.options.parameterAsString(this.getClass().getName(), "geometryDimension", null, false, true);
            shortNameByTaggedValue = this.options.parameterAsString(this.getClass().getName(), "shortNameByTaggedValue", "shortName", false, true);
            createReferences = this.options.parameterAsBoolean(this.getClass().getName(), "createReferences", false);
            applyForeignKeyColumnSuffixesInAssociativeTables = this.options.parameterAsBoolean(this.getClass().getName(), "applyForeignKeyColumnSuffixesInAssociativeTables", false);
            createDocumentation = this.options.parameterAsBoolean(this.getClass().getName(), "createDocumentation", true);
            createExplicitComments = pi.matches("rule-sql-all-documentationViaExplicitCommentStatements");
            removeEmptyLinesInDdlOutput = this.options.parameterAsBoolean(this.getClass().getName(), "removeEmptyLinesInDdlOutput", false);
            List<String> tvsToRepresent = this.options.parameterAsStringList(null, "representTaggedValues", null, true, true);
            taggedValuesToRepresent = new TreeSet<String>(tvsToRepresent);
            representTaggedValues = pi.matches("rule-sql-all-representTaggedValues");
            if (pi.matches("rule-sql-all-suppressDocumentationViaInlineComments")) {
                createDocumentation = false;
            }
            documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
            documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
            String descriptorsForCodelistByConfig = this.options.parameter(this.getClass().getName(), "descriptorsForCodelist");
            if (descriptorsForCodelistByConfig != null && !descriptorsForCodelistByConfig.trim().isEmpty()) {
                descriptorsForCodelistFromConfig = descriptorsForCodelistByConfig.trim().split("(?<!\\\\),");
            }
            boolean unknownDescriptorFound = false;
            for (String tmp : descriptorsForCodelistFromConfig) {
                if (tmp.matches("(name|documentation|alias|definition|description|example|legalBasis|dataCaptureStatement|primaryCode)(\\(((columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)(;(columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)*\\))?")) {
                    String name = null;
                    String columnName = null;
                    String documentation = null;
                    Integer size = null;
                    if (tmp.contains("(")) {
                        String[] metadata;
                        name = tmp.substring(0, tmp.indexOf("("));
                        String tmp2 = tmp.substring(tmp.indexOf("(") + 1, tmp.length() - 1);
                        for (String meta : metadata = tmp2.split("(?<!\\\\);")) {
                            String[] meta_parts = meta.split("=", 2);
                            String metaKey = meta_parts[0];
                            String metaValue = meta_parts[1];
                            metaValue = metaValue.replaceAll("\\\\,", ",");
                            metaValue = metaValue.replaceAll("\\\\;", ";");
                            metaValue = metaValue.replaceAll("\\\\\\)", ")");
                            if (metaKey.equalsIgnoreCase("columnName")) {
                                columnName = metaValue;
                                continue;
                            }
                            if (metaKey.equalsIgnoreCase("size")) {
                                size = Integer.valueOf(metaValue);
                                continue;
                            }
                            if (!metaKey.equalsIgnoreCase("columnDocumentation")) continue;
                            documentation = metaValue;
                        }
                    } else {
                        name = tmp;
                    }
                    descriptorsForCodelist.add(new DescriptorForCodeList(name, columnName, documentation, size));
                    continue;
                }
                unknownDescriptorFound = true;
            }
            if (unknownDescriptorFound) {
                this.result.addWarning(this, 23, descriptorsForCodelistByConfig, "(name|documentation|alias|definition|description|example|legalBasis|dataCaptureStatement|primaryCode)(\\(((columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)(;(columnName|size|columnDocumentation)=([^,;\\)]|(?<=\\\\)[,;\\)])+)*\\))?");
            }
            if (descriptorsForCodelist.isEmpty()) {
                this.result.addWarning(this, 24);
                descriptorsForCodelist.add(new DescriptorForCodeList("documentation", null, null, null));
            }
            codeNameColumnName = this.options.parameterAsString(this.getClass().getName(), "codeNameColumnName", "name", false, true);
            codeNameColumnDocumentation = this.options.parameterAsString(this.getClass().getName(), "codeNameColumnDocumentation", null, false, true);
            codeNameSize = this.options.parameterAsInteger(this.getClass().getName(), "codeNameSize", 0);
            List<ProcessMapEntry> mapEntries = this.options.getCurrentProcessConfig().getMapEntries();
            if (mapEntries.isEmpty()) {
                this.result.addWarning(this, 15);
            } else {
                mapEntryParamInfos = new MapEntryParamInfos(this.result, mapEntries);
            }
            if (this.schema.matches("rule-sql-all-replicationSchema")) {
                createRepSchema = true;
                repSchemaObjectIdentifierFieldType = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaObjectIdentifierFieldType", "string", false, true);
                repSchemaForeignKeyFieldType = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaForeignKeyFieldType", repSchemaObjectIdentifierFieldType, false, true);
                repSchemaTargetNamespaceSuffix = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaTargetNamespaceSuffix", "", false, true);
                if (this.mainAppSchema != null) {
                    repSchemaTargetNamespace = this.mainAppSchema.targetNamespace();
                    repSchemaTargetVersion = this.mainAppSchema.version();
                    repSchemaTargetXmlns = this.mainAppSchema.xmlns();
                } else {
                    repSchemaTargetNamespace = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaTargetNamespace", this.schema.targetNamespace(), true, true);
                    repSchemaTargetVersion = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaTargetVersion", this.schema.version(), true, true);
                    repSchemaTargetXmlns = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaTargetXmlns", this.schema.xmlns(), true, true);
                }
                repSchemaTargetNamespace = StringUtils.defaultString((String)repSchemaTargetNamespace);
                repSchemaTargetVersion = StringUtils.defaultString((String)repSchemaTargetVersion);
                repSchemaTargetXmlns = StringUtils.defaultString((String)repSchemaTargetXmlns);
                repSchemaDocumentationUnlimitedLengthCharacterDataType = this.options.parameterAsString(this.getClass().getName(), "replicationSchemaDocumentationForFieldWithUnlimitedLengthCharacterDataType", "May contain a very large character string.", false, true);
            } else if (this.schema.matches("rule-sql-all-databaseModel")) {
                createDatabaseModel = true;
            }
        }
    }

    private void parseSdoDimElementValue(String sdoDimElement_value) {
        if (sdoDimElement_value != null) {
            Pattern p = Pattern.compile("(\\([^,]+(,[-]?([0-9]+\\.[0-9]+|[0-9]+)){3}\\))+");
            Matcher m = p.matcher(sdoDimElement_value.trim());
            if (!m.matches()) {
                this.result.addError(this, 16, sdoDimElement_value, "(\\([^,]+(,[-]?([0-9]+\\.[0-9]+|[0-9]+)){3}\\))+");
            } else {
                String[] elements;
                for (String element : elements = sdoDimElement_value.trim().split("\\)")) {
                    String s = element.substring(1);
                    String[] parts = s.split(",");
                    SdoDimElement sde = new SdoDimElement();
                    sde.setDimName(parts[0]);
                    sde.setLowerBound(parts[1]);
                    sde.setUpperBound(parts[2]);
                    sde.setTolerance(parts[3]);
                    sdoDimArrayExpression.addElement(sde);
                }
            }
        }
    }

    @Override
    public void process(ClassInfo ci) {
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (!SqlDdl.isEncoded(ci)) {
            this.result.addInfo(this, 8, ci.name());
            return;
        }
        this.result.addDebug(this, 2, ci.name());
        ProcessMapEntry pme = this.options.targetMapEntry(ci.name(), ci.encodingRule(PLATFORM));
        if (pme != null) {
            this.result.addInfo(this, 22, ci.name(), pme.getTargetType());
            return;
        }
        if (this.schemaNotEncoded) {
            this.result.addInfo(this, 18, this.schema.name(), ci.name());
            return;
        }
        if (ci.isAbstract() && ci.matches("rule-sql-all-exclude-abstract")) {
            return;
        }
        if (ci.category() == 6 && ci.matches("rule-sql-cls-object-types") || ci.category() == 1 && ci.matches("rule-sql-cls-feature-types") || ci.category() == 5 && ci.matches("rule-sql-cls-data-types")) {
            cisToProcess.add(ci);
        } else if (ci.category() != 3) {
            if (ci.category() == 2) {
                if (ci.matches("rule-sql-cls-code-lists")) {
                    cisToProcess.add(ci);
                }
            } else {
                this.result.addInfo(this, 17, ci.name());
            }
        }
    }

    @Override
    public void write() {
    }

    private String readDdl(String paramFileDdl) {
        String res = null;
        String fileDdl = this.options.parameterAsString(this.getClass().getName(), paramFileDdl, null, false, true);
        if (fileDdl != null) {
            File ddlTop = new File(fileDdl);
            if (!ddlTop.exists() || ddlTop.isDirectory() || !ddlTop.canRead()) {
                this.result.addError(this, 25, "fileDdlTop", fileDdl);
            } else {
                try {
                    res = FileUtils.readFileToString((File)ddlTop, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    this.result.addError(this, 26, fileDdl, e.getMessage());
                }
            }
        }
        return res;
    }

    @Override
    public String getTargetName() {
        return "SQL DDL";
    }

    public static boolean isEncoded(Info i) {
        return !i.matches("rule-sql-all-notEncoded") || !i.encodingRule(PLATFORM).equalsIgnoreCase("notencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAll(ShapeChangeResult r) {
        block32: {
            List<Statement> stmts;
            this.result = r;
            this.options = r.options();
            if (diagnosticsOnly || numberOfEncodedSchemas == 0) {
                return;
            }
            SqlBuilder builder = new SqlBuilder(this.result, this.options);
            try {
                stmts = builder.process(cisToProcess);
            }
            catch (SqlDdlException e) {
                this.result.addError(this, 32);
                return;
            }
            stmts = Collections.unmodifiableList(stmts);
            try {
                Object fileName;
                if (createRepSchema) {
                    ReplicationSchemaVisitor visitor = new ReplicationSchemaVisitor(this, builder);
                    visitor.visit(stmts);
                    visitor.postprocess();
                    Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
                    outputFormat.setProperty("indent", "yes");
                    outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                    outputFormat.setProperty("encoding", "UTF-8");
                    String fileName2 = outputFilename + ".xsd";
                    File repXsd = new File(outputDirectory, fileName2);
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repXsd), "UTF-8"));){
                        Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
                        serializer.setWriter((Writer)writer);
                        serializer.asDOMSerializer().serialize((Node)visitor.getDocument());
                        this.result.addResult(this.getTargetName(), outputDirectory, fileName2, repSchemaTargetNamespace);
                        break block32;
                    }
                }
                if (createDatabaseModel) {
                    String fileNameDM = outputFilename + ".eap";
                    File eap = new File(outputDirectory, fileNameDM);
                    String eapFilePathByConfig = this.options.parameter(SqlDdl.class.getName(), "dataModelEapPath");
                    if (eapFilePathByConfig != null) {
                        if (eapFilePathByConfig.toLowerCase().startsWith("http")) {
                            try {
                                URL eapUrl = new URL(eapFilePathByConfig);
                                FileUtils.copyURLToFile((URL)eapUrl, (File)eap);
                                this.result.addInfo(this, 30, eapFilePathByConfig, eap.getAbsolutePath());
                            }
                            catch (MalformedURLException e1) {
                                this.result.addError(this, 28, eapFilePathByConfig);
                            }
                            catch (IOException e2) {
                                this.result.addFatalError(this, 29, e2.getMessage());
                            }
                        } else {
                            this.result.addInfo(this, 31, eapFilePathByConfig);
                            eap = new File(eapFilePathByConfig);
                        }
                    }
                    Repository repository = EARepositoryUtil.openRepository(eap, true);
                    EARepositoryUtil.setEABatchAppend(repository, true);
                    EARepositoryUtil.setEAEnableUIUpdates(repository, false);
                    try {
                        DatabaseModelVisitor dmVisitor = new DatabaseModelVisitor(this, repository);
                        dmVisitor.initialize();
                        dmVisitor.visit(stmts);
                        dmVisitor.postprocess();
                        this.result.addResult(this.getTargetName(), outputDirectory, fileNameDM, null);
                    }
                    catch (EAException e) {
                        this.result.addError(this, 27, e.getMessage());
                    }
                    catch (NullPointerException npe) {
                        if (npe.getMessage() != null) {
                            this.result.addError(this, 27, npe.getMessage());
                        }
                        npe.printStackTrace(System.err);
                    }
                    finally {
                        EARepositoryUtil.closeRepository(repository);
                        repository = null;
                    }
                }
                List<Statement> stmtsForDdlCreation = new ArrayList<Statement>(stmts);
                if (databaseStrategy instanceof SQLiteStrategy) {
                    stmtsForDdlCreation = SQLiteDdlFixer.fixDdl(stmtsForDdlCreation);
                    StatementSortAlphabetic stmtComparator = new StatementSortAlphabetic();
                    Collections.sort(stmtsForDdlCreation, stmtComparator);
                }
                if (separateSpatialIndexStatements) {
                    fileName = outputFilename + "_spatial.sql";
                    SpatialIndexStatementFilter stmtFilter = new SpatialIndexStatementFilter();
                    List<Statement> filteredStatements = stmtFilter.filter(stmtsForDdlCreation);
                    if (!filteredStatements.isEmpty()) {
                        this.writeDdl(filteredStatements, (String)fileName);
                        stmtsForDdlCreation.removeAll(filteredStatements);
                    }
                }
                if (!categoriesForSeparatingCodeInsertStatements.isEmpty()) {
                    for (String category : categoriesForSeparatingCodeInsertStatements) {
                        String fileName3 = outputFilename + "_inserts_codelistType_" + category + ".sql";
                        CodeByCategoryInsertStatementFilter stmtFilter = new CodeByCategoryInsertStatementFilter(category);
                        List<Statement> filteredStatements = stmtFilter.filter(stmtsForDdlCreation);
                        if (filteredStatements.isEmpty()) continue;
                        this.writeDdl(filteredStatements, fileName3);
                        stmtsForDdlCreation.removeAll(filteredStatements);
                    }
                }
                fileName = outputFilename + ".sql";
                this.writeDdl(stmtsForDdlCreation, (String)fileName);
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
    }

    private void writeDdl(List<Statement> stmts, String fileName) throws Exception {
        StringBuffer sb = new StringBuffer();
        DdlVisitor visitor = databaseStrategy instanceof PostgreSQLStrategy ? new PostgreSQLDdlVisitor("\r\n", "   ", this) : new DdlVisitor("\r\n", "   ", this);
        visitor.visit(stmts);
        visitor.postprocess();
        sb.append(visitor.getDdl());
        File outputFile = new File(outputDirectory, fileName);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));){
            String ddlTop = this.readDdl("fileDdlTop");
            if (ddlTop != null) {
                writer.write(ddlTop);
            }
            writer.write(sb.toString());
            String ddlBottom = this.readDdl("fileDdlBottom");
            if (ddlBottom != null) {
                writer.write(ddlBottom);
            }
        }
        if (removeEmptyLinesInDdlOutput) {
            File outputWithoutEmptyLines = new File(outputDirectory, fileName + ".tmp");
            try (BufferedReader originalDdlReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outputFile), StandardCharsets.UTF_8));
                 BufferedWriter ddlWithoutEmptyLinesWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputWithoutEmptyLines), StandardCharsets.UTF_8));){
                String aLine = null;
                while ((aLine = originalDdlReader.readLine()) != null) {
                    if (aLine.trim().isEmpty()) continue;
                    ddlWithoutEmptyLinesWriter.write(aLine);
                    ddlWithoutEmptyLinesWriter.newLine();
                }
            }
            Files.move(outputWithoutEmptyLines.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.result.addResult(this.getTargetName(), outputDirectory, fileName, null);
    }

    @Override
    public void reset() {
        model = null;
        descriptorsForCodelistFromConfig = new String[]{"documentation"};
        descriptorsForCodelist = new ArrayList<DescriptorForCodeList>();
        codeNameColumnName = "name";
        codeNameColumnDocumentation = null;
        codeNameSize = 0;
        initialised = false;
        diagnosticsOnly = false;
        numberOfEncodedSchemas = 0;
        documentationTemplate = null;
        documentationNoValue = null;
        outputDirectory = null;
        outputFilename = null;
        categoriesForSeparatingCodeInsertStatements = new TreeSet<String>();
        codeStatusCLType = null;
        codeStatusCLLength = 50;
        idColumnName = null;
        lengthQualifier = null;
        oneToManyReferenceColumnName = null;
        foreignKeyColumnSuffix = null;
        reflexiveRelationshipFieldSuffix = null;
        foreignKeyColumnSuffixDatatype = null;
        foreignKeyColumnSuffixCodelist = null;
        foreignKeyColumnDataType = null;
        primaryKeySpec = null;
        primaryKeySpecCodelist = null;
        separateSpatialIndexStatements = false;
        nameCodeStatusCLColumn = null;
        codeStatusCLColumnDocumentation = null;
        nameCodeStatusNotesColumn = null;
        codeStatusNotesColumnDocumentation = null;
        nameCodeSupercedesColumn = null;
        codeSupercedesColumnDocumentation = null;
        defaultSize = 0;
        srid = 0;
        shortNameByTaggedValue = null;
        constraintNameUsingShortName = false;
        indexNameUsingShortName = false;
        createReferences = false;
        createDocumentation = true;
        createExplicitComments = false;
        createAssociativeTables = false;
        removeEmptyLinesInDdlOutput = false;
        taggedValuesToRepresent = null;
        representTaggedValues = false;
        postgreSqlRole = null;
        applyForeignKeyColumnSuffixesInAssociativeTables = false;
        identifierColumnSuffix = "";
        mapEntryParamInfos = null;
        databaseStrategy = null;
        namingScheme = null;
        cisToProcess = new ArrayList<ClassInfo>();
        sdoDimArrayExpression = new SdoDimArrayExpression();
        createRepSchema = false;
        repSchemaDocumentationUnlimitedLengthCharacterDataType = null;
        repSchemaTargetNamespace = null;
        repSchemaTargetNamespaceSuffix = null;
        repSchemaTargetVersion = null;
        repSchemaTargetXmlns = null;
        repSchemaObjectIdentifierFieldType = null;
        repSchemaForeignKeyFieldType = null;
        repSchemaMultiplicity1 = new Multiplicity(1, 1);
        createDatabaseModel = false;
    }

    @Override
    public String getTargetIdentifier() {
        return PLATFORM;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-sql-all-associativetables");
        r.addRule("rule-sql-all-check-constraint-naming-oracle-default");
        r.addRule("rule-sql-all-check-constraint-naming-pearsonhash");
        r.addRule("rule-sql-all-check-constraint-naming-postgresql-default");
        r.addRule("rule-sql-all-check-constraint-naming-sqlserver-default");
        r.addRule("rule-sql-all-constraintNameUsingShortName");
        r.addRule("rule-sql-all-databaseModel");
        r.addRule("rule-sql-all-documentationViaExplicitCommentStatements");
        r.addRule("rule-sql-all-exclude-abstract");
        r.addRule("rule-sql-all-foreign-key-oracle-naming-style");
        r.addRule("rule-sql-all-foreign-key-pearsonhash-naming");
        r.addRule("rule-sql-all-foreign-key-default-naming");
        r.addRule("rule-sql-all-indexNameUsingShortName");
        r.addRule("rule-sql-all-normalizing-ignore-case");
        r.addRule("rule-sql-all-normalizing-lower-case");
        r.addRule("rule-sql-all-normalizing-oracle");
        r.addRule("rule-sql-all-normalizing-sqlserver");
        r.addRule("rule-sql-all-normalizing-upper-case");
        r.addRule("rule-sql-all-notEncoded");
        r.addRule("rule-sql-all-precisionAndScale");
        r.addRule("rule-sql-all-representTaggedValues");
        r.addRule("rule-sql-all-schemas");
        r.addRule("rule-sql-all-suppressDocumentationViaInlineComments");
        r.addRule("rule-sql-all-unique-naming-count-suffix");
        r.addRule("rule-sql-cls-code-lists");
        r.addRule("rule-sql-cls-code-lists-pods");
        r.addRule("rule-sql-cls-data-types");
        r.addRule("rule-sql-cls-data-types-oneToMany-oneTable");
        r.addRule("rule-sql-cls-data-types-oneToMany-oneTable-ignoreSingleValuedCase");
        r.addRule("rule-sql-cls-data-types-oneToMany-severalTables");
        r.addRule("rule-sql-cls-feature-types");
        r.addRule("rule-sql-cls-identifierStereotype");
        r.addRule("rule-sql-cls-object-types");
        r.addRule("rule-sql-cls-references-to-external-types");
        r.addRule("rule-sql-prop-check-constraint-for-range");
        r.addRule("rule-sql-prop-check-constraints-for-enumerations");
        r.addRule("rule-sql-prop-check-constraint-restrictTimeOfDate");
        r.addRule("rule-sql-prop-exclude-derived");
        r.addRule("rule-sql-prop-multiplicity-orderAndUniqueness");
        r.addRule("rule-sql-prop-uniqueConstraints");
        r.addRule("rule-sql-all-replicationSchema");
        r.addRule("rule-sql-prop-replicationSchema-documentation-fieldWithUnlimitedLengthCharacterDataType");
        r.addRule("rule-sql-prop-replicationSchema-geometryAnnotation");
        r.addRule("rule-sql-prop-replicationSchema-maxLength-from-size");
        r.addRule("rule-sql-prop-replicationSchema-nillable");
        r.addRule("rule-sql-prop-replicationSchema-optional");
        ProcessRuleSet sqlPrs = new ProcessRuleSet(PLATFORM, "*", new TreeSet<String>(Stream.of("rule-sql-cls-feature-types").collect(Collectors.toSet())));
        r.addRuleSet(sqlPrs);
    }

    @Override
    public String getDefaultEncodingRule() {
        return PLATFORM;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class SqlDdl";
            }
            case 2: {
                return "Processing class '$1$'.";
            }
            case 3: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 5: {
                return "Number format exception while converting the tagged value '$1$' to an integer. Exception message: $2$. Using $3$ as default value.";
            }
            case 6: {
                return "Unknown database system '$1$'";
            }
            case 7: {
                return "Schema '$1$' is not encoded.";
            }
            case 8: {
                return "Class '$1$' is not encoded.";
            }
            case 9: {
                return "Determined database system is '$1$'.";
            }
            case 15: {
                return "No map entries provided via the configuration.";
            }
            case 16: {
                return "Value '$1$' of configuration parameter $2$ does not match the regular expression: $3$. The parameter will be ignored.";
            }
            case 17: {
                return "Type '$1$' is of a category not enabled for conversion, meaning that no table will be created to represent it.";
            }
            case 18: {
                return "Schema '$1$' is not encoded. Thus class '$2$' (which belongs to that schema) is not encoded either.";
            }
            case 22: {
                return "Type '$1$' has been mapped to '$2$', as defined by the configuration.";
            }
            case 23: {
                return "At least one of the descriptor identifiers in configuration parameter 'descriptorsForCodelist' (parameter value is '$1$') does not match the regular expression '$2$'. Identifiers that do not match this expression will be ignored.";
            }
            case 24: {
                return "Configuration parameter 'descriptorsForCodelist' did not contain a well-known identifier. Using default value 'documentation'.";
            }
            case 25: {
                return "Value of configuration parameter '$1$' is '$2$'. The file does not exist, is a directory, or cannot be read.";
            }
            case 26: {
                return "Exception occurred while transferring contents of file '$1$': $2$";
            }
            case 27: {
                return "Exception occurred while creating database model. Exception message is: $1$";
            }
            case 28: {
                return "URL '$1$' provided for configuration parameter dataModelEapPath is malformed. The data model will be created in a new EAP within the output directory.";
            }
            case 29: {
                return "Exception encountered while copying the data model EAP file defined by configuration parameter dataModelEapPath to the output directory. The data model will be created in a new EAP within the output directory.";
            }
            case 30: {
                return "Copied EAP file for creation of the data model from URL '$1$' to '$2$'.";
            }
            case 31: {
                return "Using local EAP file '$1$' for creation of the data model.";
            }
            case 32: {
                return "Error encountered while processing classes. Consult the log file for further information. No output will be created.";
            }
            case 503: {
                return "Output file '$1$' already exists in output directory ('$2$'). It will be deleted prior to processing.";
            }
            case 504: {
                return "File has been deleted.";
            }
        }
        return "(" + SqlDdl.class.getName() + ") Unknown message with number: " + mnr;
    }

    static {
        shortNameByTaggedValue = null;
        constraintNameUsingShortName = false;
        indexNameUsingShortName = false;
        createReferences = false;
        createDocumentation = true;
        createExplicitComments = false;
        createAssociativeTables = false;
        removeEmptyLinesInDdlOutput = false;
        representTaggedValues = false;
        taggedValuesToRepresent = null;
        postgreSqlRole = null;
        applyForeignKeyColumnSuffixesInAssociativeTables = false;
        identifierColumnSuffix = "";
        mapEntryParamInfos = null;
        cisToProcess = new ArrayList<ClassInfo>();
        sdoDimArrayExpression = new SdoDimArrayExpression();
        createRepSchema = false;
        repSchemaDocumentationUnlimitedLengthCharacterDataType = null;
        repSchemaTargetNamespace = null;
        repSchemaTargetNamespaceSuffix = null;
        repSchemaTargetVersion = null;
        repSchemaTargetXmlns = null;
        repSchemaMultiplicity1 = new Multiplicity(1, 1);
        createDatabaseModel = false;
    }
}

