/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.ColumnSortAlphabetic;
import de.interactive_instruments.ShapeChange.Target.SQL.CreateTableSortAlphabetic;
import de.interactive_instruments.ShapeChange.Target.SQL.DescriptorForCodeList;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLiteStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlConstants;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdlException;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.StatementSortAlphabetic;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.BetweenExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ColumnExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.DoubleValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ExpressionList;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.InExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.IsNullExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.NullValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.OrExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.StringValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.UnquotedStringExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.naming.SqlNamingScheme;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.AlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CheckConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Comment;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ConstraintAlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ForeignKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PrimaryKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SQLitePragma;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.UniqueConstraint;
import de.interactive_instruments.ShapeChange.Transformation.Flattening.PropertySetEdge;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.JohnsonSimpleCycles;
import org.jgrapht.alg.cycle.SzwarcfiterLauerSimpleCycles;
import org.jgrapht.alg.cycle.TarjanSimpleCycles;
import org.jgrapht.alg.cycle.TiernanSimpleCycles;
import org.jgrapht.graph.DirectedMultigraph;

public class SqlBuilder
implements MessageSource {
    private static Comparator<Statement> STATEMENT_COMPARATOR = new StatementSortAlphabetic();
    private static Comparator<CreateTable> CREATE_TABLE_COMPARATOR = new CreateTableSortAlphabetic();
    private static Comparator<Column> COLUMN_DEFINITION_COMPARATOR = new ColumnSortAlphabetic();
    private ShapeChangeResult result;
    private Options options;
    private Model model;
    private Pattern pattern_find_true = Pattern.compile("true", 2);
    private Pattern pattern_find_false = Pattern.compile("false", 2);
    private Map<PropertyInfo, Integer> sizeByCharacterValuedProperty = new HashMap<PropertyInfo, Integer>();
    private List<Table> tables = new ArrayList<Table>();
    private List<SQLitePragma> sqLitePragmas = new ArrayList<SQLitePragma>();
    private List<CreateTable> createTableStatements = new ArrayList<CreateTable>();
    private List<Alter> foreignKeyConstraints = new ArrayList<Alter>();
    private List<Alter> checkConstraints = new ArrayList<Alter>();
    private List<Alter> uniqueConstraints = new ArrayList<Alter>();
    private List<Statement> geometryMetadataUpdateStatements = new ArrayList<Statement>();
    private List<Statement> geometryIndexStatements = new ArrayList<Statement>();
    private List<Statement> nonGeometryIndexStatements = new ArrayList<Statement>();
    private List<Insert> insertStatements = new ArrayList<Insert>();
    private List<Comment> commentStatements = new ArrayList<Comment>();
    private List<Statement> schemaInitializationStatements = new ArrayList<Statement>();
    private SqlNamingScheme namingScheme;

    public SqlBuilder(ShapeChangeResult result, Options options) {
        this.result = result;
        this.options = options;
        this.model = SqlDdl.model;
        this.namingScheme = SqlDdl.namingScheme;
    }

    private Table createAssociativeTableForAttribute(PropertyInfo pi, Table referencedTable) {
        Object tableName;
        if (!pi.isAttribute()) {
            return null;
        }
        String schemaName = referencedTable.getSchemaName();
        if (this.map(pi.inClass()) != referencedTable) {
            tableName = referencedTable.getName() + "_" + pi.name();
            this.result.addInfo(this, 40, pi.name(), pi.inClass().name(), referencedTable.getName(), (String)tableName);
        } else {
            tableName = pi.taggedValuesAll().getFirstValue("associativeTable");
            if (StringUtils.isBlank((CharSequence)tableName)) {
                tableName = pi.inClass().name() + "_" + pi.name();
                this.result.addInfo(this, 12, pi.name(), pi.inClass().name(), (String)tableName);
            }
        }
        CreateTable createTable = new CreateTable();
        this.createTableStatements.add(createTable);
        Table table = this.map(schemaName, (String)tableName);
        createTable.setTable(table);
        table.setAssociativeTable(true);
        table.setRepresentedProperty(pi);
        ArrayList<Column> columns = new ArrayList<Column>();
        table.setColumns(columns);
        String classReferenceFieldName = pi.inClass().name() + this.determineForeignKeyColumnSuffix(pi.inClass());
        Column cdInClassReference = this.createColumn(table, null, null, classReferenceFieldName, SqlDdl.foreignKeyColumnDataType, "NOT NULL", false, true);
        cdInClassReference.setReferencedTable(referencedTable);
        columns.add(cdInClassReference);
        Column cdPi = null;
        if (this.refersToTypeRepresentedByTable(pi)) {
            String piFieldName = this.determineTableNameForValueType(pi) + this.determineForeignKeyColumnSuffix(pi);
            String piDocumentation = pi.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
            if (pi.categoryOfValue() == 2 && pi.inClass().matches("rule-sql-cls-code-lists")) {
                if (this.isNumericallyValued(pi)) {
                    ColumnDataType mappedType = this.identifyNumericType(pi);
                    if (mappedType != null) {
                        cdPi = this.createColumn(table, pi, piDocumentation, piFieldName, mappedType, "NOT NULL", false, true);
                    } else {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 29, pi.typeInfo().name, pi.name());
                        if (mc != null) {
                            mc.addDetail(this, 2, pi.fullNameInSchema());
                        }
                    }
                }
                if (cdPi == null) {
                    ColumnDataType fieldType = null;
                    fieldType = SqlDdl.codeNameSize < 1 ? SqlDdl.databaseStrategy.unlimitedLengthCharacterDataType() : SqlDdl.databaseStrategy.limitedLengthCharacterDataType(SqlDdl.codeNameSize, SqlDdl.lengthQualifier);
                    cdPi = this.createColumn(table, pi, piDocumentation, piFieldName, fieldType, "NOT NULL", false, true);
                }
            } else {
                cdPi = this.createColumn(table, pi, piDocumentation, piFieldName, SqlDdl.foreignKeyColumnDataType, "NOT NULL", false, true);
            }
            cdPi.setReferencedTable(this.map(pi));
        } else {
            cdPi = this.createColumn(table, pi, true);
        }
        columns.add(cdPi);
        boolean createPrimaryKeyConstraint = true;
        if (pi.matches("rule-sql-prop-multiplicity-orderAndUniqueness")) {
            if (pi.isOrdered()) {
                String encodingRule = pi.encodingRule("sql");
                ProcessMapEntry pme = this.options.targetMapEntry("Integer", encodingRule);
                ColumnDataType seqNoColDt = this.determineTypeFromMapEntry(pme);
                Column seqNoCol = this.createColumn(table, null, "", "seqno", seqNoColDt, "NOT NULL", false, false);
                columns.add(seqNoCol);
                if (pi.isUnique()) {
                    ArrayList<Column> columnsForUniqueConstraint = new ArrayList<Column>();
                    columnsForUniqueConstraint.add(cdInClassReference);
                    columnsForUniqueConstraint.add(cdPi);
                    UniqueConstraint uc = new UniqueConstraint(null, columnsForUniqueConstraint);
                    table.addConstraint(uc);
                }
            } else if (!pi.isUnique()) {
                createPrimaryKeyConstraint = false;
                Index index = new Index("idx_" + table.getFullName());
                index.addColumn(cdInClassReference);
                index.addColumn(cdPi);
                CreateIndex cIndex = new CreateIndex();
                cIndex.setIndex(index);
                cIndex.setTable(table);
                this.nonGeometryIndexStatements.add(cIndex);
            }
        }
        if (createPrimaryKeyConstraint) {
            PrimaryKeyConstraint pkc = new PrimaryKeyConstraint();
            pkc.setColumns(columns);
            table.addConstraint(pkc);
        }
        return table;
    }

    private String determineForeignKeyColumnSuffix(PropertyInfo pi) {
        if (SqlDdl.applyForeignKeyColumnSuffixesInAssociativeTables) {
            return this.identifyForeignKeyColumnSuffix(pi);
        }
        return SqlDdl.idColumnName;
    }

    private String determineForeignKeyColumnSuffix(ClassInfo ci) {
        if (SqlDdl.applyForeignKeyColumnSuffixesInAssociativeTables) {
            return this.identifyForeignKeyColumnSuffix(ci);
        }
        return SqlDdl.idColumnName;
    }

    private Table map(PropertyInfo pi) {
        String tableName = this.determineTableNameForValueType(pi);
        String schemaName = this.determineSchemaNameForValueType(pi);
        return this.map(schemaName, tableName);
    }

    private Table createTables(ClassInfo ci) {
        return this.createTables(ci, this.determineSchemaNameForType(ci), ci.name());
    }

    private Table createTables(ClassInfo ci, String schemaName, String tableName) {
        Table table = this.map(schemaName, tableName);
        ArrayList<PropertyInfo> propertyInfosForColumns = new ArrayList<PropertyInfo>();
        for (PropertyInfo pi : ci.properties().values()) {
            PropertyInfo pi2;
            PropertyInfo pi1;
            if (!SqlDdl.isEncoded(pi)) {
                this.result.addInfo(this, 15, pi.name(), pi.inClass().name());
                continue;
            }
            ClassInfo typeCi = this.model.classById(pi.typeInfo().id);
            if (typeCi == null) {
                typeCi = this.model.classByName(pi.typeInfo().name);
            }
            if (typeCi != null && this.options.targetMapEntry(pi.typeInfo().name, pi.encodingRule("sql")) == null && this.model.isInSelectedSchemas(typeCi) && (typeCi.category() == 6 && !typeCi.matches("rule-sql-cls-object-types") || typeCi.category() == 1 && !typeCi.matches("rule-sql-cls-feature-types") || typeCi.category() == 5 && !typeCi.matches("rule-sql-cls-data-types"))) {
                this.result.addWarning(this, 16, pi.name(), pi.inClass().name(), pi.typeInfo().name);
                continue;
            }
            if (pi.isDerived() && pi.matches("rule-sql-prop-exclude-derived")) {
                this.result.addInfo(this, 14, pi.name(), pi.inClass().name());
                continue;
            }
            if (typeCi != null && typeCi.isAbstract() && typeCi.matches("rule-sql-all-exclude-abstract")) continue;
            if (pi.isAttribute()) {
                if (pi.cardinality().maxOccurs == 1) {
                    if (SqlDdl.createAssociativeTables && this.options.targetMapEntry(pi.typeInfo().name, pi.encodingRule("sql")) == null && typeCi != null && typeCi.category() == 5 && typeCi.matches("rule-sql-cls-data-types") && (typeCi.matches("rule-sql-cls-data-types-oneToMany-oneTable") && typeCi.matches("rule-sql-cls-data-types-oneToMany-oneTable-ignoreSingleValuedCase") || typeCi.matches("rule-sql-cls-data-types-oneToMany-severalTables"))) continue;
                    propertyInfosForColumns.add(pi);
                    continue;
                }
                if (SqlDdl.createAssociativeTables) {
                    if (this.options.targetMapEntry(pi.typeInfo().name, pi.encodingRule("sql")) == null && typeCi != null && typeCi.category() == 5 && typeCi.matches("rule-sql-cls-data-types") && (typeCi.matches("rule-sql-cls-data-types-oneToMany-oneTable") || typeCi.matches("rule-sql-cls-data-types-oneToMany-severalTables"))) continue;
                    this.createAssociativeTableForAttribute(pi, table);
                    continue;
                }
                this.result.addWarning(this, 11, pi.name(), pi.inClass().name());
                continue;
            }
            AssociationInfo ai = pi.association();
            if (this.tableForAssociationExists(ai)) continue;
            PropertyInfo revPi = pi.reverseProperty();
            if (!SqlDdl.isEncoded(revPi.inClass()) && this.options.targetMapEntry(revPi.inClass().name(), revPi.inClass().encodingRule("sql")) == null) {
                this.result.addWarning(this, 19, revPi.inClass().name(), revPi.name(), pi.inClass().name(), pi.name());
                continue;
            }
            int maxOccursPi = pi.cardinality().maxOccurs;
            int maxOccursRevPi = revPi.cardinality().maxOccurs;
            if (maxOccursPi == 1) {
                propertyInfosForColumns.add(pi);
                continue;
            }
            if (revPi.isNavigable() && maxOccursRevPi == 1) {
                if (this.options.targetMapEntry(revPi.inClass().name(), revPi.inClass().encodingRule("sql")) == null) continue;
                this.result.addWarning(this, 22, revPi.inClass().name(), revPi.name(), pi.inClass().name(), pi.name());
                continue;
            }
            if (SqlDdl.createAssociativeTables) {
                this.createAssociativeTable(ai);
                continue;
            }
            if (pi.inClass().name().compareTo(pi.reverseProperty().inClass().name()) <= 0) {
                pi1 = pi;
                pi2 = pi.reverseProperty();
            } else {
                pi1 = pi.reverseProperty();
                pi2 = pi;
            }
            this.result.addWarning(this, 8, pi1.inClass().name(), pi1.name(), pi2.inClass().name(), pi2.name());
        }
        CreateTable createTable = new CreateTable();
        this.createTableStatements.add(createTable);
        createTable.setTable(table);
        table.setRepresentedClass(ci);
        table.setDocumentation(ci.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue));
        if (SqlDdl.createExplicitComments) {
            this.createExplicitCommentUnlessNoDocumentation(table);
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        int countIdentifierAttributes = 0;
        for (PropertyInfo pi : propertyInfosForColumns) {
            if (!pi.isAttribute() || !pi.stereotype("identifier") || !ci.matches("rule-sql-cls-identifierStereotype")) continue;
            ++countIdentifierAttributes;
        }
        if (countIdentifierAttributes == 0) {
            Column id_cd = this.createColumn(table, null, null, SqlDdl.idColumnName + SqlDdl.identifierColumnSuffix, SqlDdl.databaseStrategy.primaryKeyDataType(), SqlDdl.primaryKeySpec, true, false);
            columns.add(id_cd);
            id_cd.setObjectIdentifierColumn(true);
        }
        boolean identifierSet = false;
        for (PropertyInfo pi : propertyInfosForColumns) {
            Column cd = this.createColumn(table, pi, false);
            columns.add(cd);
            if (identifierSet || !pi.isAttribute() || !pi.stereotype("identifier") || !ci.matches("rule-sql-cls-identifierStereotype")) continue;
            cd.setName(cd.getName() + SqlDdl.identifierColumnSuffix);
            cd.removeSpecification("NOT NULL");
            cd.addSpecification(SqlDdl.primaryKeySpec);
            identifierSet = true;
        }
        table.setColumns(columns);
        return table;
    }

    private void createExplicitCommentUnlessNoDocumentation(Table table) {
        if (StringUtils.isNotBlank((CharSequence)table.getDocumentation())) {
            this.commentStatements.add(new Comment(table, table.getDocumentation().replaceAll("\\s+", " ").trim()));
        }
    }

    private void createExplicitCommentUnlessNoDocumentation(Column column) {
        if (StringUtils.isNotBlank((CharSequence)column.getDocumentation())) {
            this.commentStatements.add(new Comment(column, column.getDocumentation().replaceAll("\\s+", " ").trim()));
        }
    }

    private boolean tableForAssociationExists(AssociationInfo ai) {
        for (CreateTable cat : this.createTableStatements) {
            Table t = cat.getTable();
            if (!t.isAssociativeTable() || t.getRepresentedAssociation() == null || t.getRepresentedAssociation() != ai) continue;
            return true;
        }
        return false;
    }

    private Table createAssociativeTable(AssociationInfo ai) {
        PropertyInfo pi2;
        PropertyInfo pi1;
        Object tableName = ai.taggedValuesAll().getFirstValue("associativeTable");
        String schemaName = null;
        String tableNameEnd1InClass = this.determineTableNameForType(ai.end1().inClass());
        String tableNameEnd2InClass = this.determineTableNameForType(ai.end2().inClass());
        if (StringUtils.isBlank((CharSequence)tableName)) {
            tableName = ai.end1().isNavigable() && ai.end2().isNavigable() ? (tableNameEnd1InClass.compareTo(tableNameEnd2InClass) <= 0 ? tableNameEnd1InClass + "_" + ai.end1().name() : tableNameEnd2InClass + "_" + ai.end2().name()) : (ai.end1().isNavigable() ? tableNameEnd1InClass + "_" + ai.end1().name() : tableNameEnd2InClass + "_" + ai.end2().name());
            this.result.addInfo(this, 13, ai.end1().inClass().name() + " (context property '" + ai.end1().name() + "')", ai.end2().inClass().name() + " (context property '" + ai.end2().name() + "')", (String)tableName);
        }
        if (ai.matches("rule-sql-all-schemas") && StringUtils.isBlank((CharSequence)(schemaName = ai.taggedValuesAll().getFirstValue("sqlSchema")))) {
            schemaName = ai.end1().isNavigable() && ai.end2().isNavigable() ? (tableNameEnd1InClass.compareTo(tableNameEnd2InClass) <= 0 ? this.determineSchemaNameForType(ai.end1().inClass()) : this.determineSchemaNameForType(ai.end2().inClass())) : (ai.end1().isNavigable() ? this.determineSchemaNameForType(ai.end1().inClass()) : this.determineSchemaNameForType(ai.end2().inClass()));
            this.result.addInfo(this, 39, ai.end1().inClass().name() + " (context property '" + ai.end1().name() + "')", ai.end2().inClass().name() + " (context property '" + ai.end2().name() + "')", schemaName);
        }
        CreateTable createTable = new CreateTable();
        this.createTableStatements.add(createTable);
        Table table = this.map(schemaName, (String)tableName);
        createTable.setTable(table);
        table.setAssociativeTable(true);
        table.setRepresentedAssociation(ai);
        ArrayList<Column> columns = new ArrayList<Column>();
        table.setColumns(columns);
        if (tableNameEnd1InClass.compareTo(tableNameEnd2InClass) <= 0) {
            pi1 = ai.end1();
            pi2 = ai.end2();
        } else {
            pi1 = ai.end2();
            pi2 = ai.end1();
        }
        boolean reflexive = pi1.inClass().id().equals(pi2.inClass().id());
        String name_1 = this.determineTableNameForType(pi1.inClass()) + (String)(reflexive ? "_" + pi1.name() : "") + this.determineForeignKeyColumnSuffix(pi1);
        String documentation_1 = pi2.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
        Column cd1 = this.createColumn(table, pi2, documentation_1, name_1, SqlDdl.foreignKeyColumnDataType, "NOT NULL", false, true);
        cd1.setReferencedTable(this.map(pi1.inClass()));
        columns.add(cd1);
        String name_2 = this.determineTableNameForType(pi2.inClass()) + (String)(reflexive ? "_" + pi2.name() : "") + this.determineForeignKeyColumnSuffix(pi2);
        String documentation_2 = pi1.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
        Column cd2 = this.createColumn(table, pi1, documentation_2, name_2, SqlDdl.foreignKeyColumnDataType, "NOT NULL", false, true);
        cd2.setReferencedTable(this.map(pi2.inClass()));
        columns.add(cd2);
        PrimaryKeyConstraint pkc = new PrimaryKeyConstraint();
        pkc.setColumns(columns);
        table.addConstraint(pkc);
        return table;
    }

    private Table map(ClassInfo ci) {
        String tableName = this.determineTableNameForType(ci);
        String schemaName = this.determineSchemaNameForType(ci);
        return this.map(schemaName, tableName);
    }

    private Table createTableForCodeList(ClassInfo ci) {
        CreateTable createTable = new CreateTable();
        this.createTableStatements.add(createTable);
        Table table = this.map(ci);
        createTable.setTable(table);
        table.setRepresentedClass(ci);
        table.setDocumentation(ci.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue));
        if (SqlDdl.createExplicitComments) {
            this.createExplicitCommentUnlessNoDocumentation(table);
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        table.setColumns(columns);
        String name = SqlDdl.codeNameColumnName + SqlDdl.identifierColumnSuffix;
        String codeNameColumnDocumentation = SqlDdl.codeNameColumnDocumentation;
        Column cd_codename = null;
        ColumnDataType codeColumnType = null;
        if (this.isNumericallyValued(ci)) {
            codeColumnType = this.identifyNumericType(ci);
            if (codeColumnType == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 28, ci.name());
                if (mc != null) {
                    mc.addDetail(this, 1, ci.fullNameInSchema());
                }
            } else {
                cd_codename = this.createColumn(table, null, codeNameColumnDocumentation, name, codeColumnType, SqlDdl.primaryKeySpecCodelist, true, false);
            }
        }
        if (cd_codename == null) {
            codeColumnType = SqlDdl.codeNameSize < 1 ? SqlDdl.databaseStrategy.unlimitedLengthCharacterDataType() : SqlDdl.databaseStrategy.limitedLengthCharacterDataType(SqlDdl.codeNameSize, SqlDdl.lengthQualifier);
            cd_codename = this.createColumn(table, null, codeNameColumnDocumentation, name, codeColumnType, SqlDdl.primaryKeySpecCodelist, true, false);
        }
        columns.add(cd_codename);
        for (DescriptorForCodeList descriptor : SqlDdl.descriptorsForCodelist) {
            ColumnDataType descriptor_fieldType = descriptor.getSize() == null ? SqlDdl.databaseStrategy.unlimitedLengthCharacterDataType() : SqlDdl.databaseStrategy.limitedLengthCharacterDataType(descriptor.getSize(), SqlDdl.lengthQualifier);
            String descriptorDocumentation = descriptor.getDocumentation();
            Column cd_descriptor = this.createColumn(table, null, descriptorDocumentation, descriptor.getColumnName(), descriptor_fieldType, "", false, false);
            columns.add(cd_descriptor);
        }
        if (ci.matches("rule-sql-cls-code-lists-pods")) {
            ClassInfo codeStatusCLType = this.model.classByName(SqlDdl.codeStatusCLType);
            if (ci != codeStatusCLType) {
                Column cd_codeStatusCl = this.createColumn(table, null, SqlDdl.codeStatusCLColumnDocumentation, SqlDdl.nameCodeStatusCLColumn, SqlDdl.foreignKeyColumnDataType, "", false, false);
                if (codeStatusCLType != null) {
                    if (codeStatusCLType.category() == 3) {
                        cd_codeStatusCl.setEnumerationValueType(codeStatusCLType);
                        ColumnDataType codeStatusCLDataType = this.determineCharacterVaryingOrText(SqlDdl.codeStatusCLLength, SqlDdl.lengthQualifier);
                        cd_codeStatusCl.setDataType(codeStatusCLDataType);
                        if (this.isNumericallyValued(codeStatusCLType)) {
                            ColumnDataType mappedType = this.identifyNumericType(codeStatusCLType);
                            if (mappedType != null) {
                                cd_codeStatusCl.setDataType(mappedType);
                            } else {
                                this.result.addError(this, 31, codeStatusCLType.name(), SqlDdl.nameCodeStatusCLColumn, table.getFullName());
                            }
                        }
                    } else if (this.isRepresentedByTable(codeStatusCLType)) {
                        cd_codeStatusCl.setForeignKeyColumn(true);
                        cd_codeStatusCl.setReferencedTable(this.map(codeStatusCLType));
                    } else {
                        this.result.addError(this, 30, SqlDdl.codeStatusCLType, SqlDdl.nameCodeStatusCLColumn, table.getFullName());
                    }
                } else {
                    this.result.addError(this, 26, SqlDdl.codeStatusCLType, SqlDdl.nameCodeStatusCLColumn, table.getFullName());
                }
                columns.add(cd_codeStatusCl);
                Column cd_codeStatusNotes = this.createColumn(table, null, SqlDdl.codeStatusNotesColumnDocumentation, SqlDdl.nameCodeStatusNotesColumn, SqlDdl.databaseStrategy.limitedLengthCharacterDataType(255, SqlDdl.lengthQualifier), "", false, false);
                columns.add(cd_codeStatusNotes);
                Column cd_codeSupercedes = this.createColumn(table, null, SqlDdl.codeSupercedesColumnDocumentation, SqlDdl.nameCodeSupercedesColumn, codeColumnType, "", false, false);
                columns.add(cd_codeSupercedes);
            } else if (ci == codeStatusCLType) {
                table.setRepresentsCodeStatusCLType(true);
            }
        }
        return table;
    }

    private String determineTableNameForType(ClassInfo ci) {
        ProcessMapEntry pme = this.options.targetMapEntry(ci.name(), ci.encodingRule("sql"));
        if (pme != null && SqlDdl.mapEntryParamInfos.hasParameter(pme, "table")) {
            return pme.getTargetType();
        }
        for (CreateTable ct : this.createTableStatements) {
            if (ct.getTable() == null || !ct.getTable().representsClass(ci)) continue;
            return ct.getTable().getName();
        }
        return ci.name();
    }

    private String determineSchemaNameForType(ClassInfo ci) {
        if (!ci.matches("rule-sql-all-schemas")) {
            return null;
        }
        ProcessMapEntry pme = this.options.targetMapEntry(ci.name(), ci.encodingRule("sql"));
        if (pme != null && SqlDdl.mapEntryParamInfos.hasParameter(pme, "table")) {
            return this.sqlSchemaName(pme);
        }
        for (CreateTable ct : this.createTableStatements) {
            if (ct.getTable() == null || !ct.getTable().representsClass(ci)) continue;
            return ct.getTable().getSchemaName();
        }
        return this.sqlSchemaName(ci);
    }

    private void alterTableAddCheckConstraintForEnumerationValueType(Column column) {
        PropertyInfo pi = column.getRepresentedProperty();
        ProcessMapEntry pme = this.options.targetMapEntry(pi.typeInfo().name, pi.encodingRule("sql"));
        if (pme != null) {
            return;
        }
        ClassInfo enumCi = this.model.classById(pi.typeInfo().id);
        if (enumCi == null || enumCi.properties().size() == 0) {
            this.result.addError(this, 18, pi.typeInfo().name, pi.fullNameInSchema());
        } else {
            this.alterTableAddCheckConstraintForEnumerationValueType(column, enumCi);
        }
    }

    private void alterTableAddCheckConstraintForEnumerationValueType(Column column, ClassInfo enumCi) {
        ProcessMapEntry pme = this.options.targetMapEntry(enumCi.name(), enumCi.encodingRule("sql"));
        if (pme != null) {
            return;
        }
        Table tableWithColumn = column.getInTable();
        if (enumCi.properties().size() == 0) {
            this.result.addError(this, 32, enumCi.name(), column.getName());
        } else {
            String constraintName = this.namingScheme.nameForCheckConstraint(SqlUtil.determineName(tableWithColumn, SqlDdl.constraintNameUsingShortName), SqlUtil.determineName(column, SqlDdl.constraintNameUsingShortName));
            Alter alter = new Alter();
            alter.setTable(tableWithColumn);
            ConstraintAlterExpression cae = new ConstraintAlterExpression();
            alter.setExpression(cae);
            cae.setOperation(AlterExpression.AlterOperation.ADD);
            CheckConstraint cc = new CheckConstraint();
            cae.setConstraint(cc);
            cc.setName(constraintName);
            InExpression iexp = new InExpression();
            ColumnExpression col = new ColumnExpression(column);
            iexp.setLeftExpression(col);
            ExpressionList el = new ExpressionList();
            ArrayList<Expression> el_tmp = new ArrayList<Expression>();
            el.setExpressions(el_tmp);
            for (PropertyInfo enumPi : enumCi.properties().values()) {
                if (!SqlDdl.isEncoded(enumPi)) continue;
                String value = enumPi.name();
                if (enumPi.initialValue() != null) {
                    value = enumPi.initialValue();
                }
                if (this.isNumericallyValued(enumCi)) {
                    UnquotedStringExpression use = new UnquotedStringExpression(value);
                    el_tmp.add(use);
                    continue;
                }
                value = StringUtils.replace((String)value, (String)"'", (String)"''");
                StringValueExpression sv = new StringValueExpression(value);
                el_tmp.add(sv);
            }
            iexp.setRightExpressionsList(el);
            if (column.isNotNull()) {
                cc.setExpression(iexp);
            } else {
                IsNullExpression nullexp = new IsNullExpression();
                nullexp.setExpression(col);
                OrExpression orexp = new OrExpression(nullexp, iexp);
                cc.setExpression(orexp);
            }
            this.checkConstraints.add(alter);
        }
    }

    private boolean isNumericallyValued(Info i) {
        if (i instanceof ClassInfo || i instanceof PropertyInfo) {
            ClassInfo type = null;
            if (i instanceof PropertyInfo) {
                PropertyInfo pi = (PropertyInfo)i;
                type = this.model.classByIdOrName(pi.typeInfo());
            } else {
                type = (ClassInfo)i;
            }
            if (type != null && StringUtils.isNotBlank((CharSequence)type.taggedValue("numericType"))) {
                return true;
            }
        }
        return false;
    }

    private void alterTableAddCheckConstraintToRestrictTimeOfDate(Column column) {
        Expression expr = SqlDdl.databaseStrategy.expressionForCheckConstraintToRestrictTimeOfDate(column);
        if (expr != null) {
            Table tableWithColumn = column.getInTable();
            String constraintName = this.namingScheme.nameForCheckConstraint(SqlUtil.determineName(tableWithColumn, SqlDdl.constraintNameUsingShortName), SqlUtil.determineName(column, SqlDdl.constraintNameUsingShortName));
            Alter alter = new Alter();
            alter.setTable(tableWithColumn);
            ConstraintAlterExpression cae = new ConstraintAlterExpression();
            alter.setExpression(cae);
            cae.setOperation(AlterExpression.AlterOperation.ADD);
            CheckConstraint cc = new CheckConstraint();
            cae.setConstraint(cc);
            cc.setName(constraintName);
            cc.setExpression(expr);
            this.checkConstraints.add(alter);
        }
    }

    private String determineTableNameForValueType(PropertyInfo pi) {
        String valueTypeName = pi.typeInfo().name;
        String piEncodingRule = pi.encodingRule("sql");
        ProcessMapEntry pme = this.options.targetMapEntry(valueTypeName, piEncodingRule);
        if (pme != null && SqlDdl.mapEntryParamInfos.hasParameter(valueTypeName, piEncodingRule, "table")) {
            return SqlDdl.mapEntryParamInfos.getMapEntry(valueTypeName, piEncodingRule).getTargetType();
        }
        ClassInfo valueType = this.model.classById(pi.typeInfo().id);
        if (valueType == null) {
            valueType = this.model.classByName(pi.typeInfo().name);
        }
        if (valueType != null) {
            for (CreateTable ct : this.createTableStatements) {
                Table t = ct.getTable();
                if (!t.representsClass(valueType) || t.isUsageSpecificTable()) continue;
                return ct.getTable().getName();
            }
        }
        return pi.typeInfo().name;
    }

    private String determineSchemaNameForValueType(PropertyInfo pi) {
        if (!pi.matches("rule-sql-all-schemas")) {
            return null;
        }
        String valueTypeName = pi.typeInfo().name;
        String piEncodingRule = pi.encodingRule("sql");
        ProcessMapEntry pme = this.options.targetMapEntry(valueTypeName, piEncodingRule);
        if (pme != null && SqlDdl.mapEntryParamInfos.hasParameter(valueTypeName, piEncodingRule, "table")) {
            return this.sqlSchemaName(pme);
        }
        ClassInfo valueType = this.model.classById(pi.typeInfo().id);
        if (valueType == null) {
            valueType = this.model.classByName(pi.typeInfo().name);
        }
        if (valueType != null) {
            for (CreateTable ct : this.createTableStatements) {
                Table t = ct.getTable();
                if (!t.representsClass(valueType) || t.isUsageSpecificTable()) continue;
                return ct.getTable().getSchemaName();
            }
        }
        return this.sqlSchemaName(valueType);
    }

    private String sqlSchemaName(ProcessMapEntry pme) {
        String targetType = pme.getTargetType();
        int numberOfDots = StringUtils.countMatches((CharSequence)targetType, (CharSequence)".");
        if (numberOfDots == 0) {
            return null;
        }
        if (numberOfDots == 1) {
            return targetType.split("\\.")[0];
        }
        return targetType.split("\\.")[1];
    }

    private String sqlSchemaName(ClassInfo ci) {
        PackageInfo schemaPkg = this.model.schemaPackage(ci);
        String schemaName = schemaPkg.taggedValue("sqlSchema");
        if (StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = schemaPkg.taggedValue("xmlns");
        }
        if (StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = "fixme";
        }
        return schemaName;
    }

    private boolean refersToTypeRepresentedByTable(PropertyInfo pi) {
        String name = pi.typeInfo().name;
        String encodingRule = pi.encodingRule("sql");
        ProcessMapEntry pme = this.options.targetMapEntry(name, encodingRule);
        if (pme != null) {
            return SqlDdl.mapEntryParamInfos.hasParameter(name, encodingRule, "table");
        }
        ClassInfo typeCi = this.model.classById(pi.typeInfo().id);
        if (typeCi != null) {
            return this.isRepresentedByTable(typeCi);
        }
        return false;
    }

    private boolean isRepresentedByTable(ClassInfo ci) {
        String encodingRule;
        String name = ci.name();
        ProcessMapEntry pme = this.options.targetMapEntry(name, encodingRule = ci.encodingRule("sql"));
        if (pme != null) {
            return SqlDdl.mapEntryParamInfos.hasParameter(name, encodingRule, "table");
        }
        if (ci.category() == 1 || ci.category() == 6 || ci.category() == 5 || ci.category() == 2) {
            if (ci.category() == 6 && !ci.matches("rule-sql-cls-object-types") || ci.category() == 1 && !ci.matches("rule-sql-cls-feature-types") || ci.category() == 5 && !ci.matches("rule-sql-cls-data-types") || ci.category() == 2 && !ci.matches("rule-sql-cls-code-lists")) {
                return false;
            }
            return this.model.isInSelectedSchemas(ci) || ci.matches("rule-sql-cls-references-to-external-types");
        }
        return false;
    }

    private Column createColumn(Table inTable, PropertyInfo representedProperty, String documentation, String name, ColumnDataType type, String columnSpecification, boolean isPrimaryKey, boolean isForeignKey) {
        Column column = new Column(name, representedProperty, documentation, inTable);
        if (SqlDdl.createExplicitComments) {
            this.createExplicitCommentUnlessNoDocumentation(column);
        }
        column.setDataType(type);
        if (columnSpecification != null && !columnSpecification.trim().isEmpty()) {
            column.addSpecification(columnSpecification.trim());
        }
        column.setForeignKeyColumn(isForeignKey);
        return column;
    }

    private Column createColumn(Table inTable, PropertyInfo pi, boolean alwaysNotNull) {
        Object name;
        boolean isForeignKeyColumn = false;
        if (this.refersToTypeRepresentedByTable(pi)) {
            name = pi.name() + this.identifyForeignKeyColumnSuffix(pi);
            isForeignKeyColumn = true;
        } else {
            name = pi.name();
        }
        String documentation = pi.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
        Column cd = new Column((String)name, pi, documentation, inTable);
        if (SqlDdl.createExplicitComments) {
            this.createExplicitCommentUnlessNoDocumentation(cd);
        }
        ColumnDataType colDataType = this.identifyType(pi);
        cd.setDataType(colDataType);
        if (isForeignKeyColumn) {
            cd.setForeignKeyColumn(true);
            cd.setReferencedTable(this.map(pi));
        }
        ArrayList<String> columnSpecStrings = new ArrayList<String>();
        String columnDefault = pi.initialValue();
        if (columnDefault != null && columnDefault.trim().length() > 0) {
            Map<String, String> characteristics;
            ClassInfo valueType;
            Expression defaultValue = null;
            String booleanTrue = "TRUE";
            String booleanFalse = "FALSE";
            boolean quoted = false;
            if (!(pi.categoryOfValue() != 2 && pi.categoryOfValue() != 3 || (valueType = pi.model().classByIdOrName(pi.typeInfo())) != null && this.isNumericallyValued(valueType))) {
                quoted = true;
            }
            if ((characteristics = SqlDdl.mapEntryParamInfos.getCharacteristics(pi.typeInfo().name, pi.encodingRule("sql"), "defaultValue")) != null) {
                if (characteristics.containsKey("true")) {
                    booleanTrue = characteristics.get("true");
                }
                if (characteristics.containsKey("false")) {
                    booleanFalse = characteristics.get("false");
                }
                if (characteristics.containsKey("quoted")) {
                    quoted = characteristics.get("quoted").equalsIgnoreCase("true");
                }
            }
            if (pi.typeInfo().name.equals("Boolean")) {
                if (this.pattern_find_true.matcher(columnDefault).find()) {
                    defaultValue = quoted ? new StringValueExpression(booleanTrue) : new UnquotedStringExpression(booleanTrue);
                } else if (this.pattern_find_false.matcher(columnDefault).find()) {
                    Expression expression = defaultValue = quoted ? new StringValueExpression(booleanFalse) : new UnquotedStringExpression(booleanFalse);
                }
            }
            if (defaultValue == null) {
                defaultValue = quoted ? new StringValueExpression(columnDefault.replaceAll("'", "''")) : new UnquotedStringExpression(columnDefault);
            }
            cd.setDefaultValue(defaultValue);
        }
        if (alwaysNotNull) {
            columnSpecStrings.add("NOT NULL");
        } else if (!(pi.implementedByNilReason() || pi.nilReasonAllowed() || pi.voidable() || pi.cardinality().minOccurs < 1)) {
            columnSpecStrings.add("NOT NULL");
        }
        cd.setSpecifications(columnSpecStrings);
        return cd;
    }

    private String identifyForeignKeyColumnSuffix(PropertyInfo pi) {
        boolean isReflexiveProperty = pi.inClass().id().equals(pi.typeInfo().id);
        String typeName = pi.typeInfo().name;
        String piEncodingRule = pi.encodingRule("sql");
        ProcessMapEntry pme = this.options.targetMapEntry(typeName, piEncodingRule);
        if (pme != null && SqlDdl.mapEntryParamInfos.hasCharacteristic(typeName, piEncodingRule, "table", "representedCategory")) {
            String repCat = SqlDdl.mapEntryParamInfos.getCharacteristic(typeName, piEncodingRule, "table", "representedCategory");
            if (repCat != null && repCat.equalsIgnoreCase("datatype")) {
                return SqlDdl.foreignKeyColumnSuffixDatatype;
            }
            if (repCat != null && repCat.equalsIgnoreCase("codelist")) {
                return SqlDdl.foreignKeyColumnSuffixCodelist;
            }
            return isReflexiveProperty && SqlDdl.reflexiveRelationshipFieldSuffix != null ? SqlDdl.reflexiveRelationshipFieldSuffix : SqlDdl.foreignKeyColumnSuffix;
        }
        if (pi.categoryOfValue() == 5) {
            return SqlDdl.foreignKeyColumnSuffixDatatype;
        }
        if (pi.categoryOfValue() == 2) {
            return SqlDdl.foreignKeyColumnSuffixCodelist;
        }
        return isReflexiveProperty && SqlDdl.reflexiveRelationshipFieldSuffix != null ? SqlDdl.reflexiveRelationshipFieldSuffix : SqlDdl.foreignKeyColumnSuffix;
    }

    private String identifyForeignKeyColumnSuffix(ClassInfo ci) {
        String ciEncodingRule;
        String typeName = ci.name();
        ProcessMapEntry pme = this.options.targetMapEntry(typeName, ciEncodingRule = ci.encodingRule("sql"));
        if (pme != null && SqlDdl.mapEntryParamInfos.hasCharacteristic(typeName, ciEncodingRule, "table", "representedCategory")) {
            String repCat = SqlDdl.mapEntryParamInfos.getCharacteristic(typeName, ciEncodingRule, "table", "representedCategory");
            if (repCat != null && repCat.equalsIgnoreCase("datatype")) {
                return SqlDdl.foreignKeyColumnSuffixDatatype;
            }
            if (repCat != null && repCat.equalsIgnoreCase("codelist")) {
                return SqlDdl.foreignKeyColumnSuffixCodelist;
            }
            return SqlDdl.foreignKeyColumnSuffix;
        }
        if (ci.category() == 5) {
            return SqlDdl.foreignKeyColumnSuffixDatatype;
        }
        if (ci.category() == 2) {
            return SqlDdl.foreignKeyColumnSuffixCodelist;
        }
        return SqlDdl.foreignKeyColumnSuffix;
    }

    private ColumnDataType identifyType(PropertyInfo pi) {
        int catOfValue;
        ProcessMapEntry me = this.options.targetMapEntry(pi.typeInfo().name, pi.encodingRule("sql"));
        if (me != null) {
            if (SqlDdl.mapEntryParamInfos.hasParameter(me, "geometry")) {
                return new ColumnDataType(SqlDdl.databaseStrategy.geometryDataType(me, SqlDdl.srid));
            }
            if (SqlDdl.mapEntryParamInfos.hasParameter(me, "table")) {
                return SqlDdl.foreignKeyColumnDataType;
            }
            if (me.getTargetType().startsWith("cond:")) {
                String conditionalCriterium = me.getTargetType().substring("cond:".length());
                if (conditionalCriterium.equalsIgnoreCase("textOrCharacterVarying")) {
                    return this.determineCharacterVaryingOrText(pi);
                }
            } else {
                if (SqlDdl.mapEntryParamInfos.hasParameter(me, "textOrCharacterVarying")) {
                    return this.determineCharacterVaryingOrText(pi);
                }
                ColumnDataType type = this.determineTypeFromMapEntry(me);
                this.updatePrecisionAndScaleWithLocalInfo(type, pi);
                return type;
            }
        }
        if ((catOfValue = pi.categoryOfValue()) == 3) {
            if (this.isNumericallyValued(pi)) {
                ColumnDataType mappedType = this.identifyNumericType(pi);
                if (mappedType != null) {
                    return mappedType;
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 29, pi.typeInfo().name, pi.name());
                if (mc != null) {
                    mc.addDetail(this, 2, pi.fullNameInSchema());
                }
            }
            return this.determineCharacterVaryingOrText(pi);
        }
        if (catOfValue == 6 || catOfValue == 1 || catOfValue == 5 || catOfValue == 2) {
            ClassInfo typeCi = this.model.classById(pi.typeInfo().id);
            if (typeCi != null) {
                if (catOfValue == 6 && !typeCi.matches("rule-sql-cls-object-types") || catOfValue == 1 && !typeCi.matches("rule-sql-cls-feature-types") || catOfValue == 5 && !typeCi.matches("rule-sql-cls-data-types") || catOfValue == 2 && !typeCi.matches("rule-sql-cls-code-lists")) {
                    if (catOfValue == 2 && this.isNumericallyValued(pi)) {
                        ColumnDataType mappedType = this.identifyNumericType(pi);
                        if (mappedType != null) {
                            return mappedType;
                        }
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 29, pi.typeInfo().name, pi.name());
                        if (mc != null) {
                            mc.addDetail(this, 2, pi.fullNameInSchema());
                        }
                    }
                    return this.determineCharacterVaryingOrText(pi);
                }
                if (this.model.isInSelectedSchemas(typeCi) || typeCi.matches("rule-sql-cls-references-to-external-types")) {
                    if (catOfValue == 2) {
                        if (this.isNumericallyValued(pi)) {
                            ColumnDataType mappedType = this.identifyNumericType(pi);
                            if (mappedType != null) {
                                return mappedType;
                            }
                            ShapeChangeResult.MessageContext mc = this.result.addError(this, 29, pi.typeInfo().name, pi.name());
                            if (mc != null) {
                                mc.addDetail(this, 2, pi.fullNameInSchema());
                            }
                        }
                        if (SqlDdl.codeNameSize < 1) {
                            return SqlDdl.databaseStrategy.unlimitedLengthCharacterDataType();
                        }
                        return SqlDdl.databaseStrategy.limitedLengthCharacterDataType(SqlDdl.codeNameSize, SqlDdl.lengthQualifier);
                    }
                    return SqlDdl.foreignKeyColumnDataType;
                }
                this.result.addWarning(this, 9, typeCi.name(), pi.name(), pi.inClass().name());
                return this.determineCharacterVaryingOrText(pi);
            }
            this.result.addWarning(this, 10, pi.typeInfo().name, pi.name(), pi.inClass().name());
            return this.determineCharacterVaryingOrText(pi);
        }
        this.result.addWarning(this, 21, pi.typeInfo().name);
        return new ColumnDataType("unknown");
    }

    private void updatePrecisionAndScaleWithLocalInfo(ColumnDataType type, Info info) {
        if (info.matches("rule-sql-all-precisionAndScale")) {
            Integer precisionFromTV = this.parseTaggedValue("precision", info);
            Integer scaleFromTV = this.parseTaggedValue("scale", info);
            if (scaleFromTV != null && precisionFromTV == null) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 27);
                if (mc != null) {
                    mc.addDetail(this, 3, info.fullNameInSchema());
                }
                scaleFromTV = null;
            }
            if (precisionFromTV != null) {
                type.setPrecision(precisionFromTV);
                type.setScale(scaleFromTV);
            }
        }
    }

    private ColumnDataType determineTypeFromMapEntry(ProcessMapEntry me) {
        Matcher lengthPrecisionScale;
        String dtName = me.getTargetType();
        Integer length = null;
        String lengthQualifier = null;
        Integer precision = null;
        Integer scale = null;
        if ((SqlDdl.mapEntryParamInfos.hasParameter(me, "length") || SqlDdl.mapEntryParamInfos.hasParameter(me, "precision")) && (lengthPrecisionScale = SqlConstants.PATTERN_ME_TARGETTYPE_LENGTH_PRECISION_SCALE.matcher(me.getTargetType().trim())).matches()) {
            dtName = lengthPrecisionScale.group(1);
            String group2 = lengthPrecisionScale.group(2);
            String group3 = lengthPrecisionScale.group(3);
            if (SqlDdl.mapEntryParamInfos.hasParameter(me, "length")) {
                length = Integer.parseInt(group2);
                lengthQualifier = this.determineLengthQualifierFromMapEntry(me);
            } else if (SqlDdl.mapEntryParamInfos.hasParameter(me, "precision")) {
                precision = Integer.parseInt(group2);
                if (group3 != null && (scale = Integer.valueOf(Integer.parseInt(group3))) == 0) {
                    scale = null;
                }
            }
        }
        return new ColumnDataType(dtName, precision, scale, length, lengthQualifier);
    }

    private ColumnDataType identifyNumericType(Info i) {
        if (i instanceof ClassInfo || i instanceof PropertyInfo) {
            ClassInfo type = null;
            if (i instanceof PropertyInfo) {
                PropertyInfo pi = (PropertyInfo)i;
                type = this.model.classByIdOrName(pi.typeInfo());
            } else {
                type = (ClassInfo)i;
            }
            String numericConceptualType = type.taggedValue("numericType");
            if (type != null && StringUtils.isNotBlank((CharSequence)numericConceptualType)) {
                String encodingRule = i.encodingRule("sql");
                ProcessMapEntry pme = this.options.targetMapEntry(numericConceptualType.trim(), encodingRule);
                if (pme != null && pme.hasTargetType()) {
                    ColumnDataType colDt = this.determineTypeFromMapEntry(pme);
                    this.updatePrecisionAndScaleWithLocalInfo(colDt, type);
                    return colDt;
                }
            }
        }
        return null;
    }

    private Integer parseTaggedValue(String taggedValueName, Info i) {
        Integer res;
        block4: {
            res = null;
            String value = StringUtils.stripToNull((String)i.taggedValue(taggedValueName));
            if (value != null) {
                try {
                    res = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 6, taggedValueName, value);
                    if (mc == null) break block4;
                    if (i instanceof ClassInfo) {
                        mc.addDetail(this, 1, i.fullNameInSchema());
                    }
                    mc.addDetail(this, 2, i.fullNameInSchema());
                }
            }
        }
        return res;
    }

    private ColumnDataType determineCharacterVaryingOrText(PropertyInfo pi) {
        int size = this.getSizeForProperty(pi);
        this.sizeByCharacterValuedProperty.put(pi, size);
        String lengthQualifier = null;
        ProcessMapEntry me = this.options.targetMapEntry(pi.typeInfo().name, pi.encodingRule("sql"));
        lengthQualifier = me != null ? this.determineLengthQualifierFromMapEntry(me) : SqlDdl.lengthQualifier;
        return this.determineCharacterVaryingOrText(size, lengthQualifier);
    }

    private String determineLengthQualifierFromMapEntry(ProcessMapEntry me) {
        String statedLengthQualifier = SqlDdl.mapEntryParamInfos.getCharacteristic(me.getType(), me.getRule(), "length", "lengthQualifier");
        String lengthQualifier = "NONE".equalsIgnoreCase(statedLengthQualifier) ? null : statedLengthQualifier;
        return lengthQualifier;
    }

    private ColumnDataType determineCharacterVaryingOrText(int size, String lengthQualifier) {
        if (size < 1) {
            return SqlDdl.databaseStrategy.unlimitedLengthCharacterDataType();
        }
        return SqlDdl.databaseStrategy.limitedLengthCharacterDataType(size, lengthQualifier);
    }

    private int getSizeForProperty(PropertyInfo pi) {
        String tvSize = pi.taggedValuesAll().getFirstValue("size");
        int size = SqlDdl.defaultSize;
        if (StringUtils.isNotBlank((CharSequence)tvSize)) {
            try {
                size = Integer.parseInt(tvSize);
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 5, "size", e.getMessage(), "" + SqlDdl.defaultSize);
                mc.addDetail(this, 0);
                mc.addDetail(this, 100, pi.fullNameInSchema());
                size = SqlDdl.defaultSize;
            }
        }
        return size;
    }

    private Statement generateGeometryIndex(Table tableWithColumn, Column columnForProperty, PropertyInfo pi) {
        Map<String, String> geometryCharacteristics = SqlDdl.mapEntryParamInfos.getCharacteristics(pi.typeInfo().name, pi.encodingRule("sql"), "geometry");
        String indexName = this.namingScheme.nameForGeometryIndex(SqlUtil.determineName(tableWithColumn, SqlDdl.indexNameUsingShortName), SqlUtil.determineName(columnForProperty, SqlDdl.indexNameUsingShortName));
        Statement result = SqlDdl.databaseStrategy.geometryIndexColumnPart(indexName, tableWithColumn, columnForProperty, geometryCharacteristics);
        return result;
    }

    public List<Statement> process(List<ClassInfo> cisToProcess) throws SqlDdlException {
        Statement stmt;
        PropertyInfo pi;
        Table t;
        this.checkRequirements(cisToProcess);
        this.identifyTablesFor_DataTypesOneToManySeveralTables(cisToProcess);
        for (ClassInfo classInfo : cisToProcess) {
            if (classInfo.category() == 2) {
                this.createTableForCodeList(classInfo);
                continue;
            }
            if (classInfo.category() == 5 && classInfo.matches("rule-sql-cls-data-types") && classInfo.matches("rule-sql-cls-data-types-oneToMany-severalTables")) continue;
            this.createTables(classInfo);
        }
        for (ClassInfo classInfo : cisToProcess) {
            if (classInfo.category() != 5 || !classInfo.matches("rule-sql-cls-data-types") || classInfo.matches("rule-sql-cls-data-types-oneToMany-severalTables") || !classInfo.matches("rule-sql-cls-data-types-oneToMany-oneTable")) continue;
            Table table = this.map(classInfo);
            String columnName = SqlDdl.oneToManyReferenceColumnName;
            String string = classInfo.taggedValue("oneToManyReferenceColumnName");
            if (StringUtils.isNotBlank((CharSequence)string)) {
                columnName = string.trim();
            }
            Object dtOwnerRef_columnSpec = null;
            if (classInfo.matches("rule-sql-cls-data-types-oneToMany-oneTable-ignoreSingleValuedCase")) {
                dtOwnerRef_columnSpec = "NOT NULL";
            }
            Column dtOwnerRef_cd = this.createColumn(table, null, null, columnName + this.determineForeignKeyColumnSuffix(classInfo), SqlDdl.foreignKeyColumnDataType, (String)dtOwnerRef_columnSpec, false, true);
            table.addColumn(dtOwnerRef_cd);
        }
        for (Table table : this.tables) {
            for (Column col : table.getColumns()) {
                Table table2 = col.getReferencedTable();
                if (table2 == null) continue;
                for (Column refCol : table2.getColumns()) {
                    ColumnDataType refColdt;
                    if (!refCol.isPrimaryKeyColumn() || (refColdt = refCol.getDataType()).getName().equals(SqlDdl.databaseStrategy.primaryKeyDataType().getName())) continue;
                    col.setDataType(new ColumnDataType(refColdt.getName(), refColdt.getPrecision(), refColdt.getScale(), refColdt.getLength(), refColdt.getLengthQualifier()));
                }
            }
        }
        List<Statement> statements = this.statements();
        Collections.sort(statements, STATEMENT_COMPARATOR);
        this.namingScheme.getNameNormalizer().visit(statements);
        for (CreateTable createTable : this.createTableStatements) {
            t = createTable.getTable();
            for (Column col : t.getColumns()) {
                ClassInfo enumerationValueType;
                pi = col.getRepresentedProperty();
                if (pi != null) {
                    if (pi.categoryOfValue() == 3 && pi.matches("rule-sql-prop-check-constraints-for-enumerations")) {
                        this.alterTableAddCheckConstraintForEnumerationValueType(col);
                    }
                    if (pi.typeInfo().name.equalsIgnoreCase("Date") && pi.matches("rule-sql-prop-check-constraint-restrictTimeOfDate")) {
                        this.alterTableAddCheckConstraintToRestrictTimeOfDate(col);
                    }
                    if (pi.matches("rule-sql-prop-check-constraint-for-range")) {
                        ShapeChangeResult.MessageContext mc;
                        Double lowerBoundaryValue = -1.0E9;
                        Double upperBoundaryValue = 1.0E9;
                        boolean foundLowerBoundary = false;
                        boolean foundUpperBoundary = false;
                        String TV_RANGE_MIN = "rangeMinimum";
                        String TV_RANGE_MAX = "rangeMaximum";
                        String rMin = pi.taggedValue(TV_RANGE_MIN);
                        String rMax = pi.taggedValue(TV_RANGE_MAX);
                        if (StringUtils.isNotBlank((CharSequence)rMin)) {
                            try {
                                lowerBoundaryValue = Double.parseDouble(rMin.trim());
                                foundLowerBoundary = true;
                            }
                            catch (NumberFormatException e) {
                                mc = this.result.addWarning(this, 36, rMin.trim(), TV_RANGE_MIN);
                                mc.addDetail(this, 100, pi.fullNameInSchema());
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)rMax)) {
                            try {
                                upperBoundaryValue = Double.parseDouble(rMax.trim());
                                foundUpperBoundary = true;
                            }
                            catch (NumberFormatException e) {
                                mc = this.result.addWarning(this, 36, rMax.trim(), TV_RANGE_MAX);
                                mc.addDetail(this, 100, pi.fullNameInSchema());
                            }
                        }
                        if (foundLowerBoundary || foundUpperBoundary) {
                            this.alterTableAddCheckConstraintForRange(col, lowerBoundaryValue, upperBoundaryValue);
                        }
                    }
                }
                if ((enumerationValueType = col.getEnumerationValueType()) == null) continue;
                this.alterTableAddCheckConstraintForEnumerationValueType(col, enumerationValueType);
            }
        }
        for (CreateTable createTable : this.createTableStatements) {
            Table table = createTable.getTable();
            for (Column col : table.getColumns()) {
                pi = col.getRepresentedProperty();
                if (pi == null || !pi.matches("rule-sql-prop-uniqueConstraints") || !"true".equalsIgnoreCase(pi.taggedValue("sqlUnique"))) continue;
                if (pi.cardinality().maxOccurs > 1) {
                    this.result.addWarning(this, 33, col.getName(), table.getFullName());
                    continue;
                }
                String constraintName = this.namingScheme.nameForUniqueConstraint(SqlUtil.determineName(table, SqlDdl.constraintNameUsingShortName), SqlUtil.determineName(col, SqlDdl.constraintNameUsingShortName));
                Alter alter = this.alterTableAddUniqueConstraint(table, constraintName, col);
                this.uniqueConstraints.add(alter);
            }
        }
        if (SqlDdl.createReferences) {
            boolean bl;
            boolean bl2 = false;
            ArrayList<CreateTable> arrayList = new ArrayList<CreateTable>(this.createTableStatements);
            Collections.sort(arrayList, CREATE_TABLE_COMPARATOR);
            for (CreateTable createTable : arrayList) {
                Table t2 = createTable.getTable();
                ArrayList<Column> columns = new ArrayList<Column>(t2.getColumns());
                Collections.sort(columns, COLUMN_DEFINITION_COMPARATOR);
                for (Column cd : columns) {
                    if (cd.getReferencedTable() == null) continue;
                    Table t_main = cd.getInTable();
                    Alter alter = this.alterTableAddForeignKeyConstraint(t_main, this.namingScheme.nameForForeignKeyConstraint(SqlUtil.determineName(t_main, SqlDdl.constraintNameUsingShortName), SqlUtil.determineName(cd, SqlDdl.constraintNameUsingShortName), SqlUtil.determineName(cd.getReferencedTable(), SqlDdl.constraintNameUsingShortName)), cd, cd.getReferencedTable());
                    this.foreignKeyConstraints.add(alter);
                    bl = true;
                }
            }
            if (bl && SqlDdl.databaseStrategy instanceof SQLiteStrategy) {
                SQLitePragma pragma = new SQLitePragma("foreign_keys", "ON");
                this.sqLitePragmas.add(pragma);
            }
        }
        for (CreateTable createTable : this.createTableStatements) {
            t = createTable.getTable();
            for (Column col : t.getColumns()) {
                pi = col.getRepresentedProperty();
                if (pi == null || !SqlUtil.isGeometryTypedProperty(pi) || (stmt = SqlDdl.databaseStrategy.geometryMetadataUpdateStatement(t, col, SqlDdl.srid)) == null) continue;
                this.geometryMetadataUpdateStatements.add(stmt);
            }
        }
        for (CreateTable createTable : this.createTableStatements) {
            t = createTable.getTable();
            for (Column col : t.getColumns()) {
                pi = col.getRepresentedProperty();
                if (pi == null || !SqlUtil.isGeometryTypedProperty(pi) || (stmt = this.generateGeometryIndex(t, col, pi)) == null) continue;
                this.geometryIndexStatements.add(stmt);
            }
        }
        for (CreateTable createTable : this.createTableStatements) {
            t = createTable.getTable();
            ClassInfo classInfo = t.getRepresentedClass();
            if (classInfo == null || classInfo.category() != 2 || !classInfo.matches("rule-sql-cls-code-lists")) continue;
            ArrayList<Insert> insertStatements = new ArrayList<Insert>();
            for (PropertyInfo codePi : classInfo.properties().values()) {
                if (!SqlDdl.isEncoded(codePi)) continue;
                Insert ins = new Insert();
                ins.setTable(createTable.getTable());
                insertStatements.add(ins);
                ins.setColumns(createTable.getTable().getColumns());
                ExpressionList el = new ExpressionList();
                ArrayList<Expression> values = new ArrayList<Expression>();
                el.setExpressions(values);
                ins.setExpressionList(el);
                String codeName = codePi.name();
                if (codePi.initialValue() != null) {
                    codeName = codePi.initialValue();
                }
                codeName = codeName.replaceAll("'", "''");
                if (this.isNumericallyValued(classInfo)) {
                    values.add(new UnquotedStringExpression(codeName));
                } else {
                    values.add(new StringValueExpression(codeName));
                }
                for (DescriptorForCodeList descriptor : SqlDdl.descriptorsForCodelist) {
                    String descName = descriptor.getDescriptorName();
                    String value = null;
                    if (descName.equalsIgnoreCase("name")) {
                        value = codePi.name();
                    } else if (descName.equalsIgnoreCase("documentation")) {
                        value = codePi.derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
                    } else if (descName.equalsIgnoreCase("alias")) {
                        value = codePi.aliasName();
                    } else if (descName.equalsIgnoreCase("definition")) {
                        value = codePi.definition();
                    } else if (descName.equalsIgnoreCase("description")) {
                        value = codePi.description();
                    } else if (descName.equalsIgnoreCase("example")) {
                        Object[] examples = codePi.examples();
                        if (examples != null && examples.length > 0) {
                            value = StringUtils.join((Object[])examples, (String)" ");
                        }
                    } else if (descName.equalsIgnoreCase("legalBasis")) {
                        value = codePi.legalBasis();
                    } else if (descName.equalsIgnoreCase("dataCaptureStatement")) {
                        Object[] dcss = codePi.dataCaptureStatements();
                        if (dcss != null && dcss.length > 0) {
                            value = StringUtils.join((Object[])dcss, (String)" ");
                        }
                    } else if (descName.equalsIgnoreCase("primaryCode")) {
                        value = codePi.primaryCode();
                    } else if (descName.equalsIgnoreCase("globalIdentifier")) {
                        value = codePi.globalIdentifier();
                    }
                    if (value == null) {
                        values.add(new NullValueExpression());
                        continue;
                    }
                    String valueWithEscapedQuotes = value.replaceAll("'", "''");
                    values.add(new StringValueExpression(valueWithEscapedQuotes));
                }
                if (!classInfo.matches("rule-sql-cls-code-lists-pods") || t.representsCodeStatusCLType()) continue;
                values.add(new StringValueExpression("valid"));
                values.add(new NullValueExpression());
                values.add(new NullValueExpression());
            }
            this.insertStatements.addAll(insertStatements);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (CreateTable ct : this.createTableStatements) {
            Table table = ct.getTable();
            if (!StringUtils.isNotBlank((CharSequence)table.getSchemaName())) continue;
            treeSet.add(table.getSchemaName().trim());
        }
        this.schemaInitializationStatements = SqlDdl.databaseStrategy.schemaInitializationStatements(treeSet);
        List<Statement> list = this.statements();
        this.namingScheme.getNameNormalizer().visit(list);
        Collections.sort(list, STATEMENT_COMPARATOR);
        ArrayList<Statement> result = new ArrayList<Statement>();
        result.addAll(this.schemaInitializationStatements);
        result.addAll(list);
        return result;
    }

    private void identifyTablesFor_DataTypesOneToManySeveralTables(List<ClassInfo> cisToProcess) {
        for (ClassInfo ci : cisToProcess) {
            if (ci.category() != 1 && ci.category() != 6) continue;
            this.createDataTypeUseSpecificTables(ci, this.map(ci));
        }
    }

    private void createDataTypeUseSpecificTables(ClassInfo ci, Table parentTable) {
        for (PropertyInfo pi : ci.properties().values()) {
            ClassInfo typeCi;
            if (pi.categoryOfValue() != 5 || !(typeCi = this.model.classByIdOrName(pi.typeInfo())).matches("rule-sql-cls-data-types") || !typeCi.matches("rule-sql-cls-data-types-oneToMany-severalTables") || !this.model.isInSelectedSchemas(typeCi)) continue;
            String tableName = parentTable.getName() + "_" + pi.name();
            Table table = this.createTables(typeCi, parentTable.getSchemaName(), tableName);
            table.setRepresentedProperty(pi);
            table.setUsageSpecificTable(true);
            String columnName = ci.name() + this.determineForeignKeyColumnSuffix(ci);
            Column dtOwner_cd = this.createColumn(table, null, null, columnName, SqlDdl.foreignKeyColumnDataType, "NOT NULL", false, true);
            dtOwner_cd.setReferencedTable(parentTable);
            table.addColumn(dtOwner_cd);
            this.createDataTypeUseSpecificTables(typeCi, table);
        }
    }

    private void alterTableAddCheckConstraintForRange(Column column, Double lowerBound, Double upperBound) {
        Table tableWithColumn = column.getInTable();
        String constraintName = this.namingScheme.nameForCheckConstraint(SqlUtil.determineName(tableWithColumn, SqlDdl.constraintNameUsingShortName), SqlUtil.determineName(column, SqlDdl.constraintNameUsingShortName));
        Alter alter = new Alter();
        alter.setTable(tableWithColumn);
        ConstraintAlterExpression cae = new ConstraintAlterExpression();
        alter.setExpression(cae);
        cae.setOperation(AlterExpression.AlterOperation.ADD);
        CheckConstraint cc = new CheckConstraint();
        cae.setConstraint(cc);
        cc.setName(constraintName);
        BetweenExpression bexp = new BetweenExpression();
        ColumnExpression col = new ColumnExpression(column);
        bexp.setTestExpression(col);
        DoubleValueExpression lowerExp = new DoubleValueExpression(lowerBound);
        bexp.setBeginExpression(lowerExp);
        DoubleValueExpression upperExp = new DoubleValueExpression(upperBound);
        bexp.setEndExpression(upperExp);
        if (column.isNotNull()) {
            cc.setExpression(bexp);
        } else {
            IsNullExpression nullexp = new IsNullExpression();
            nullexp.setExpression(col);
            OrExpression orexp = new OrExpression(nullexp, bexp);
            cc.setExpression(orexp);
        }
        this.checkConstraints.add(alter);
    }

    private Alter alterTableAddUniqueConstraint(Table tableWithColumn, String uniqueConstraintIdentifier, Column column) {
        Alter alter = new Alter();
        alter.setTable(tableWithColumn);
        ConstraintAlterExpression cae = new ConstraintAlterExpression();
        alter.setExpression(cae);
        cae.setOperation(AlterExpression.AlterOperation.ADD);
        UniqueConstraint uc = new UniqueConstraint();
        cae.setConstraint(uc);
        uc.setName(uniqueConstraintIdentifier);
        uc.addColumn(column);
        return alter;
    }

    private void checkRequirements(List<ClassInfo> cisToProcess) throws SqlDdlException {
        for (ClassInfo ci : cisToProcess) {
            ShapeChangeResult.MessageContext mc;
            if (!ci.matches("rule-sql-cls-identifierStereotype")) continue;
            int countIdentifierAttributes = 0;
            for (PropertyInfo pi : ci.properties().values()) {
                ShapeChangeResult.MessageContext mc2;
                if (!pi.isAttribute() || !pi.stereotype("identifier")) continue;
                ++countIdentifierAttributes;
                if (pi.cardinality().maxOccurs <= 1 || (mc2 = this.result.addError(this, 25, pi.name())) == null) continue;
                mc2.addDetail(this, 100, pi.fullNameInSchema());
            }
            if (countIdentifierAttributes <= true || (mc = this.result.addWarning(this, 24, ci.name())) == null) continue;
            mc.addDetail(this, 101, ci.fullNameInSchema());
        }
        HashMap<String, ClassInfo> dataTypesToProcessById = new HashMap<String, ClassInfo>();
        for (ClassInfo ci : cisToProcess) {
            if (ci.category() != 5 || !ci.matches("rule-sql-cls-data-types") || !ci.matches("rule-sql-cls-data-types-oneToMany-severalTables")) continue;
            dataTypesToProcessById.put(ci.id(), ci);
        }
        if (this.hasCircularDependencies(dataTypesToProcessById)) {
            throw new SqlDdlException("Circular dependencies in datatypes detected.");
        }
    }

    private boolean hasCircularDependencies(Map<String, ClassInfo> dataTypesToProcessById) {
        if (dataTypesToProcessById == null || dataTypesToProcessById.isEmpty()) {
            return false;
        }
        boolean outcome = false;
        this.result.addInfo(this, 1001);
        DirectedMultigraph graph = new DirectedMultigraph(PropertySetEdge.class);
        for (ClassInfo classInfo : dataTypesToProcessById.values()) {
            graph.addVertex((Object)(classInfo.pkg().name() + "::" + classInfo.name()));
        }
        TreeMap<CallSite, Set> refTypeInfo = new TreeMap<CallSite, Set>();
        for (ClassInfo typeToProcess : dataTypesToProcessById.values()) {
            String typeToProcessKey = typeToProcess.pkg().name() + "::" + typeToProcess.name();
            HashMap propertiesByValueTypeName = new HashMap();
            for (PropertyInfo pi : typeToProcess.properties().values()) {
                Set<String> props;
                if (!pi.isNavigable() || !dataTypesToProcessById.containsKey(pi.typeInfo().id)) continue;
                ClassInfo targetType = dataTypesToProcessById.get(pi.typeInfo().id);
                String key = targetType.pkg().name() + "::" + targetType.name();
                if (propertiesByValueTypeName.containsKey(key)) {
                    props = (Set)propertiesByValueTypeName.get(key);
                } else {
                    props = new TreeSet();
                    propertiesByValueTypeName.put((CallSite)((Object)key), props);
                }
                props.add(pi.name());
            }
            for (String targetKey : propertiesByValueTypeName.keySet()) {
                Set props = (Set)propertiesByValueTypeName.get(targetKey);
                if (typeToProcessKey.equals(targetKey)) {
                    refTypeInfo.put((CallSite)((Object)typeToProcessKey), props);
                    continue;
                }
                graph.addEdge((Object)typeToProcessKey, (Object)targetKey, (Object)new PropertySetEdge(typeToProcessKey, targetKey, props));
            }
        }
        if (refTypeInfo.isEmpty()) {
            this.result.addInfo(this, 1003);
        } else {
            outcome = true;
            for (String key : refTypeInfo.keySet()) {
                this.result.addError(this, 1002, key, StringUtils.join((Iterable)((Iterable)refTypeInfo.get(key)), (String)","));
            }
        }
        TiernanSimpleCycles tiernanSimpleCycles = new TiernanSimpleCycles((Graph)graph);
        List cycles = tiernanSimpleCycles.findSimpleCycles();
        if (cycles != null && cycles.size() > 0) {
            for (List cycle : cycles) {
                outcome = true;
                this.result.addInfo(this, 1004);
                for (int i = 0; i < cycle.size(); ++i) {
                    String target;
                    String source;
                    if (tiernanSimpleCycles instanceof JohnsonSimpleCycles) {
                        source = (String)cycle.get(i);
                        target = i == 0 ? (String)cycle.get(cycle.size() - 1) : (String)cycle.get(i - 1);
                    } else if (tiernanSimpleCycles instanceof SzwarcfiterLauerSimpleCycles) {
                        source = (String)cycle.get(i);
                        target = i == cycle.size() - 1 ? (String)cycle.get(0) : (String)cycle.get(i + 1);
                    } else if (tiernanSimpleCycles instanceof TarjanSimpleCycles) {
                        source = (String)cycle.get(i);
                        target = i == cycle.size() - 1 ? (String)cycle.get(0) : (String)cycle.get(i + 1);
                    } else {
                        source = (String)cycle.get(i);
                        target = i == cycle.size() - 1 ? (String)cycle.get(0) : (String)cycle.get(i + 1);
                    }
                    PropertySetEdge edge = (PropertySetEdge)((Object)graph.getEdge((Object)source, (Object)target));
                    this.result.addInfo(this, 1005, source, target, edge.toString());
                }
            }
        } else {
            this.result.addInfo(this, 1006);
        }
        Object var5_10 = null;
        graph = null;
        return outcome;
    }

    private List<Statement> statements() {
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        stmts.addAll(this.sqLitePragmas);
        stmts.addAll(this.createTableStatements);
        stmts.addAll(this.checkConstraints);
        stmts.addAll(this.foreignKeyConstraints);
        stmts.addAll(this.uniqueConstraints);
        stmts.addAll(this.geometryMetadataUpdateStatements);
        stmts.addAll(this.geometryIndexStatements);
        stmts.addAll(this.nonGeometryIndexStatements);
        stmts.addAll(this.insertStatements);
        stmts.addAll(this.commentStatements);
        return stmts;
    }

    private Alter alterTableAddForeignKeyConstraint(Table t_main, String foreignKeyIdentifier, Column column, Table referenceTable) {
        Alter alter = new Alter();
        alter.setTable(t_main);
        ConstraintAlterExpression cae = new ConstraintAlterExpression();
        alter.setExpression(cae);
        cae.setOperation(AlterExpression.AlterOperation.ADD);
        ForeignKeyConstraint fkc = new ForeignKeyConstraint(foreignKeyIdentifier, referenceTable);
        cae.setConstraint(fkc);
        fkc.addColumn(column);
        PropertyInfo representedPi = column.getRepresentedProperty();
        if (representedPi != null) {
            Info relevantInfo = representedPi;
            String tvOnDelete = relevantInfo.taggedValue("sqlOnDelete");
            String tvOnUpdate = relevantInfo.taggedValue("sqlOnUpdate");
            if (!representedPi.isAttribute() && StringUtils.isBlank((CharSequence)tvOnDelete) && StringUtils.isBlank((CharSequence)tvOnUpdate)) {
                relevantInfo = representedPi.association();
                tvOnDelete = relevantInfo.taggedValue("sqlOnDelete");
                tvOnUpdate = relevantInfo.taggedValue("sqlOnUpdate");
            }
            this.setForeignKeyOption(true, tvOnDelete, fkc, column, relevantInfo);
            this.setForeignKeyOption(false, tvOnUpdate, fkc, column, relevantInfo);
        }
        return alter;
    }

    private void setForeignKeyOption(boolean isOnDelete, String optionValue, ForeignKeyConstraint fkc, Column column, Info relevantInfo) {
        block11: {
            if (StringUtils.isNotBlank((CharSequence)optionValue)) {
                Table table = column.getInTable();
                try {
                    ForeignKeyConstraint.Option o = ForeignKeyConstraint.Option.fromString(optionValue);
                    if (isOnDelete && SqlDdl.databaseStrategy.isForeignKeyOnDeleteOptionSupported(o) || !isOnDelete && SqlDdl.databaseStrategy.isForeignKeyOnUpdateOptionSupported(o)) {
                        boolean isValid = true;
                        if (o == ForeignKeyConstraint.Option.SET_NULL && column.isNotNull()) {
                            isValid = false;
                            ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 37, column.getName());
                            if (relevantInfo != null && mc != null) {
                                mc.addDetail(this, 102, table.getFullName(), column.getName());
                                mc.addDetail(this, 38, relevantInfo.fullNameInSchema());
                            }
                        }
                        if (isValid) {
                            if (isOnDelete) {
                                fkc.setOnDelete(o);
                            } else {
                                fkc.setOnUpdate(o);
                            }
                        }
                    } else {
                        ShapeChangeResult.MessageContext mc = this.result.addInfo(this, 35, o.toString(), isOnDelete ? "sqlOnDelete" : "sqlOnUpdate", isOnDelete ? "ON DELETE" : "ON UPDATE");
                        if (mc != null) {
                            mc.addDetail(this, 102, table.getFullName(), column.getName());
                            mc.addDetail(this, 38, relevantInfo.fullNameInSchema());
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 34, optionValue, isOnDelete ? "sqlOnDelete" : "sqlOnUpdate");
                    if (mc == null) break block11;
                    mc.addDetail(this, 102, table.getFullName(), column.getName());
                    mc.addDetail(this, 38, relevantInfo.fullNameInSchema());
                }
            }
        }
    }

    public Integer getSizeForCharacterValuedProperty(PropertyInfo pi) {
        return pi == null ? null : this.sizeByCharacterValuedProperty.get(pi);
    }

    public boolean isForeignKeyField(PropertyInfo pi) {
        return this.refersToTypeRepresentedByTable(pi);
    }

    private Table map(String schemaName, String tableName) {
        for (Table t : this.tables) {
            if (!StringUtils.equals((CharSequence)schemaName, (CharSequence)t.getSchemaName()) || !tableName.equals(t.getName())) continue;
            return t;
        }
        this.result.addDebug(this, 23, (String)(StringUtils.isBlank((CharSequence)schemaName) ? tableName : schemaName + "." + tableName));
        Table t = new Table(schemaName, tableName);
        this.tables.add(t);
        return t;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class SqlBuilder";
            }
            case 1: {
                return "Context: class '$1$'";
            }
            case 2: {
                return "Context: property '$1$'";
            }
            case 3: {
                return "Context: '$1$'";
            }
            case 5: {
                return "Number format exception while converting the tagged value '$1$' to an integer. Exception message: $2$. Using $3$ as default value.";
            }
            case 6: {
                return "??Number format exception while converting the tagged value '$1$' with value '$2$' to an integer.";
            }
            case 8: {
                return "??Many-to-many relationship represented by association between types with identity and maximum multiplicity > 1 on all navigable ends (in this case for classes: '$1$' [context is property '$2$'] <-> '$3$' [context is property '$4$']) is only supported if creation for associative tables is enabled (via inclusion of rule rule-sql-all-associativetables). Because the rule is not included, the relationship will be ignored.";
            }
            case 9: {
                return "Type '$1$' of property '$2$' in class '$3$' is not part of the schema that is being processed, no map entry is defined for it, and rule-sql-cls-references-to-external-types is not enabled. Please ensure that map entries are defined for external types used in the schema - or allow referencing of external types in general by enabling rule-sql-cls-references-to-external-types. Assigning textual type to the property.";
            }
            case 10: {
                return "Type '$1$' of property '$2$' in class '$3$' could not be found in the model. Assigning textual type to the property.";
            }
            case 11: {
                return "Attribute '$1$' in class '$2$' has maximum multiplicity greater than one. Creation of associative tables is not enabled. The property will thus be ignored.";
            }
            case 12: {
                return "Creating associative table to represent attribute '$1$' in class '$2$'. Tagged value 'associativeTable' not set on this attribute, thus using default naming pattern, which leads to table name: '$3$'.";
            }
            case 13: {
                return "Creating associative table to represent association between $1$ and $2$. Tagged value 'associativeTable' not set on this association, thus using default naming pattern, which leads to table name: '$3$'.";
            }
            case 14: {
                return "??Derived property '$1$' in class '$2$' has been ignored.";
            }
            case 15: {
                return "??Property '$1$' in class '$2$' is not encoded.";
            }
            case 16: {
                return "??The type of property '$1$' in class '$2$' is '$3$'. It is contained in the schema that is being processed. However, it is of a category not enabled for conversion, meaning that no table will be created to represent the type '$3$'. The property '$1$' in class '$2$' will therefore be ignored.";
            }
            case 17: {
                return "Could not find type '$1$' in the model. It was required to identify the correct map entry that applies for this type (based upon the encoding rule that applies to the type), when trying to determine if property '$2$' (that has this type) is a geometry typed property. Proceeding with the map entry that is retrieved when using the encoding rule that applies to the property.";
            }
            case 18: {
                return "Could not find enumeration '$1$' in the model - or no enum values defined for it. Check constraint for '$2$' will not be created.";
            }
            case 19: {
                return "Class $1$ is not encoded and no map entry (that applies in the SQL encoding) is defined for it. The relationship between class $1$ (context property is $2$) and class $3$ (context property is $4$), which in the model is defined via an association, thus does not exist in the SQL encoding.";
            }
            case 20: {
                return "??More than eleven occurrences of foreign key '$1$'. Resulting schema will be ambiguous.";
            }
            case 21: {
                return "?? The type '$1$' was not found in the schema(s) selected for processing or in map entries, or conversion of the category of classes to which the type belongs is generally not supported by the target. It will be mapped to 'unknown'.";
            }
            case 22: {
                return "An association exists between class $1$ (context property is $2$) and class $3$ (context property is $4$). The association represents a 1:n relationship, which would be encoded by adding a foreign key field to the table representing $1$. A map entry is defined for $1$. Thus, the table defined in that map entry, which represents $1$, should have a foreign key field to reference the table that represents $3$.";
            }
            case 23: {
                return "Creating table with name '$1$'";
            }
            case 24: {
                return "Multiple attributes with stereotype <<identifier>> found for class '$1$'. The first - arbitrary one - will be set as primary key.";
            }
            case 25: {
                return "Identifier attribute '$1$' has max multiplicity > 1.";
            }
            case 26: {
                return "Type '$1$' is configured to be used as conceptual type of the '$2$' column in table '$3$' (which represents a code list). However, the type could not be found in the model. The column will have the common data type for foreign keys (defined via the configuration). No specific constraints will be created for the $2$ column.";
            }
            case 27: {
                return "??Tagged value 'scale' is not blank (i.e., it is defined and not whitespace only), while tagged value 'precision' is blank. Scale cannot be defined without precision. Tagged value 'scale' will be ignored.";
            }
            case 28: {
                return "Type '$1$' is numerically valued. However, the numeric type could not be determined. Check tagged value 'numericType' on the type and that an appropriate map entry (with valid target type) exists for it in the configuration.";
            }
            case 29: {
                return "Type '$1$' of property '$2$' is numerically valued. However, the numeric type could not be determined. Check tagged value 'numericType' on the type and that an appropriate map entry (with valid target type) exists for it in the configuration.";
            }
            case 30: {
                return "Type '$1$' is configured to be used as conceptual type of the '$2$' column in table '$3$' (which represents a code list). However, the type is neither an enumeration nor represented by a table. The column will have the common data type for foreign keys (defined via the configuration). No specific constraints will be created for the $2$ column.";
            }
            case 31: {
                return "Type '$1$' - which is the conceptual type of '$2$' column in table '$3$' (which represents a code list) - is numerically valued. However, the numeric type could not be determined. Check tagged value 'numericType' on the type and that an appropriate map entry (with valid target type) exists for it in the configuration.";
            }
            case 32: {
                return "No enum values defined for enumeration '$1$'. Check constraint for column '$2$' in table '$3$' will not be created.";
            }
            case 33: {
                return "No unique constraint is created for column '$1$' of table '$2$', since the property represented by the column is multi-valued.";
            }
            case 34: {
                return "Foreign key constraint option '$1$' defined by tagged value '$2$' is unknown. The option is ignored.";
            }
            case 35: {
                return "Foreign key constraint option '$1$' is defined by tagged value '$2$'. The database system does not support this option for clause '$3$'. The option is ignored.";
            }
            case 36: {
                return "Could not parse value '$1$' of tag '$2$' to a double value. The tagged value will be ignored.";
            }
            case 37: {
                return "Foreign key option is 'SET NULL', but column '$1$' is 'NOT NULL'. The foreign key option is ignored.";
            }
            case 38: {
                return "Model element that defines the option: '$1$'";
            }
            case 39: {
                return "Creating associative table to represent association between $1$ and $2$. Tagged value 'sqlSchema' not set on this association, thus using default naming pattern, which leads to database schema name: '$3$'.";
            }
            case 40: {
                return "Creating associative table to represent attribute '$1$' in class '$2$' for referenced table '$3$'. Tagged value 'associativeTable' is ignored on this attribute, because a usage specific table must be created, which leads to table name: '$4$'.";
            }
            case 100: {
                return "Context: property '$1$'.";
            }
            case 101: {
                return "Context: class '$1$'.";
            }
            case 102: {
                return "Context: table '$1$', column '$2$'.";
            }
            case 1001: {
                return "---------- Checking for reflexive relationships and cyles in data types ----------";
            }
            case 1002: {
                return "--- Reflexive relationship detected for data type '$1$' (via properties: $2$).";
            }
            case 1003: {
                return "--- No reflexive relationships detected.";
            }
            case 1004: {
                return "--- Found cycle:";
            }
            case 1005: {
                return "   Class '$1$' -> class '$2$' (via properties: $3$)";
            }
            case 1006: {
                return "--- No cycles found.";
            }
        }
        return "(" + SqlBuilder.class.getName() + ") Unknown message with number: " + mnr;
    }
}

