/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteCreateSpatialIndexExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ForeignKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class SQLiteStrategy
implements DatabaseStrategy,
MessageSource {
    public static final String GEOMETRY_DIMENSION_VALIDATION_REGEX = "(?i:(XY|XYM|XYZ|XYZM|2|3|4))";
    private ShapeChangeResult result;

    public SQLiteStrategy(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public ColumnDataType primaryKeyDataType() {
        return new ColumnDataType("INTEGER");
    }

    @Override
    public String geometryDataType(ProcessMapEntry me, int srid) {
        return me.getTargetType();
    }

    @Override
    public ColumnDataType unlimitedLengthCharacterDataType() {
        return new ColumnDataType("TEXT");
    }

    @Override
    public ColumnDataType limitedLengthCharacterDataType(int size, String lengthQualifier) {
        return new ColumnDataType("TEXT");
    }

    @Override
    public Statement geometryIndexColumnPart(String indexName, Table table, Column column, Map<String, String> geometryCharacteristics) {
        Select select = new Select();
        SpatiaLiteCreateSpatialIndexExpression createSpatialIndexExpr = new SpatiaLiteCreateSpatialIndexExpression(table, column);
        select.setExpression(createSpatialIndexExpr);
        return select;
    }

    @Override
    public Statement geometryMetadataUpdateStatement(Table tableWithColumn, Column columForGeometryTypedProperty, int srid) {
        return null;
    }

    @Override
    public boolean validate(Map<String, ProcessMapEntry> mapEntryByType, MapEntryParamInfos mepp) {
        boolean isValid = true;
        if (mepp != null) {
            for (Map.Entry<String, Map<String, Map<String, String>>> entry : mepp.getParameterCache().entrySet()) {
                Map<String, String> geometryCharacteristics;
                String typeRuleKey = entry.getKey();
                Map<String, Map<String, String>> characteristicsByParameter = entry.getValue();
                if (!characteristicsByParameter.containsKey("geometry") || !(geometryCharacteristics = characteristicsByParameter.get("geometry")).containsKey("dimension")) continue;
                String dimension = geometryCharacteristics.get("dimension");
                if (dimension == null) {
                    this.result.addError(this, 3, typeRuleKey, "dimension", "geometry");
                    isValid = false;
                    continue;
                }
                if (dimension.matches(GEOMETRY_DIMENSION_VALIDATION_REGEX)) continue;
                this.result.addError(this, 4, typeRuleKey, "dimension", "geometry", GEOMETRY_DIMENSION_VALIDATION_REGEX);
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public Expression expressionForCheckConstraintToRestrictTimeOfDate(Column column) {
        return null;
    }

    @Override
    public boolean isForeignKeyOnDeleteOptionSupported(ForeignKeyConstraint.Option o) {
        return true;
    }

    @Override
    public boolean isForeignKeyOnUpdateOptionSupported(ForeignKeyConstraint.Option o) {
        return true;
    }

    @Override
    public List<Statement> schemaInitializationStatements(SortedSet<String> schemaNames) {
        return new ArrayList<Statement>();
    }

    @Override
    public String name() {
        return "SQLite";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class SQLiteStrategy";
            }
            case 3: {
                return "Invalid map entry for type#rule '$1$': no value is provided for the characteristic '$2$' of parameter '$3$'.";
            }
            case 4: {
                return "Invalid map entry for type#rule '$1$': value provided for characteristic '$2$' of parameter '$3$' is invalid. Check that the value matches the regular expression: $4$.";
            }
        }
        return "(" + SQLiteStrategy.class.getName() + ") Unknown message with number: " + mnr;
    }
}

