/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteAddGeometryColumn;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.AlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ConstraintAlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SqlConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SQLiteDdlFixer {
    public static List<Statement> fixDdl(List<Statement> stmtsIn) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        TreeMap constraintsFromAlterStatementsByFullTableName = new TreeMap();
        TreeMap<String, Table> tableByFullName = new TreeMap<String, Table>();
        for (Statement statement : stmtsIn) {
            if (statement instanceof Alter) {
                Alter alter = (Alter)statement;
                AlterExpression ae = alter.getExpression();
                if (ae.getOperation().equals((Object)AlterExpression.AlterOperation.ADD) && ae instanceof ConstraintAlterExpression) {
                    List<SqlConstraint> cons;
                    String fullTableName = alter.getTable().getFullName();
                    if (!constraintsFromAlterStatementsByFullTableName.containsKey(fullTableName)) {
                        cons = new ArrayList();
                        constraintsFromAlterStatementsByFullTableName.put(fullTableName, cons);
                    } else {
                        cons = (List)constraintsFromAlterStatementsByFullTableName.get(fullTableName);
                    }
                    cons.add(((ConstraintAlterExpression)ae).getConstraint());
                    continue;
                }
                result.add(statement);
                continue;
            }
            if (statement instanceof CreateTable) {
                result.add(statement);
                CreateTable ct = (CreateTable)statement;
                Table table = ct.getTable();
                tableByFullName.put(table.getFullName(), table);
                ArrayList<Column> columnsToRemoveFromTable = new ArrayList<Column>();
                for (Column col : table.getColumns()) {
                    PropertyInfo pi = col.getRepresentedProperty();
                    if (pi == null || !SqlUtil.isGeometryTypedProperty(pi)) continue;
                    columnsToRemoveFromTable.add(col);
                    String valueTypeName = pi.typeInfo().name;
                    String piEncodingRule = pi.encodingRule("sql");
                    String geometryDimension = SqlDdl.mapEntryParamInfos.getCharacteristic(valueTypeName, piEncodingRule, "geometry", "dimension");
                    if (geometryDimension == null) {
                        geometryDimension = SqlDdl.geometryDimension;
                    }
                    Select select = new Select();
                    SpatiaLiteAddGeometryColumn agc = new SpatiaLiteAddGeometryColumn(table, col, SqlDdl.srid, geometryDimension);
                    select.setExpression(agc);
                    result.add(select);
                }
                table.removeColumns(columnsToRemoveFromTable);
                continue;
            }
            result.add(statement);
        }
        for (Map.Entry entry : constraintsFromAlterStatementsByFullTableName.entrySet()) {
            String fullTableName = (String)entry.getKey();
            List cons = (List)entry.getValue();
            Table table = (Table)tableByFullName.get(fullTableName);
            table.addConstraints(cons);
        }
        return result;
    }
}

