/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ForeignKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class SQLServerStrategy
implements DatabaseStrategy,
MessageSource {
    public static final String IDX_PARAM_USING = "USING";
    public static final String IDX_PARAM_BOUNDING_BOX = "BOUNDING_BOX";
    private ShapeChangeResult result;

    public SQLServerStrategy(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public ColumnDataType primaryKeyDataType() {
        return new ColumnDataType("bigint");
    }

    @Override
    public String geometryDataType(ProcessMapEntry me, int srid) {
        return me.getTargetType();
    }

    @Override
    public ColumnDataType unlimitedLengthCharacterDataType() {
        return new ColumnDataType("nvarchar(max)", null, null, null, null);
    }

    @Override
    public ColumnDataType limitedLengthCharacterDataType(int size, String lengthQualifier) {
        if (size > 4000) {
            return new ColumnDataType("nvarchar(max)", null, null, null, null);
        }
        return new ColumnDataType("nvarchar", null, null, size, null);
    }

    @Override
    public Statement geometryIndexColumnPart(String indexName, Table table, Column column, Map<String, String> geometryCharacteristics) {
        Index index = new Index(indexName);
        index.setType("SPATIAL");
        index.addColumn(column);
        if (geometryCharacteristics.containsKey(IDX_PARAM_USING)) {
            index.addSpec("USING " + geometryCharacteristics.get(IDX_PARAM_USING));
        }
        if (geometryCharacteristics.containsKey(IDX_PARAM_BOUNDING_BOX)) {
            index.addSpec("WITH (BOUNDING_BOX = " + geometryCharacteristics.get(IDX_PARAM_BOUNDING_BOX) + ")");
        }
        CreateIndex cIndex = new CreateIndex();
        cIndex.setIndex(index);
        cIndex.setTable(table);
        return cIndex;
    }

    @Override
    public Statement geometryMetadataUpdateStatement(Table tableWithColumn, Column columForGeometryTypedProperty, int srid) {
        return null;
    }

    @Override
    public boolean validate(Map<String, ProcessMapEntry> mapEntryByType, MapEntryParamInfos mepp) {
        return true;
    }

    @Override
    public Expression expressionForCheckConstraintToRestrictTimeOfDate(Column columnForPi) {
        return null;
    }

    @Override
    public boolean isForeignKeyOnDeleteOptionSupported(ForeignKeyConstraint.Option o) {
        return o == ForeignKeyConstraint.Option.CASCADE || o == ForeignKeyConstraint.Option.SET_NULL || o == ForeignKeyConstraint.Option.NO_ACTION || o == ForeignKeyConstraint.Option.SET_DEFAULT;
    }

    @Override
    public boolean isForeignKeyOnUpdateOptionSupported(ForeignKeyConstraint.Option o) {
        return o == ForeignKeyConstraint.Option.CASCADE || o == ForeignKeyConstraint.Option.SET_NULL || o == ForeignKeyConstraint.Option.NO_ACTION || o == ForeignKeyConstraint.Option.SET_DEFAULT;
    }

    @Override
    public List<Statement> schemaInitializationStatements(SortedSet<String> schemaNames) {
        return new ArrayList<Statement>();
    }

    @Override
    public String name() {
        return "SQLServer";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class SQLServerStrategy";
            }
        }
        return "(" + SQLServerStrategy.class.getName() + ") Unknown message with number: " + mnr;
    }
}

