/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlBuilder;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Comment;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.DropSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PostgreSQLAlterRole;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SQLitePragma;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.StatementVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import de.interactive_instruments.ShapeChange.Type;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReplicationSchemaVisitor
implements StatementVisitor,
MessageSource {
    protected SqlDdl sqlddl;
    protected SqlBuilder sqlbuilder;
    protected Options options;
    protected ShapeChangeResult result;
    protected Model model;
    protected SortedSet<ClassInfo> enumerationsInSchema = new TreeSet<ClassInfo>(new Comparator<ClassInfo>(){

        @Override
        public int compare(ClassInfo ci1, ClassInfo ci2) {
            return ci1.name().compareTo(ci2.name());
        }
    });
    protected Document document;
    protected Element root;
    protected String targetNamespace;
    private TreeSet<PackageInfo> repSchemaPackagesForImport = new TreeSet<PackageInfo>(new Comparator<PackageInfo>(){

        @Override
        public int compare(PackageInfo pi1, PackageInfo pi2) {
            return pi1.name().compareTo(pi2.name());
        }
    });

    public ReplicationSchemaVisitor(SqlDdl sqlddl, SqlBuilder sqlbuilder) throws ShapeChangeAbortException {
        DocumentBuilder documentBuilder;
        this.sqlddl = sqlddl;
        this.sqlbuilder = sqlbuilder;
        this.options = sqlddl.options;
        this.result = sqlddl.result;
        this.model = SqlDdl.model;
        for (ClassInfo classInfo : this.model.selectedSchemaClasses()) {
            if (classInfo.category() != 3) continue;
            this.enumerationsInSchema.add(classInfo);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            throw new ShapeChangeAbortException();
        }
        this.document = documentBuilder.newDocument();
        this.root = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.root, "xmlns", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.root, "elementFormDefault", "qualified");
        this.addAttribute(this.root, "version", SqlDdl.repSchemaTargetVersion);
        this.targetNamespace = SqlDdl.repSchemaTargetNamespace + SqlDdl.repSchemaTargetNamespaceSuffix;
        this.addAttribute(this.root, "targetNamespace", this.targetNamespace);
        this.addAttribute(this.root, "xmlns:" + SqlDdl.repSchemaTargetXmlns, this.targetNamespace);
        this.addAttribute(this.root, "xmlns:sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
        if (this.options.getCurrentProcessConfig().parameterAsString("processOutput_addComment", null, false, true) == null) {
            org.w3c.dom.Comment generationComment = this.document.createComment("XML Schema document created by ShapeChange - http://shapechange.net/");
            this.root.appendChild(generationComment);
        }
    }

    @Override
    public void visit(Insert insert) {
    }

    @Override
    public void visit(CreateIndex createIndex) {
    }

    @Override
    public void visit(CreateTable createTable) {
        Table table = createTable.getTable();
        if (!table.isAssociativeTable() && table.getRepresentedClass().category() == 2) {
            return;
        }
        Element globalElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.document.getDocumentElement().appendChild(globalElement);
        this.addAttribute(globalElement, "name", table.getName());
        this.addAttribute(globalElement, "type", SqlDdl.repSchemaTargetXmlns + ":" + table.getName() + "Type");
        String globalIdForGlobalElement = table.getGlobalId();
        Element annotationGlobalElement = this.addAnnotation(globalElement);
        this.addGlobalId(annotationGlobalElement, globalIdForGlobalElement);
        Element complexTypeElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(complexTypeElement);
        this.addAttribute(complexTypeElement, "name", table.getName() + "Type");
        Element sequence = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        complexTypeElement.appendChild(sequence);
        for (Column column : table.getColumns()) {
            Object type;
            String taggedValueSize;
            PropertyInfo propForColumn = column.getRepresentedProperty();
            Integer sizeForFieldWithCharacterDataType = null;
            if (propForColumn != null && StringUtils.isNotBlank((CharSequence)(taggedValueSize = propForColumn.taggedValuesAll().getFirstValue("size")))) {
                try {
                    sizeForFieldWithCharacterDataType = Integer.parseInt(taggedValueSize);
                }
                catch (NumberFormatException e) {
                    this.result.addError(this, 4, taggedValueSize, e.getMessage());
                }
            }
            Element columnDefinitionElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            sequence.appendChild(columnDefinitionElement);
            this.addAttribute(columnDefinitionElement, "name", column.getName());
            if (column.isObjectIdentifierColumn()) {
                type = SqlDdl.repSchemaObjectIdentifierFieldType;
            } else if (propForColumn != null) {
                Type ti = propForColumn.typeInfo();
                ProcessMapEntry pme = this.options.targetMapEntry(ti.name, propForColumn.encodingRule("sql"));
                if (pme != null) {
                    if (pme.hasTargetType()) {
                        type = pme.getTargetType();
                    } else {
                        type = "fixme:fixme";
                        this.result.addError(this, 2, ti.name, (String)type);
                    }
                } else if (propForColumn.categoryOfValue() == 3) {
                    ClassInfo enumeration = this.getValueType(propForColumn);
                    if (this.model.isInSelectedSchemas(enumeration)) {
                        type = SqlDdl.repSchemaTargetXmlns + ":" + enumeration.name() + "Type";
                    } else {
                        type = enumeration.qname() + "Type";
                        this.repSchemaPackagesForImport.add(enumeration.pkg());
                    }
                } else {
                    type = propForColumn.categoryOfValue() == 2 ? "string" : SqlDdl.repSchemaForeignKeyFieldType;
                }
            } else if (column.isForeignKeyColumn()) {
                type = SqlDdl.repSchemaForeignKeyFieldType;
            } else {
                type = "fixme:fixme";
                this.result.addError(this, 3, column.getName(), table.getName(), (String)type);
            }
            this.addAttribute(columnDefinitionElement, "type", (String)type);
            if (propForColumn != null) {
                if (!table.isAssociativeTable() && (propForColumn.cardinality().minOccurs == 0 || propForColumn.matches("rule-sql-prop-replicationSchema-optional"))) {
                    this.addAttribute(columnDefinitionElement, "minOccurs", "0");
                }
                if (propForColumn.matches("rule-sql-prop-replicationSchema-nillable") && !column.isNotNull()) {
                    this.addAttribute(columnDefinitionElement, "nillable", "true");
                }
            }
            String globalIdForColumnElement = null;
            String documentationForColumnElement = null;
            String geometryType = null;
            if (propForColumn != null) {
                globalIdForColumnElement = propForColumn.globalIdentifier();
                if (sizeForFieldWithCharacterDataType != null && sizeForFieldWithCharacterDataType < 1 && propForColumn.matches("rule-sql-prop-replicationSchema-documentation-fieldWithUnlimitedLengthCharacterDataType")) {
                    documentationForColumnElement = SqlDdl.repSchemaDocumentationUnlimitedLengthCharacterDataType;
                }
                if (propForColumn.typeInfo().name.startsWith("GM_") && propForColumn.matches("rule-sql-prop-replicationSchema-geometryAnnotation")) {
                    geometryType = propForColumn.typeInfo().name;
                }
            }
            if (globalIdForColumnElement != null || documentationForColumnElement != null || geometryType != null) {
                Element annotationColumnElement = this.addAnnotation(columnDefinitionElement);
                this.addGlobalId(annotationColumnElement, globalIdForColumnElement);
                this.addDocumentation(annotationColumnElement, documentationForColumnElement);
                this.addGeometryAnnotation(annotationColumnElement, geometryType);
            }
            if (propForColumn == null || sizeForFieldWithCharacterDataType == null || sizeForFieldWithCharacterDataType <= 0 || !propForColumn.matches("rule-sql-prop-replicationSchema-maxLength-from-size") || propForColumn.categoryOfValue() == 3) continue;
            Element simpleType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
            columnDefinitionElement.appendChild(simpleType);
            Element restriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            simpleType.appendChild(restriction);
            columnDefinitionElement.removeAttribute("type");
            this.addAttribute(restriction, "base", (String)type);
            Element concreteRestriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
            this.addAttribute(concreteRestriction, "value", "" + sizeForFieldWithCharacterDataType);
            restriction.appendChild(concreteRestriction);
        }
    }

    private void addGeometryAnnotation(Element annotation, String geometryType) {
        if (geometryType != null) {
            Element eAppInfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            Element eGeomType = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "sc:geometryType");
            eGeomType.appendChild(this.document.createTextNode(geometryType));
            eAppInfo.appendChild(eGeomType);
            Element eSrid = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "sc:srid");
            eSrid.appendChild(this.document.createTextNode("" + SqlDdl.srid));
            eAppInfo.appendChild(eSrid);
            annotation.appendChild(eAppInfo);
        }
    }

    private ClassInfo getValueType(PropertyInfo pi) {
        ShapeChangeResult.MessageContext mc;
        Type ti = pi.typeInfo();
        ClassInfo typeCi = pi.model().classById(ti.id);
        if (typeCi == null && (typeCi = pi.model().classByName(ti.name)) != null && (mc = this.result.addError(null, 135, pi.name())) != null) {
            mc.addDetail(null, 400, "Property", pi.fullNameInSchema());
        }
        if (typeCi == null && (mc = this.result.addError(null, 131, pi.name(), ti.name)) != null) {
            mc.addDetail(null, 400, "Property", pi.fullNameInSchema());
        }
        return typeCi;
    }

    private void addGlobalId(Element annotation, String globalId) {
        if (globalId != null) {
            Element eAppInfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            eAppInfo.appendChild(this.document.createTextNode(globalId));
            annotation.appendChild(eAppInfo);
        }
    }

    private void addDocumentation(Element annotation, String documentation) {
        if (documentation != null) {
            Element eDoc = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "documentation");
            eDoc.appendChild(this.document.createTextNode(documentation));
            annotation.appendChild(eDoc);
        }
    }

    private Element addAnnotation(Element e) {
        Element res = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        e.appendChild(res);
        return res;
    }

    private void addGlobalEnumeration(ClassInfo ci) {
        if (ci.category() == 3) {
            Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
            Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            e1.appendChild(e4);
            this.addAttribute(e4, "base", "string");
            for (PropertyInfo atti : ci.properties().values()) {
                Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "enumeration");
                e4.appendChild(e3);
                String val = atti.name();
                if (atti.initialValue() != null) {
                    val = atti.initialValue();
                }
                this.addAttribute(e3, "value", val);
            }
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", ci.name() + "Type");
        }
    }

    @Override
    public void visit(Alter alter) {
    }

    @Override
    public void visit(List<Statement> stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                stmt.accept(this);
            }
        }
    }

    protected void addAttribute(Element e, String name, String value) {
        Attr att = this.document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    public Document getDocument() {
        this.addImports();
        for (ClassInfo enumeration : this.enumerationsInSchema) {
            this.addGlobalEnumeration(enumeration);
        }
        return this.document;
    }

    private void addImports() {
        Node anchor = null;
        for (PackageInfo packageInfo : this.repSchemaPackagesForImport) {
            this.addAttribute(this.root, "xmlns:" + packageInfo.xmlns(), packageInfo.targetNamespace() + SqlDdl.repSchemaTargetNamespaceSuffix);
            Element importElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            this.addAttribute(importElement, "namespace", packageInfo.targetNamespace() + SqlDdl.repSchemaTargetNamespaceSuffix);
            if (anchor == null) {
                this.root.insertBefore(importElement, this.root.getFirstChild());
            } else {
                this.root.insertBefore(importElement, anchor.getNextSibling());
            }
            anchor = importElement;
        }
    }

    @Override
    public void visit(Comment comment) {
    }

    @Override
    public void visit(SQLitePragma sqLitePragma) {
    }

    @Override
    public void postprocess() {
    }

    @Override
    public void visit(Select select) {
    }

    @Override
    public void visit(CreateSchema createSchema) {
    }

    @Override
    public void visit(DropSchema dropSchema) {
    }

    @Override
    public void visit(PostgreSQLAlterRole postgreSQLAlterRole) {
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Could not find enumeration '$1$' in the model.";
            }
            case 2: {
                return "??No target type defined in map entry with type '$1$'. Using '$2$' instead.";
            }
            case 3: {
                return "Column '$1$' in table '$2$' neither represents a specific property nor an object identifier. Using '$3$' as type.";
            }
            case 4: {
                return "Could not parse tagged value size (value = $1$, error message = $2$)";
            }
            case 100: {
                return "Context: $1$";
            }
        }
        return "(" + ReplicationSchemaVisitor.class.getName() + ") Unknown message with number: " + mnr;
    }
}

