/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.DropSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ForeignKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PostgreSQLAlterRole;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;

public class PostgreSQLStrategy
implements DatabaseStrategy {
    @Override
    public ColumnDataType primaryKeyDataType() {
        return new ColumnDataType("bigserial");
    }

    @Override
    public String geometryDataType(ProcessMapEntry me, int srid) {
        return "geometry(" + me.getTargetType() + "," + srid + ")";
    }

    @Override
    public ColumnDataType unlimitedLengthCharacterDataType() {
        return new ColumnDataType("text");
    }

    @Override
    public ColumnDataType limitedLengthCharacterDataType(int size, String lengthQualifier) {
        return new ColumnDataType("character varying", null, null, size, null);
    }

    @Override
    public Statement geometryIndexColumnPart(String indexName, Table table, Column column, Map<String, String> geometryCharacteristics) {
        Index index = new Index(indexName);
        index.addColumn(column);
        index.getProperties().setProperty("method", "GIST");
        CreateIndex cIndex = new CreateIndex();
        cIndex.setIndex(index);
        cIndex.setTable(table);
        return cIndex;
    }

    @Override
    public Statement geometryMetadataUpdateStatement(Table tableWithColumn, Column columForGeometryTypedProperty, int srid) {
        return null;
    }

    @Override
    public boolean validate(Map<String, ProcessMapEntry> mapEntryByType, MapEntryParamInfos mepp) {
        return true;
    }

    @Override
    public Expression expressionForCheckConstraintToRestrictTimeOfDate(Column columnForPi) {
        return null;
    }

    @Override
    public boolean isForeignKeyOnDeleteOptionSupported(ForeignKeyConstraint.Option o) {
        return true;
    }

    @Override
    public boolean isForeignKeyOnUpdateOptionSupported(ForeignKeyConstraint.Option o) {
        return true;
    }

    @Override
    public List<Statement> schemaInitializationStatements(SortedSet<String> schemaNames) {
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        if (!schemaNames.isEmpty()) {
            DropSchema dp = new DropSchema(schemaNames);
            dp.setIfExists(true);
            dp.addSpec("CASCADE");
            stmts.add(dp);
            for (String name : schemaNames) {
                CreateSchema cs = new CreateSchema(name);
                cs.setIfNotExists(false);
                stmts.add(cs);
            }
            PostgreSQLAlterRole ar = new PostgreSQLAlterRole();
            ar.setRoleSpecificationOrALL(SqlDdl.postgreSqlRole);
            ArrayList<String> searchPathValues = new ArrayList<String>(schemaNames);
            searchPathValues.add("public");
            ar.setSpec("SET search_path TO " + StringUtils.join(searchPathValues, (String)","));
            stmts.add(ar);
        }
        return stmts;
    }

    @Override
    public String name() {
        return "PostgreSQL";
    }
}

