/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.Target.SQL.DdlVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PostgreSQLAlterRole;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PostgreSQLDdlVisitor
extends DdlVisitor {
    public PostgreSQLDdlVisitor(String crlf, String indent, SqlDdl sqlddl) {
        super(crlf, indent, sqlddl);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        Properties indexProps = index.getProperties();
        this.sb.append("CREATE ");
        if (index.getType() != null) {
            this.sb.append(index.getType());
            this.sb.append(" ");
        }
        this.sb.append("INDEX ");
        this.sb.append(index.getName());
        this.sb.append(" ON ");
        this.sb.append(createIndex.getTable().getFullName());
        if (indexProps.containsKey("method")) {
            this.sb.append(" USING ");
            this.sb.append(indexProps.getProperty("method"));
        }
        if (index.hasColumns()) {
            this.sb.append(" ");
            this.sb.append(SqlUtil.getStringList(index.getColumns(), true, true));
        }
        if (index.hasSpecs()) {
            this.sb.append(" ");
            this.sb.append(StringUtils.join(index.getSpecs(), (String)" "));
        }
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(PostgreSQLAlterRole postgreSQLAlterRole) {
        this.sb.append("ALTER ROLE ");
        this.sb.append(postgreSQLAlterRole.getRoleSpecificationOrALL());
        this.sb.append(" ");
        this.sb.append(postgreSQLAlterRole.getSpec());
        this.sb.append(";");
        this.sb.append(this.crlf);
    }
}

