/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.DatabaseStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ColumnExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.EqualsExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.Expression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.LongValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SdoDimArrayExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.StringValueExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.ToCharExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ForeignKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class OracleStrategy
implements DatabaseStrategy,
MessageSource {
    public static final String GEOM_PARAM_LAYER_GTYPE = "layer_gtype";
    public static final String GEOM_PARAM_LAYER_GTYPE_VALIDATION_REGEX = "(?i:(POINT|LINE|POLYGON|COLLECTION|MULTIPOINT|MULTILINE|MULTIPOLYGON))";
    private ShapeChangeResult result;
    private Table userSdoGeomMetadataTable = new Table(null, "USER_SDO_GEOM_METADATA");

    public OracleStrategy(ShapeChangeResult result) {
        this.result = result;
    }

    @Override
    public ColumnDataType primaryKeyDataType() {
        return new ColumnDataType("INTEGER");
    }

    @Override
    public String geometryDataType(ProcessMapEntry me, int srid) {
        return me.getTargetType();
    }

    @Override
    public ColumnDataType unlimitedLengthCharacterDataType() {
        return new ColumnDataType("CLOB");
    }

    @Override
    public ColumnDataType limitedLengthCharacterDataType(int size, String lengthQualifier) {
        return new ColumnDataType("VARCHAR2", null, null, size, lengthQualifier);
    }

    @Override
    public Statement geometryIndexColumnPart(String indexName, Table table, Column column, Map<String, String> geometryCharacteristics) {
        String layergtype;
        Index index = new Index(indexName);
        index.addColumn(column);
        index.addSpec("INDEXTYPE IS MDSYS.SPATIAL_INDEX");
        if (geometryCharacteristics != null && geometryCharacteristics.containsKey(GEOM_PARAM_LAYER_GTYPE) && (layergtype = geometryCharacteristics.get(GEOM_PARAM_LAYER_GTYPE)) != null) {
            index.addSpec("PARAMETERS('layer_gtype=" + geometryCharacteristics.get(GEOM_PARAM_LAYER_GTYPE) + "')");
        }
        CreateIndex cIndex = new CreateIndex();
        cIndex.setIndex(index);
        cIndex.setTable(table);
        return cIndex;
    }

    @Override
    public Statement geometryMetadataUpdateStatement(Table tableWithColumn, Column columnForGeometryTypedProperty, int srid) {
        Insert ins = new Insert();
        ins.setTable(this.userSdoGeomMetadataTable);
        ins.setColumns(SqlUtil.toColumnList(this.userSdoGeomMetadataTable, "TABLE_NAME", "COLUMN_NAME", "DIMINFO", "SRID"));
        ArrayList<Expression> items = new ArrayList<Expression>();
        items.addAll(SqlUtil.toStringValueList(tableWithColumn.getName(), columnForGeometryTypedProperty.getName()));
        SdoDimArrayExpression dimArray = SqlDdl.sdoDimArrayExpression;
        items.add(dimArray);
        items.add(new LongValueExpression(srid));
        ins.setExpressionList(SqlUtil.toExpressionList(items));
        return ins;
    }

    @Override
    public boolean validate(Map<String, ProcessMapEntry> mapEntryByType, MapEntryParamInfos mepp) {
        boolean isValid = true;
        if (mepp != null) {
            for (Map.Entry<String, Map<String, Map<String, String>>> entry : mepp.getParameterCache().entrySet()) {
                Map<String, String> geometryCharacteristics;
                String typeRuleKey = entry.getKey();
                Map<String, Map<String, String>> characteristicsByParameter = entry.getValue();
                if (!characteristicsByParameter.containsKey("geometry") || !(geometryCharacteristics = characteristicsByParameter.get("geometry")).containsKey(GEOM_PARAM_LAYER_GTYPE)) continue;
                String layergtype = geometryCharacteristics.get(GEOM_PARAM_LAYER_GTYPE);
                if (layergtype == null) {
                    this.result.addError(this, 3, typeRuleKey, GEOM_PARAM_LAYER_GTYPE, "geometry");
                    isValid = false;
                    continue;
                }
                if (layergtype.matches(GEOM_PARAM_LAYER_GTYPE_VALIDATION_REGEX)) continue;
                this.result.addError(this, 4, typeRuleKey, GEOM_PARAM_LAYER_GTYPE, "geometry", GEOM_PARAM_LAYER_GTYPE_VALIDATION_REGEX);
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public Expression expressionForCheckConstraintToRestrictTimeOfDate(Column columnForPi) {
        if (columnForPi.getDataType().getName().equalsIgnoreCase("DATE")) {
            ColumnExpression colexp = new ColumnExpression(columnForPi);
            ToCharExpression tcexp = new ToCharExpression(colexp, "HH24:MI:SS");
            StringValueExpression compareValue = new StringValueExpression("00:00:00");
            EqualsExpression eexp = new EqualsExpression(tcexp, compareValue);
            return eexp;
        }
        return null;
    }

    @Override
    public boolean isForeignKeyOnDeleteOptionSupported(ForeignKeyConstraint.Option o) {
        return o == ForeignKeyConstraint.Option.CASCADE || o == ForeignKeyConstraint.Option.SET_NULL || o == ForeignKeyConstraint.Option.NO_ACTION;
    }

    @Override
    public boolean isForeignKeyOnUpdateOptionSupported(ForeignKeyConstraint.Option o) {
        return false;
    }

    @Override
    public List<Statement> schemaInitializationStatements(SortedSet<String> schemaNames) {
        return new ArrayList<Statement>();
    }

    @Override
    public String name() {
        return "Oracle";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class OracleStrategy";
            }
            case 3: {
                return "Invalid map entry for type#rule '$1$': no value is provided for the characteristic '$2$' of parameter '$3$'.";
            }
            case 4: {
                return "Invalid map entry for type#rule '$1$': value provided for characteristic '$2$' of parameter '$3$' is invalid. Check that the value matches the regular expression: $4$.";
            }
        }
        return "(" + OracleStrategy.class.getName() + ") Unknown message with number: " + mnr;
    }
}

