/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.AlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Comment;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ConstraintAlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.DropSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PostgreSQLAlterRole;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SQLitePragma;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SqlConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.StatementVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;

public class DdlVisitor
implements StatementVisitor {
    protected StringBuffer sb = new StringBuffer();
    protected String crlf;
    protected String indent;
    protected SqlDdl sqlddl;

    public DdlVisitor(String crlf, String indent, SqlDdl sqlddl) {
        this.crlf = crlf;
        this.indent = indent;
        this.sqlddl = sqlddl;
    }

    @Override
    public void visit(Insert insert) {
        this.sb.append("INSERT INTO ");
        this.sb.append(insert.getTable().getFullName());
        if (insert.getColumns() != null) {
            this.sb.append(" ");
            this.sb.append(SqlUtil.getStringList(insert.getColumns(), true, true));
        }
        this.sb.append(" ");
        this.sb.append("VALUES ");
        if (insert.getExpressionList() != null) {
            this.sb.append(insert.getExpressionList());
        }
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        this.sb.append("CREATE ");
        if (index.getType() != null) {
            this.sb.append(index.getType());
            this.sb.append(" ");
        }
        this.sb.append("INDEX ");
        this.sb.append(index.getName());
        this.sb.append(" ON ");
        this.sb.append(createIndex.getTable().getFullName());
        if (index.hasColumns()) {
            this.sb.append(" ");
            this.sb.append(SqlUtil.getStringList(index.getColumns(), true, true));
        }
        if (index.hasSpecs()) {
            this.sb.append(" ");
            this.sb.append(StringUtils.join(index.getSpecs(), (String)" "));
        }
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(CreateTable ct) {
        Iterator<Object> iter;
        Table table = ct.getTable();
        this.sb.append("CREATE TABLE ");
        this.sb.append(table.getFullName());
        this.sb.append(" (");
        this.sb.append(this.crlf);
        this.sb.append(this.crlf);
        if (table.getColumns() != null) {
            iter = table.getColumns().iterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                this.sb.append(this.indent);
                this.sb.append(col.getName());
                this.sb.append(" ");
                ColumnDataType colDataType = col.getDataType();
                this.sb.append(colDataType.getName());
                if (colDataType.hasPrecision()) {
                    this.sb.append("(");
                    this.sb.append(colDataType.getPrecision().toString());
                    if (colDataType.hasScale()) {
                        this.sb.append(",");
                        this.sb.append(colDataType.getScale().toString());
                    }
                    this.sb.append(")");
                } else if (colDataType.hasLength()) {
                    this.sb.append("(");
                    this.sb.append(colDataType.getLength());
                    if (colDataType.hasLengthQualifier()) {
                        this.sb.append(" ");
                        this.sb.append(colDataType.getLengthQualifier());
                    }
                    this.sb.append(")");
                }
                if (col.getDefaultValue() != null) {
                    this.sb.append(" DEFAULT " + col.getDefaultValue());
                }
                if (col.getSpecifications() != null && !col.getSpecifications().isEmpty()) {
                    this.sb.append(" ");
                    this.sb.append(StringUtils.join(col.getSpecifications(), (String)" "));
                }
                if (iter.hasNext() || table.hasConstraints()) {
                    this.sb.append(",");
                }
                if (SqlDdl.createDocumentation && StringUtils.isNotBlank((CharSequence)col.getDocumentation())) {
                    this.sb.append(" -- " + col.getDocumentation().replaceAll("\\s+", " ").trim());
                }
                this.sb.append(this.crlf);
            }
        }
        if (table.hasConstraints()) {
            iter = table.getConstraints().iterator();
            while (iter.hasNext()) {
                SqlConstraint constr = (SqlConstraint)iter.next();
                this.sb.append(this.indent).append(constr);
                if (iter.hasNext()) {
                    this.sb.append(",");
                }
                this.sb.append(this.crlf);
            }
        }
        this.sb.append(")");
        this.sb.append(";");
        this.sb.append(this.crlf);
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(Alter alter) {
        Table table = alter.getTable();
        this.sb.append("ALTER TABLE ");
        this.sb.append(table.getFullName());
        this.sb.append(" ");
        AlterExpression ae = alter.getExpression();
        this.sb.append((Object)ae.getOperation());
        this.sb.append(" ");
        if (ae instanceof ConstraintAlterExpression) {
            ConstraintAlterExpression cae = (ConstraintAlterExpression)ae;
            this.sb.append(cae.toString());
        }
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(List<Statement> stmts) {
        if (stmts != null) {
            Object last = null;
            for (Statement stmt : stmts) {
                if (last != null && !last.getClass().getName().equals(stmt.getClass().getName())) {
                    this.sb.append(this.crlf);
                }
                stmt.accept(this);
                last = stmt;
            }
        }
    }

    public String getDdl() {
        return this.sb.toString();
    }

    @Override
    public void visit(Comment comment) {
        this.sb.append(comment.toString());
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void postprocess() {
    }

    @Override
    public void visit(Select select) {
        this.sb.append("SELECT ");
        this.sb.append(select.getExpression().toString());
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(SQLitePragma pragma) {
        this.sb.append("PRAGMA ");
        this.sb.append(pragma.getName());
        if (pragma.hasValue()) {
            this.sb.append(" = ");
            this.sb.append(pragma.getValue());
        }
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(PostgreSQLAlterRole postgreSQLAlterRole) {
    }

    @Override
    public void visit(CreateSchema createSchema) {
        String schemaName = createSchema.getSchemaName();
        this.sb.append("CREATE SCHEMA ");
        if (createSchema.isIfNotExists()) {
            this.sb.append("IF NOT EXISTS ");
        }
        this.sb.append(schemaName);
        this.sb.append(";");
        this.sb.append(this.crlf);
    }

    @Override
    public void visit(DropSchema dropSchema) {
        SortedSet<String> schemaNames = dropSchema.getSchemaNames();
        this.sb.append("DROP SCHEMA");
        if (dropSchema.isIfExists()) {
            this.sb.append(" IF EXISTS ");
        }
        this.sb.append(StringUtils.join(schemaNames, (String)", "));
        if (dropSchema.hasSpecs()) {
            this.sb.append(" ");
            this.sb.append(StringUtils.join(dropSchema.getSpecs(), (String)" "));
        }
        this.sb.append(";");
        this.sb.append(this.crlf);
    }
}

