/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.SQL;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SQL.OracleStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLServerStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SQLiteStrategy;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlDdl;
import de.interactive_instruments.ShapeChange.Target.SQL.SqlUtil;
import de.interactive_instruments.ShapeChange.Target.SQL.expressions.SpatiaLiteCreateSpatialIndexExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Alter;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.AlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CheckConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Column;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ColumnDataType;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Comment;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ConstraintAlterExpression;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateIndex;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.CreateTable;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.DropSchema;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.ForeignKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Index;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Insert;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PostgreSQLAlterRole;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.PrimaryKeyConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SQLitePragma;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Select;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.SqlConstraint;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Statement;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.StatementVisitor;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.Table;
import de.interactive_instruments.ShapeChange.Target.SQL.structure.UniqueConstraint;
import de.interactive_instruments.ShapeChange.Util.ea.EAAttributeUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EADirection;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EAMethodUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EANavigable;
import de.interactive_instruments.ShapeChange.Util.ea.EAPackageUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAParameterUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EASupportedDBMS;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.Element;
import org.sparx.Method;
import org.sparx.Package;
import org.sparx.Parameter;
import org.sparx.Project;
import org.sparx.Repository;

public class DatabaseModelVisitor
implements StatementVisitor,
MessageSource {
    private SqlDdl sqlddl;
    protected Options options;
    protected ShapeChangeResult result;
    protected Model model;
    protected Repository repository;
    protected String dbOwner;
    protected String dbVersion;
    protected String tablespace;
    protected String author = null;
    protected String status = null;
    protected EASupportedDBMS eadbms;
    protected boolean establishPackageHierarchy = false;
    protected Integer tablesPkgID = null;
    protected SortedMap<Integer, SortedMap<PackageInfo, Integer>> eaPkgIdByModelPkg_byDatabaseModelSubPkgId = new TreeMap<Integer, SortedMap<PackageInfo, Integer>>();
    protected Map<Column, Integer> eaAttributeIDByColumn = new HashMap<Column, Integer>();
    protected Map<Table, Integer> eaElementIDByTable = new HashMap<Table, Integer>();
    protected Map<String, Integer> spatialIndexCounterByTableName = new HashMap<String, Integer>();

    public DatabaseModelVisitor(SqlDdl sqlddl, Repository repository) {
        this.sqlddl = sqlddl;
        this.options = sqlddl.options;
        this.result = sqlddl.result;
        this.model = SqlDdl.model;
        this.repository = repository;
        this.dbOwner = this.options.parameterAsString(sqlddl.getClass().getName(), "dbOwner", null, false, true);
        this.dbVersion = this.options.parameterAsString(sqlddl.getClass().getName(), "dbVersion", null, false, true);
        this.author = this.options.parameterAsString(sqlddl.getClass().getName(), "eaAuthor", null, false, true);
        this.status = this.options.parameterAsString(sqlddl.getClass().getName(), "eaStatus", null, false, true);
        this.tablespace = this.options.parameterAsString(sqlddl.getClass().getName(), "tablespace", null, false, true);
        this.eadbms = SqlDdl.databaseStrategy instanceof OracleStrategy ? EASupportedDBMS.ORACLE : (SqlDdl.databaseStrategy instanceof SQLServerStrategy ? EASupportedDBMS.SQLSERVER2012 : (SqlDdl.databaseStrategy instanceof SQLiteStrategy ? EASupportedDBMS.SQLITE : EASupportedDBMS.POSTGRESQL));
        this.establishPackageHierarchy = this.options.parameterAsBoolean(sqlddl.getClass().getName(), "dataModelEstablishPackageHierarchy", false);
    }

    public void initialize() throws Exception {
        File dmPatternFile;
        Integer dmPkgID;
        this.repository.RefreshModelView(0);
        Collection c = this.repository.GetModels();
        Package root = (Package)c.GetAt((short)0);
        boolean deletePreexistingPackage = this.options.parameterAsBoolean(SqlDdl.class.getName(), "deletePreExistingDataModelPackage", false);
        if (deletePreexistingPackage && (dmPkgID = EARepositoryUtil.getEAChildPackageByName(this.repository, root.GetPackageID(), this.eadbms.getDmPatternPackageName())) != null) {
            this.result.addInfo(this, 100, this.eadbms.getDmPatternPackageName());
            EARepositoryUtil.deletePackage(this.repository, dmPkgID);
        }
        String dmPatternDir = this.options.parameterAsString(this.sqlddl.getClass().getName(), "dataModelPatternPath", "http://shapechange.net/resources/dataModelPatterns", false, true);
        String dmPatternFilePath = dmPatternDir + "/" + this.eadbms.getDmPatternFileName();
        if (dmPatternDir.toLowerCase().startsWith("http")) {
            try {
                URL url = new URL(dmPatternFilePath);
                dmPatternFile = File.createTempFile(this.eadbms.getDmPatternFileName(), null);
                dmPatternFile.deleteOnExit();
                FileUtils.copyURLToFile((URL)url, (File)dmPatternFile);
            }
            catch (IOException e) {
                this.result.addError(this, 102, dmPatternFilePath, e.getMessage());
                throw new Exception();
            }
        } else {
            dmPatternFile = new File(dmPatternFilePath);
            if (!dmPatternFile.exists()) {
                this.result.addError(this, 101, dmPatternFile.getAbsolutePath());
                throw new Exception();
            }
        }
        Project project = this.repository.GetProjectInterface();
        String modelPkgGUIDAsXML = project.GUIDtoXML(root.GetPackageGUID());
        String dmPkgGUIDOrError = project.ImportPackageXMI(modelPkgGUIDAsXML, dmPatternFile.getAbsolutePath(), 1, 1);
        if (StringUtils.isEmpty((CharSequence)dmPkgGUIDOrError) || !dmPkgGUIDOrError.startsWith("{")) {
            this.result.addError(this, 103, dmPatternFilePath, dmPkgGUIDOrError);
        } else {
            Integer dbPkg = EARepositoryUtil.getEAChildPackageByStereotype(this.repository, this.repository.GetPackageByGuid(dmPkgGUIDOrError).GetPackageID(), "Database");
            if (this.dbOwner != null) {
                EAPackageUtil.setTaggedValue(this.repository.GetPackageByID(dbPkg.intValue()), "DefaultOwner", this.dbOwner);
            }
            this.tablesPkgID = EARepositoryUtil.getEAChildPackageByName(this.repository, dbPkg, "Tables");
            this.eaPkgIdByModelPkg_byDatabaseModelSubPkgId.put(this.tablesPkgID, new TreeMap());
        }
    }

    @Override
    public void visit(Insert insert) {
    }

    @Override
    public void visit(CreateTable createTable) {
        Table table = createTable.getTable();
        try {
            String tableDocumentation;
            int eaPkgID = this.tablesPkgID;
            if (this.establishPackageHierarchy && table.getRepresentedClass() != null) {
                eaPkgID = EARepositoryUtil.establishEAPackageHierarchy(table.getRepresentedClass(), this.tablesPkgID, this.eaPkgIdByModelPkg_byDatabaseModelSubPkgId, this.repository, SqlDdl.numberOfEncodedSchemas, this.author, this.status);
            }
            Element tableElmt = EARepositoryUtil.createEAClass(this.repository, table.getName(), eaPkgID);
            this.setCommonElementFields(tableElmt);
            this.eaElementIDByTable.put(table, tableElmt.GetElementID());
            ClassInfo representedClass = table.getRepresentedClass();
            if (representedClass != null && representedClass.getLinkedDocument() != null) {
                EAElementUtil.loadLinkedDocument(tableElmt, representedClass.getLinkedDocument().getAbsolutePath());
            }
            EAElementUtil.setEAStereotypeEx(tableElmt, "EAUML::table");
            EAElementUtil.setEAGenType(tableElmt, this.eadbms.getGenType());
            if (this.dbOwner != null) {
                EAElementUtil.updateTaggedValue(tableElmt, "EAUML::table::Owner", this.dbOwner, false);
            }
            if (this.dbVersion != null) {
                EAElementUtil.updateTaggedValue(tableElmt, "EAUML::table::DBVersion", this.dbVersion, false);
            }
            if (this.tablespace != null) {
                EAElementUtil.updateTaggedValue(tableElmt, "EAUML::table::Tablespace", this.tablespace, false);
            }
            if (SqlDdl.representTaggedValues) {
                Info representedInfo = null;
                if (table.getRepresentedClass() != null) {
                    representedInfo = table.getRepresentedClass();
                } else if (table.getRepresentedAssociation() != null) {
                    representedInfo = table.getRepresentedAssociation();
                }
                if (representedInfo != null) {
                    for (String tvToRepresent : SqlDdl.taggedValuesToRepresent) {
                        String normalizedTag = this.options.normalizeTag(tvToRepresent);
                        String[] values = representedInfo.taggedValuesForTag(normalizedTag);
                        if (values.length <= 0) continue;
                        EAElementUtil.setTaggedValue(tableElmt, new EATaggedValue(tvToRepresent, Arrays.asList(values)));
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)(tableDocumentation = table.getDocumentation()))) {
                if (table.getRepresentedClass() != null) {
                    tableDocumentation = table.getRepresentedClass().derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
                } else if (table.getRepresentedAssociation() != null) {
                    tableDocumentation = table.getRepresentedAssociation().derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
                }
            }
            if (tableDocumentation != null) {
                EAElementUtil.setEANotes(tableElmt, tableDocumentation);
            }
            ArrayList<Column> primaryKeyColumns = new ArrayList<Column>();
            HashSet<String> columnStereotypes = new HashSet<String>();
            columnStereotypes.add("EAUML::column");
            for (Column col : table.getColumns()) {
                ColumnDataType coldt;
                String columnDocumentation = col.getDocumentation();
                if (StringUtils.isBlank((CharSequence)columnDocumentation) && col.getRepresentedProperty() != null) {
                    columnDocumentation = col.getRepresentedProperty().derivedDocumentation(SqlDdl.documentationTemplate, SqlDdl.documentationNoValue);
                }
                Attribute att = EAElementUtil.createEAAttribute(tableElmt, col.getName(), null, columnDocumentation, columnStereotypes, null, false, false, false, col.hasDefaultValue() ? col.getDefaultValue().toString() : null, false, new Multiplicity(1, 1), this.mapDataType(col), null);
                this.eaAttributeIDByColumn.put(col, att.GetAttributeID());
                if (col.isNotNull()) {
                    EAAttributeUtil.setEAAllowDuplicates(att, true);
                }
                int precision = (coldt = col.getDataType()).hasPrecision() ? coldt.getPrecision() : 0;
                int scale = coldt.hasScale() ? coldt.getScale() : 0;
                EAAttributeUtil.setEAPrecision(att, precision);
                EAAttributeUtil.setEAScale(att, scale);
                if (coldt.hasLength()) {
                    EAAttributeUtil.setEALength(att, "" + coldt.getLength());
                    if (coldt.hasLengthQualifier()) {
                        EAAttributeUtil.setTaggedValue(att, "LengthType", coldt.getLengthQualifier());
                    }
                }
                if (col.isForeignKeyColumn()) {
                    EAAttributeUtil.setEAIsCollection(att, true);
                }
                if (col.isPrimaryKeyColumn()) {
                    primaryKeyColumns.add(col);
                }
                if (!SqlDdl.representTaggedValues || col.getRepresentedProperty() == null) continue;
                for (String tvToRepresent : SqlDdl.taggedValuesToRepresent) {
                    String normalizedTag = this.options.normalizeTag(tvToRepresent);
                    String[] values = col.getRepresentedProperty().taggedValuesForTag(normalizedTag);
                    if (values.length <= 0) continue;
                    EAAttributeUtil.setTaggedValue(att, new EATaggedValue(tvToRepresent, Arrays.asList(values)));
                }
            }
            for (SqlConstraint constr : table.getConstraints()) {
                if (!(constr instanceof PrimaryKeyConstraint)) continue;
                PrimaryKeyConstraint pkCon = (PrimaryKeyConstraint)constr;
                primaryKeyColumns.addAll(pkCon.getColumns());
            }
            Method m = EAElementUtil.createEAMethod(tableElmt, "PK_" + SqlUtil.determineName(table, SqlDdl.constraintNameUsingShortName));
            EAMethodUtil.setEAStereotypeEx(m, "EAUML::PK");
            Collections.reverse(primaryKeyColumns);
            for (Column pkCol : primaryKeyColumns) {
                Parameter param = EAMethodUtil.createEAParameter(m, pkCol.getName());
                EAParameterUtil.setEAType(param, this.mapDataType(pkCol));
                Integer attributeID = this.eaAttributeIDByColumn.get(pkCol);
                EAAttributeUtil.setEAIsOrdered(this.repository.GetAttributeByID(attributeID.intValue()), true);
            }
        }
        catch (EAException e) {
            this.result.addError(this, 104, table.getName(), e.getMessage());
        }
    }

    private void setCommonElementFields(Element e) throws EAException {
        if (this.author != null) {
            EAElementUtil.setEAAuthor(e, this.author);
        }
        if (this.status != null) {
            EAElementUtil.setEAStatus(e, this.status);
        }
    }

    @Override
    public void visit(CreateIndex createIndex) {
        Table table = createIndex.getTable();
        Element tableElmt = this.repository.GetElementByID(this.eaElementIDByTable.get(table).intValue());
        Index index = createIndex.getIndex();
        try {
            Method m = EAElementUtil.createEAMethod(tableElmt, index.getName());
            EAMethodUtil.setEAStereotypeEx(m, "EAUML::index");
            List<Column> indexColumns = index.getColumns();
            for (Column indexCol : indexColumns) {
                Parameter param = EAMethodUtil.createEAParameter(m, indexCol.getName());
                EAParameterUtil.setEAType(param, this.mapDataType(indexCol));
            }
        }
        catch (EAException e) {
            this.result.addError(this, 109, index.getName(), table.getName(), e.getMessage());
        }
    }

    @Override
    public void visit(Alter alter) {
        Table table = alter.getTable();
        AlterExpression expr = alter.getExpression();
        if (expr instanceof ConstraintAlterExpression) {
            ConstraintAlterExpression conAltExpr = (ConstraintAlterExpression)expr;
            SqlConstraint constr = conAltExpr.getConstraint();
            if (constr instanceof CheckConstraint) {
                CheckConstraint checkCon = (CheckConstraint)constr;
                try {
                    Element tableElmt = this.repository.GetElementByID(this.eaElementIDByTable.get(table).intValue());
                    Method m = EAElementUtil.createEAMethod(tableElmt, constr.getName());
                    EAMethodUtil.setEAStereotypeEx(m, "EAUML::check");
                    EAMethodUtil.setEACode(m, checkCon.getExpression().toString());
                }
                catch (EAException e) {
                    this.result.addError(this, 105, constr.getName(), table.getName(), e.getMessage());
                }
            } else if (constr instanceof ForeignKeyConstraint) {
                ForeignKeyConstraint fkCon = (ForeignKeyConstraint)constr;
                try {
                    Element tableElmt = this.repository.GetElementByID(this.eaElementIDByTable.get(table).intValue());
                    Method m = EAElementUtil.createEAMethod(tableElmt, constr.getName());
                    EAMethodUtil.setEAStereotypeEx(m, "EAUML::FK");
                    List<Column> foreignKeyColumns = fkCon.getColumns();
                    Collections.reverse(foreignKeyColumns);
                    for (Column fkCol : foreignKeyColumns) {
                        Parameter param = EAMethodUtil.createEAParameter(m, fkCol.getName());
                        EAParameterUtil.setEAType(param, this.mapDataType(fkCol));
                    }
                    ArrayList<EATaggedValue> methodTVs = new ArrayList<EATaggedValue>();
                    String onDeleteValue = this.translateForeignKeyOption(fkCon.getOnDelete());
                    EATaggedValue tvDelete = new EATaggedValue("Delete", onDeleteValue);
                    methodTVs.add(tvDelete);
                    if (this.eadbms == EASupportedDBMS.ORACLE) {
                        EATaggedValue tvProperty = new EATaggedValue("property", "Delete " + onDeleteValue + "=1;");
                        methodTVs.add(tvProperty);
                    } else {
                        String onUpdateValue = this.translateForeignKeyOption(fkCon.getOnUpdate());
                        EATaggedValue tvUpdate = new EATaggedValue("Update", onUpdateValue);
                        methodTVs.add(tvUpdate);
                        EATaggedValue tvProperty = new EATaggedValue("property", "Delete " + onDeleteValue + "=1;Update " + onUpdateValue + "=1;");
                        methodTVs.add(tvProperty);
                    }
                    EAMethodUtil.setTaggedValues(m, methodTVs);
                    Integer refTableEaElmtID = this.eaElementIDByTable.get(fkCon.getReferenceTable());
                    if (refTableEaElmtID == null) {
                        this.result.addError(this, 111, constr.getName(), table.getName(), fkCon.getReferenceTable().getName());
                        return;
                    }
                    Element referenceTableElmt = this.repository.GetElementByID(refTableEaElmtID.intValue());
                    Method pkMethodOfReferenceTableElmt = EAElementUtil.getEAMethodWithStereotypeEx(referenceTableElmt, "PK");
                    if (pkMethodOfReferenceTableElmt == null) {
                        this.result.addError(this, 108, constr.getName(), table.getName(), fkCon.getReferenceTable().getName());
                        return;
                    }
                    String pkMethodName = pkMethodOfReferenceTableElmt.GetName();
                    Parameter pkColParam = EAMethodUtil.getFirstParameter(pkMethodOfReferenceTableElmt);
                    String conName = "(" + foreignKeyColumns.get(0).getName() + " = " + pkColParam.GetName() + ")";
                    Connector con = EAElementUtil.createEAAssociation(tableElmt, referenceTableElmt);
                    EAConnectorUtil.setEAStereotypeEx(con, "EAUML::FK");
                    EAConnectorUtil.setEAName(con, conName);
                    ConnectorEnd clientEnd = con.GetClientEnd();
                    EAConnectorEndUtil.setEARole(clientEnd, fkCon.getName());
                    EAConnectorEndUtil.setEACardinality(clientEnd, "0..*");
                    EAConnectorEndUtil.setEANavigable(clientEnd, EANavigable.NONNAVIGABLE);
                    EAConnectorEndUtil.setEAContainment(clientEnd, "Unspecified");
                    ConnectorEnd supplierEnd = con.GetSupplierEnd();
                    EAConnectorEndUtil.setEARole(supplierEnd, pkMethodName);
                    EAConnectorEndUtil.setEACardinality(supplierEnd, "1");
                    EAConnectorEndUtil.setEANavigable(supplierEnd, EANavigable.NAVIGABLE);
                    EAConnectorEndUtil.setEAContainment(supplierEnd, "Unspecified");
                    EAConnectorUtil.setEAStyleEx(con, "FKINFO=SRC=" + fkCon.getName() + ":DST=" + pkMethodName + ":;");
                    EAConnectorUtil.setEADirection(con, EADirection.SOURCE_DESTINATION);
                }
                catch (EAException e) {
                    this.result.addError(this, 106, constr.getName(), table.getName(), e.getMessage());
                }
            } else if (constr instanceof UniqueConstraint) {
                UniqueConstraint ukCon = (UniqueConstraint)constr;
                try {
                    Element tableElmt = this.repository.GetElementByID(this.eaElementIDByTable.get(table).intValue());
                    Method m = EAElementUtil.createEAMethod(tableElmt, constr.getName());
                    EAMethodUtil.setEAStereotypeEx(m, "EAUML::unique");
                    List<Column> uniqueColumns = ukCon.getColumns();
                    Collections.reverse(uniqueColumns);
                    for (Column ukCol : uniqueColumns) {
                        Parameter param = EAMethodUtil.createEAParameter(m, ukCol.getName());
                        EAParameterUtil.setEAType(param, this.mapDataType(ukCol));
                    }
                }
                catch (EAException e) {
                    this.result.addError(this, 110, constr.getName(), table.getName(), e.getMessage());
                }
            }
        }
    }

    private String translateForeignKeyOption(ForeignKeyConstraint.Option o) {
        if (o == ForeignKeyConstraint.Option.CASCADE) {
            return "Cascade";
        }
        if (o == ForeignKeyConstraint.Option.RESTRICT) {
            return "Restrict";
        }
        if (o == ForeignKeyConstraint.Option.SET_DEFAULT) {
            return "Set Default";
        }
        if (o == ForeignKeyConstraint.Option.SET_NULL) {
            return "Set Null";
        }
        return "No Action";
    }

    private String mapDataType(Column col) {
        ColumnDataType coldt = col.getDataType();
        ProcessMapEntry pme = this.options.targetMapEntry(coldt.getName(), "*");
        String typeName = pme != null ? pme.getTargetType() : coldt.getName();
        return typeName;
    }

    @Override
    public void visit(Comment comment) {
    }

    @Override
    public void visit(List<Statement> stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                stmt.accept(this);
            }
        }
    }

    @Override
    public void visit(CreateSchema createSchema) {
    }

    @Override
    public void visit(DropSchema dropSchema) {
    }

    @Override
    public void postprocess() {
        for (Integer eaElmtID : this.eaElementIDByTable.values()) {
            Method method;
            int i;
            Element element = this.repository.GetElementByID(eaElmtID.intValue());
            Collection eaMethods = element.GetMethods();
            ArrayList<Method> methods = new ArrayList<Method>();
            for (i = 0; i < eaMethods.GetCount(); i = (short)(i + 1)) {
                method = (Method)eaMethods.GetAt((short)i);
                methods.add(method);
            }
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    String m1Stereo = m1.GetStereotype();
                    String m2Stereo = m2.GetStereotype();
                    String m1Name = m1.GetName();
                    String m2Name = m2.GetName();
                    if (m1Stereo.equalsIgnoreCase(m2Stereo)) {
                        return m1Name.compareTo(m2Name);
                    }
                    if (m1Stereo.endsWith("PK")) {
                        return -1;
                    }
                    if (m2Stereo.endsWith("PK")) {
                        return 1;
                    }
                    if (m1Stereo.endsWith("check")) {
                        return -1;
                    }
                    if (m2Stereo.endsWith("check")) {
                        return 1;
                    }
                    if (m1Stereo.endsWith("index")) {
                        return -1;
                    }
                    if (m2Stereo.endsWith("index")) {
                        return 1;
                    }
                    if (m1Stereo.endsWith("unique")) {
                        return -1;
                    }
                    if (m2Stereo.endsWith("unique")) {
                        return 1;
                    }
                    return m1Name.compareTo(m2Name);
                }
            });
            try {
                for (i = 0; i < methods.size(); ++i) {
                    method = (Method)methods.get(i);
                    EAMethodUtil.setEAPos(method, i);
                }
            }
            catch (EAException e) {
                this.result.addError(this, 107, element.GetName(), e.getMessage());
            }
        }
    }

    @Override
    public void visit(Select select) {
        if (select.getExpression() != null && select.getExpression() instanceof SpatiaLiteCreateSpatialIndexExpression) {
            SpatiaLiteCreateSpatialIndexExpression expr = (SpatiaLiteCreateSpatialIndexExpression)select.getExpression();
            Table table = expr.getTable();
            Column indexCol = expr.getColumn();
            Element tableElmt = this.repository.GetElementByID(this.eaElementIDByTable.get(table).intValue());
            int indexCounter = this.spatialIndexCounterByTableName.containsKey(table.getName()) ? this.spatialIndexCounterByTableName.get(table.getName()) : 0;
            this.spatialIndexCounterByTableName.put(table.getName(), ++indexCounter);
            String indexName = "spatialIndex" + indexCounter;
            try {
                Method m = EAElementUtil.createEAMethod(tableElmt, indexName);
                EAMethodUtil.setEAStereotypeEx(m, "EAUML::index");
                Parameter param = EAMethodUtil.createEAParameter(m, indexCol.getName());
                EAParameterUtil.setEAType(param, this.mapDataType(indexCol));
            }
            catch (EAException e) {
                this.result.addError(this, 112, indexName, table.getName(), indexCol.getName(), e.getMessage());
            }
        }
    }

    @Override
    public void visit(SQLitePragma sqLitePragma) {
    }

    @Override
    public void visit(PostgreSQLAlterRole postgreSQLAlterRole) {
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "";
            }
            case 4: {
                return "";
            }
            case 100: {
                return "Package with name '$1$' already exists. It will be deleted.";
            }
            case 101: {
                return "Required configuration file '$1$' does not exist.";
            }
            case 102: {
                return "Could not create temporary local copy of XMI file with data model pattern (at '$1$'). Exception message is: $2$";
            }
            case 103: {
                return "Importing data model pattern from '$1$' was not successful. Error message is: $2$";
            }
            case 104: {
                return "Exception encountered while creating table '$1$'. Exception message: '$2$'";
            }
            case 105: {
                return "Exception encountered while creating check constraint '$1$' (operation) on table '$2$'. Exception message: '$3$'";
            }
            case 106: {
                return "Exception encountered while creating foreign key constraint '$1$' on table '$2$'. Exception message: '$3$'";
            }
            case 107: {
                return "??Postprocessing - Exception encountered while updating position of methods in table '$1$'. Exception message: '$2$'";
            }
            case 108: {
                return "Could not create foreign key constraint '$1$' on table '$2$' because no primary key method was found on reference table '$3$'.";
            }
            case 109: {
                return "Exception encountered while creating index '$1$' on table '$2$'. Exception message: '$3$'";
            }
            case 110: {
                return "Exception encountered while creating unique constraint '$1$' on table '$2$'. Exception message: '$3$'";
            }
            case 111: {
                return "Could not create foreign key constraint '$1$' on table '$2$' because no ElementID was found for referenced table '$3$'. Does that table belong to a schema that was not selected for processing?";
            }
            case 112: {
                return "Exception encountered while creating spatial index '$1$' on table '$2$' (column '$3$') from SpatiaLite CreateSpatialIndex. Exception message: '$4$'";
            }
        }
        return "(" + DatabaseModelVisitor.class.getName() + ") Unknown message with number: " + mnr;
    }
}

