/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ReplicationSchema;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReplicationXmlSchema
implements Target,
MessageSource {
    public static final String PARAM_OBJECT_IDENTIFIER_FIELD_NAME = "objectIdentifierFieldName";
    public static final String PARAM_TARGET_NAMESPACE_SUFFIX = "targetNamespaceSuffix";
    public static final String PARAM_SUFFIX_FOR_PROPERTIES_WITH_FEATURE_VALUE_TYPE = "suffixForPropertiesWithFeatureValueType";
    public static final String PARAM_SUFFIX_FOR_PROPERTIES_WITH_OBJECT_VALUE_TYPE = "suffixForPropertiesWithObjectValueType";
    public static final String PARAM_SIZE = "size";
    public static final String RULE_TGT_REP_CLS_GENERATE_OBJECTIDENTIFIER = "rule-rep-cls-generate-objectidentifier";
    public static final String RULE_TGT_REP_PROP_EXCLUDE_DERIVED = "rule-rep-prop-exclude-derived";
    public static final String RULE_TGT_REP_PROP_OPTIONAL = "rule-rep-prop-optional";
    public static final String RULE_TGT_REP_PROP_MAXLENGTHFROMSIZE = "rule-rep-prop-maxLength-from-size";
    public static final String TV_SIZE = "size";
    public static final String DEFAULT_OBJECT_IDENTIFIER_FIELD_NAME = "id";
    public static final String MAP_ENTRY_PARAM_MAXLENGTHFROMSIZE = "maxLengthFromSize";
    private ShapeChangeResult result = null;
    private PackageInfo schemaPi = null;
    private Model model = null;
    private Options options = null;
    private boolean printed = false;
    private boolean diagnosticsOnly = false;
    private File outputDirectoryFile;
    private String outputDirectory;
    private String outputFilename;
    protected Document document = null;
    protected Element root = null;
    protected Map<String, ProcessMapEntry> mapEntryByType = new HashMap<String, ProcessMapEntry>();
    protected String targetNamespace = null;
    protected String objectIdentifierFieldName;
    protected String suffixForPropWithFeatureValueType;
    protected String suffixForPropWithObjectValueType;
    protected Multiplicity multiplicity1 = new Multiplicity(1, 1);
    protected Integer defaultSize = null;
    protected String targetNamespaceSuffix;
    private TreeSet<PackageInfo> packagesForImport = new TreeSet<PackageInfo>(new Comparator<PackageInfo>(){

        @Override
        public int compare(PackageInfo pi1, PackageInfo pi2) {
            return pi1.name().compareTo(pi2.name());
        }
    });

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        DocumentBuilder db;
        String defaultSizeByConfig;
        List<ProcessMapEntry> mapEntries;
        this.schemaPi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        this.result.addDebug(this, 1, this.schemaPi.name());
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        this.outputFilename = this.schemaPi.name().replace("/", "_").replace(" ", "_") + ".xsd";
        this.outputDirectoryFile = new File(this.outputDirectory);
        boolean exi = this.outputDirectoryFile.exists();
        if (!exi) {
            try {
                FileUtils.forceMkdir((File)this.outputDirectoryFile);
            }
            catch (IOException e) {
                this.result.addError(null, 600, e.getMessage());
                e.printStackTrace(System.err);
            }
            exi = this.outputDirectoryFile.exists();
        }
        boolean dir = this.outputDirectoryFile.isDirectory();
        boolean wrt = this.outputDirectoryFile.canWrite();
        boolean rea = this.outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            this.result.addFatalError(null, 601, this.outputDirectory);
            throw new ShapeChangeAbortException();
        }
        File outputFile = new File(this.outputDirectoryFile, this.outputFilename);
        exi = outputFile.exists();
        if (exi) {
            this.result.addInfo(this, 3, this.outputFilename, this.outputDirectory);
            try {
                FileUtils.forceDelete((File)outputFile);
                this.result.addInfo(this, 4);
            }
            catch (IOException e) {
                this.result.addInfo(null, 600, e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        if ((mapEntries = this.options.getCurrentProcessConfig().getMapEntries()).isEmpty()) {
            this.result.addFatalError(this, 9);
            throw new ShapeChangeAbortException();
        }
        for (ProcessMapEntry pme : mapEntries) {
            this.mapEntryByType.put(pme.getType(), pme);
        }
        this.objectIdentifierFieldName = this.options.parameter(this.getClass().getName(), PARAM_OBJECT_IDENTIFIER_FIELD_NAME);
        if (this.objectIdentifierFieldName == null || this.objectIdentifierFieldName.trim().length() == 0) {
            this.objectIdentifierFieldName = DEFAULT_OBJECT_IDENTIFIER_FIELD_NAME;
        }
        this.suffixForPropWithFeatureValueType = this.options.parameter(this.getClass().getName(), PARAM_SUFFIX_FOR_PROPERTIES_WITH_FEATURE_VALUE_TYPE);
        if (this.suffixForPropWithFeatureValueType == null || this.suffixForPropWithFeatureValueType.trim().length() == 0) {
            this.suffixForPropWithFeatureValueType = "";
        }
        this.suffixForPropWithObjectValueType = this.options.parameter(this.getClass().getName(), PARAM_SUFFIX_FOR_PROPERTIES_WITH_OBJECT_VALUE_TYPE);
        if (this.suffixForPropWithObjectValueType == null || this.suffixForPropWithObjectValueType.trim().length() == 0) {
            this.suffixForPropWithObjectValueType = "";
        }
        this.targetNamespaceSuffix = this.options.parameter(this.getClass().getName(), PARAM_TARGET_NAMESPACE_SUFFIX);
        if (this.targetNamespaceSuffix == null || this.objectIdentifierFieldName.trim().length() == 0) {
            this.targetNamespaceSuffix = "";
        }
        if ((defaultSizeByConfig = this.options.parameter(this.getClass().getName(), "size")) != null) {
            try {
                this.defaultSize = Integer.parseInt(defaultSizeByConfig);
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 8, "size", e.getMessage());
                mc.addDetail(this, 0);
            }
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            throw new ShapeChangeAbortException();
        }
        this.document = db.newDocument();
        this.root = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.root, "xmlns", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.root, "elementFormDefault", "qualified");
        this.addAttribute(this.root, "version", this.schemaPi.version());
        this.targetNamespace = this.schemaPi.targetNamespace() + this.targetNamespaceSuffix;
        this.addAttribute(this.root, "targetNamespace", this.targetNamespace);
        this.addAttribute(this.root, "xmlns:" + this.schemaPi.xmlns(), this.targetNamespace);
        if (this.options.getCurrentProcessConfig().parameterAsString("processOutput_addComment", null, false, true) == null) {
            Comment generationComment = this.document.createComment("XML Schema document created by ShapeChange - http://shapechange.net/");
            this.root.appendChild(generationComment);
        }
    }

    protected void addAttribute(Element e, String name, String value) {
        Attr att = this.document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    @Override
    public void process(ClassInfo ci) {
        if (ci == null || ci.pkg() == null) {
            return;
        }
        this.result.addDebug(this, 6, ci.name());
        int cat = ci.category();
        switch (cat) {
            case 8: {
                this.result.addWarning(this, 7, ci.name(), "union");
                break;
            }
            case 5: {
                this.result.addWarning(this, 7, ci.name(), "datatype");
                break;
            }
            case 4: {
                this.result.addWarning(this, 7, ci.name(), "mixin");
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                break;
            }
            case 1: 
            case 6: {
                this.pObjectElement(ci);
            }
        }
        switch (cat) {
            case 3: {
                this.pGlobalEnumeration(ci);
                break;
            }
            case 1: 
            case 6: {
                Element propertyHook = this.pComplexType(ci);
                this.processLocalProperties(ci, propertyHook);
            }
        }
    }

    public void processLocalProperties(ClassInfo ci, Element sequenceOrChoice) {
        this.result.addDebug(null, 10023, ci.name());
        if ((ci.category() == 1 || ci.category() == 6) && ci.matches(RULE_TGT_REP_CLS_GENERATE_OBJECTIDENTIFIER)) {
            Element eOID = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addAttribute(eOID, "name", this.objectIdentifierFieldName);
            this.addAttribute(eOID, "type", "string");
            this.addMinMaxOccurs(eOID, this.multiplicity1);
            sequenceOrChoice.appendChild(eOID);
        }
        for (PropertyInfo pi : ci.properties().values()) {
            this.processLocalProperty(pi, sequenceOrChoice);
        }
    }

    public void processLocalProperty(PropertyInfo pi, Element sequenceOrChoice) {
        if (this.includeProperty(pi)) {
            Element piElement = this.addProperty(pi);
            if (piElement.getLocalName().equals("attribute") || piElement.getLocalName().equals("attributeGroup")) {
                sequenceOrChoice.getParentNode().appendChild(piElement);
            } else {
                sequenceOrChoice.appendChild(piElement);
            }
        }
    }

    protected Element addProperty(PropertyInfo pi) {
        ClassInfo inClass = pi.inClass();
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.addGlobalIdentifierAnnotation(e1, pi);
        Object piName = pi.name();
        if (pi.categoryOfValue() == 1) {
            piName = pi.name() + this.suffixForPropWithFeatureValueType;
        } else if (pi.categoryOfValue() == 6) {
            piName = pi.name() + this.suffixForPropWithObjectValueType;
        }
        this.addAttribute(e1, "name", (String)piName);
        this.mapPropertyType(pi, e1);
        this.addMinMaxOccurs(e1, pi);
        ProcessMapEntry pme = this.mapEntryByType.get(pi.typeInfo().name);
        if (pme != null && pme.hasParam() && pme.getParam().trim().equals(MAP_ENTRY_PARAM_MAXLENGTHFROMSIZE)) {
            int size = -1;
            if (StringUtils.isNotBlank((CharSequence)pi.taggedValue("size"))) {
                try {
                    size = Integer.parseInt(pi.taggedValue("size").trim());
                }
                catch (NumberFormatException e) {
                    this.result.addWarning(this, 14, "size", pi.name(), inClass.name(), e.getMessage());
                }
            }
            if (size <= 0 && this.defaultSize != null) {
                size = this.defaultSize;
            }
            if (size > 0) {
                Element simpleType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                e1.appendChild(simpleType);
                Element restriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                this.addAttribute(restriction, "base", "string");
                e1.removeAttribute("type");
                simpleType.appendChild(restriction);
                Element concreteRestriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                this.addAttribute(concreteRestriction, "value", "" + size);
                restriction.appendChild(concreteRestriction);
            }
        }
        return e1;
    }

    protected void mapPropertyType(PropertyInfo propi, Element e) {
        ShapeChangeResult.MessageContext mc;
        ClassInfo ci = propi.inClass();
        String pName = ci.name() + "." + propi.name();
        Type ti = propi.typeInfo();
        ProcessMapEntry pme = this.mapEntryByType.get(ti.name);
        if (pme != null) {
            String targetType;
            if (pme.hasTargetType()) {
                targetType = pme.getTargetType();
            } else {
                targetType = "fixme:fixme";
                this.result.addError(this, 11, ti.name, targetType);
            }
            this.addAttribute(e, "type", targetType);
            return;
        }
        ClassInfo typeCi = this.model.classById(ti.id);
        if (typeCi == null && (typeCi = this.model.classByName(ti.name)) != null && (mc = this.result.addError(null, 135, pName)) != null) {
            mc.addDetail(null, 400, "Property", propi.fullNameInSchema());
        }
        if (typeCi == null) {
            mc = this.result.addError(null, 131, pName, ti.name);
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullNameInSchema());
            }
        } else if (this.classHasObjectType(typeCi)) {
            this.addAttribute(e, "type", "string");
        } else if (typeCi.category() == 2) {
            this.addAttribute(e, "type", "string");
        } else if (typeCi.category() == 3) {
            this.addAttribute(e, "type", this.options.internalize(typeCi.qname() + "Type"));
            if (!typeCi.pkg().targetNamespace().equals(this.schemaPi.targetNamespace())) {
                this.packagesForImport.add(typeCi.pkg());
            }
        } else {
            this.addAttribute(e, "type", "fixme:fixme");
            this.result.addError(this, 13, pName, "fixme:fixme");
        }
    }

    private void addMinMaxOccurs(Element e, PropertyInfo pi) {
        Multiplicity m = pi.cardinality();
        if (pi.matches(RULE_TGT_REP_PROP_OPTIONAL)) {
            this.addMinMaxOccurs(e, new Multiplicity(0, m.maxOccurs));
        } else {
            this.addMinMaxOccurs(e, m);
        }
    }

    private void addMinMaxOccurs(Element e, Multiplicity m) {
        if (m.minOccurs != 1) {
            this.addAttribute(e, "minOccurs", this.options.internalize(Integer.valueOf(m.minOccurs).toString()));
        }
        if (m.maxOccurs == Integer.MAX_VALUE) {
            this.addAttribute(e, "maxOccurs", "unbounded");
        } else if (m.maxOccurs != 1) {
            String maxOccursTxt = this.options.internalize(Integer.valueOf(m.maxOccurs).toString());
            this.addAttribute(e, "maxOccurs", maxOccursTxt);
        }
    }

    private boolean includeProperty(PropertyInfo pi) {
        return pi.isNavigable() && (!pi.isDerived() || !pi.matches(RULE_TGT_REP_PROP_EXCLUDE_DERIVED));
    }

    public Element pComplexType(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.typeName(ci, false));
        if (ci.isAbstract()) {
            this.addAttribute(e1, "abstract", "true");
        }
        Element e3 = e1;
        Element ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e3.appendChild(ret);
        return ret;
    }

    protected String mapBaseType(ClassInfo ci) {
        String s = null;
        if (this.classHasObjectType(ci)) {
            s = this.typeName(ci, true);
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 117, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
        return s;
    }

    public void pGlobalEnumeration(ClassInfo ci) {
        Element e1 = this.pAnonymousEnumeration(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", this.typeName(ci, false));
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 126, this.typeName(ci, false));
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
    }

    private Element pAnonymousEnumeration(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        for (PropertyInfo atti : ci.properties().values()) {
            Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "enumeration");
            e4.appendChild(e3);
            String val = atti.name();
            if (atti.initialValue() != null) {
                val = atti.initialValue();
            }
            this.addAttribute(e3, "value", val);
        }
        return e1;
    }

    public void pObjectElement(ClassInfo ci) {
        if (ci.pkg() == null || ci.pkg().xmlns() == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            return;
        }
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.document.getDocumentElement().appendChild(e4);
        this.addAttribute(e4, "name", this.elementName(ci, false));
        this.addAttribute(e4, "type", this.typeName(ci, true));
        this.addGlobalIdentifierAnnotation(e4, ci);
        if (ci.isAbstract()) {
            this.addAttribute(e4, "abstract", "true");
        }
        if (ci.baseClass() != null) {
            this.result.addWarning(this, 15, ci.name(), ci.baseClass().name());
        }
    }

    private boolean classHasObjectType(ClassInfo ci) {
        int cat = ci.category();
        return cat == 1 || cat == 6;
    }

    protected void addGlobalIdentifierAnnotation(Element e, Info info) {
        PropertyInfo pi;
        Element eAppInfo = null;
        if (info instanceof ClassInfo) {
            ClassInfo ci = (ClassInfo)info;
            if (ci.globalIdentifier() != null && (ci.category() == 1 || ci.category() == 6)) {
                if (eAppInfo == null) {
                    eAppInfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                eAppInfo.appendChild(this.document.createTextNode(ci.globalIdentifier()));
            }
        } else if (info instanceof PropertyInfo && (pi = (PropertyInfo)info).globalIdentifier() != null) {
            if (eAppInfo == null) {
                eAppInfo = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            }
            eAppInfo.appendChild(this.document.createTextNode(pi.globalIdentifier()));
        }
        if (eAppInfo != null) {
            Element e0 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
            e0.appendChild(eAppInfo);
            e.appendChild(e0);
        }
    }

    private String elementName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullNameInSchema());
                }
            } else {
                return qualified ? ci.qname() : ci.name();
            }
        }
        return null;
    }

    private String typeName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                return (qualified ? ci.qname() : ci.name()) + "Type";
            }
        }
        return null;
    }

    @Override
    public void write() {
        if (this.printed || this.diagnosticsOnly) {
            return;
        }
        this.addImports();
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File repXsd = new File(this.outputDirectoryFile, this.outputFilename);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repXsd), "UTF-8"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)writer);
            serializer.asDOMSerializer().serialize((Node)this.document);
            writer.close();
            this.result.addResult(this.getTargetName(), this.outputDirectory, this.outputFilename, this.schemaPi.targetNamespace());
        }
        catch (IOException ioe) {
            this.result.addError(null, 171, this.outputFilename);
        }
        this.printed = true;
    }

    private void addImports() {
        Node anchor = null;
        for (PackageInfo packageInfo : this.packagesForImport) {
            this.addAttribute(this.root, "xmlns:" + packageInfo.xmlns(), packageInfo.targetNamespace() + this.targetNamespaceSuffix);
            Element importElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            this.addAttribute(importElement, "namespace", packageInfo.targetNamespace() + this.targetNamespaceSuffix);
            if (anchor == null) {
                this.root.insertBefore(importElement, this.root.getFirstChild());
            } else {
                this.root.insertBefore(importElement, anchor.getNextSibling());
            }
            anchor = importElement;
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule(RULE_TGT_REP_PROP_OPTIONAL);
        r.addRule(RULE_TGT_REP_PROP_EXCLUDE_DERIVED);
        r.addRule(RULE_TGT_REP_CLS_GENERATE_OBJECTIDENTIFIER);
        r.addRule(RULE_TGT_REP_PROP_MAXLENGTHFROMSIZE);
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetIdentifier() {
        return "rep";
    }

    @Override
    public String getTargetName() {
        return "Replication XML Schema";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class ReplicationSchema";
            }
            case 1: {
                return "Generating replication schema for application schema '$1$'.";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "Output file '$1$' already exists in output directory ('$2$'). It will be deleted prior to processing.";
            }
            case 4: {
                return "File has been deleted.";
            }
            case 5: {
                return "";
            }
            case 6: {
                return "Processing class '$1$'.";
            }
            case 7: {
                return "Class '$1$' is a $2$ which is not supported by this target. The class will be ignored.";
            }
            case 8: {
                return "Number format exception while converting the value of configuration parameter '$1$' to an integer. Exception message: $2$. The parameter will be ignored.";
            }
            case 9: {
                return "No map entries provided via the configuration. Target cannot be executed.";
            }
            case 10: {
                return "No map entry defined for type '$1$'. Cannot map this type.";
            }
            case 11: {
                return "No target type defined in type mapping for type '$1$'. Using '$2$' instead.";
            }
            case 12: {
                return "No map entry defined for type '$1$'. Using 'string' as target type.";
            }
            case 13: {
                return "Property '$1$' has an unsupported value type. Using '$2$' as target type.";
            }
            case 14: {
                return "Number format exception while converting tagged value '$1$' on property '$2$' of class '$3$' to an integer. Exception message: $4$. Global size setting for target will be used if available.";
            }
            case 15: {
                return "Class '$1$' has supertype '$2$'. Inheritance is not supported by this target. Apply rule-trf-cls-flatten-inheritance of the Flattener transformer before executing this target.";
            }
            case 100: {
                return "Context: property '$1$' in class '$2$'.";
            }
        }
        return "(" + ReplicationXmlSchema.class.getName() + ") Unknown message with number: " + mnr;
    }
}

