/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ProfileTransfer;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sparx.Repository;

public class ProfileTransferEAConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("deleteExistingProfiles", "processAllSchemas", "profilesToTransfer", "password", "repositoryFileNameOrConnectionString", "transferToCopyOfEAP", "username").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        Object repoConnectionInfo = null;
        String username = null;
        String password = null;
        if (config.hasParameter("repositoryFileNameOrConnectionString")) {
            result.addInfo(this, 29);
            repoConnectionInfo = config.parameterAsString("repositoryFileNameOrConnectionString", null, false, true);
            if (repoConnectionInfo == null) {
                result.addError(this, 31);
                isValid = false;
            } else {
                username = config.getParameterValue("username");
                password = config.getParameterValue("password");
            }
        } else {
            result.addInfo(this, 30);
            String inputModelType = options.parameter("inputModelType");
            if (inputModelType == null || !inputModelType.equalsIgnoreCase("EA7")) {
                result.addError(this, 10);
                isValid = false;
            } else {
                String mdl = options.parameter("inputFile");
                String repoFileNameOrConnectionString = options.parameter("repositoryFileNameOrConnectionString");
                username = options.parameter("username");
                password = options.parameter("password");
                if (repoFileNameOrConnectionString != null && repoFileNameOrConnectionString.length() > 0) {
                    repoConnectionInfo = repoFileNameOrConnectionString;
                } else if (mdl != null && mdl.length() > 0) {
                    repoConnectionInfo = mdl;
                } else {
                    result.addError(this, 11);
                    isValid = false;
                }
            }
        }
        if (isValid) {
            boolean transferToCopyOfEAP = config.parameterAsBoolean("transferToCopyOfEAP", false);
            if (((String)repoConnectionInfo).contains("DBType=") || ((String)repoConnectionInfo).contains("Connect=Cloud")) {
                if (transferToCopyOfEAP) {
                    result.addError(this, 13);
                    isValid = false;
                }
            } else {
                File repfile = new File((String)repoConnectionInfo);
                boolean ex = true;
                if (!repfile.exists()) {
                    ex = false;
                    if (!((String)repoConnectionInfo).toLowerCase().endsWith(".eap")) {
                        repoConnectionInfo = (String)repoConnectionInfo + ".eap";
                        repfile = new File((String)repoConnectionInfo);
                        ex = repfile.exists();
                    }
                }
                if (!ex) {
                    result.addError(this, 14, (String)repoConnectionInfo);
                    isValid = false;
                } else {
                    repoConnectionInfo = repfile.getAbsolutePath();
                }
                if (transferToCopyOfEAP) {
                    File outputDirectoryFile;
                    boolean exi;
                    String outputDirectory = config.getParameterValue("outputDirectory");
                    if (outputDirectory == null) {
                        outputDirectory = options.parameter("outputDirectory");
                    }
                    if (outputDirectory == null) {
                        outputDirectory = ".";
                    }
                    if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
                        outputDirectoryFile.mkdirs();
                        exi = outputDirectoryFile.exists();
                    }
                    boolean dir = outputDirectoryFile.isDirectory();
                    boolean wrt = outputDirectoryFile.canWrite();
                    boolean rea = outputDirectoryFile.canRead();
                    if (!(exi && dir && wrt && rea)) {
                        result.addError(this, 12, outputDirectory);
                        isValid = false;
                    }
                }
            }
        }
        if (isValid) {
            String errormsg;
            username = username == null ? "" : username;
            password = password == null ? "" : password;
            Repository eaRepo = new Repository();
            if (username.length() == 0) {
                if (!eaRepo.OpenFile((String)repoConnectionInfo)) {
                    errormsg = eaRepo.GetLastError();
                    result.addError(this, 16, (String)repoConnectionInfo, errormsg);
                    isValid = false;
                }
            } else if (!eaRepo.OpenFile2((String)repoConnectionInfo, username, password)) {
                errormsg = eaRepo.GetLastError();
                result.addError(this, 17, (String)repoConnectionInfo, username, password, errormsg);
                isValid = false;
            }
            if (eaRepo != null) {
                eaRepo.CloseFile();
                eaRepo.Exit();
                eaRepo = null;
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "";
            }
            case 2: {
                return "Output directory '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "";
            }
            case 10: {
                return "The input parameter 'inputModelType' was not set or does not equal (ignoring case) 'EA7'. This target can only be executed if the model to which profiles are transferred is an EA repository.";
            }
            case 11: {
                return "Neither the input parameter 'inputFile' nor the input parameter 'repositoryFileNameOrConnectionString' are set. This target requires one of these parameters in order to connect to the EA repository.";
            }
            case 12: {
                return "The target is configured to copy the EA project file to the output directory, before transferring the profile infos. However, the directory named '$1$' does not exist or is not accessible. The transfer would not be executed.";
            }
            case 13: {
                return "The target is configured to copy the EA project file to the output directory, before transferring the profile infos. However, the EA repository is a server based repository, not an EA project file. The transfer would not be executed.";
            }
            case 14: {
                return "Enterprise Architect repository file named '$1$' not found.";
            }
            case 16: {
                return "Enterprise Architect repository cannot be opened. File name or connection string is: '$1$', exception message is: '$2$'";
            }
            case 17: {
                return "Enterprise Architect repository cannot be opened. File name or connection string is: '$1$', username is: '$2$', password is: '$3$', exception message is: '$4$'";
            }
            case 29: {
                return "Using EA repository connection info provided by target configuration.";
            }
            case 30: {
                return "Using EA repository connection info provided by input configuration.";
            }
            case 31: {
                return "Parameter 'repositoryFileNameOrConnectionString' is set in the configuration of this target, but it does not contain a valid value. Provide such a value or remove the target parameter in order for the target to look up the EA repository connection info in the input configuration.";
            }
        }
        return "(" + ProfileTransferEAConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

