/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ProfileTransfer;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Util.ea.EAAttributeUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;
import org.sparx.TaggedValue;

public class ProfileTransferEA
implements SingleTarget,
MessageSource {
    public static final String PARAM_TRANSFER_TO_EAP_COPY = "transferToCopyOfEAP";
    public static final String PARAM_DELETE_EXISTING_PROFILES = "deleteExistingProfiles";
    public static final String PARAM_PROFILES_TO_TRANSFER = "profilesToTransfer";
    public static final String PARAM_PROCESS_ALL_SCHEMAS = "processAllSchemas";
    public static final String PARAM_REPO_CONNECTION_STRING = "repositoryFileNameOrConnectionString";
    public static final String PARAM_USER = "username";
    public static final String PARAM_PWD = "password";
    private static boolean initialised = false;
    private static boolean invalidConfiguration = false;
    private static String connectionString = null;
    private static Model inputModel = null;
    private static Map<String, Map<String, ClassInfo>> inputModelClassesByClassNameBySchemaName = null;
    private static Repository eaRepo = null;
    private static boolean processAllSchemas = false;
    private static boolean deleteExistingProfiles = false;
    private static SortedSet<String> profilesToTransfer = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        if (!initialised) {
            initialised = true;
            inputModel = m;
            processAllSchemas = this.options.parameterAsBoolean(ProfileTransferEA.class.getName(), PARAM_PROCESS_ALL_SCHEMAS, false);
            deleteExistingProfiles = this.options.parameterAsBoolean(ProfileTransferEA.class.getName(), PARAM_DELETE_EXISTING_PROFILES, false);
            if (this.options.hasParameter(ProfileTransferEA.class.getName(), PARAM_PROFILES_TO_TRANSFER)) {
                profilesToTransfer = new TreeSet<String>(this.options.parameterAsStringList(ProfileTransferEA.class.getName(), PARAM_PROFILES_TO_TRANSFER, null, true, true));
            }
            Object repoConnectionInfo = null;
            String username = null;
            String password = null;
            if (this.options.hasParameter(ProfileTransferEA.class.getName(), PARAM_REPO_CONNECTION_STRING)) {
                this.result.addInfo(this, 29);
                repoConnectionInfo = this.options.parameterAsString(ProfileTransferEA.class.getName(), PARAM_REPO_CONNECTION_STRING, null, false, true);
                if (repoConnectionInfo == null) {
                    this.result.addError(this, 31);
                    invalidConfiguration = true;
                } else {
                    username = this.options.parameter(ProfileTransferEA.class.getName(), PARAM_USER);
                    password = this.options.parameter(ProfileTransferEA.class.getName(), PARAM_PWD);
                }
            } else {
                this.result.addInfo(this, 30);
                String inputModelType = this.options.parameter("inputModelType");
                if (inputModelType == null || !inputModelType.equalsIgnoreCase("EA7")) {
                    this.result.addError(this, 10);
                    invalidConfiguration = true;
                } else {
                    String mdl = this.options.parameter("inputFile");
                    String repoFileNameOrConnectionString = this.options.parameter(PARAM_REPO_CONNECTION_STRING);
                    username = this.options.parameter(PARAM_USER);
                    password = this.options.parameter(PARAM_PWD);
                    if (repoFileNameOrConnectionString != null && repoFileNameOrConnectionString.length() > 0) {
                        repoConnectionInfo = repoFileNameOrConnectionString;
                    } else if (mdl != null && mdl.length() > 0) {
                        repoConnectionInfo = mdl;
                    } else {
                        this.result.addError(this, 11);
                        invalidConfiguration = true;
                    }
                }
            }
            if (!invalidConfiguration) {
                username = username == null ? "" : username;
                password = password == null ? "" : password;
                boolean transferToCopyOfEAP = this.options.parameterAsBoolean(ProfileTransferEA.class.getName(), PARAM_TRANSFER_TO_EAP_COPY, false);
                if (((String)repoConnectionInfo).contains("DBType=") || ((String)repoConnectionInfo).contains("Connect=Cloud")) {
                    if (transferToCopyOfEAP) {
                        this.result.addError(this, 13);
                        invalidConfiguration = true;
                    } else {
                        connectionString = repoConnectionInfo;
                    }
                } else {
                    File repfile = new File((String)repoConnectionInfo);
                    boolean ex = true;
                    if (!repfile.exists()) {
                        ex = false;
                        if (!((String)repoConnectionInfo).toLowerCase().endsWith(".eap")) {
                            repoConnectionInfo = (String)repoConnectionInfo + ".eap";
                            repfile = new File((String)repoConnectionInfo);
                            ex = repfile.exists();
                        }
                    }
                    if (!ex) {
                        this.result.addError(this, 14, (String)repoConnectionInfo);
                        invalidConfiguration = true;
                    } else if (transferToCopyOfEAP) {
                        File outputDirectoryFile;
                        boolean exi;
                        String outputDirectory = this.options.parameter(ProfileTransferEA.class.getName(), "outputDirectory");
                        if (outputDirectory == null) {
                            outputDirectory = this.options.parameter("outputDirectory");
                        }
                        if (outputDirectory == null) {
                            outputDirectory = ".";
                        }
                        if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
                            outputDirectoryFile.mkdirs();
                            exi = outputDirectoryFile.exists();
                        }
                        boolean dir = outputDirectoryFile.isDirectory();
                        boolean wrt = outputDirectoryFile.canWrite();
                        boolean rea = outputDirectoryFile.canRead();
                        if (!(exi && dir && wrt && rea)) {
                            this.result.addError(this, 12, outputDirectory);
                            invalidConfiguration = true;
                        } else {
                            File inputEAP = new File((String)repoConnectionInfo);
                            File copyEAP = new File(outputDirectoryFile, inputEAP.getName());
                            try {
                                FileUtils.copyFile((File)inputEAP, (File)copyEAP, (boolean)false);
                                connectionString = copyEAP.getAbsolutePath();
                            }
                            catch (Exception e) {
                                this.result.addError(this, 15, e.getMessage());
                                invalidConfiguration = true;
                            }
                        }
                    } else {
                        connectionString = repfile.getAbsolutePath();
                    }
                }
                if (!invalidConfiguration) {
                    String errormsg;
                    eaRepo = new Repository();
                    if (username.length() == 0) {
                        if (!eaRepo.OpenFile(connectionString)) {
                            errormsg = eaRepo.GetLastError();
                            this.result.addError(this, 16, connectionString, errormsg);
                            invalidConfiguration = true;
                        }
                    } else if (!eaRepo.OpenFile2(connectionString, username, password)) {
                        errormsg = eaRepo.GetLastError();
                        this.result.addError(this, 17, connectionString, username, password, errormsg);
                        invalidConfiguration = true;
                    }
                }
                if (!invalidConfiguration) {
                    inputModelClassesByClassNameBySchemaName = new HashMap<String, Map<String, ClassInfo>>();
                    for (PackageInfo inputModelPkg : inputModel.schemas(null)) {
                        HashMap<String, ClassInfo> classesByName = new HashMap<String, ClassInfo>();
                        for (ClassInfo ci : inputModel.classes(inputModelPkg)) {
                            classesByName.put(ci.name(), ci);
                        }
                        inputModelClassesByClassNameBySchemaName.put(inputModelPkg.name(), classesByName);
                    }
                }
            }
        }
    }

    @Override
    public void process(ClassInfo ci) {
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "Profile Transfer EA";
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        if (invalidConfiguration) {
            return;
        }
        this.result = r;
        this.options = r.options();
        Collection eaModelPackages = eaRepo.GetModels();
        for (Package eaModelPkg : eaModelPackages) {
            this.processProfiles(eaModelPkg, null, null);
        }
        if (eaRepo != null) {
            eaRepo.CloseFile();
            eaRepo.Exit();
            eaRepo = null;
        }
    }

    private void processProfiles(Package eaModelPkg, String parentSchemaName, String parentSchemaTargetNamespace) {
        String schemaTargetNamespace;
        String schemaName;
        Element pkgElement;
        String pkgName = eaModelPkg.GetName();
        String targetNamespace = this.identifyTargetNamespace(pkgName, pkgElement = eaModelPkg.GetElement());
        if (!(targetNamespace == null || parentSchemaTargetNamespace != null && targetNamespace.equalsIgnoreCase(parentSchemaTargetNamespace))) {
            schemaName = pkgName;
            schemaTargetNamespace = targetNamespace;
        } else {
            schemaName = parentSchemaName;
            schemaTargetNamespace = parentSchemaTargetNamespace;
        }
        if (schemaTargetNamespace != null && (processAllSchemas || !this.skipSchema(schemaName, schemaTargetNamespace))) {
            boolean hasCorrespondingInputSchema = inputModelClassesByClassNameBySchemaName.containsKey(schemaName);
            if (!hasCorrespondingInputSchema) {
                this.result.addWarning(this, 20, schemaName, schemaTargetNamespace);
            }
            for (Element classElmt : eaModelPkg.GetElements()) {
                String profilesTV;
                String statusTaggedValue;
                String type = classElmt.GetType();
                int classElementId = classElmt.GetElementID();
                if (!type.equals("DataType") && !type.equals("Class") && !type.equals("Interface") && !type.equals("Enumeration") || (statusTaggedValue = EAElementUtil.taggedValue(classElmt, "status")) != null && this.options.prohibitedStatusValuesWhenLoadingClasses().contains(statusTaggedValue)) continue;
                if (deleteExistingProfiles) {
                    EAElementUtil.deleteTaggedValue(classElmt, "profiles");
                    for (Attribute att : classElmt.GetAttributes()) {
                        EAAttributeUtil.deleteTaggedValue(att, "profiles");
                    }
                    for (Connector con : classElmt.GetConnectors()) {
                        String conType = con.GetType();
                        if (!conType.equalsIgnoreCase("Association") && !conType.equalsIgnoreCase("Aggregation")) continue;
                        if (con.GetClientID() == classElementId && this.isNavigableEnd(con, con.GetSupplierEnd())) {
                            EAConnectorEndUtil.deleteTaggedValue(con.GetSupplierEnd(), "profiles");
                        }
                        if (con.GetSupplierID() != classElementId || !this.isNavigableEnd(con, con.GetClientEnd())) continue;
                        EAConnectorEndUtil.deleteTaggedValue(con.GetClientEnd(), "profiles");
                    }
                }
                if (!hasCorrespondingInputSchema) continue;
                Map<String, ClassInfo> inputModelSchemaCisByCiName = inputModelClassesByClassNameBySchemaName.get(schemaName);
                String className = classElmt.GetName().trim();
                this.result.addInfo(this, 3, className);
                if (!inputModelSchemaCisByCiName.containsKey(className)) {
                    this.result.addWarning(this, 21, className, schemaName, schemaTargetNamespace);
                    continue;
                }
                Profiles newProfilesCi = new Profiles();
                if (!deleteExistingProfiles && (profilesTV = EAElementUtil.taggedValue(classElmt, "profiles")) != null && profilesTV.trim().length() > 0) {
                    try {
                        newProfilesCi = Profiles.parse(profilesTV.trim(), false);
                    }
                    catch (MalformedProfileIdentifierException e) {
                        this.result.addError(this, 22, className, schemaName, e.getMessage());
                    }
                }
                ClassInfo inputModelCi = inputModelSchemaCisByCiName.get(className);
                newProfilesCi.put(this.computeProfilesToTransfer(inputModelCi.profiles()));
                try {
                    EAElementUtil.setTaggedValue(classElmt, "profiles", newProfilesCi.toString());
                }
                catch (EAException e) {
                    this.result.addError(this, 23, className, schemaName, e.getMessage());
                }
                for (Attribute att : classElmt.GetAttributes()) {
                    String profilesTV2;
                    String attName = att.GetName();
                    PropertyInfo inputModelPi = inputModelCi.ownedProperty(attName);
                    if (inputModelPi == null) {
                        this.result.addWarning(this, 24, className, schemaName, schemaTargetNamespace, attName);
                        continue;
                    }
                    Profiles newProfilesPi = new Profiles();
                    if (!deleteExistingProfiles && (profilesTV2 = EAAttributeUtil.taggedValue(att, "profiles")) != null && profilesTV2.trim().length() > 0) {
                        try {
                            newProfilesPi = Profiles.parse(profilesTV2.trim(), false);
                        }
                        catch (MalformedProfileIdentifierException e) {
                            this.result.addError(this, 25, className, attName, schemaName, e.getMessage());
                        }
                    }
                    newProfilesPi.put(this.computeProfilesToTransfer(inputModelPi.profiles()));
                    try {
                        EAAttributeUtil.setTaggedValue(att, "profiles", newProfilesPi.toString());
                    }
                    catch (EAException e) {
                        this.result.addError(this, 26, className, attName, schemaName, e.getMessage());
                    }
                }
                for (Connector con : classElmt.GetConnectors()) {
                    String conType = con.GetType();
                    if (!conType.equalsIgnoreCase("Association") && !conType.equalsIgnoreCase("Aggregation")) continue;
                    if (con.GetClientID() == classElementId && this.isNavigableEnd(con, con.GetSupplierEnd())) {
                        this.transferProfileForAssociationRole(con.GetSupplierEnd(), inputModelCi, schemaName, schemaTargetNamespace);
                    }
                    if (con.GetSupplierID() != classElementId || !this.isNavigableEnd(con, con.GetClientEnd())) continue;
                    this.transferProfileForAssociationRole(con.GetClientEnd(), inputModelCi, schemaName, schemaTargetNamespace);
                }
            }
        }
        Collection subPackages = eaModelPkg.GetPackages();
        for (Package subPkg : subPackages) {
            this.processProfiles(subPkg, schemaName, schemaTargetNamespace);
        }
    }

    private void transferProfileForAssociationRole(ConnectorEnd end, ClassInfo inputModelCi, String schemaName, String schemaTargetNamespace) {
        String roleName = end.GetRole();
        PropertyInfo inputModelPi = inputModelCi.ownedProperty(roleName);
        if (inputModelPi == null) {
            this.result.addWarning(this, 24, inputModelCi.name(), schemaName, schemaTargetNamespace, roleName);
        } else {
            String profilesTV;
            Profiles newProfilesPi = new Profiles();
            if (!deleteExistingProfiles && (profilesTV = EAConnectorEndUtil.taggedValue(end, "profiles")) != null && profilesTV.trim().length() > 0) {
                try {
                    newProfilesPi = Profiles.parse(profilesTV.trim(), false);
                }
                catch (MalformedProfileIdentifierException e) {
                    this.result.addError(this, 27, inputModelCi.name(), roleName, schemaName, e.getMessage());
                }
            }
            newProfilesPi.put(this.computeProfilesToTransfer(inputModelPi.profiles()));
            try {
                EAConnectorEndUtil.setTaggedValue(end, "profiles", newProfilesPi.toString());
            }
            catch (EAException e) {
                this.result.addError(this, 28, inputModelCi.name(), roleName, schemaName, e.getMessage());
            }
        }
    }

    private boolean isNavigableEnd(Connector eaConnector, ConnectorEnd eaConnectorEnd) {
        boolean nav = eaConnectorEnd.GetIsNavigable();
        if (!nav) {
            int navigability = 0;
            String dirText = eaConnector.GetDirection();
            if (dirText.equals("Source -> Destination")) {
                navigability = 1;
            } else if (dirText.equals("Destination -> Source")) {
                navigability = -1;
            }
            boolean bl = nav = navigability == 0;
        }
        if (nav) {
            String roleName;
            String sn = eaConnectorEnd.GetStereotype();
            if (sn != null) {
                sn = this.options.normalizeStereotype(sn);
            }
            if (sn != null && sn.length() > 0) {
                boolean found = false;
                for (String st : Options.propertyStereotypes) {
                    if (!sn.equals(st)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    nav = false;
                }
            }
            if ((roleName = eaConnectorEnd.GetRole()) == null || roleName.length() == 0) {
                nav = false;
            }
        }
        return nav;
    }

    private Profiles computeProfilesToTransfer(Profiles profilesOfModelElement) {
        Profiles ptt = profilesToTransfer == null ? profilesOfModelElement : new Profiles(profilesOfModelElement.getProfiles(profilesToTransfer));
        return ptt;
    }

    private boolean skipSchema(String schemaName, String targetNamespace) {
        String schemaFilter = this.options.parameter("appSchemaName");
        if (schemaFilter != null && schemaFilter.length() > 0 && !schemaFilter.equals(schemaName)) {
            return true;
        }
        String appSchemaNameRegex = this.options.parameter("appSchemaNameRegex");
        if (appSchemaNameRegex != null && appSchemaNameRegex != null && appSchemaNameRegex.length() > 0 && !schemaName.matches(appSchemaNameRegex)) {
            return true;
        }
        String appSchemaNamespaceRegex = this.options.parameter("appSchemaNamespaceRegex");
        return appSchemaNamespaceRegex != null && appSchemaNamespaceRegex.length() > 0 && !targetNamespace.matches(appSchemaNamespaceRegex);
    }

    private String identifyTargetNamespace(String pkgName, Element pkgElmt) {
        String targetNamespace = null;
        if (pkgElmt != null) {
            ArrayList<String> tagNames = new ArrayList<String>();
            tagNames.add("targetNamespace");
            tagNames.add("xmlNamespace");
            Collection tvs = pkgElmt.GetTaggedValues();
            if (tvs != null) {
                for (TaggedValue tv : tvs) {
                    String tvName = tv.GetName();
                    if ("targetNamespace".equals(tvName)) {
                        targetNamespace = tv.GetValue();
                        break;
                    }
                    if (!"xmlNamespace".equals(tvName)) continue;
                    targetNamespace = tv.GetValue();
                }
            }
        }
        if (targetNamespace == null) {
            targetNamespace = this.options.nsOfPackage(pkgName);
        }
        return targetNamespace;
    }

    @Override
    public void reset() {
        initialised = false;
        invalidConfiguration = false;
        connectionString = null;
        inputModel = null;
        inputModelClassesByClassNameBySchemaName = null;
        eaRepo = null;
        processAllSchemas = false;
        deleteExistingProfiles = false;
        profilesToTransfer = null;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetIdentifier() {
        return "proftrans";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: $1$";
            }
            case 2: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "Transferring profiles for class '$1$'.";
            }
            case 10: {
                return "The input parameter 'inputModelType' was not set or does not equal (ignoring case) 'EA7'. This target can only be executed if the model to transfer profiles to is an EA repository.";
            }
            case 11: {
                return "Neither the input parameter 'inputFile' nor the input parameter 'repositoryFileNameOrConnectionString' are set. This target requires one of these parameters in order to connect to the EA repository.";
            }
            case 12: {
                return "The target is configured to copy the EA project file to the output directory, before transferring the profile infos. However, the directory named '$1$' does not exist or is not accessible. The transfer will not be executed.";
            }
            case 13: {
                return "The target is configured to copy the EA project file to the output directory, before transferring the profile infos. However, the EA repository is a server based repository, not an EA project file. The transfer will not be executed.";
            }
            case 14: {
                return "Enterprise Architect repository file named '$1$' not found.";
            }
            case 15: {
                return "The target is configured to copy the EA project file to the output directory, before transferring the profile infos. However, an exception occurred when copying the file: $1$. The transfer will not be executed.";
            }
            case 16: {
                return "Enterprise Architect repository cannot be opened. File name or connection string is: '$1$', exception message is: '$2$'";
            }
            case 17: {
                return "Enterprise Architect repository cannot be opened. File name or connection string is: '$1$', username is: '$2$', password is: '$3$', exception message is: '$4$'";
            }
            case 18: {
                return "Could not transfer profiles to class '$1$'. Exception message is: $2$.";
            }
            case 19: {
                return "Could not transfer profiles to property '$1$' in class '$2$'. Exception message is: $3$.";
            }
            case 20: {
                return "??The target EA repository contains the schema '$1$' with namespace '$2$' for which profiles shall be transferred. However, the input model does not contain a schema with that name. Consequently, no profiles can be transferred for this schema.";
            }
            case 21: {
                return "The target EA repository contains class '$1$' (in schema '$2$' with namespace '$3$') for which profiles shall be transferred. However, the according schema in the input model does not contain a class with that name. Consequently, no profiles can be transferred for the class.";
            }
            case 22: {
                return "Profiles tagged value of class '$1$' in schema '$2$' of the target EA repository is malformed: $3$. Existing profiles will be overwritten by profiles from corresponding input model element.";
            }
            case 23: {
                return "Unexpected exception occurred while transferring the profiles of class '$1$' in schema '$2$' of the target EA repository: $3$.";
            }
            case 24: {
                return "The target EA repository contains class '$1$' (in schema '$2$' with namespace '$3$') with property '$4$' for which profiles shall be transferred. However, the according class in the input model does not contain a property with that name. Consequently, no profiles can be transferred for the property.";
            }
            case 25: {
                return "Profiles tagged value of attribute '$1$.$2$' in schema '$3$' of the target EA repository is malformed: $4$. Existing profiles will be overwritten by profiles from corresponding input model element.";
            }
            case 26: {
                return "Unexpected exception occurred while transferring the profiles of attribute '$1$.$2$' in schema '$3$' of the target EA repository: $4$.";
            }
            case 27: {
                return "Profiles tagged value of association role '$1$.$2$' in schema '$3$' of the target EA repository is malformed: $4$. Existing profiles will be overwritten by profiles from corresponding input model element.";
            }
            case 28: {
                return "Unexpected exception occurred while transferring the profiles of association role '$1$.$2$' in schema '$3$' of the target EA repository: $4$.";
            }
            case 29: {
                return "Using EA repository connection info provided by target configuration.";
            }
            case 30: {
                return "Using EA repository connection info provided by input configuration.";
            }
            case 31: {
                return "Parameter 'repositoryFileNameOrConnectionString' is set in the configuration of this target, but it does not contain a valid value. Provide such a value or remove the target parameter in order for the target to look up the EA repository connection info in the input configuration.";
            }
        }
        return "(" + ProfileTransferEA.class.getName() + ") Unknown message with number: " + mnr;
    }
}

