/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.OpenApi;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaVersion;
import de.interactive_instruments.ShapeChange.Target.OpenApi.ConformanceClass;
import de.interactive_instruments.ShapeChange.Target.OpenApi.OpenApiConfigItems;
import de.interactive_instruments.ShapeChange.Target.OpenApi.OpenApiDefinition;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OpenApiDefinitionConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("baseTemplate", "collections", "jsonSchemaVersion", "jsonSchemasBaseLocation").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        String jsVersionParamValue;
        Optional<JsonSchemaVersion> jsVersion;
        File outputDirectoryFile;
        boolean exi;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, pConfig.getParameters().keySet(), result) && isValid;
        String outputDirectory = pConfig.getParameterValue("outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
        }
        if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            isValid = false;
            result.addError(this, 2, outputDirectory);
        }
        if (pConfig.getAdvancedProcessConfigurations() == null) {
            isValid = false;
            result.addError(this, 3);
        } else {
            try {
                OpenApiConfigItems oapiConfig = new OpenApiConfigItems(result, pConfig.getAdvancedProcessConfigurations());
                Optional<ConformanceClass> coreCc = oapiConfig.conformanceClass("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core");
                if (coreCc.isEmpty()) {
                    isValid = false;
                    result.addError(this, 5);
                }
            }
            catch (Exception e) {
                isValid = false;
            }
        }
        String baseTemplateValue = options.parameterAsString(OpenApiDefinition.class.getName(), "baseTemplate", "https://shapechange.net/resources/openapi/overlays/default-template.json", false, true);
        if (StringUtils.isBlank((CharSequence)baseTemplateValue)) {
            isValid = false;
            result.addError(this, 8, "baseTemplate", baseTemplateValue);
        } else {
            try {
                OpenApiDefinition.loadJson(baseTemplateValue);
            }
            catch (IOException e) {
                isValid = false;
                result.addError(this, 7, baseTemplateValue, e.getMessage());
            }
        }
        String jsonSchemasBaseLocation = options.parameterAsString(OpenApiDefinition.class.getName(), "jsonSchemasBaseLocation", null, false, true);
        if (StringUtils.isBlank((CharSequence)jsonSchemasBaseLocation)) {
            isValid = false;
            result.addError(this, 4, "jsonSchemasBaseLocation");
        }
        if (!(jsVersion = JsonSchemaVersion.fromString(jsVersionParamValue = options.parameterAsString(OpenApiDefinition.class.getName(), "jsonSchemaVersion", "2019-09", false, true))).isPresent()) {
            isValid = false;
            result.addError(this, 8, "jsonSchemaVersion", jsVersionParamValue);
        }
        if (pConfig.hasParameter("collections") && options.parameterAsStringList(OpenApiDefinition.class.getName(), "collections", null, true, true).isEmpty()) {
            isValid = false;
            result.addError(this, 6, "collections");
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'.";
            }
            case 2: {
                return "Output directory '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "No 'advancedProcessConfigurations' element present in the configuration.";
            }
            case 4: {
                return "Required target parameter '$1$' is not set in the configuration.";
            }
            case 5: {
                return "The configuration does not define the required conformance class http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core.";
            }
            case 6: {
                return "Target parameter '$1$' is set in the configuration, but does not have an actual value.";
            }
            case 7: {
                return "Target parameter 'baseTemplate' has value: '$1$'. Could not load JSON from that location. Exception message is: $2$";
            }
            case 8: {
                return "Configuration parameter '$1$' has invalid value '$2$'";
            }
        }
        return "(OpenApiDefinitionConfigurationValidator.java) Unknown message with number: " + mnr;
    }
}

