/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.OpenApi;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.JSON.JsonSchemaTarget;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaVersion;
import de.interactive_instruments.ShapeChange.Target.OpenApi.ConformanceClass;
import de.interactive_instruments.ShapeChange.Target.OpenApi.OpenApiConfigItems;
import de.interactive_instruments.ShapeChange.Target.OpenApi.OpenApiDefinitionProcessingPhase;
import de.interactive_instruments.ShapeChange.Target.OpenApi.QueryParameter;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonPointer;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OpenApiDefinition
implements SingleTarget,
MessageSource {
    protected static Model model = null;
    private static boolean initialised = false;
    protected static boolean diagnosticsOnly = false;
    protected static int numberOfEncodedSchemas = 0;
    protected static String outputDirectory = null;
    protected static String outputFilename = null;
    protected static OpenApiConfigItems oapiConfig = null;
    protected static JsonObject baseTemplate = null;
    protected static String jsonSchemasBaseLocation = null;
    protected static String jsonSchemasPathSeparator = null;
    protected static JsonSchemaVersion jsonSchemaVersion = null;
    protected static SortedSet<String> collections = new TreeSet<String>();
    protected static SortedMap<ClassInfo, String> jsonSchemaPathByFeatureType = new TreeMap<ClassInfo, String>();
    protected ShapeChangeResult result = null;
    protected Options options = null;
    private PackageInfo schema = null;
    private boolean schemaNotEncoded = false;

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schema = pi;
        model = m;
        this.options = o;
        this.result = r;
        diagnosticsOnly = diagOnly;
        if (!OpenApiDefinition.isEncoded(this.schema) || !OpenApiDefinition.isJsonEncoded(this.schema)) {
            this.schemaNotEncoded = true;
            this.result.addInfo(this, 7, this.schema.name());
            return;
        }
        ++numberOfEncodedSchemas;
        if (!initialised) {
            String jsVersionParamValue;
            Optional<JsonSchemaVersion> jsVersion;
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            if ((outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename")) == null) {
                outputFilename = "OpenApiDefinition";
            }
            outputFilename = outputFilename.endsWith(".json") ? outputFilename : outputFilename + ".json";
            try {
                oapiConfig = new OpenApiConfigItems(this.result, this.options.getCurrentProcessConfig().getAdvancedProcessConfigurations());
            }
            catch (Exception e) {
                this.result.addFatalError(this, 11);
                throw new ShapeChangeAbortException();
            }
            String baseTemplateValue = this.options.parameterAsString(this.getClass().getName(), "baseTemplate", "https://shapechange.net/resources/openapi/overlays/default-template.json", false, true);
            try {
                baseTemplate = OpenApiDefinition.loadJson(baseTemplateValue);
            }
            catch (IOException e) {
                this.result.addFatalError(this, 12, baseTemplateValue, e.getMessage());
                throw new ShapeChangeAbortException();
            }
            if (this.options.hasParameter(OpenApiDefinition.class.getName(), "collections")) {
                collections.addAll(this.options.parameterAsStringList(OpenApiDefinition.class.getName(), "collections", null, true, true));
            }
            if (!jsonSchemasBaseLocation.endsWith(jsonSchemasPathSeparator = (jsonSchemasBaseLocation = this.options.parameterAsString(OpenApiDefinition.class.getName(), "jsonSchemasBaseLocation", null, false, true)).contains("\\") ? "\\" : "/")) {
                jsonSchemasBaseLocation = jsonSchemasBaseLocation + jsonSchemasPathSeparator;
            }
            if ((jsVersion = JsonSchemaVersion.fromString(jsVersionParamValue = this.options.parameterAsString(this.getClass().getName(), "jsonSchemaVersion", "2019-09", false, true))).isPresent()) {
                jsonSchemaVersion = jsVersion.get();
            } else {
                this.result.addWarning(this, 10, "jsonSchemaVersion", jsVersionParamValue, "2019-09");
                jsonSchemaVersion = JsonSchemaVersion.DRAFT_2019_09;
            }
            File outputDirectoryFile = new File(outputDirectory);
            if (!diagnosticsOnly) {
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 5, outputDirectory);
                    throw new ShapeChangeAbortException();
                }
            } else {
                this.result.addInfo(this, 10002);
            }
        }
        this.result.addDebug(this, 10001, pi.name());
    }

    public static JsonObject loadJson(String uri) throws IOException {
        InputStream stream = null;
        if (uri.startsWith("http")) {
            URL url = new URL(uri);
            URLConnection urlConnection = url.openConnection();
            stream = urlConnection.getInputStream();
        } else {
            File f = new File(uri);
            stream = new FileInputStream(f);
        }
        JsonReader reader = Json.createReader((InputStream)stream);
        JsonObject jsonObj = reader.readObject();
        reader.close();
        return jsonObj;
    }

    public static boolean isEncoded(Info i) {
        return !i.matches("rule-openapi-all-notEncoded") || !i.encodingRule("openapi").equalsIgnoreCase("notencoded");
    }

    public static boolean isJsonEncoded(Info i) {
        return !i.matches("rule-json-all-notEncoded") || !i.encodingRule("json").equalsIgnoreCase("notencoded");
    }

    @Override
    public void process(ClassInfo ci) {
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (!OpenApiDefinition.isEncoded(ci) || !OpenApiDefinition.isJsonEncoded(ci)) {
            this.result.addInfo(this, 8, ci.name());
            return;
        }
        this.result.addDebug(this, 4, ci.name());
        if (this.schemaNotEncoded) {
            this.result.addInfo(this, 18, this.schema.name(), ci.name());
            return;
        }
        if (ci.category() == 1) {
            if (ci.matches("rule-openapi-all-explicit-collections")) {
                if (collections.contains(ci.name())) {
                    this.register(ci);
                }
            } else if (ci.matches("rule-openapi-cls-instantiable-feature-types")) {
                if (!ci.isAbstract()) {
                    this.register(ci);
                }
            } else if (ci.matches("rule-openapi-cls-top-level-feature-types")) {
                if (ci.supertypes().isEmpty() || ci.supertypeClasses().stream().filter(st -> st.inSchema(this.schema)).findAny().isEmpty()) {
                    this.register(ci);
                }
            } else {
                this.result.addInfo(this, 13, ci.name());
            }
        } else {
            this.result.addDebug(this, 17, ci.name());
        }
    }

    protected void register(ClassInfo ci) {
        PackageInfo ciSchemaPkg = ci.model().schemaPackage(ci);
        String jsonDirectory = JsonSchemaTarget.identifyJsonDirectory(ciSchemaPkg);
        String fileName = this.identifyJsonDocumentName(ci.pkg());
        String definitionsReference = jsonSchemaVersion == JsonSchemaVersion.DRAFT_2019_09 ? "#/$defs/" : "#/definitions/";
        String jsonSchemaDefinitionPath = jsonSchemasBaseLocation + jsonDirectory + jsonSchemasPathSeparator + fileName + definitionsReference + ci.name();
        jsonSchemaPathByFeatureType.put(ci, jsonSchemaDefinitionPath);
    }

    private String identifyJsonDocumentName(PackageInfo pi) {
        String s = pi.taggedValue("jsonDocument");
        s = StringUtils.isBlank((CharSequence)s) ? (pi.isAppSchema() ? JsonSchemaTarget.normalizedJsonDocumentName(pi) : this.identifyJsonDocumentName(pi.owner())) : s.trim();
        return s;
    }

    public Optional<ProcessMapEntry> mapEntry(ClassInfo ci) {
        return Optional.ofNullable(this.options.targetMapEntry(ci.name(), ci.encodingRule("openapi")));
    }

    @Override
    public void write() {
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        this.options = r.options();
        if (numberOfEncodedSchemas == 0) {
            return;
        }
        if (!diagnosticsOnly) {
            JsonValue res1;
            Optional<ConformanceClass> coreCcOpt = oapiConfig.conformanceClass("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core");
            JsonObject bbCore = coreCcOpt.get().getOverlay();
            JsonMergePatch mergePatch1 = Json.createMergePatch((JsonValue)bbCore);
            JsonValue res2 = res1 = mergePatch1.apply((JsonValue)baseTemplate);
            Optional<ConformanceClass> geojsonCcOpt = oapiConfig.conformanceClass("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson");
            boolean isGeojsonApplicable = geojsonCcOpt.isPresent();
            if (isGeojsonApplicable) {
                JsonObject bbGeoJson = geojsonCcOpt.get().getOverlay();
                JsonMergePatch mergePatchGeoJson = Json.createMergePatch((JsonValue)bbGeoJson);
                res2 = mergePatchGeoJson.apply(res1);
            }
            JsonObject res3 = (JsonObject)res2;
            Optional<ConformanceClass> htmlCcOpt = oapiConfig.conformanceClass("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/html");
            boolean isHtmlApplicable = htmlCcOpt.isPresent();
            if (isHtmlApplicable) {
                JsonObject bbHtml = htmlCcOpt.get().getOverlay();
                JsonMergePatch mergePatchHtml = Json.createMergePatch((JsonValue)bbHtml);
                res3 = (JsonObject)mergePatchHtml.apply(res2);
            }
            JsonObject res4 = res3;
            Optional<ConformanceClass> crsCcOpt = oapiConfig.conformanceClass("http://www.opengis.net/spec/ogcapi-features-2/1.0/conf/crs");
            boolean isCrsApplicable = crsCcOpt.isPresent();
            if (isCrsApplicable) {
                ConformanceClass crsCc = crsCcOpt.get();
                JsonObject crs_queryParametersMerged = this.mergeQueryParameters(res3, crsCc.getOverlay());
                JsonMergePatch mergePatchCrs = Json.createMergePatch((JsonValue)crs_queryParametersMerged);
                res4 = (JsonObject)mergePatchCrs.apply((JsonValue)res3);
                if (crsCc.getParam().isPresent()) {
                    List<String> supportedCrs = Arrays.asList(StringUtils.split((String)crsCc.getParam().get()));
                    JsonObject supportedCrsOverlay = Json.createObjectBuilder().add("components", Json.createObjectBuilder().add("parameters", Json.createObjectBuilder().add("crs", Json.createObjectBuilder().add("schema", Json.createObjectBuilder().add("enum", Json.createArrayBuilder(supportedCrs)))).add("bbox-crs", Json.createObjectBuilder().add("schema", Json.createObjectBuilder().add("enum", Json.createArrayBuilder(supportedCrs)))))).build();
                    JsonMergePatch mergePatchSupportedCrs = Json.createMergePatch((JsonValue)supportedCrsOverlay);
                    res4 = (JsonObject)mergePatchSupportedCrs.apply((JsonValue)res4);
                }
            }
            List queryParametersPreFeatureIdent = oapiConfig.getQueryParameters().stream().filter(qp -> qp.getPhase() == OpenApiDefinitionProcessingPhase.PRE_FEATURE_IDENTIFICATION).collect(Collectors.toList());
            for (QueryParameter qp2 : queryParametersPreFeatureIdent) {
                JsonObject qpOverlay = qp2.getOverlay();
                JsonObject queryParametersMerged = this.mergeQueryParameters(res4, qpOverlay);
                JsonMergePatch mergePatchQueryParameterOverlay = Json.createMergePatch((JsonValue)queryParametersMerged);
                res4 = (JsonObject)mergePatchQueryParameterOverlay.apply((JsonValue)res4);
            }
            JsonObject featureTypesMerged = this.featureTypeUpdates(res4, isGeojsonApplicable);
            JsonObject removeGenericsOverlay = Json.createObjectBuilder().add("paths", Json.createObjectBuilder().add("/collections/{collectionId}", JsonValue.NULL).add("/collections/{collectionId}/items", JsonValue.NULL).add("/collections/{collectionId}/items/{featureId}", JsonValue.NULL)).add("components", Json.createObjectBuilder().add("parameters", Json.createObjectBuilder().add("collectionId", JsonValue.NULL)).add("schemas", Json.createObjectBuilder().add("Features", JsonValue.NULL).add("Feature", JsonValue.NULL)).add("responses", Json.createObjectBuilder().add("Features", JsonValue.NULL).add("Feature", JsonValue.NULL))).build();
            JsonMergePatch mergePatchRemoveGenerics = Json.createMergePatch((JsonValue)removeGenericsOverlay);
            JsonObject res5 = (JsonObject)mergePatchRemoveGenerics.apply((JsonValue)featureTypesMerged);
            List queryParametersFinalization = oapiConfig.getQueryParameters().stream().filter(qp -> qp.getPhase() == OpenApiDefinitionProcessingPhase.FINALIZATION).collect(Collectors.toList());
            for (QueryParameter qp3 : queryParametersFinalization) {
                JsonObject qpOverlay = qp3.getOverlay();
                JsonObject queryParametersMerged = this.mergeQueryParameters(res5, qpOverlay);
                JsonMergePatch mergePatchQueryParameterOverlay = Json.createMergePatch((JsonValue)queryParametersMerged);
                res5 = (JsonObject)mergePatchQueryParameterOverlay.apply((JsonValue)res5);
            }
            Map<String, Boolean> jsonWriterConfig = Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
            JsonWriterFactory factory = Json.createWriterFactory(jsonWriterConfig);
            File outputFile = new File(outputDirectory, outputFilename);
            try (JsonWriter writer = factory.createWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));){
                writer.write((JsonStructure)res5);
                this.result.addResult(this.getTargetName(), outputFile.getParent(), outputFile.getName(), null);
            }
            catch (Exception e) {
                this.result.addError(this, 100, outputFile.getAbsolutePath(), e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private JsonObject featureTypeUpdates(JsonObject source, boolean isGeojsonApplicable) {
        JsonObject overlay = Json.createObjectBuilder().add("paths", (JsonValue)JsonValue.EMPTY_JSON_OBJECT).add("components", Json.createObjectBuilder().add("responses", (JsonValue)JsonValue.EMPTY_JSON_OBJECT).add("schemas", (JsonValue)JsonValue.EMPTY_JSON_OBJECT)).build();
        for (Map.Entry<ClassInfo, String> entry : jsonSchemaPathByFeatureType.entrySet()) {
            JsonPointer jpUpdateGeojsonResponse;
            ClassInfo ftCi = entry.getKey();
            String featureType = ftCi.name();
            String jsonSchemaPath = entry.getValue();
            String collectionsCollectionIdTemplatePath = "/paths/~1collections~1{collectionId}";
            JsonPointer jp1 = Json.createPointer((String)collectionsCollectionIdTemplatePath);
            JsonObject collectionsCollectionIdTemplate = (JsonObject)jp1.getValue((JsonStructure)source);
            JsonObject modified1 = (JsonObject)this.replaceParameter((JsonValue)collectionsCollectionIdTemplate, "\\{collectionId\\}", featureType);
            String collectionsFeatureTypeBaseJsonPointer = "/paths/~1collections~1" + featureType;
            JsonPointer jp1add = Json.createPointer((String)collectionsFeatureTypeBaseJsonPointer);
            overlay = (JsonObject)jp1add.add((JsonStructure)overlay, (JsonValue)modified1);
            overlay = this.removeCollectionIdParameter(overlay, collectionsFeatureTypeBaseJsonPointer);
            String collectionsCollectionIdItemsTemplatePath = collectionsCollectionIdTemplatePath + "~1items";
            JsonPointer jp2 = Json.createPointer((String)collectionsCollectionIdItemsTemplatePath);
            JsonObject collectionsCollectionIdItemsTemplate = (JsonObject)jp2.getValue((JsonStructure)source);
            JsonPointer jpUpdate200Response = Json.createPointer((String)"/get/responses/200/$ref");
            collectionsCollectionIdItemsTemplate = (JsonObject)jpUpdate200Response.replace((JsonStructure)collectionsCollectionIdItemsTemplate, (JsonValue)Json.createValue((String)"#/components/responses/Features_{collectionId}"));
            JsonObject modified2 = (JsonObject)this.replaceParameter((JsonValue)collectionsCollectionIdItemsTemplate, "\\{collectionId\\}", featureType);
            String collectionsFeatureTypeItemsBaseJsonPointer = "/paths/~1collections~1" + featureType + "~1items";
            JsonPointer jp2add = Json.createPointer((String)collectionsFeatureTypeItemsBaseJsonPointer);
            overlay = (JsonObject)jp2add.add((JsonStructure)overlay, (JsonValue)modified2);
            overlay = this.removeCollectionIdParameter(overlay, collectionsFeatureTypeItemsBaseJsonPointer);
            String collectionsCollectionIdItemsFeatureIdTemplatePath = collectionsCollectionIdItemsTemplatePath + "~1{featureId}";
            JsonPointer jp3 = Json.createPointer((String)collectionsCollectionIdItemsFeatureIdTemplatePath);
            JsonObject collectionsCollectionIdItemsFeatureIdTemplate = (JsonObject)jp3.getValue((JsonStructure)source);
            JsonPointer jp2Update200Response = Json.createPointer((String)"/get/responses/200/$ref");
            collectionsCollectionIdItemsFeatureIdTemplate = (JsonObject)jp2Update200Response.replace((JsonStructure)collectionsCollectionIdItemsFeatureIdTemplate, (JsonValue)Json.createValue((String)"#/components/responses/Feature_{collectionId}"));
            JsonObject modified3 = (JsonObject)this.replaceParameter((JsonValue)collectionsCollectionIdItemsFeatureIdTemplate, "\\{collectionId\\}", featureType);
            String collectionsFeatureTypeItemsFeatureIdBaseJsonPointer = "/paths/~1collections~1" + featureType + "~1items~1{featureId}";
            JsonPointer jp3add = Json.createPointer((String)collectionsFeatureTypeItemsFeatureIdBaseJsonPointer);
            overlay = (JsonObject)jp3add.add((JsonStructure)overlay, (JsonValue)modified3);
            overlay = this.removeCollectionIdParameter(overlay, collectionsFeatureTypeItemsFeatureIdBaseJsonPointer);
            String responsesFeaturesTemplatePath = "/components/responses/Features";
            JsonPointer jp4 = Json.createPointer((String)responsesFeaturesTemplatePath);
            JsonObject responsesFeaturesTemplate = (JsonObject)jp4.getValue((JsonStructure)source);
            if (isGeojsonApplicable) {
                jpUpdateGeojsonResponse = Json.createPointer((String)"/content/application~1geo+json/schema/$ref");
                responsesFeaturesTemplate = (JsonObject)jpUpdateGeojsonResponse.replace((JsonStructure)responsesFeaturesTemplate, (JsonValue)Json.createValue((String)("#/components/schemas/Features_" + featureType)));
            }
            JsonPointer jp4add = Json.createPointer((String)("/components/responses/Features_" + featureType));
            overlay = (JsonObject)jp4add.add((JsonStructure)overlay, (JsonValue)responsesFeaturesTemplate);
            if (isGeojsonApplicable) {
                String schemasFeaturesTemplatePath = "/components/schemas/Features";
                JsonPointer jpSchemasFeatures = Json.createPointer((String)schemasFeaturesTemplatePath);
                JsonObject schemasFeaturesTemplate = (JsonObject)jpSchemasFeatures.getValue((JsonStructure)source);
                JsonPointer jpUpdateFeaturesItems = Json.createPointer((String)"/properties/features/items/$ref");
                schemasFeaturesTemplate = (JsonObject)jpUpdateFeaturesItems.replace((JsonStructure)schemasFeaturesTemplate, (JsonValue)Json.createValue((String)("#/components/schemas/Feature_" + featureType)));
                JsonPointer jpSchemasFeaturesAdd = Json.createPointer((String)("/components/schemas/Features_" + featureType));
                overlay = (JsonObject)jpSchemasFeaturesAdd.add((JsonStructure)overlay, (JsonValue)schemasFeaturesTemplate);
            }
            String responsesFeatureTemplatePath = "/components/responses/Feature";
            JsonPointer jp5 = Json.createPointer((String)responsesFeatureTemplatePath);
            JsonObject responsesFeatureTemplate = (JsonObject)jp5.getValue((JsonStructure)source);
            responsesFeatureTemplate = (JsonObject)this.replaceParameter((JsonValue)responsesFeatureTemplate, "\\{collectionId\\}", featureType);
            if (isGeojsonApplicable) {
                jpUpdateGeojsonResponse = Json.createPointer((String)"/content/application~1geo+json/schema/$ref");
                responsesFeatureTemplate = (JsonObject)jpUpdateGeojsonResponse.replace((JsonStructure)responsesFeatureTemplate, (JsonValue)Json.createValue((String)("#/components/schemas/Feature_" + featureType)));
            }
            JsonPointer jp5add = Json.createPointer((String)("/components/responses/Feature_" + featureType));
            overlay = (JsonObject)jp5add.add((JsonStructure)overlay, (JsonValue)responsesFeatureTemplate);
            if (!isGeojsonApplicable) continue;
            JsonObject featureSchemaObject = Json.createObjectBuilder().add("$ref", (JsonValue)Json.createValue((String)jsonSchemaPath)).build();
            JsonPointer jpSchemasFeatureAdd = Json.createPointer((String)("/components/schemas/Feature_" + featureType));
            overlay = (JsonObject)jpSchemasFeatureAdd.add((JsonStructure)overlay, (JsonValue)featureSchemaObject);
        }
        JsonMergePatch mergePatch = Json.createMergePatch((JsonValue)overlay);
        JsonObject result = (JsonObject)mergePatch.apply((JsonValue)source);
        return result;
    }

    private JsonObject removeCollectionIdParameter(JsonObject overlay, String baseJsonPointerPath) {
        JsonObject result = overlay;
        JsonPointer basePathPointer = Json.createPointer((String)baseJsonPointerPath);
        JsonObject pathObject = (JsonObject)basePathPointer.getValue((JsonStructure)overlay);
        Set httpMethods = pathObject.keySet();
        block2: for (String httpMethod : httpMethods) {
            String parametersBaseJsonPointerPath = baseJsonPointerPath + "/" + httpMethod + "/parameters";
            JsonPointer jpParameters = Json.createPointer((String)parametersBaseJsonPointerPath);
            try {
                JsonStructure tmp = (JsonStructure)jpParameters.getValue((JsonStructure)overlay);
                if (!(tmp instanceof JsonArray)) continue;
                JsonArray array = (JsonArray)tmp;
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject p = (JsonObject)array.get(i);
                    if (!p.containsValue((Object)Json.createValue((String)"#/components/parameters/collectionId"))) continue;
                    JsonPointer jpRemoveCollIdParam = Json.createPointer((String)(parametersBaseJsonPointerPath + "/" + i));
                    result = (JsonObject)jpRemoveCollIdParam.remove((JsonStructure)overlay);
                    continue block2;
                }
            }
            catch (JsonException jsonException) {
            }
        }
        return result;
    }

    private JsonValue replaceParameter(JsonValue jv, String parameter, String replacement) {
        JsonValue result;
        if (jv instanceof JsonObject) {
            JsonObject jvObj = (JsonObject)jv;
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry e : jvObj.entrySet()) {
                builder.add(((String)e.getKey()).replaceAll(parameter, replacement), this.replaceParameter((JsonValue)e.getValue(), parameter, replacement));
            }
            result = builder.build();
        } else if (jv instanceof JsonArray) {
            JsonArray jvArr = (JsonArray)jv;
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (JsonValue arrValue : jvArr) {
                builder.add(this.replaceParameter(arrValue, parameter, replacement));
            }
            result = builder.build();
        } else if (jv instanceof JsonString) {
            JsonString jvString = (JsonString)jv;
            result = Json.createValue((String)jvString.getString().replaceAll(parameter, replacement));
        } else {
            result = jv;
        }
        return result;
    }

    private JsonObject mergeQueryParameters(JsonObject source, JsonObject target) {
        JsonObject paths = source.getJsonObject("paths");
        if (paths == null) {
            return target;
        }
        Set pathsProps = paths.keySet();
        if (pathsProps.isEmpty()) {
            return target;
        }
        JsonObject result = target;
        for (String pathsProp : pathsProps) {
            JsonObject propObj = paths.getJsonObject(pathsProp);
            for (String httpMethodProp : propObj.keySet()) {
                JsonObject httpMethodObj = propObj.getJsonObject(httpMethodProp);
                JsonArray parametersArray = httpMethodObj.getJsonArray("parameters");
                if (parametersArray == null) continue;
                String parametersPath = "/paths/" + pathsProp.replace("~", "~0").replace("/", "~1") + "/" + httpMethodProp + "/parameters";
                JsonPointer jp1 = Json.createPointer((String)parametersPath);
                try {
                    if (!jp1.containsValue((JsonStructure)result)) continue;
                    ArrayList paramArrayReverseOrder = new ArrayList(parametersArray);
                    Collections.reverse(paramArrayReverseOrder);
                    JsonPointer jp2 = Json.createPointer((String)(parametersPath + "/0"));
                    for (JsonValue arrayVal : paramArrayReverseOrder) {
                        result = (JsonObject)jp2.add((JsonStructure)result, arrayVal);
                    }
                }
                catch (JsonException jsonException) {
                }
            }
        }
        return result;
    }

    @Override
    public void reset() {
        model = null;
        initialised = false;
        diagnosticsOnly = false;
        numberOfEncodedSchemas = 0;
        outputDirectory = null;
        outputFilename = null;
        oapiConfig = null;
        baseTemplate = null;
        jsonSchemasBaseLocation = null;
        jsonSchemasPathSeparator = null;
        jsonSchemaVersion = null;
        collections = new TreeSet<String>();
        jsonSchemaPathByFeatureType = new TreeMap<ClassInfo, String>();
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-openapi-all-explicit-collections");
        r.addRule("rule-openapi-all-notEncoded");
        r.addRule("rule-openapi-cls-instantiable-feature-types");
        r.addRule("rule-openapi-cls-top-level-feature-types");
        ProcessRuleSet openapiPrs = new ProcessRuleSet("openapi", "*");
        r.addRuleSet(openapiPrs);
    }

    @Override
    public String getDefaultEncodingRule() {
        return "openapi";
    }

    @Override
    public String getTargetName() {
        return "OpenAPI Definition";
    }

    @Override
    public String getTargetIdentifier() {
        return "openapi";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class '$1$'";
            }
            case 1: {
                return "Context: property '$1$'";
            }
            case 3: {
                return "Context: class OpenAPI target";
            }
            case 4: {
                return "Processing class '$1$'.";
            }
            case 5: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 6: {
                return "System error: Exception raised '$1$'. '$2$'";
            }
            case 7: {
                return "Schema '$1$' is not encoded (via the applicable OpenAPI or the JSON Schema encoding rule).";
            }
            case 8: {
                return "Class '$1$' is not encoded (via the applicable OpenAPI or the JSON Schema encoding rule).";
            }
            case 9: {
                return "";
            }
            case 10: {
                return "Configuration parameter '$1$' has invalid value '$2$'. Using value '$3$' instead.";
            }
            case 11: {
                return "The OpenApiConfigItems element, a required item within the advancedProcessConfigurations element of the OpenApiDefinition target configuration, could not be loaded. Consult the log file for further details.";
            }
            case 12: {
                return "Target parameter 'baseTemplate' has value: $1$. Could not load JSON from that location. Exception message is: $2$";
            }
            case 13: {
                return "Feature type '$1$' is not encoded, because it matches none of the feature type conversion rules defined for the OpenAPI definition target.";
            }
            case 15: {
                return "";
            }
            case 17: {
                return "Type '$1$' is of a category not enabled for conversion, meaning that the OpenAPI definition will not represent it.";
            }
            case 18: {
                return "Schema '$1$' is not encoded. Thus class '$2$' (which belongs to that schema) is not encoded either.";
            }
            case 100: {
                return "Exception occurred while writing OpenAPI definition to file: $1$. Exception message is: $2$.";
            }
            case 503: {
                return "Output file '$1$' already exists in output directory ('$2$'). It will be deleted prior to processing.";
            }
            case 504: {
                return "File has been deleted.";
            }
            case 10001: {
                return "Generating OpenAPI definition for application schema $1$.";
            }
            case 10002: {
                return "Diagnostics-only mode. All output to files is suppressed.";
            }
        }
        return "(" + OpenApiDefinition.class.getName() + ") Unknown message with number: " + mnr;
    }
}

