/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.OpenApi;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.OpenApi.ConformanceClass;
import de.interactive_instruments.ShapeChange.Target.OpenApi.OpenApiDefinition;
import de.interactive_instruments.ShapeChange.Target.OpenApi.OpenApiDefinitionProcessingPhase;
import de.interactive_instruments.ShapeChange.Target.OpenApi.QueryParameter;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OpenApiConfigItems
implements MessageSource {
    protected List<ConformanceClass> conformanceClasses = new ArrayList<ConformanceClass>();
    protected List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();

    public OpenApiConfigItems(ShapeChangeResult result, Element apcs) throws Exception {
        boolean ioExceptionOccurred = false;
        NodeList ccNl = apcs.getElementsByTagName("ConformanceClass");
        List<Element> ccEs = XMLUtil.getElementNodes(ccNl);
        for (int i = 0; i < ccEs.size(); ++i) {
            String indexForMsg = "" + (i + 1);
            Element ccE = ccEs.get(i);
            ConformanceClass cc = new ConformanceClass();
            String uri = ccE.getAttribute("uri").trim();
            if (uri.length() == 0) {
                result.addError(this, 11, "uri", indexForMsg);
                continue;
            }
            cc.uri = uri;
            String overlay = ccE.getAttribute("overlay").trim();
            if (overlay.length() == 0) {
                if (uri.equalsIgnoreCase("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core")) {
                    overlay = "https://shapechange.net/resources/openapi/overlays/features-1-10-core.json";
                } else if (uri.equalsIgnoreCase("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson")) {
                    overlay = "https://shapechange.net/resources/openapi/overlays/features-1-10-geojson.json";
                } else if (uri.equalsIgnoreCase("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/html")) {
                    overlay = "https://shapechange.net/resources/openapi/overlays/features-1-10-html.json";
                } else if (uri.equalsIgnoreCase("http://www.opengis.net/spec/ogcapi-features-2/1.0/conf/crs")) {
                    overlay = "https://shapechange.net/resources/openapi/overlays/features-2-10-crs.json";
                } else {
                    result.addError(this, 10, "overlay", indexForMsg);
                    continue;
                }
            }
            try {
                JsonObject overlayJson;
                cc.overlay = overlayJson = OpenApiDefinition.loadJson(overlay);
            }
            catch (IOException e) {
                ioExceptionOccurred = true;
                result.addError(this, 14, indexForMsg, cc.uri, overlay, e.getMessage());
                continue;
            }
            String param = ccE.getAttribute("param").trim();
            cc.param = param.length() == 0 ? Optional.empty() : Optional.of(param);
            this.conformanceClasses.add(cc);
        }
        NodeList qpNl = apcs.getElementsByTagName("QueryParameter");
        List<Element> qpEs = XMLUtil.getElementNodes(qpNl);
        for (int i = 0; i < qpEs.size(); ++i) {
            String indexForMsg = "" + (i + 1);
            Element qpE = qpEs.get(i);
            QueryParameter qp = new QueryParameter();
            String name = qpE.getAttribute("name").trim();
            if (name.length() == 0) {
                result.addError(this, 12, "name", indexForMsg);
                continue;
            }
            qp.name = name;
            String overlay = qpE.getAttribute("overlay").trim();
            if (overlay.length() == 0) {
                result.addError(this, 12, "overlay", indexForMsg);
                continue;
            }
            try {
                JsonObject overlayJson;
                qp.overlay = overlayJson = OpenApiDefinition.loadJson(overlay);
            }
            catch (IOException e) {
                ioExceptionOccurred = true;
                result.addError(this, 16, indexForMsg, qp.name, overlay, e.getMessage());
                continue;
            }
            String param = qpE.getAttribute("appliesToPhase").trim();
            if (param.length() != 0) {
                switch (param) {
                    case "pre-feature-identification": {
                        qp.phase = OpenApiDefinitionProcessingPhase.PRE_FEATURE_IDENTIFICATION;
                        break;
                    }
                    default: {
                        qp.phase = OpenApiDefinitionProcessingPhase.FINALIZATION;
                    }
                }
            }
            this.queryParameters.add(qp);
        }
        if (ioExceptionOccurred) {
            throw new Exception("An IOException occurred. Consult the log for further details");
        }
    }

    public List<ConformanceClass> getConformanceClasses() {
        return this.conformanceClasses;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void setConformanceClasses(List<ConformanceClass> conformanceClasses) {
        if (conformanceClasses != null) {
            this.conformanceClasses = conformanceClasses;
        }
    }

    public void setQueryParameters(List<QueryParameter> queryParameters) {
        if (queryParameters != null) {
            this.queryParameters = queryParameters;
        }
    }

    public Optional<ConformanceClass> conformanceClass(String conformanceClassUri) {
        return this.conformanceClasses.stream().filter(cc -> cc.uri.equalsIgnoreCase(conformanceClassUri)).findFirst();
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 10: {
                return "'$1$' attribute of $2$ ConformanceClass element is empty, with no default being defined for the conformance class. ConformanceClass will be ignored.";
            }
            case 11: {
                return "'$1$' attribute of $2$ ConformanceClass element is empty which is not allowed. ConformanceClass will be ignored.";
            }
            case 12: {
                return "'$1$' attribute of $2$ QueryParameter element is empty which is not allowed. QueryParameter will be ignored.";
            }
            case 14: {
                return "Could not load JSON overlay for $1$ ConformanceClass with uri '$2$' from: '$3$'. ConformanceClass will be ignored. Exception message is: $4$";
            }
            case 16: {
                return "Could not load JSON overlay for $1$ QueryParameter with name '$2$' from: '$3$'. QueryParameter will be ignored. Exception message is: $4$";
            }
        }
        return "(OpenApiConfigItems.java) Unknown message with number: " + mnr;
    }
}

