/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ontology;

import de.interactive_instruments.ShapeChange.Target.Ontology.RdfPropertyValue;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public abstract class RdfGeneralProperty {
    private String namespaceAbbreviation;
    private String name;
    private String namespace = null;
    private String domain;
    private boolean domainByUnionOfSubPropertyDomains;
    private String range;
    private SortedSet<String> equivalentProperty;
    private SortedSet<String> disjointProperty;
    private SortedSet<String> subPropertyOf;
    private SortedMap<String, List<RdfPropertyValue>> additionalPropertiesByQName = new TreeMap<String, List<RdfPropertyValue>>();

    public RdfGeneralProperty(Element gpE) {
        this.namespaceAbbreviation = XMLUtil.getTextContentOfFirstElement(gpE, "namespaceAbbreviation");
        this.name = XMLUtil.getTextContentOfFirstElement(gpE, "name");
        this.domain = XMLUtil.getTextContentOfFirstElement(gpE, "domain");
        this.domainByUnionOfSubPropertyDomains = XMLUtil.getTextContentOfFirstElement(gpE, "domainByUnionOfSubPropertyDomains") != null;
        this.range = XMLUtil.getTextContentOfFirstElement(gpE, "range");
        this.equivalentProperty = new TreeSet<String>(XMLUtil.getTextContentOfChildElements(gpE, "equivalentProperty"));
        this.disjointProperty = new TreeSet<String>(XMLUtil.getTextContentOfChildElements(gpE, "disjointProperty"));
        this.subPropertyOf = new TreeSet<String>(XMLUtil.getTextContentOfChildElements(gpE, "subPropertyOf"));
        List<Element> additionalProps = XMLUtil.getChildElements(gpE, "additionalProperty");
        for (Element ap : additionalProps) {
            String propertyQName = XMLUtil.getTextContentOfFirstElement(ap, "property");
            ArrayList<RdfPropertyValue> values = new ArrayList<RdfPropertyValue>();
            List<Element> valueEs = XMLUtil.getChildElements(ap, "value");
            for (Element valueE : valueEs) {
                String text = StringUtils.stripToEmpty((String)valueE.getTextContent());
                String lang = StringUtils.stripToNull((String)valueE.getAttribute("lang"));
                boolean isIRI = XMLUtil.parseBoolean(valueE.getAttribute("isIRI"));
                RdfPropertyValue rpv = new RdfPropertyValue(text, lang, isIRI);
                values.add(rpv);
            }
            this.additionalPropertiesByQName.put(propertyQName, values);
        }
    }

    public String getNamespaceAbbreviation() {
        return this.namespaceAbbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isDomainByUnionOfSubPropertyDomains() {
        return this.domainByUnionOfSubPropertyDomains;
    }

    public String getRange() {
        return this.range;
    }

    public SortedSet<String> getEquivalentProperty() {
        return this.equivalentProperty;
    }

    public SortedSet<String> getDisjointProperty() {
        return this.disjointProperty;
    }

    public SortedSet<String> getSubPropertyOf() {
        return this.subPropertyOf;
    }

    public SortedMap<String, List<RdfPropertyValue>> getAdditionalProperties() {
        return this.additionalPropertiesByQName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getURI() {
        return this.namespace + this.name;
    }

    public boolean hasRange() {
        return this.range != null;
    }

    public boolean hasDomain() {
        return this.domain != null;
    }
}

