/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ontology;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Type;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RDF
implements Target,
MessageSource {
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_TV_FOR_TITLE = "taggedValueForTitle";
    public static final String PARAM_TV_FOR_CODE = "taggedValueForCode";
    public static final String PARAM_CODELIST_ONLY = "codeListOnly";
    public static final String PARAM_ID_REPLACE_PATTERN = "idReplacePattern";
    public static final String PARAM_ID_REPLACE_CHAR = "idReplaceChar";
    public static final String W3C_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String W3C_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String W3C_OWL = "http://www.w3.org/2002/07/owl#";
    public static final String W3C_OWL2XML = "http://www.w3.org/2006/12/owl2-xml#";
    public static final String DC = "http://purl.org/dc/elements/1.1/";
    public static final String OGC_GEOSPARQL = "http://www.opengis.net/geosparql#";
    public static final String W3C_SKOS = "http://www.w3.org/2004/02/skos/core#";
    private HashSet<PropertyInfo> exportedRoles = new HashSet();
    private HashSet<PropertyInfo> exportedProperties = new HashSet();
    private boolean error = false;
    private boolean printed = false;
    private String language = "en";
    private String outputDirectory = null;
    private Element root = null;
    private String encoding = null;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private Document document = null;
    private String ns = null;
    private String taggedValueForTitle = null;
    private String taggedValueForCode = null;
    private String idReplacePattern = null;
    private String idReplaceChar = "-";
    private boolean codeListOnly = false;

    @Override
    public String getTargetName() {
        return "RDF";
    }

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = ".";
        }
        this.language = this.options.parameter(this.getClass().getName(), PARAM_LANGUAGE);
        if (this.language == null) {
            this.language = "en";
        }
        this.taggedValueForTitle = this.options.parameter(this.getClass().getName(), PARAM_TV_FOR_TITLE);
        this.taggedValueForCode = this.options.parameter(this.getClass().getName(), PARAM_TV_FOR_CODE);
        this.encoding = this.model.characterEncoding();
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_CODELIST_ONLY)) != null && s.equalsIgnoreCase("true")) {
            this.codeListOnly = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_ID_REPLACE_PATTERN)) != null && !s.isEmpty()) {
            this.idReplacePattern = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_ID_REPLACE_CHAR)) != null && !s.isEmpty()) {
            this.idReplaceChar = s;
        }
        this.document = this.createDocument();
        this.document.appendChild(this.document.createComment("Created using ShapeChange - http://shapechange.net/"));
        this.root = this.document.createElementNS(W3C_RDF, "RDF");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns:rdf", W3C_RDF);
        this.addAttribute(this.document, this.root, "xmlns:owl", W3C_OWL);
        this.addAttribute(this.document, this.root, "xmlns:skos", W3C_SKOS);
        if (!this.codeListOnly) {
            this.addAttribute(this.document, this.root, "xmlns:rdfs", W3C_RDFS);
            this.addAttribute(this.document, this.root, "xmlns:owl2xml", W3C_OWL2XML);
            this.addAttribute(this.document, this.root, "xmlns:dc", DC);
            this.addAttribute(this.document, this.root, "xmlns:xsd", "http://www.w3.org/2001/XMLSchema#");
        }
        this.addAttribute(this.document, this.root, "xml:base", this.pi.targetNamespace());
        this.ns = this.pi.targetNamespace() + "#";
        this.addAttribute(this.document, this.root, "xmlns:" + this.pi.xmlns(), this.ns);
        if (!this.codeListOnly) {
            Element e0 = this.document.createElementNS(W3C_OWL, "Ontology");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "");
            Element e1 = this.document.createElementNS(W3C_OWL, "imports");
            this.addAttribute(this.document, e1, "rdf:resource", OGC_GEOSPARQL);
            e0.appendChild(e1);
            e0 = this.document.createElementNS(W3C_OWL, "AnnotationProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://purl.org/dc/elements/1.1/source");
            e0 = this.document.createElementNS(W3C_OWL, "AnnotationProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://purl.org/dc/elements/1.1/description");
            e0 = this.document.createElementNS(W3C_OWL, "AnnotationProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2004/02/skos/core#historyNote");
            e0 = this.document.createElementNS(W3C_OWL, "AnnotationProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2004/02/skos/core#prefLabel");
            e0 = this.document.createElementNS(W3C_OWL, "AnnotationProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2004/02/skos/core#definition");
            e0 = this.document.createElementNS(W3C_OWL, "ObjectProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.opengis.net/geosparql#defaultGeometry");
            e0 = this.document.createElementNS(W3C_OWL, "ObjectProperty");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2004/02/skos/core#inScheme");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.opengis.net/geosparql#Feature");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.opengis.net/geosparql#Point");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.opengis.net/geosparql#Curve");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.opengis.net/geosparql#Surface");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.opengis.net/geosparql#Geometry");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2002/07/owl#Thing");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2002/07/owl#Concept");
            e0 = this.document.createElementNS(W3C_OWL, "Class");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", "http://www.w3.org/2002/07/owl#ConceptScheme");
            e0 = this.document.createElementNS(W3C_RDF, "Description");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", this.pi.targetNamespace());
            s = this.documentation(this.pi);
            if (s != null && s.length() > 0) {
                e1 = this.document.createElementNS(DC, "description");
                this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
                e0.appendChild(e1);
                e1.setTextContent(s);
            }
        }
    }

    private String documentation(Info i) {
        Object s = this.getDef(i);
        if (s != null && ((String)s).length() > 0) {
            String s2 = this.getDesc(this.pi);
            if (s2 != null && s2.length() > 0) {
                s = (String)s + "\n\n" + s2;
            }
            s = ((String)s).replace("\r", "").trim();
        }
        return s;
    }

    private String PrepareToPrint(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    @Override
    public void process(ClassInfo ci) {
        if (this.error) {
            return;
        }
        int cat = ci.category();
        switch (cat) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.codeListOnly) break;
                this.PrintClass(ci);
                break;
            }
            case 2: 
            case 3: {
                this.PrintValues(ci);
            }
        }
    }

    private String uri(String v) {
        try {
            URI uri = null;
            if (!v.contains("#")) {
                uri = new URI(null, v, null);
            } else {
                String[] sa = v.split("#", 2);
                if (this.idReplacePattern != null) {
                    sa[1] = sa[1].replaceAll(this.idReplacePattern, this.idReplaceChar);
                }
                uri = new URI(null, sa[0], sa[1]);
            }
            v = uri.toString();
            if (v.startsWith(this.ns)) {
                v = v.replace(this.ns, "#");
            }
        }
        catch (URISyntaxException e) {
            this.result.addWarning(this, 1001, v);
        }
        return v;
    }

    private void PrintValues(ClassInfo ci) {
        Element e0 = this.document.createElementNS(W3C_SKOS, "ConceptScheme");
        this.root.appendChild(e0);
        this.addAttribute(this.document, e0, "rdf:about", this.uri(this.ns + ci.name()));
        Element e1 = this.document.createElementNS(W3C_RDF, "type");
        e0.appendChild(e1);
        this.addAttribute(this.document, e1, "rdf:resource", "http://www.w3.org/2002/07/owl#Thing");
        String s = ci.taggedValue("name");
        if (StringUtils.isBlank((CharSequence)s)) {
            s = ci.taggedValue("title");
        }
        if (StringUtils.isNotBlank((CharSequence)s)) {
            e1 = this.document.createElementNS(W3C_SKOS, "prefLabel");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
            this.addAttribute(this.document, e1, "xml:lang", this.language);
            e1.setTextContent(s);
        }
        if ((s = this.documentation(ci)) != null && s.length() > 0) {
            e1 = this.document.createElementNS(W3C_SKOS, "definition");
            this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
            this.addAttribute(this.document, e1, "xml:lang", this.language);
            e0.appendChild(e1);
            e1.setTextContent(s);
        }
        for (PropertyInfo propi : ci.properties().values()) {
            String s1;
            String code;
            if (propi == null || !this.ExportValue(propi)) continue;
            String label = null;
            if (this.taggedValueForTitle != null) {
                label = propi.taggedValue(this.taggedValueForTitle);
            }
            if (StringUtils.isBlank(label)) {
                label = this.PrepareToPrint(propi.name());
            }
            if ((code = propi.initialValue()) == null || code.length() == 0) {
                code = propi.name();
            }
            code = this.PrepareToPrint(code);
            e0 = this.document.createElementNS(W3C_SKOS, "Concept");
            this.root.appendChild(e0);
            this.addAttribute(this.document, e0, "rdf:about", this.uri(this.ns + ci.name() + "_" + code));
            e1 = this.document.createElementNS(W3C_RDF, "type");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "rdf:resource", "http://www.w3.org/2002/07/owl#Thing");
            e1 = this.document.createElementNS(W3C_SKOS, "prefLabel");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
            this.addAttribute(this.document, e1, "xml:lang", this.language);
            e1.setTextContent(label);
            if (!label.equalsIgnoreCase(code)) {
                e1 = this.document.createElementNS(W3C_SKOS, "hiddenLabel");
                e0.appendChild(e1);
                this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
                e1.setTextContent(code);
            }
            if (this.taggedValueForCode != null && StringUtils.isNotBlank((CharSequence)(s = propi.taggedValue(this.taggedValueForCode)))) {
                e1 = this.document.createElementNS(W3C_SKOS, "altLabel");
                e0.appendChild(e1);
                this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
                this.addAttribute(this.document, e1, "xml:lang", this.language);
                e1.setTextContent(s);
            }
            if (propi.matches("rule-rdf-prop-parent") && StringUtils.isNotBlank((CharSequence)(s = propi.taggedValue("parent"))) && StringUtils.isNotBlank((CharSequence)(s1 = ci.taggedValue("parent")))) {
                String[] sac;
                String[] sap = s.split(";");
                for (String sc : sac = s1.split(";")) {
                    ClassInfo cip = this.model.classByName(sc.trim());
                    if (cip == null) continue;
                    for (String sp : sap) {
                        sp = sp.trim();
                        String codep = null;
                        for (PropertyInfo propip : cip.properties().values()) {
                            if (propip == null || !propip.name().equalsIgnoreCase(sp)) continue;
                            codep = propip.initialValue();
                            if (codep == null || codep.length() == 0) {
                                codep = propip.name();
                            }
                            codep = this.PrepareToPrint(codep);
                            break;
                        }
                        if (codep == null) continue;
                        e1 = this.document.createElementNS(W3C_SKOS, "broader");
                        e0.appendChild(e1);
                        String nsp = cip.pkg().targetNamespace() + "#";
                        this.addAttribute(this.document, e1, "rdf:resource", this.uri(nsp + cip.name() + "_" + codep));
                    }
                }
            }
            if ((s = this.documentation(propi)) != null && s.length() > 0) {
                e1 = this.document.createElementNS(W3C_SKOS, "definition");
                this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
                this.addAttribute(this.document, e1, "xml:lang", this.language);
                e0.appendChild(e1);
                e1.setTextContent(s);
            }
            e1 = this.document.createElementNS(W3C_SKOS, "inScheme");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "rdf:resource", this.uri(this.ns + ci.name()));
        }
    }

    private boolean ExportItem(Info i) {
        return true;
    }

    private boolean ExportValue(PropertyInfo propi) {
        return this.ExportItem(propi);
    }

    private boolean ExportProperty(PropertyInfo propi) {
        if (propi.name().length() == 0) {
            return false;
        }
        return this.ExportItem(propi);
    }

    private boolean ExportClass(ClassInfo ci) {
        if (!ci.inSchema(this.pi)) {
            return false;
        }
        return this.ExportItem(ci);
    }

    private String getDef(Info i) {
        return this.PrepareToPrint(i.definition());
    }

    private String getDesc(Info i) {
        if (i.description() == null) {
            return null;
        }
        return this.PrepareToPrint(i.description());
    }

    private boolean InheritsFrom(ClassInfo ci, String nam) {
        for (String t : ci.supertypes()) {
            ClassInfo cix = this.model.classById(t);
            if (cix.name().equals(nam)) {
                return true;
            }
            if (!this.InheritsFrom(cix, nam)) continue;
            return true;
        }
        return false;
    }

    private String DetermineDefaultGeometry(ClassInfo ci) {
        for (PropertyInfo propi : ci.properties().values()) {
            Type ti = propi.typeInfo();
            if (ti.name.equals("GM_Point")) {
                return "Point";
            }
            if (ti.name.equals("GM_Curve")) {
                return "Curve";
            }
            if (ti.name.equals("GM_Surface")) {
                return "Surface";
            }
            if (ti.name.startsWith("GM_")) {
                return "Geometry";
            }
            if (ti.name.equals("GeometryInfo")) {
                return "Geometry";
            }
            ClassInfo cix = this.model.classById(ti.id);
            if (cix == null) continue;
            if (this.InheritsFrom(ci, "GM_Point")) {
                return "Point";
            }
            if (this.InheritsFrom(ci, "GM_Curve")) {
                return "Curve";
            }
            if (this.InheritsFrom(ci, "GM_Surface")) {
                return "Surface";
            }
            if (this.InheritsFrom(ci, "GM_Object")) {
                return "Geometry";
            }
            if (!this.InheritsFrom(ci, "GM_Primitive")) continue;
            return "Geometry";
        }
        return null;
    }

    private void PrintClass(ClassInfo ci) {
        String s;
        String g;
        Element e1;
        if (!this.ExportClass(ci)) {
            return;
        }
        Element e0 = this.document.createElementNS(W3C_OWL, "Class");
        this.root.appendChild(e0);
        this.addAttribute(this.document, e0, "rdf:about", this.uri(this.ns + ci.name()));
        boolean feature = false;
        for (String t : ci.supertypes()) {
            ClassInfo cix = this.model.classById(t);
            e1 = this.document.createElementNS(W3C_RDFS, "subClassOf");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "rdf:resource", this.uri(cix.pkg().targetNamespace() + "#" + cix.name()));
            if (cix.category() != 1) continue;
            feature = true;
        }
        if (ci.category() == 1 && !feature) {
            e1 = this.document.createElementNS(W3C_RDFS, "subClassOf");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "rdf:resource", "http://www.opengis.net/geosparql#Feature");
        }
        if ((g = this.DetermineDefaultGeometry(ci)) != null) {
            e1 = this.document.createElementNS(W3C_RDFS, "subClassOf");
            e0.appendChild(e1);
            Element e2 = this.document.createElementNS(W3C_OWL, "Restriction");
            e1.appendChild(e2);
            Element e3 = this.document.createElementNS(W3C_OWL, "onProperty");
            this.addAttribute(this.document, e3, "rdf:resource", "http://www.opengis.net/geosparql#defaultGeometry");
            e2.appendChild(e3);
            e3 = this.document.createElementNS(W3C_OWL, "allValuesFrom");
            this.addAttribute(this.document, e3, "rdf:resource", OGC_GEOSPARQL + g);
            e2.appendChild(e3);
        }
        if (this.taggedValueForTitle != null && StringUtils.isNotBlank((CharSequence)(s = ci.taggedValue(this.taggedValueForTitle)))) {
            e1 = this.document.createElementNS(W3C_RDFS, "label");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "xml:lang", this.language);
            e1.setTextContent(s);
        }
        if ((s = this.documentation(ci)) != null && s.length() > 0) {
            e1 = this.document.createElementNS(DC, "description");
            this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
            e0.appendChild(e1);
            e1.setTextContent(s);
        }
        for (PropertyInfo propi : ci.properties().values()) {
            this.PrintProperty(propi);
        }
    }

    private void PrintProperty(PropertyInfo propi) {
        if (!this.ExportProperty(propi)) {
            return;
        }
        if (this.exportedProperties.contains(propi)) {
            return;
        }
        Object assocId = "__FIXME";
        if (!propi.isAttribute()) {
            if (!this.exportedRoles.contains(propi)) {
                assocId = "__" + propi.id();
                this.PrintPropertyDetail(propi, (String)assocId);
                this.exportedRoles.add(propi);
                PropertyInfo propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    if (this.ExportProperty(propi2)) {
                        this.PrintPropertyDetail(propi2, (String)assocId);
                    }
                    this.exportedRoles.add(propi2);
                }
            } else {
                PropertyInfo propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    assocId = "__" + propi2.id();
                }
            }
        } else {
            this.PrintPropertyDetail(propi, (String)assocId);
        }
        this.exportedProperties.add(propi);
    }

    private void PrintPropertyDetail(PropertyInfo propi, String assocId) {
        Element e1;
        String cn = propi.inClass().name();
        Element e0 = this.document.createElementNS(W3C_OWL, "DatatypeProperty");
        this.root.appendChild(e0);
        this.addAttribute(this.document, e0, "rdf:about", this.uri(this.PrepareToPrint(this.ns + cn + "." + propi.name())));
        String s = this.documentation(propi);
        if (s != null && s.length() > 0) {
            e1 = this.document.createElementNS(DC, "description");
            this.addAttribute(this.document, e1, "rdf:datatype", "http://www.w3.org/2001/XMLSchema#string");
            e0.appendChild(e1);
            e1.setTextContent(s);
        }
        if (this.taggedValueForTitle != null && StringUtils.isNotBlank((CharSequence)(s = propi.taggedValue(this.taggedValueForTitle)))) {
            e1 = this.document.createElementNS(W3C_RDFS, "label");
            e0.appendChild(e1);
            this.addAttribute(this.document, e1, "xml:lang", this.language);
            e1.setTextContent(s);
        }
        e1 = this.document.createElementNS(W3C_RDFS, "domain");
        this.addAttribute(this.document, e1, "rdf:resource", this.uri(this.ns + cn));
        e0.appendChild(e1);
        Type ti = propi.typeInfo();
        if (!propi.isAttribute()) {
            ClassInfo cix;
            if (ti != null && (cix = this.model.classById(ti.id)) != null) {
                e1 = this.document.createElementNS(W3C_RDFS, "range");
                this.addAttribute(this.document, e1, "rdf:resource", this.uri(cix.pkg().targetNamespace() + "#" + cix.name()));
                e0.appendChild(e1);
            }
        } else if (ti != null) {
            ClassInfo cix = this.model.classById(ti.id);
            if (cix != null) {
                int cat = cix.category();
                switch (cat) {
                    case 2: 
                    case 3: {
                        e1 = this.document.createElementNS(W3C_RDFS, "range");
                        this.addAttribute(this.document, e1, "rdf:resource", "http://www.w3.org/2004/02/skos/core#Concept");
                        e0.appendChild(e1);
                        e1 = this.document.createElementNS(W3C_SKOS, "definition");
                        this.addAttribute(this.document, e1, "rdf:resource", this.uri(this.ns + cix.name()));
                        e0.appendChild(e1);
                        break;
                    }
                    default: {
                        s = this.mapTypeByName(ti.name);
                        if (s == null) {
                            s = this.uri(cix.pkg().targetNamespace() + "#" + cix.name());
                        }
                        e1 = this.document.createElementNS(W3C_RDFS, "range");
                        this.addAttribute(this.document, e1, "rdf:resource", s);
                        e0.appendChild(e1);
                        break;
                    }
                }
            } else {
                s = this.mapTypeByName(ti.name);
                if (s != null) {
                    e1 = this.document.createElementNS(W3C_RDFS, "range");
                    this.addAttribute(this.document, e1, "rdf:resource", s);
                    e0.appendChild(e1);
                }
            }
        }
    }

    private String mapTypeByName(String nam) {
        Object s = null;
        MapEntry me = this.options.baseMapEntry(nam, "iso19136_2007");
        if (me != null && !me.p1.equals("")) {
            s = me.p1;
            int idx = ((String)s).indexOf(":");
            if (idx > 0) {
                String nsabr = ((String)s).substring(0, idx);
                s = this.uri(((String)s).replace(nsabr + ":", this.options.fullNamespace(nsabr) + "#"));
            } else {
                s = "http://www.w3.org/2001/XMLSchema#" + (String)s;
            }
        }
        return s;
    }

    @Override
    public void write() {
        if (this.error || this.printed) {
            return;
        }
        File outputDirectoryFile = new File(this.outputDirectory);
        boolean exi = outputDirectoryFile.exists();
        if (!exi) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            this.result.addFatalError(this, 12, this.outputDirectory);
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", this.encoding);
        String fileName = this.pi.name().replace("/", "_").replace(" ", "_") + ".rdf";
        try {
            FileOutputStream fout = new FileOutputStream(this.outputDirectory + "/" + fileName);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, outputFormat.getProperty("encoding"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            this.result.addResult(this.getTargetName(), this.outputDirectory, fileName, this.pi.targetNamespace() + "#");
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-rdf-prop-parent");
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetIdentifier() {
        return "rdf";
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 1001: {
                return "URI '$1$' is invalid, but could not be converted to a valid URI.";
            }
        }
        return null;
    }

    @Override
    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "XML Schema Target: " + mess;
    }
}

