/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ontology;

import de.interactive_instruments.ShapeChange.ConstraintMapping;
import de.interactive_instruments.ShapeChange.DescriptorTarget;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.PropertyConversionParameter;
import de.interactive_instruments.ShapeChange.RdfPropertyMapEntry;
import de.interactive_instruments.ShapeChange.RdfTypeMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StereotypeConversionParameter;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Target.Ontology.GeneralDataProperty;
import de.interactive_instruments.ShapeChange.Target.Ontology.GeneralObjectProperty;
import de.interactive_instruments.ShapeChange.Target.Ontology.ISO19150_2;
import de.interactive_instruments.ShapeChange.Target.Ontology.OWLISO19150;
import de.interactive_instruments.ShapeChange.Target.Ontology.PropertyAxiom;
import de.interactive_instruments.ShapeChange.Target.Ontology.RdfGeneralProperty;
import de.interactive_instruments.ShapeChange.Target.Ontology.RdfPropertyValue;
import de.interactive_instruments.ShapeChange.Target.Ontology.SKOS;
import de.interactive_instruments.ShapeChange.TargetOwlConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.TypeConversionParameter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.CardinalityRestriction;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.IntersectionClass;
import org.apache.jena.ontology.MaxCardinalityRestriction;
import org.apache.jena.ontology.MinCardinalityRestriction;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.OWL2;

public class OntologyModel
implements MessageSource {
    private OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    private Ontology ontology = null;
    private OntModel refmodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    private Options options = null;
    public ShapeChangeResult result = null;
    private Model model = null;
    private PackageInfo mpackage = null;
    private Pattern descriptorTargetTaggedValuePattern = Pattern.compile("TV(\\(.+?\\))?:(.+)");
    private String name;
    private String fileName;
    private String rdfNamespace;
    private String prefix;
    private OWLISO19150 owliso19150;
    private boolean finalized = false;
    private String path;
    private SortedSet<ClassInfo> classInfos = new TreeSet<ClassInfo>();
    private Resource defaultTypeImplementation;
    private TargetOwlConfiguration config;
    private SortedMap<String, OwlProperty> properties = new TreeMap<String, OwlProperty>();
    private SortedMap<String, OwlGeneralProperty> generalProperties = new TreeMap<String, OwlGeneralProperty>();
    protected SortedMap<ClassInfo, Resource> resourceByClassInfo = new TreeMap<ClassInfo, Resource>();
    private SortedMap<ClassInfo, OntClass> ontClassByClassInfo = new TreeMap<ClassInfo, OntClass>();
    private SortedMap<PropertyInfo, OntProperty> ontPropertyByPropertyInfo = new TreeMap<PropertyInfo, OntProperty>();
    private SortedMap<PropertyInfo, Resource> rangeByPropertyInfo = new TreeMap<PropertyInfo, Resource>();
    private ConstraintMapping defaultConstraintMapping = new ConstraintMapping(null, "iso19150-2:constraint", "[[name]]: [[text]]", "", " ", ConstraintMapping.Format.STRING);
    private SortedSet<String> uniquePropertyNames = new TreeSet<String>();

    private OntologyModel(Model m, Options o, ShapeChangeResult r, String xmlprefix, OWLISO19150 owliso19150) {
        this.model = m;
        this.options = o;
        this.result = r;
        this.prefix = xmlprefix;
        this.owliso19150 = owliso19150;
        this.config = this.owliso19150.getConfig();
        this.ontmodel.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.ontmodel.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.ontmodel.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        this.ontmodel.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        if (owliso19150.getDefaultTypeImplementation() == null) {
            this.defaultTypeImplementation = OWL.Class;
            this.result.addInfo(this, 40, "owl:Class");
        } else {
            String dti = owliso19150.getDefaultTypeImplementation();
            this.defaultTypeImplementation = this.mapClass(dti);
            this.result.addInfo(this, 40, dti);
        }
    }

    public OntologyModel(PackageInfo pi, Model m, Options o, ShapeChangeResult r, String xmlprefix, OWLISO19150 owliso19150) throws ShapeChangeAbortException {
        this(m, o, r, xmlprefix, owliso19150);
        String version;
        String ontologyNameTVName;
        this.mpackage = pi;
        Object ontologyName = null;
        String uriBase = owliso19150.getUriBase() != null ? owliso19150.getUriBase() : this.mpackage.targetNamespace();
        if (this.mpackage.matches("rule-owl-pkg-ontologyName-byTaggedValue") && StringUtils.isBlank((CharSequence)(ontologyName = this.mpackage.taggedValue(ontologyNameTVName = owliso19150.getOntologyNameTaggedValue())))) {
            this.result.addWarning(this, 26, "rule-owl-pkg-ontologyName-byTaggedValue", ontologyNameTVName, this.mpackage.fullNameInSchema());
        }
        if (ontologyName == null) {
            Object path;
            if (this.mpackage.matches("rule-owl-pkg-singleOntologyPerSchema") && this.mpackage.matches("rule-owl-pkg-ontologyName-code")) {
                String code = this.computeOntologyNameCode();
                path = "/" + code;
            } else if (this.mpackage.matches("rule-owl-pkg-ontologyName-withPath")) {
                path = OntologyModel.computePath(this.mpackage);
            } else {
                if (!this.mpackage.matches("rule-owl-pkg-ontologyName-iso191502")) {
                    this.result.addWarning(this, 27, this.mpackage.fullNameInSchema());
                }
                path = "/" + OntologyModel.normalizedName(this.mpackage);
            }
            ontologyName = uriBase + (String)path;
        }
        if (this.mpackage.matches("rule-owl-pkg-ontologyName-appendVersion") && (version = this.mpackage.version()) != null && version.trim().length() > 0) {
            ontologyName = (String)ontologyName + "/" + version.trim();
        }
        this.name = ontologyName;
        if (this.mpackage.matches("rule-owl-pkg-singleOntologyPerSchema") && this.mpackage.matches("rule-owl-pkg-ontologyName-code")) {
            this.fileName = this.computeOntologyNameCode();
            this.path = "";
        } else {
            this.fileName = OntologyModel.normalizedName(pi);
            this.path = OntologyModel.computePath(pi);
        }
        SortedSet<ClassInfo> relevantClasses = this.mpackage.matches("rule-owl-pkg-singleOntologyPerSchema") ? this.model.classes(this.mpackage) : this.mpackage.containedClasses();
        TreeSet<String> encounteredPropertyNames = new TreeSet<String>();
        for (ClassInfo ci : relevantClasses) {
            for (PropertyInfo prop : ci.properties().values()) {
                if (encounteredPropertyNames.contains(prop.name())) {
                    this.uniquePropertyNames.remove(prop.name());
                    continue;
                }
                encounteredPropertyNames.add(prop.name());
                this.uniquePropertyNames.add(prop.name());
            }
        }
        this.rdfNamespace = this.name + owliso19150.getRdfNamespaceSeparator();
        this.ontmodel.setNsPrefix(this.prefix, this.rdfNamespace);
        this.ontology = this.ontmodel.createOntology(this.name);
        if (this.mpackage.matches("rule-owl-pkg-versionInfo") && this.mpackage.version() != null && !this.mpackage.version().trim().isEmpty()) {
            this.ontology.addVersionInfo(this.mpackage.version());
        }
        if (this.mpackage.matches("rule-owl-pkg-versionIRI") && this.mpackage.version() != null && !this.mpackage.version().trim().isEmpty()) {
            if (this.mpackage.matches("rule-owl-pkg-ontologyName-appendVersion") && this.mpackage.matches("rule-owl-pkg-versionIRI-avoid-duplicate-version")) {
                this.ontology.addProperty(OWL2.versionIRI, this.name);
            } else {
                this.ontology.addProperty(OWL2.versionIRI, this.name + "/" + this.mpackage.version());
            }
        }
        if (this.mpackage.matches("rule-owl-pkg-importISO191502Base")) {
            this.addImport("http://def.isotc211.org/iso19150/-2/2012/base#", this.config.locationOfNamespace("http://def.isotc211.org/iso19150/-2/2012/base#"));
        }
        if (this.mpackage.matches("rule-owl-pkg-dctSourceTitle")) {
            this.ontmodel.setNsPrefix("dct", "http://purl.org/dc/terms/");
            this.ontology.addProperty(DCTerms.source, owliso19150.computeSource(this.mpackage), owliso19150.getLanguage());
        }
        this.applyDescriptorTargets((OntResource)this.ontology, this.mpackage, DescriptorTarget.AppliesTo.ONTOLOGY);
    }

    public OntologyModel(Model m, Options o, ShapeChangeResult r, String prefix, String rdfns, String name, String path, String fileName, OWLISO19150 owliso19150) throws ShapeChangeAbortException {
        this(m, o, r, prefix, owliso19150);
        this.name = name;
        this.path = path;
        this.fileName = fileName;
        this.rdfNamespace = rdfns;
        this.ontmodel.setNsPrefix(prefix, this.rdfNamespace);
        this.ontology = this.ontmodel.createOntology(name);
    }

    private String computeOntologyNameCode() {
        String onc = this.owliso19150.getOntologyNameCodeParameterValue();
        String xmlns = this.mpackage.xmlns();
        if (onc != null && onc.trim().length() > 0) {
            return onc;
        }
        if (xmlns != null && xmlns.trim().length() > 0) {
            return this.mpackage.xmlns();
        }
        return "FIXME";
    }

    public static String normalizedName(ClassInfo ci) {
        String result = ci.name();
        result = result.replaceAll(" ", "");
        result = result.replaceAll("[\\p{Punct}&&[^-_]]", "_");
        char[] characters = result.toCharArray();
        String firstChar = String.valueOf(characters[0]);
        firstChar = firstChar.toUpperCase();
        characters[0] = firstChar.charAt(0);
        result = String.valueOf(characters);
        return result;
    }

    public static String computePath(PackageInfo pi) {
        String ownerTargetNamespace;
        String result = "/" + OntologyModel.normalizedName(pi);
        if (pi.owner() != null && (ownerTargetNamespace = pi.owner().targetNamespace()) != null && ownerTargetNamespace.equals(pi.targetNamespace())) {
            String parentPath = OntologyModel.computePath(pi.owner());
            result = parentPath + result;
        }
        return result;
    }

    public static String computeBackPath(PackageInfo pi) {
        String ownerTargetNamespace;
        Object result = "../";
        if (pi.owner() != null && (ownerTargetNamespace = pi.owner().targetNamespace()) != null && ownerTargetNamespace.equals(pi.targetNamespace())) {
            result = (String)result + OntologyModel.computeBackPath(pi.owner());
        }
        return result;
    }

    public static String normalizedName(PackageInfo pi) {
        String result = pi.name();
        result = result.replaceAll(" ", "");
        result = result.replaceAll("[\\p{Punct}&&[^-_]]", "_");
        result = result.toLowerCase(Locale.ENGLISH);
        return result;
    }

    public void createClasses() {
        block10: for (ClassInfo ci : this.classInfos) {
            RdfTypeMapEntry rtme = this.config.getTypeMapEntry(ci);
            if (rtme != null) {
                Resource r = this.mapClass(rtme.getTarget());
                this.resourceByClassInfo.put(ci, r);
                continue;
            }
            int cat = ci.category();
            switch (cat) {
                case 1: {
                    if (ci.matches("rule-owl-cls-encode-featuretypes")) {
                        this.addClassDefinition(ci);
                        break;
                    }
                }
                case 6: {
                    if (ci.matches("rule-owl-cls-encode-objecttypes")) {
                        this.addClassDefinition(ci);
                        break;
                    }
                }
                case 4: {
                    if (ci.matches("rule-owl-cls-encode-mixintypes")) {
                        this.addClassDefinition(ci);
                        break;
                    }
                }
                case 7: {
                    if (ci.matches("rule-owl-cls-encode-basictypes")) {
                        this.addClassDefinition(ci);
                        break;
                    }
                }
                case 5: {
                    if (ci.matches("rule-owl-cls-encode-datatypes")) {
                        this.addClassDefinition(ci);
                        break;
                    }
                }
                case 8: {
                    if (ci.matches("rule-owl-cls-union")) {
                        this.addClassDefinition(ci);
                        break;
                    }
                }
                case 3: {
                    if (!ci.matches("rule-owl-cls-enumerationAsCodelist") && !ci.matches("rule-owl-cls-iso191502Enumeration")) break;
                    if (ci.matches("rule-owl-cls-iso191502Enumeration")) {
                        if (ci.matches("rule-owl-cls-enumerationAsCodelist")) {
                            this.result.addWarning(this, 29, "rule-owl-cls-enumerationAsCodelist", "rule-owl-cls-iso191502Enumeration");
                        }
                        this.addEnumeration(ci);
                        break;
                    }
                }
                case 2: {
                    if (ci.matches("rule-owl-cls-codelist-19150-2") || ci.matches("rule-owl-cls-codelist-external")) {
                        this.addCodelist(ci);
                        break;
                    }
                }
                default: {
                    ShapeChangeResult.MessageContext mc2;
                    this.resourceByClassInfo.put(ci, this.defaultTypeImplementation);
                    if (this.owliso19150.isSuppressMessagesForUnsupportedCategoryOfClasses()) continue block10;
                    ShapeChangeResult.MessageContext mc = this.result.addInfo(this, 5, this.options.categoryName(cat));
                    if (mc != null) {
                        mc.addDetail(this, 10000, ci.fullName());
                    }
                    if ((mc2 = this.result.addInfo(this, 41, ci.name())) == null) continue block10;
                    mc2.addDetail(this, 10000, ci.fullName());
                }
            }
        }
    }

    public void createProperties() {
        for (ClassInfo ci : this.ontClassByClassInfo.keySet()) {
            int cat = ci.category();
            switch (cat) {
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.createNormalProperties(ci);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    public void createNormalProperties(ClassInfo ci) {
        SortedMap<StructuredNumber, PropertyInfo> pis = ci.properties();
        for (PropertyInfo pi : pis.values()) {
            if (!pi.matches("rule-owl-prop-general")) break;
            if (!pi.isNavigable()) continue;
            OntProperty p = this.addPropertyDeclaration(pi);
            this.ontPropertyByPropertyInfo.put(pi, p);
            Resource range = this.computeRange(pi);
            this.rangeByPropertyInfo.put(pi, range);
        }
    }

    public void createGeneralProperty(String nsabr, String namespace, RdfGeneralProperty gp) {
        String propAbout = namespace + gp.getName();
        if (!this.properties.containsKey(propAbout)) {
            OntProperty p;
            if (gp instanceof GeneralDataProperty) {
                DatatypeProperty dp = this.ontmodel.createDatatypeProperty(propAbout);
                p = dp.asProperty();
            } else {
                ObjectProperty op = this.ontmodel.createObjectProperty(propAbout);
                p = op.asProperty();
            }
            this.generalProperties.put(propAbout, new OwlGeneralProperty(gp, p));
            if (gp.hasRange()) {
                Resource range = this.mapClass(gp.getRange());
                p.addRange(range);
            }
            if (gp.hasDomain()) {
                Resource domain = this.mapClass(gp.getDomain());
                p.addDomain(domain);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Resource computeRange(PropertyInfo pi) {
        Resource range = null;
        if (this.rangeByPropertyInfo.containsKey(pi)) {
            return (Resource)this.rangeByPropertyInfo.get(pi);
        }
        RdfPropertyMapEntry rpme = this.config.getPropertyMapEntry(pi);
        if (rpme != null) {
            if (!rpme.hasRange()) return null;
            range = this.mapClass(rpme.getRange());
        } else {
            PropertyConversionParameter pcp = this.config.getPropertyConversionParameter(pi);
            if (pcp != null && pcp.hasTarget()) {
                PropertyInfo globalProp = this.getGlobalProperty(pcp);
                if (globalProp == null) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 36, pcp.getTarget(), pcp.getTargetSchema());
                    if (mc != null) {
                        mc.addDetail(this, 10001, pi.fullName());
                    }
                    range = this.mapType(pi);
                } else {
                    range = this.mapType(globalProp);
                }
            } else {
                String propAbout = this.computePropertyName(pi);
                if (this.properties.containsKey(propAbout)) {
                    OwlProperty p0 = (OwlProperty)this.properties.get(propAbout);
                    range = this.mapType(p0.pi);
                } else {
                    range = this.mapType(pi);
                }
            }
        }
        if (range == null) {
            range = this.defaultTypeImplementation;
            ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 42, pi.name());
            if (mc != null) {
                mc.addDetail(this, 10001, pi.fullName());
            }
        }
        this.rangeByPropertyInfo.put(pi, range);
        return range;
    }

    public PropertyInfo getGlobalProperty(PropertyConversionParameter pcp) {
        SortedSet<PackageInfo> schemas = this.model.schemas(pcp.getTargetSchema());
        if (schemas != null && schemas.size() == 1) {
            String[] qnameParts = pcp.getTarget().split("::");
            PackageInfo schema = schemas.first();
            SortedSet<ClassInfo> schemaCis = this.model.classes(schema);
            for (ClassInfo schemaCi : schemaCis) {
                if (!schemaCi.name().equals(qnameParts[0])) continue;
                for (PropertyInfo prop : schemaCi.properties().values()) {
                    if (!prop.name().equals(qnameParts[1])) continue;
                    return prop;
                }
            }
        }
        return null;
    }

    public void createAdditionalClassDetails() {
        for (ClassInfo ci : this.ontClassByClassInfo.keySet()) {
            OntClass c = (OntClass)this.ontClassByClassInfo.get(ci);
            if ((ci.baseClass() != null || ci.supertypes() != null && !ci.supertypes().isEmpty()) && ci.matches("rule-owl-cls-generalization")) {
                String baseClassId = null;
                if (ci.baseClass() != null) {
                    Iterator supertype = ci.baseClass();
                    baseClassId = supertype.id();
                    this.mapAndAddSuperClass(ci, c, (ClassInfo)((Object)supertype));
                }
                if (ci.supertypes() != null && !ci.supertypes().isEmpty()) {
                    for (String ciId : ci.supertypes()) {
                        if (baseClassId != null && baseClassId.equals(ciId)) continue;
                        ClassInfo supertype = this.model.classById(ciId);
                        this.mapAndAddSuperClass(ci, c, supertype);
                    }
                }
            }
            if (ci.subtypes() != null && !ci.subtypes().isEmpty() && ci.subtypes().size() > 1 && ci.matches("rule-owl-cls-disjoint-classes")) {
                TreeMap<String, Resource> subtypeResources = new TreeMap<String, Resource>();
                for (String ciId : ci.subtypes()) {
                    ClassInfo subtype = this.model.classById(ciId);
                    Resource mappedResource = this.map(subtype);
                    if (mappedResource == null) {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 28, subtype.name(), ci.name());
                        if (mc == null) continue;
                        mc.addDetail(this, 10000, ci.fullName());
                        continue;
                    }
                    subtypeResources.put(mappedResource.getURI(), mappedResource);
                }
                if (subtypeResources.size() == 2) {
                    Iterator it = subtypeResources.values().iterator();
                    Resource r1 = (Resource)it.next();
                    Resource r2 = (Resource)it.next();
                    r1.addProperty(OWL2.disjointWith, (RDFNode)r2);
                } else {
                    OntClass adw = this.ontmodel.createClass();
                    adw.setRDFType(OWL2.AllDisjointClasses);
                    adw.addProperty(OWL2.members, (RDFNode)this.ontmodel.createList(subtypeResources.values().iterator()));
                }
            }
            if (ci.category() != 3 && ci.category() != 2) {
                SortedMap<StructuredNumber, PropertyInfo> pis = ci.properties();
                for (PropertyInfo pi : pis.values()) {
                    if (!pi.matches("rule-owl-prop-general")) break;
                    if (!pi.isNavigable()) continue;
                    OntProperty p = (OntProperty)this.ontPropertyByPropertyInfo.get(pi);
                    this.addMultiplicity(c, pi, p);
                    this.addAllValuesFrom(c, pi, (Property)p);
                }
            }
            this.addUnionSemantics(ci, c);
        }
    }

    protected void addUnionSemantics(ClassInfo ci, OntClass c) {
        SortedMap<StructuredNumber, PropertyInfo> pis = ci.properties();
        TreeMap<String, Object> sets = new TreeMap<String, Object>();
        String unionSetId = "INTERNAL_UNION_SET_IDENTIFIER";
        for (PropertyInfo pi : pis.values()) {
            Object set;
            if (!pi.isNavigable()) continue;
            if (!pi.matches("rule-owl-prop-general")) break;
            if (ci.category() == 8 && ci.matches("rule-owl-cls-union")) {
                SortedSet<PropertyInfo> set2;
                if (sets.containsKey(unionSetId)) {
                    set2 = (SortedSet)sets.get(unionSetId);
                } else {
                    set2 = new TreeSet();
                    sets.put(unionSetId, set2);
                }
                set2.add(pi);
                continue;
            }
            String tag = pi.taggedValue("SC_UNION_SET");
            if (!StringUtils.isNotBlank((CharSequence)tag) || !pi.inClass().matches("rule-owl-cls-unionSets")) continue;
            if (sets.containsKey(tag)) {
                set = (SortedSet)sets.get(tag);
            } else {
                set = new TreeSet();
                sets.put(tag, set);
            }
            set.add(pi);
        }
        for (SortedSet set : sets.values()) {
            if (set.size() == 1) continue;
            ArrayList<IntersectionClass> intersections = new ArrayList<IntersectionClass>();
            for (PropertyInfo pi_main : set) {
                ArrayList<OntClass> cardinalityRestrictions = new ArrayList<OntClass>();
                for (PropertyInfo pi_x : set) {
                    OntClass restriction;
                    OntProperty p = (OntProperty)this.ontPropertyByPropertyInfo.get(pi_x);
                    if (pi_x == pi_main) {
                        ArrayList<OntClass> pi_main_restrictions;
                        OntClass restriction_upper;
                        OntClass restriction_lower;
                        int lower = pi_main.cardinality().minOccurs;
                        int upper = pi_main.cardinality().maxOccurs;
                        Resource range = (Resource)this.rangeByPropertyInfo.get(pi_main);
                        if (pi_main.matches("rule-owl-prop-multiplicityAsUnqualifiedCardinalityRestriction") || range == null && pi_main.matches("rule-owl-prop-multiplicityAsQualifiedCardinalityRestriction")) {
                            if (lower == upper) {
                                restriction = this.createCardinalityRestriction(p, lower);
                            } else if (upper == Integer.MAX_VALUE) {
                                restriction = this.createMinCardinalityRestriction(p, lower);
                            } else if (lower == 0) {
                                restriction = this.createMaxCardinalityRestriction(p, upper);
                            } else {
                                restriction_lower = this.createMinCardinalityRestriction(p, lower);
                                restriction_upper = this.createMaxCardinalityRestriction(p, upper);
                                pi_main_restrictions = new ArrayList<OntClass>();
                                pi_main_restrictions.add(restriction_lower);
                                pi_main_restrictions.add(restriction_upper);
                                restriction = this.ontmodel.createIntersectionClass(null, this.ontmodel.createList(pi_main_restrictions.iterator()));
                            }
                        } else if (pi_main.matches("rule-owl-prop-multiplicityAsQualifiedCardinalityRestriction")) {
                            if (lower == upper) {
                                restriction = this.createQCardinalityRestriction(p, lower, range);
                            } else if (upper == Integer.MAX_VALUE) {
                                restriction = this.createQMinCardinalityRestriction(p, lower, range);
                            } else if (lower == 0) {
                                restriction = this.createQMaxCardinalityRestriction(p, upper, range);
                            } else {
                                restriction_lower = this.createQMinCardinalityRestriction(p, lower, range);
                                restriction_upper = this.createQMaxCardinalityRestriction(p, upper, range);
                                pi_main_restrictions = new ArrayList();
                                pi_main_restrictions.add(restriction_lower);
                                pi_main_restrictions.add(restriction_upper);
                                restriction = this.ontmodel.createIntersectionClass(null, this.ontmodel.createList(pi_main_restrictions.iterator()));
                            }
                        } else {
                            restriction = this.createMinCardinalityRestriction(p, 0);
                        }
                    } else {
                        restriction = this.createCardinalityRestriction(p, 0);
                    }
                    cardinalityRestrictions.add(restriction);
                }
                IntersectionClass intersectionRestriction = this.ontmodel.createIntersectionClass(null, this.ontmodel.createList(cardinalityRestrictions.iterator()));
                intersections.add(intersectionRestriction);
            }
            UnionClass unionOfRestriction = this.ontmodel.createUnionClass(null, this.ontmodel.createList(intersections.iterator()));
            c.addSuperClass((Resource)unionOfRestriction);
        }
    }

    public OntClass createQCardinalityRestriction(OntProperty p, int cardinality, Resource range) {
        CardinalityRestriction restriction = this.ontmodel.createCardinalityRestriction(null, (Property)p, cardinality);
        restriction.removeAll(OWL.cardinality);
        Literal cardAsNonNegativeInteger = this.ontmodel.createTypedLiteral((Object)cardinality, "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        restriction.addLiteral(OWL2.qualifiedCardinality, cardAsNonNegativeInteger);
        restriction.addProperty(OWL2.onClass, (RDFNode)range);
        return restriction;
    }

    public OntClass createQMinCardinalityRestriction(OntProperty p, int cardinality, Resource range) {
        MinCardinalityRestriction restriction = this.ontmodel.createMinCardinalityRestriction(null, (Property)p, cardinality);
        restriction.removeAll(OWL.minCardinality);
        Literal cardAsNonNegativeInteger = this.ontmodel.createTypedLiteral((Object)cardinality, "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        restriction.addLiteral(OWL2.minQualifiedCardinality, cardAsNonNegativeInteger);
        restriction.addProperty(OWL2.onClass, (RDFNode)range);
        return restriction;
    }

    public OntClass createQMaxCardinalityRestriction(OntProperty p, int cardinality, Resource range) {
        MaxCardinalityRestriction restriction = this.ontmodel.createMaxCardinalityRestriction(null, (Property)p, cardinality);
        restriction.removeAll(OWL.maxCardinality);
        Literal cardAsNonNegativeInteger = this.ontmodel.createTypedLiteral((Object)cardinality, "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        restriction.addLiteral(OWL2.maxQualifiedCardinality, cardAsNonNegativeInteger);
        restriction.addProperty(OWL2.onClass, (RDFNode)range);
        return restriction;
    }

    public OntClass createCardinalityRestriction(OntProperty p, int cardinality) {
        CardinalityRestriction restriction = this.ontmodel.createCardinalityRestriction(null, (Property)p, cardinality);
        restriction.removeAll(OWL.cardinality);
        Literal cardAsNonNegativeInteger = this.ontmodel.createTypedLiteral((Object)cardinality, "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        restriction.addLiteral(OWL.cardinality, cardAsNonNegativeInteger);
        return restriction;
    }

    public OntClass createMinCardinalityRestriction(OntProperty p, int cardinality) {
        MinCardinalityRestriction restriction = this.ontmodel.createMinCardinalityRestriction(null, (Property)p, cardinality);
        restriction.removeAll(OWL.minCardinality);
        Literal cardAsNonNegativeInteger = this.ontmodel.createTypedLiteral((Object)cardinality, "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        restriction.addLiteral(OWL.minCardinality, cardAsNonNegativeInteger);
        return restriction;
    }

    public OntClass createMaxCardinalityRestriction(OntProperty p, int cardinality) {
        MaxCardinalityRestriction restriction = this.ontmodel.createMaxCardinalityRestriction(null, (Property)p, cardinality);
        restriction.removeAll(OWL.maxCardinality);
        Literal cardAsNonNegativeInteger = this.ontmodel.createTypedLiteral((Object)cardinality, "http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        restriction.addLiteral(OWL.maxCardinality, cardAsNonNegativeInteger);
        return restriction;
    }

    public void createAdditionalPropertyDetails() {
        block2: for (ClassInfo ci : this.ontClassByClassInfo.keySet()) {
            SortedMap<StructuredNumber, PropertyInfo> pis = ci.properties();
            for (PropertyInfo propertyInfo : pis.values()) {
                if (!propertyInfo.matches("rule-owl-prop-general")) break block2;
                if (!propertyInfo.isNavigable()) continue;
                OntProperty ontProperty = (OntProperty)this.ontPropertyByPropertyInfo.get(propertyInfo);
                AssociationInfo ai = propertyInfo.association();
                if (ai != null) {
                    String aiName;
                    OntologyModel om;
                    PropertyInfo revPi;
                    if (ai.assocClass() != null) {
                        this.result.addError(this, 15, ai.assocClass().name());
                    }
                    if ((revPi = propertyInfo.reverseProperty()) != null && revPi.isNavigable() && propertyInfo.matches("rule-owl-prop-inverseOf") && (om = this.owliso19150.computeRelevantOntology(revPi.inClass())) != null) {
                        OntProperty ip = om == this ? (OntProperty)this.ontPropertyByPropertyInfo.get(revPi) : om.getOntProperty(revPi);
                        if (ip != null) {
                            ontProperty.addInverseOf((Property)ip);
                        } else {
                            this.result.addError(this, 13, ontProperty.getURI());
                        }
                    }
                    if ((aiName = ai.name()) != null && aiName.length() > 0 && propertyInfo.matches("rule-owl-prop-iso191502AssociationName")) {
                        this.ontmodel.setNsPrefix("iso19150-2", "http://def.isotc211.org/iso19150/-2/2012/base#");
                        ontProperty.addProperty(ISO19150_2.associationName, aiName);
                    }
                    if ((propertyInfo.isComposition() || propertyInfo.isAggregation()) && propertyInfo.matches("rule-owl-prop-iso191502Aggregation")) {
                        if (propertyInfo.isComposition()) {
                            this.ontmodel.setNsPrefix("iso19150-2", "http://def.isotc211.org/iso19150/-2/2012/base#");
                            ontProperty.addProperty(ISO19150_2.aggregationType, "partOfCompositeAggregation");
                        } else if (propertyInfo.isAggregation()) {
                            this.ontmodel.setNsPrefix("iso19150-2", "http://def.isotc211.org/iso19150/-2/2012/base#");
                            ontProperty.addProperty(ISO19150_2.aggregationType, "partOfSharedAggregation");
                        }
                    }
                }
                if (!propertyInfo.matches("rule-owl-prop-propertyEnrichment")) continue;
                this.addPropertyAxiom(propertyInfo, ontProperty, PropertyAxiom.EQUIVALENT);
                this.addPropertyAxiom(propertyInfo, ontProperty, PropertyAxiom.DISJOINT);
                this.addPropertyAxiom(propertyInfo, ontProperty, PropertyAxiom.INVERSE);
                this.addPropertyAxiom(propertyInfo, ontProperty, PropertyAxiom.SUBPROPERTYOF);
                String owlLogicalCharacteristicsTV = propertyInfo.taggedValue("owlLogicalCharacteristics");
                if (!StringUtils.isNotBlank((CharSequence)owlLogicalCharacteristicsTV)) continue;
                String[] tvValues = StringUtils.split((String)owlLogicalCharacteristicsTV, (String)", ");
                TreeSet<PropertyAxiom> propertyAxioms = new TreeSet<PropertyAxiom>();
                for (String tvValue : tvValues) {
                    try {
                        PropertyAxiom pa = PropertyAxiom.fromString(tvValue);
                        if (pa != PropertyAxiom.FUNCTIONAL && pa != PropertyAxiom.INVERSEFUNCTIONAL && pa != PropertyAxiom.REFLEXIVE && pa != PropertyAxiom.IRREFLEXIVE && pa != PropertyAxiom.SYMMETRIC && pa != PropertyAxiom.ASYMMETRIC && pa != PropertyAxiom.TRANSITIVE) continue;
                        propertyAxioms.add(pa);
                    }
                    catch (Exception e) {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 52, tvValue, propertyInfo.name());
                        if (mc == null) continue;
                        mc.addDetail(this, -2, propertyInfo.fullNameInSchema());
                    }
                }
                this.addPropertyCharacteristicAxioms(ontProperty, propertyAxioms);
            }
        }
        for (OwlGeneralProperty ogp : this.generalProperties.values()) {
            RdfGeneralProperty gp = ogp.gp;
            OntProperty op = ogp.p;
            this.addGeneralPropertyAxiom(gp, op, gp.getEquivalentProperty(), PropertyAxiom.EQUIVALENT);
            this.addGeneralPropertyAxiom(gp, op, gp.getDisjointProperty(), PropertyAxiom.DISJOINT);
            this.addGeneralPropertyAxiom(gp, op, gp.getSubPropertyOf(), PropertyAxiom.SUBPROPERTYOF);
            for (Map.Entry<String, List<RdfPropertyValue>> entry : gp.getAdditionalProperties().entrySet()) {
                String propQName = entry.getKey();
                List<RdfPropertyValue> values = entry.getValue();
                Property prop = this.mapProperty(propQName);
                for (RdfPropertyValue rpv : values) {
                    if (rpv.isIRI()) {
                        OntResource value = this.ontmodel.createOntResource(rpv.getValue());
                        op.addProperty(prop, (RDFNode)value);
                        continue;
                    }
                    Literal l = rpv.hasLang() ? this.ontmodel.createLiteral(rpv.getValue(), rpv.getLang()) : this.ontmodel.createLiteral(rpv.getValue());
                    op.addLiteral(prop, l);
                }
            }
            if (gp instanceof GeneralDataProperty) {
                GeneralDataProperty generalDataProperty = (GeneralDataProperty)gp;
                if (!generalDataProperty.isFunctional()) continue;
                op.addRDFType(OWL2.FunctionalProperty);
                continue;
            }
            GeneralObjectProperty generalObjectProperty = (GeneralObjectProperty)gp;
            this.addGeneralPropertyAxiom(gp, op, generalObjectProperty.getInverseProperty(), PropertyAxiom.INVERSE);
            SortedSet<PropertyAxiom> sortedSet = generalObjectProperty.getPropertyCharacteristicAxioms();
            this.addPropertyCharacteristicAxioms(op, sortedSet);
        }
    }

    private void addPropertyCharacteristicAxioms(OntProperty op, SortedSet<PropertyAxiom> propertyAxioms) {
        if (propertyAxioms.isEmpty()) {
            return;
        }
        if (propertyAxioms.contains((Object)PropertyAxiom.FUNCTIONAL) && propertyAxioms.contains((Object)PropertyAxiom.INVERSEFUNCTIONAL)) {
            this.result.addWarning(this, 49, op.getURI());
        } else if (propertyAxioms.contains((Object)PropertyAxiom.REFLEXIVE) && propertyAxioms.contains((Object)PropertyAxiom.IRREFLEXIVE)) {
            this.result.addWarning(this, 50, op.getURI());
        } else if (propertyAxioms.contains((Object)PropertyAxiom.SYMMETRIC) && propertyAxioms.contains((Object)PropertyAxiom.ASYMMETRIC)) {
            this.result.addWarning(this, 51, op.getURI());
        }
        for (PropertyAxiom opca : propertyAxioms) {
            if (opca == PropertyAxiom.ASYMMETRIC) {
                op.addRDFType(OWL2.AsymmetricProperty);
                continue;
            }
            if (opca == PropertyAxiom.FUNCTIONAL) {
                op.addRDFType(OWL2.FunctionalProperty);
                continue;
            }
            if (opca == PropertyAxiom.INVERSEFUNCTIONAL) {
                op.addRDFType(OWL2.InverseFunctionalProperty);
                continue;
            }
            if (opca == PropertyAxiom.IRREFLEXIVE) {
                op.addRDFType(OWL2.IrreflexiveProperty);
                continue;
            }
            if (opca == PropertyAxiom.REFLEXIVE) {
                op.addRDFType(OWL2.ReflexiveProperty);
                continue;
            }
            if (opca == PropertyAxiom.SYMMETRIC) {
                op.addRDFType(OWL2.SymmetricProperty);
                continue;
            }
            if (opca != PropertyAxiom.TRANSITIVE) continue;
            op.addRDFType(OWL2.TransitiveProperty);
        }
    }

    private void addGeneralPropertyAxiom(RdfGeneralProperty gp, OntProperty op, SortedSet<String> propertyIdentifiers, PropertyAxiom axiom) {
        if (axiom != PropertyAxiom.SUBPROPERTYOF && axiom != PropertyAxiom.EQUIVALENT && axiom != PropertyAxiom.DISJOINT && axiom != PropertyAxiom.INVERSE) {
            return;
        }
        for (String propId : propertyIdentifiers) {
            Property p = null;
            if (propId.contains("::")) {
                PropertyInfo pi = this.model.propertyByFullNameInSchema(propId);
                if (pi == null) {
                    this.result.addError(this, 45, gp.getName(), propId, axiom.getNameForMessages());
                } else {
                    OntologyModel om;
                    p = this.mapProperty(pi);
                    if (p == null && (om = this.owliso19150.computeRelevantOntology(pi.inClass())) != null) {
                        p = om.getOntProperty(pi);
                    }
                    if (p == null) {
                        this.result.addError(this, 46, gp.getName(), propId, axiom.getNameForMessages());
                    }
                }
            } else {
                p = this.mapProperty(propId);
            }
            if (p == null) continue;
            if (axiom == PropertyAxiom.SUBPROPERTYOF) {
                op.addSuperProperty(p);
                this.owliso19150.registerSubPropertyOfRelationship(p.getURI(), op);
                continue;
            }
            if (axiom == PropertyAxiom.INVERSE) {
                op.addInverseOf(p);
                continue;
            }
            if (axiom == PropertyAxiom.DISJOINT) {
                op.addProperty(OWL2.propertyDisjointWith, (RDFNode)p);
                continue;
            }
            if (axiom != PropertyAxiom.EQUIVALENT) continue;
            op.addEquivalentProperty(p);
        }
    }

    private void addPropertyAxiom(PropertyInfo pi, OntProperty op, PropertyAxiom axiom) {
        String tvName = null;
        if (axiom == PropertyAxiom.SUBPROPERTYOF) {
            tvName = "owlSubPropertyOf";
        } else if (axiom == PropertyAxiom.EQUIVALENT) {
            tvName = "owlEquivalentProperties";
        } else if (axiom == PropertyAxiom.DISJOINT) {
            tvName = "owlDisjointProperties";
        } else if (axiom == PropertyAxiom.INVERSE) {
            tvName = "owlInverseProperties";
        } else {
            return;
        }
        String tv = pi.taggedValue(tvName);
        if (StringUtils.isNotBlank((CharSequence)tv)) {
            String[] tmp = StringUtils.split((String)tv, (String)",");
            TreeSet<String> propertyIdentifiers = new TreeSet<String>();
            for (String t : tmp) {
                propertyIdentifiers.add(t.trim());
            }
            for (String propId : propertyIdentifiers) {
                Property p = null;
                if (propId.contains("::")) {
                    PropertyInfo piRef = this.model.propertyByFullNameInSchema(propId);
                    if (piRef == null) {
                        this.result.addError(this, 47, pi.name(), propId, axiom.getNameForMessages());
                    } else {
                        OntologyModel om;
                        p = this.mapProperty(piRef);
                        if (p == null && (om = this.owliso19150.computeRelevantOntology(piRef.inClass())) != null) {
                            p = om.getOntProperty(piRef);
                        }
                        if (p == null) {
                            this.result.addError(this, 48, pi.name(), propId, axiom.getNameForMessages());
                        }
                    }
                } else {
                    p = this.mapProperty(propId);
                }
                if (p == null) continue;
                if (axiom == PropertyAxiom.SUBPROPERTYOF) {
                    op.addSuperProperty(p);
                    this.owliso19150.registerSubPropertyOfRelationship(p.getURI(), op);
                    continue;
                }
                if (axiom == PropertyAxiom.INVERSE) {
                    op.addInverseOf(p);
                    continue;
                }
                if (axiom == PropertyAxiom.DISJOINT) {
                    op.addProperty(OWL2.propertyDisjointWith, (RDFNode)p);
                    continue;
                }
                if (axiom != PropertyAxiom.EQUIVALENT) continue;
                op.addEquivalentProperty(p);
            }
        }
    }

    public void finalizeDocument() {
        this.finalized = true;
    }

    public String getName() {
        return this.name;
    }

    public String getRdfNamespace() {
        return this.rdfNamespace;
    }

    public OntClass addClassDefinition(ClassInfo ci) {
        if (this.finalized) {
            this.result.addWarning(this, 3, ci.name());
            return null;
        }
        OntClass c = this.ontmodel.createClass(this.computeReference(this.getPrefix(), OntologyModel.normalizedName(ci)));
        this.ontClassByClassInfo.put(ci, c);
        this.resourceByClassInfo.put(ci, (Resource)c);
        this.applyDescriptorTargets((OntResource)c, ci, DescriptorTarget.AppliesTo.CLASS);
        if (ci.isAbstract() && ci.matches("rule-owl-cls-iso191502IsAbstract")) {
            this.ontmodel.setNsPrefix("iso19150-2", "http://def.isotc211.org/iso19150/-2/2012/base#");
            c.addLiteral(ISO19150_2.isAbstract, this.ontmodel.createTypedLiteral(true));
        }
        this.addCustomSubClassOf((OntResource)c, ci);
        this.addConstraintDeclarations((OntResource)c, ci);
        return c;
    }

    private void mapAndAddSuperClass(ClassInfo ci, OntClass c, ClassInfo supertype) {
        Resource mappedResource = this.map(supertype);
        if (mappedResource == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 6, supertype.name(), ci.name());
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullName());
            }
        } else {
            c.addSuperClass(mappedResource);
        }
    }

    private void applyDescriptorTargets(OntResource c, Info i, DescriptorTarget.AppliesTo appliesTo) {
        for (DescriptorTarget dt : this.config.getDescriptorTargets()) {
            String template;
            if (!dt.getAppliesTo().equals((Object)DescriptorTarget.AppliesTo.ALL) && !appliesTo.equals((Object)DescriptorTarget.AppliesTo.ALL) && (i instanceof PackageInfo && !dt.getAppliesTo().equals((Object)DescriptorTarget.AppliesTo.ONTOLOGY) || i instanceof ClassInfo && (!dt.getAppliesTo().equals((Object)DescriptorTarget.AppliesTo.CLASS) || !appliesTo.equals((Object)DescriptorTarget.AppliesTo.CLASS)) && (!dt.getAppliesTo().equals((Object)DescriptorTarget.AppliesTo.CONCEPT_SCHEME) || !appliesTo.equals((Object)DescriptorTarget.AppliesTo.CONCEPT_SCHEME)) || i instanceof PropertyInfo && !dt.getAppliesTo().equals((Object)DescriptorTarget.AppliesTo.PROPERTY))) continue;
            String doc = template = dt.getTemplate();
            Pattern pattern = Pattern.compile("\\[\\[([^\\[].*?)\\]\\]");
            Matcher matcher = pattern.matcher(template);
            ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>();
            builders.add(new StringBuilder());
            boolean noValuesForFieldsInTemplate = true;
            int index = 0;
            while (matcher.find()) {
                Object s;
                String desc = matcher.group(1).trim();
                ArrayList<Object> values = new ArrayList<Object>();
                boolean descRecognized = true;
                if (desc.startsWith("TV")) {
                    Matcher m = this.descriptorTargetTaggedValuePattern.matcher(desc);
                    m.matches();
                    String string = m.group(1);
                    String tv = m.group(2);
                    String[] tv_values = i.taggedValuesInLanguage(tv, this.options.language());
                    if (string != null) {
                        String string2 = string.substring(1, string.length() - 1);
                        String string3 = Pattern.quote(string2);
                        String[] stringArray = tv_values;
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String[] split;
                            String tv_value = stringArray[j];
                            for (String s2 : split = tv_value.split(string3)) {
                                if (s2.trim().isEmpty()) continue;
                                values.add(s2.trim());
                            }
                        }
                    } else {
                        for (String tv_value : tv_values) {
                            if (tv_value.trim().isEmpty()) continue;
                            values.add(tv_value.trim());
                        }
                    }
                } else if (desc.equalsIgnoreCase("name")) {
                    values.add(i.name());
                } else if (desc.equalsIgnoreCase("alias")) {
                    s = i.aliasName();
                    if (s != null && !((String)s).trim().isEmpty()) {
                        values.add(s);
                    }
                } else if (desc.equalsIgnoreCase("definition")) {
                    s = i.definition();
                    if (s != null && !((String)s).trim().isEmpty()) {
                        values.add(s);
                    }
                } else if (desc.equalsIgnoreCase("description")) {
                    s = i.description();
                    if (s != null && !((String)s).trim().isEmpty()) {
                        values.add(s);
                    }
                } else if (desc.equalsIgnoreCase("example")) {
                    s = i.examples();
                    if (s != null && ((String[])s).length > 0) {
                        for (String string : s) {
                            if (string.trim().length() <= 0) continue;
                            values.add(string.trim());
                        }
                    }
                } else if (desc.equalsIgnoreCase("legalBasis")) {
                    s = i.legalBasis();
                    if (s != null && !((String)s).trim().isEmpty()) {
                        values.add(s);
                    }
                } else if (desc.equalsIgnoreCase("dataCaptureStatement")) {
                    s = i.dataCaptureStatements();
                    if (s != null && ((Object)s).length > 0) {
                        for (Object object : s) {
                            if (((String)object).trim().length() <= 0) continue;
                            values.add(((String)object).trim());
                        }
                    }
                } else if (desc.equalsIgnoreCase("primaryCode")) {
                    s = i.primaryCode();
                    if (s != null && !((String)s).trim().isEmpty()) {
                        values.add(s);
                    }
                } else if (desc.equalsIgnoreCase("globalIdentifier")) {
                    s = i.globalIdentifier();
                    if (s != null && !((String)s).trim().isEmpty()) {
                        values.add(s);
                    }
                } else {
                    descRecognized = false;
                }
                for (StringBuilder stringBuilder : builders) {
                    stringBuilder.append(doc.substring(index, matcher.start()));
                }
                if (descRecognized) {
                    if (values.isEmpty()) {
                        values.add(dt.getNoValueText());
                    } else {
                        noValuesForFieldsInTemplate = false;
                    }
                    if (values.size() == 1) {
                        for (StringBuilder stringBuilder : builders) {
                            stringBuilder.append((String)values.get(0));
                        }
                    } else if (dt.getMultiValueBehavior() == DescriptorTarget.MultiValueBehavior.CONNECT_IN_SINGLE_TARGET) {
                        String connectedValues = StringUtils.join(values, (String)dt.getMultiValueConnectorToken());
                        for (StringBuilder b3 : builders) {
                            b3.append(connectedValues);
                        }
                    } else {
                        ArrayList<StringBuilder> newBuilders = new ArrayList<StringBuilder>();
                        for (String val : values) {
                            for (StringBuilder stringBuilder : builders) {
                                StringBuilder newBuilder = new StringBuilder(stringBuilder);
                                newBuilder.append(val);
                                newBuilders.add(newBuilder);
                            }
                        }
                        builders = newBuilders;
                    }
                } else {
                    for (StringBuilder stringBuilder : builders) {
                        stringBuilder.append(matcher.group(0));
                    }
                }
                index = matcher.end();
            }
            for (StringBuilder b : builders) {
                b.append(doc.substring(index, doc.length()));
            }
            if (noValuesForFieldsInTemplate && dt.getNoValueBehavior() == DescriptorTarget.NoValueBehavior.INGORE) continue;
            String target = dt.getTarget();
            this.addNamespaceDeclaration(target);
            String propertyIRI = this.computeReference(target);
            Property prop = this.ontmodel.createProperty(propertyIRI);
            for (StringBuilder stringBuilder : builders) {
                if (dt.getFormat() == DescriptorTarget.Format.STRING) {
                    c.addProperty(prop, stringBuilder.toString());
                    continue;
                }
                if (dt.getFormat() == DescriptorTarget.Format.LANG_STRING) {
                    c.addProperty(prop, stringBuilder.toString(), this.owliso19150.getLanguage());
                    continue;
                }
                Resource r = this.ontmodel.createResource(stringBuilder.toString());
                c.addProperty(prop, (RDFNode)r);
            }
        }
    }

    private void addCustomSubClassOf(OntResource c, ClassInfo ci) {
        TypeConversionParameter tcp;
        String catID;
        int cat = ci.category();
        switch (cat) {
            case 1: {
                catID = "featuretype";
                break;
            }
            case 4: 
            case 6: {
                catID = "type";
                break;
            }
            case 7: {
                catID = "basictype";
                break;
            }
            case 5: {
                catID = "datatype";
                break;
            }
            case 2: {
                catID = "codelist";
                break;
            }
            case 8: {
                catID = "union";
                break;
            }
            case 3: {
                catID = "enumeration";
                break;
            }
            default: {
                this.result.addWarning(this, 9, ci.name(), ci.stereotypes().toString());
                return;
            }
        }
        SortedMap<String, List<StereotypeConversionParameter>> stereotypeMappings = this.owliso19150.getConfig().getStereotypeConversionParameters();
        if (stereotypeMappings.containsKey(catID)) {
            List scps = (List)stereotypeMappings.get(catID);
            for (StereotypeConversionParameter scp : scps) {
                for (String subClassOf : scp.getSubClassOf()) {
                    Resource mappedResource = this.mapResource(subClassOf);
                    c.asClass().addSuperClass(mappedResource);
                }
            }
        }
        if ((tcp = this.owliso19150.getConfig().getTypeConversionParameter(ci)) != null) {
            for (String subClassOf : tcp.getSubClassOf()) {
                Resource mappedResource = this.mapResource(subClassOf);
                c.asClass().addSuperClass(mappedResource);
            }
        }
    }

    public void addNamespaceDeclaration(String qname) {
        if (qname == null || !qname.contains(":") || qname.substring(0, qname.indexOf(":")).length() == 0) {
            return;
        }
        String prefix = qname.substring(0, qname.indexOf(":"));
        if (this.config.hasNamespaceWithAbbreviation(prefix)) {
            String ns = this.config.fullNamespace(prefix);
            String s = this.ontmodel.getNsPrefixURI(prefix);
            if (s == null) {
                this.ontmodel.setNsPrefix(prefix, ns);
            } else if (!s.equals(ns)) {
                this.result.addError(this, 11, this.getName(), prefix, ns, s);
            }
        } else {
            this.result.addError(this, 39, prefix);
        }
    }

    public void addImport(String rdfns, String uri) {
        String prefix;
        if (rdfns == null || rdfns.equals(this.rdfNamespace)) {
            return;
        }
        if (uri != null) {
            if (this.ontmodel.hasLoadedImport(uri)) {
                return;
            }
            this.ontology.addImport(this.ontmodel.createResource(uri));
        }
        if ((prefix = this.owliso19150.computePrefixForRdfNamespace(rdfns)) != null) {
            String s = this.ontmodel.getNsPrefixURI(prefix);
            if (s == null) {
                this.ontmodel.setNsPrefix(prefix, rdfns);
            } else if (!s.equals(rdfns)) {
                this.result.addError(this, 11, this.getName(), prefix, rdfns, s);
            }
        } else {
            this.result.addWarning(this, 4, rdfns);
        }
    }

    protected void addMultiplicity(OntClass cls, PropertyInfo pi, OntProperty p) {
        if (pi.inClass().category() == 8 && pi.inClass().matches("rule-owl-cls-union") || StringUtils.isNotBlank((CharSequence)pi.taggedValue("SC_UNION_SET")) && pi.inClass().matches("rule-owl-cls-unionSets")) {
            return;
        }
        Multiplicity m = pi.cardinality();
        int lower = m.minOccurs;
        int upper = m.maxOccurs;
        if (pi.voidable() && pi.matches("rule-owl-prop-voidable-as-minCardinality0")) {
            lower = 0;
        }
        Resource range = (Resource)this.rangeByPropertyInfo.get(pi);
        if (pi.matches("rule-owl-prop-multiplicityAsUnqualifiedCardinalityRestriction") || range == null && pi.matches("rule-owl-prop-multiplicityAsQualifiedCardinalityRestriction")) {
            ShapeChangeResult.MessageContext mc;
            OntClass restriction;
            boolean restrictionCreated = false;
            if (lower == upper) {
                restriction = this.createCardinalityRestriction(p, lower);
                cls.addSuperClass((Resource)restriction);
                restrictionCreated = true;
            } else {
                if (lower != 0) {
                    restriction = this.createMinCardinalityRestriction(p, lower);
                    cls.addSuperClass((Resource)restriction);
                    restrictionCreated = true;
                }
                if (upper != Integer.MAX_VALUE) {
                    restriction = this.createMaxCardinalityRestriction(p, upper);
                    cls.addSuperClass((Resource)restriction);
                    restrictionCreated = true;
                }
            }
            if (restrictionCreated && range == null && pi.matches("rule-owl-prop-multiplicityAsQualifiedCardinalityRestriction") && (mc = this.result.addInfo(this, 33)) != null) {
                mc.addDetail(this, 10001, pi.fullName());
            }
        } else if (pi.matches("rule-owl-prop-multiplicityAsQualifiedCardinalityRestriction")) {
            if (lower == upper) {
                OntClass restriction = this.createQCardinalityRestriction(p, lower, range);
                cls.addSuperClass((Resource)restriction);
            } else {
                OntClass restriction;
                if (lower != 0) {
                    restriction = this.createQMinCardinalityRestriction(p, lower, range);
                    cls.addSuperClass((Resource)restriction);
                }
                if (upper != Integer.MAX_VALUE) {
                    restriction = this.createQMaxCardinalityRestriction(p, upper, range);
                    cls.addSuperClass((Resource)restriction);
                }
            }
        }
    }

    protected void addAllValuesFrom(OntClass cls, PropertyInfo pi, Property p) {
        if (pi.matches("rule-owl-prop-range-local-withUniversalQuantification")) {
            Resource range = (Resource)this.rangeByPropertyInfo.get(pi);
            if (range != null) {
                AllValuesFromRestriction restriction = this.ontmodel.createAllValuesFromRestriction(null, p, range);
                cls.addSuperClass((Resource)restriction);
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 35, pi.name());
                if (mc != null) {
                    mc.addDetail(this, 10001, pi.fullName());
                }
            }
        }
    }

    private boolean isDatatypeProperty(PropertyInfo pi) {
        RdfTypeMapEntry rtme = this.config.getTypeMapEntryByTypeInfo(pi);
        if (rtme == null) {
            int cat = pi.categoryOfValue();
            if (cat == 3) {
                ClassInfo enumeration = this.model.classById(pi.typeInfo().id);
                return enumeration != null && this.map(enumeration) == null;
            }
            return false;
        }
        return rtme.getTargetType() == RdfTypeMapEntry.TargetType.DATATYPE;
    }

    private OntProperty addPropertyDeclaration(PropertyInfo pi) {
        ClassInfo piType;
        OntProperty p;
        String propAbout;
        PropertyConversionParameter pcp;
        if (!pi.isNavigable()) {
            return null;
        }
        OntProperty mappedProperty = this.mapProperty(pi);
        if (mappedProperty != null) {
            if (mappedProperty.getURI().equals(this.computeReference("sc", "null"))) {
                ShapeChangeResult.MessageContext mc = this.result.addInfo(this, 20, pi.name());
                if (mc != null) {
                    mc.addDetail(this, 10001, pi.fullName());
                }
                return null;
            }
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 21, pi.name(), mappedProperty.getURI());
            if (mc != null) {
                mc.addDetail(this, 10001, pi.fullName());
            }
            return mappedProperty;
        }
        if ((!pi.isAttribute() || !pi.matches("rule-owl-prop-globalScopeAttributes")) && pi.matches("rule-owl-prop-globalScopeByConversionParameter") && (pcp = this.config.getPropertyConversionParameter(pi)) != null && pcp.hasTarget()) {
            OntologyModel ontologyWithGlobalProp = this.owliso19150.computeRelevantOntologyForTargetMapping(pcp);
            if (ontologyWithGlobalProp == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 31, pcp.getTarget(), pcp.getTargetSchema());
                if (mc != null) {
                    mc.addDetail(this, 10001, pi.fullName());
                }
            } else {
                ShapeChangeResult.MessageContext mc;
                this.addImport(ontologyWithGlobalProp.getRdfNamespace(), null);
                String propAbout2 = this.computeReference(ontologyWithGlobalProp.getPrefix(), pcp.getTarget().split("::")[1]);
                OntModel ontModel = ontologyWithGlobalProp.getOntologyModel();
                OntProperty p2 = ontModel.getOntProperty(propAbout2);
                if (p2 == null) {
                    p2 = ontModel.createOntProperty(propAbout2);
                }
                if ((mc = this.result.addInfo(this, 34, pi.name(), p2.getURI())) != null) {
                    mc.addDetail(this, 10001, pi.fullName());
                }
                if (pi.matches("rule-owl-prop-mapping-compare-specifications")) {
                    PropertyInfo globalProp = this.getGlobalProperty(pcp);
                    if (globalProp != null) {
                        this.comparePropertySpecifications(pi, globalProp);
                    } else {
                        ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 25);
                        if (mc2 != null) {
                            mc2.addDetail(this, 10003, pi.fullName());
                            mc2.addDetail(this, 10004, pi.fullName());
                        }
                    }
                }
                return p2;
            }
        }
        if (this.properties.containsKey(propAbout = this.computePropertyName(pi))) {
            OwlProperty p0 = (OwlProperty)this.properties.get(propAbout);
            if (pi.matches("rule-owl-prop-mapping-compare-specifications")) {
                this.comparePropertySpecifications(pi, p0.pi);
            }
            return p0.p;
        }
        if (this.isDatatypeProperty(pi)) {
            DatatypeProperty dp = this.ontmodel.createDatatypeProperty(propAbout);
            p = dp.asProperty();
        } else {
            ObjectProperty op = this.ontmodel.createObjectProperty(propAbout);
            p = op.asProperty();
        }
        this.addCommonPropertyPredicates((OntResource)p, pi);
        this.addConstraintDeclarations((OntResource)p, pi);
        this.addCustomSubPropertyOf(p, pi);
        if (!this.isGlobalProperty(pi)) {
            p.addDomain(this.ontmodel.createResource(this.computeReference(this.getPrefix(), OntologyModel.normalizedName(pi.inClass()))));
        }
        Resource range = this.computeRange(pi);
        if (pi.matches("rule-owl-prop-range-global") && range != null) {
            p.addRange(range);
        }
        if (pi.matches("rule-owl-prop-external-reference") && (piType = this.model.classById(pi.typeInfo().id)) != null) {
            String targetPropertyQName = this.owliso19150.getPropExternalReferenceTargetProperty();
            this.addNamespaceDeclaration(targetPropertyQName);
            String targetPropertyIRI = this.computeReference(targetPropertyQName);
            Property targetProperty = this.ontmodel.createProperty(targetPropertyIRI);
            TaggedValues refs = piType.taggedValuesForTagList("codeList,vocabulary");
            for (String tag : refs.keySet()) {
                for (String value : refs.get(tag)) {
                    if (value.trim().length() <= 0) continue;
                    p.addProperty(targetProperty, (RDFNode)this.ontmodel.createResource(value.trim()));
                }
            }
        }
        this.properties.put(propAbout, new OwlProperty(pi, p));
        return p;
    }

    private void addCommonPropertyPredicates(OntResource p, PropertyInfo pi) {
        this.applyDescriptorTargets(p, pi, DescriptorTarget.AppliesTo.PROPERTY);
        if (pi.matches("rule-owl-prop-labelFromLocalName")) {
            String rdfsLabelQname = "rdfs:label";
            this.addNamespaceDeclaration(rdfsLabelQname);
            String propertyIRI = this.computeReference(rdfsLabelQname);
            Property prop = this.ontmodel.createProperty(propertyIRI);
            p.addProperty(prop, p.getLocalName(), this.owliso19150.getLanguage());
        }
    }

    private String computePropertyName(PropertyInfo pi) {
        boolean isGlobalProperty = this.isGlobalProperty(pi);
        String result = isGlobalProperty ? this.computeReference(this.getPrefix(), OntologyModel.normalizedName(pi)) : this.computeReference(this.getPrefix(), OntologyModel.normalizedName(pi.inClass()) + "." + OntologyModel.normalizedName(pi));
        return result;
    }

    private void comparePropertySpecifications(PropertyInfo pi1, PropertyInfo pi2) {
        ShapeChangeResult.MessageContext mc;
        String s2;
        ShapeChangeResult.MessageContext mc2;
        if (this.isDatatypeProperty(pi1) != this.isDatatypeProperty(pi2)) {
            mc2 = this.result.addWarning(this, 23, pi1.typeInfo().name, pi2.typeInfo().name);
            if (mc2 != null) {
                mc2.addDetail(this, 10003, pi1.fullName());
                mc2.addDetail(this, 10004, pi2.fullName());
            }
        } else if (!pi1.typeInfo().name.equalsIgnoreCase(pi2.typeInfo().name) && (mc2 = this.result.addWarning(this, 16, pi1.typeInfo().name, pi2.typeInfo().name)) != null) {
            mc2.addDetail(this, 10003, pi1.fullName());
            mc2.addDetail(this, 10004, pi2.fullName());
        }
        String s1 = pi1.definition();
        if (s1 == null) {
            s1 = "";
        }
        if ((s2 = pi2.definition()) == null) {
            s2 = "";
        }
        if (!s1.equalsIgnoreCase(s2) && (mc = this.result.addWarning(this, 17, s1, s2)) != null) {
            mc.addDetail(this, 10003, pi1.fullName());
            mc.addDetail(this, 10004, pi2.fullName());
        }
        if ((s1 = pi1.description()) == null) {
            s1 = "";
        }
        if ((s2 = pi2.description()) == null) {
            s2 = "";
        }
        if (!s1.equalsIgnoreCase(s2) && (mc = this.result.addWarning(this, 18, s1, s2)) != null) {
            mc.addDetail(this, 10003, pi1.fullName());
            mc.addDetail(this, 10004, pi2.fullName());
        }
        if ((s1 = pi1.aliasName()) == null) {
            s1 = "";
        }
        if ((s2 = pi2.aliasName()) == null) {
            s2 = "";
        }
        if (!s1.equalsIgnoreCase(s2) && (mc = this.result.addWarning(this, 19, s1, s2)) != null) {
            mc.addDetail(this, 10003, pi1.fullName());
            mc.addDetail(this, 10004, pi2.fullName());
        }
    }

    private void addCustomSubPropertyOf(OntProperty p, PropertyInfo pi) {
        PropertyConversionParameter pcp = this.config.getPropertyConversionParameter(pi);
        if (pcp != null && pcp.hasSubPropertyOf()) {
            for (String spo : pcp.getSubPropertyOf()) {
                Property mapping = this.mapProperty(spo);
                p.addSuperProperty(mapping);
                this.owliso19150.registerSubPropertyOfRelationship(mapping.getURI(), p);
            }
        }
    }

    private boolean isGlobalProperty(PropertyInfo pi) {
        PropertyConversionParameter pcp;
        if (pi.matches("rule-owl-prop-localScopeAll")) {
            return false;
        }
        if (pi.isAttribute() && pi.matches("rule-owl-prop-globalScopeAttributes")) {
            return true;
        }
        if (pi.matches("rule-owl-prop-globalScopeByUniquePropertyName") && this.uniquePropertyNames.contains(pi.name())) {
            return true;
        }
        return pi.matches("rule-owl-prop-globalScopeByConversionParameter") && (pcp = this.config.getPropertyConversionParameter(pi)) != null && pcp.isGlobal() && !pcp.hasTarget();
    }

    private Resource mapResource(String qname) {
        Resource r;
        String location;
        String rdfNs;
        String[] qnamePars = qname.split(":");
        if (qnamePars.length != 2 || StringUtils.isBlank((CharSequence)qnamePars[0]) || StringUtils.isBlank((CharSequence)qnamePars[1])) {
            rdfNs = "http://example.org/qname/error/";
            location = null;
            String uri = rdfNs + qname;
            this.result.addError(this, 54, qname, uri);
            r = this.refmodel.getResource(uri);
            if (r == null) {
                r = this.refmodel.createResource(uri);
            }
        } else {
            String prefix = qnamePars[0];
            String resourceName = qnamePars[1];
            rdfNs = this.config.fullNamespace(prefix);
            location = this.config.locationOfNamespace(rdfNs);
            String uri = rdfNs + resourceName;
            r = this.refmodel.getResource(uri);
            if (r == null) {
                r = this.refmodel.createResource(uri);
            }
        }
        this.addImport(rdfNs, location);
        return r;
    }

    private Resource mapClass(String qname) {
        OntClass c;
        String location;
        String rdfNs;
        String[] qnamePars = qname.split(":", 2);
        if (qnamePars.length != 2 || StringUtils.isBlank((CharSequence)qnamePars[0]) || StringUtils.isBlank((CharSequence)qnamePars[1])) {
            rdfNs = "http://example.org/qname/error/";
            location = null;
            String uri = rdfNs + qname;
            this.result.addError(this, 54, qname, uri);
            c = this.refmodel.getOntClass(uri);
            if (c == null) {
                c = this.refmodel.createClass(uri);
            }
        } else {
            String prefix = qnamePars[0];
            String resourceName = qnamePars[1];
            rdfNs = this.config.fullNamespace(prefix);
            location = this.config.locationOfNamespace(rdfNs);
            String uri = rdfNs + resourceName;
            c = this.refmodel.getOntClass(uri);
            if (c == null) {
                c = this.refmodel.createClass(uri);
            }
        }
        this.addImport(rdfNs, location);
        return c;
    }

    private Property mapProperty(String qname) {
        String rdfNs = null;
        String location = null;
        Property p = null;
        String[] qnamePars = qname.split(":");
        if (qnamePars.length != 2 || StringUtils.isBlank((CharSequence)qnamePars[0]) || StringUtils.isBlank((CharSequence)qnamePars[1])) {
            rdfNs = "http://example.org/qname/error/";
            location = null;
            String uri = rdfNs + qname;
            this.result.addError(this, 54, qname, uri);
            p = this.refmodel.getProperty(uri);
            if (p == null) {
                p = this.refmodel.createProperty(uri);
            }
        } else {
            String prefix = qnamePars[0];
            String propertyName = qnamePars[1];
            OntologyModel om = this.owliso19150.computeRelevantOntology(prefix);
            if (om != null) {
                rdfNs = om.getRdfNamespace();
                location = om.getName();
                String pURI = rdfNs + propertyName;
                p = om.getOntProperty(pURI);
            } else if (this.config.hasNamespaceWithAbbreviation(prefix)) {
                rdfNs = this.config.fullNamespace(prefix);
                location = this.config.locationOfNamespace(rdfNs);
                String uri = rdfNs + propertyName;
                p = this.refmodel.getProperty(uri);
                if (p == null) {
                    p = this.refmodel.createProperty(uri);
                }
            } else {
                this.result.addError(this, 55, prefix, qname);
            }
        }
        this.addImport(rdfNs, location);
        return p;
    }

    public OntProperty getOntProperty(String propertyURI) {
        OntProperty result = null;
        if (this.properties.containsKey(propertyURI)) {
            result = ((OwlProperty)this.properties.get((Object)propertyURI)).p;
        } else if (this.generalProperties.containsKey(propertyURI)) {
            result = ((OwlGeneralProperty)this.generalProperties.get((Object)propertyURI)).p;
        }
        return result;
    }

    protected Resource map(ClassInfo ci) {
        RdfTypeMapEntry rtme = this.config.getTypeMapEntry(ci);
        if (rtme != null) {
            Resource r = this.mapClass(rtme.getTarget());
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 22, ci.name(), r.getURI());
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullName());
            }
            return r;
        }
        OntologyModel om = this.owliso19150.computeRelevantOntology(ci);
        if (om == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 14, ci.name());
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullNameInSchema());
            }
            return null;
        }
        String rdfNs = om.getRdfNamespace();
        String location = om.getName();
        this.addImport(rdfNs, location);
        return om.getResource(ci);
    }

    protected Resource mapType(PropertyInfo pi) {
        RdfTypeMapEntry rtme = this.config.getTypeMapEntryByTypeInfo(pi);
        if (rtme != null) {
            return this.mapClass(rtme.getTarget());
        }
        Type ti = pi.typeInfo();
        ClassInfo ci = this.model.classById(ti.id);
        if (ci == null) {
            ci = this.model.classByName(ti.name);
        }
        if (ci == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 37, ti.name);
            if (mc != null) {
                mc.addDetail(this, 10001, pi.fullName());
            }
            return null;
        }
        Resource r = this.map(ci);
        if (r == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 7, ti.name);
            if (mc != null) {
                mc.addDetail(this, 10001, pi.fullName());
            }
            return null;
        }
        return r;
    }

    protected OntProperty mapProperty(PropertyInfo pi) {
        if (pi == null) {
            return null;
        }
        RdfPropertyMapEntry pme = this.config.getPropertyMapEntry(pi);
        if (pme != null) {
            String qname = pme.hasTarget() ? pme.getTarget() : "sc:null";
            String rdfNs = null;
            String location = null;
            OntProperty p = null;
            String[] qnamePars = qname.split(":");
            if (qnamePars.length != 2 || StringUtils.isBlank((CharSequence)qnamePars[0]) || StringUtils.isBlank((CharSequence)qnamePars[1])) {
                rdfNs = "http://example.org/qname/error/";
                location = null;
                String uri = rdfNs + qname;
                this.result.addError(this, 54, qname, uri);
                p = this.refmodel.getOntProperty(uri);
                if (p == null) {
                    p = this.refmodel.createOntProperty(uri);
                }
            } else {
                String propAbout;
                String prefix = qnamePars[0];
                String refName = qnamePars[1];
                rdfNs = this.config.fullNamespace(prefix);
                location = this.config.locationOfNamespace(rdfNs);
                if (!qname.equalsIgnoreCase("sc:null")) {
                    this.addImport(rdfNs, location);
                }
                if ((p = this.refmodel.getOntProperty(propAbout = this.computeReference(prefix, refName))) == null) {
                    p = this.refmodel.createOntProperty(propAbout);
                }
            }
            return p;
        }
        return null;
    }

    public static String normalizedName(PropertyInfo pi) {
        return OntologyModel.normalizedPropertyName(pi.name());
    }

    public static String normalizedPropertyName(String name) {
        String result = name;
        result = result.replaceAll(" ", "");
        result = result.replaceAll("[\\p{Punct}&&[^-_]]", "_");
        char[] characters = result.toCharArray();
        String firstChar = String.valueOf(characters[0]);
        firstChar = firstChar.toLowerCase();
        characters[0] = firstChar.charAt(0);
        result = String.valueOf(characters);
        return result;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void addConstraintDeclarations(OntResource r, Info i) {
        block41: {
            List<Constraint> cons;
            block40: {
                if (i instanceof ClassInfo) {
                    cons = ((ClassInfo)i).constraints();
                } else if (i instanceof PropertyInfo) {
                    cons = ((PropertyInfo)i).constraints();
                } else {
                    return;
                }
                if (cons.isEmpty()) {
                    return;
                }
                if (!i.matches("rule-owl-all-constraints-humanReadableTextOnly")) break block40;
                if (i.matches("rule-owl-all-constraints-byConstraintMapping")) {
                    this.result.addWarning(this, 29, "rule-owl-all-constraints-byConstraintMapping", "rule-owl-all-constraints-humanReadableTextOnly");
                }
                for (Constraint c : cons) {
                    String text;
                    if (c instanceof OclConstraint) {
                        OclConstraint oclCon = (OclConstraint)c;
                        Object[] comments = oclCon.comments();
                        text = StringUtils.join((Object[])comments, (String)" ");
                    } else {
                        text = c.text();
                    }
                    r.addProperty(ISO19150_2.constraint, c.name() + ": " + text);
                }
                break block41;
            }
            if (!i.matches("rule-owl-all-constraints-byConstraintMapping")) break block41;
            for (Constraint c : cons) {
                String template;
                ConstraintMapping cm = null;
                if (c instanceof OclConstraint) {
                    if (!this.config.hasConstraintMapping(ConstraintMapping.ConstraintType.OCL)) {
                        this.result.addWarning(this, 30, "OCL");
                        cm = this.defaultConstraintMapping;
                    } else {
                        cm = this.config.getConstraintMapping(ConstraintMapping.ConstraintType.OCL);
                    }
                } else if (c instanceof FolConstraint) {
                    if (!this.config.hasConstraintMapping(ConstraintMapping.ConstraintType.FOL)) {
                        this.result.addWarning(this, 30, "FOL");
                        cm = this.defaultConstraintMapping;
                    } else {
                        cm = this.config.getConstraintMapping(ConstraintMapping.ConstraintType.FOL);
                    }
                } else if (!this.config.hasConstraintMapping(ConstraintMapping.ConstraintType.TEXT)) {
                    this.result.addWarning(this, 30, "TEXT");
                    cm = this.defaultConstraintMapping;
                } else {
                    cm = this.config.getConstraintMapping(ConstraintMapping.ConstraintType.TEXT);
                }
                String doc = template = cm.getTemplate();
                Pattern pattern = Pattern.compile("\\[\\[([^\\[].*?)\\]\\]");
                Matcher matcher = pattern.matcher(template);
                StringBuilder builder = new StringBuilder();
                int index = 0;
                while (matcher.find()) {
                    Object s;
                    String desc = matcher.group(1).trim();
                    ArrayList<Object> values = new ArrayList<Object>();
                    boolean descRecognized = true;
                    if (desc.equalsIgnoreCase("name")) {
                        values.add(c.name());
                    } else if (desc.equalsIgnoreCase("text")) {
                        s = c.text();
                        if (s != null && !s.trim().isEmpty()) {
                            values.add(s);
                        }
                    } else if (desc.equalsIgnoreCase("status")) {
                        s = c.status();
                        if (s != null && !s.trim().isEmpty()) {
                            values.add(s);
                        }
                    } else if (desc.equalsIgnoreCase("comment")) {
                        if (c instanceof OclConstraint && (s = ((OclConstraint)c).comments()) != null && ((String[])s).length > 0) {
                            for (String ex : s) {
                                if (ex.trim().length() <= 0) continue;
                                values.add(ex.trim());
                            }
                        }
                    } else {
                        descRecognized = false;
                    }
                    builder.append(doc.substring(index, matcher.start()));
                    if (descRecognized) {
                        if (values.isEmpty()) {
                            values.add(cm.getNoValue());
                        }
                        if (values.size() == 1) {
                            builder.append((String)values.get(0));
                        } else {
                            String connectedValues = StringUtils.join(values, (String)cm.getMultiValueConnectorToken());
                            builder.append(connectedValues);
                        }
                    } else {
                        builder.append(matcher.group(0));
                    }
                    index = matcher.end();
                }
                builder.append(doc.substring(index, doc.length()));
                String target = cm.getTarget();
                this.addNamespaceDeclaration(target);
                String propertyIRI = this.computeReference(target);
                if (cm == this.defaultConstraintMapping) {
                    this.addImport("http://def.isotc211.org/iso19150/-2/2012/base#", this.config.locationOfNamespace("http://def.isotc211.org/iso19150/-2/2012/base#"));
                }
                Property prop = this.ontmodel.createProperty(propertyIRI);
                if (cm.getFormat() == ConstraintMapping.Format.LANG_STRING) {
                    r.addProperty(prop, builder.toString(), this.owliso19150.getLanguage());
                    continue;
                }
                r.addProperty(prop, builder.toString());
            }
        }
    }

    public void addCodelist(ClassInfo ci) {
        if (this.finalized) {
            this.result.addWarning(this, 3, ci.name());
        } else if (ci.matches("rule-owl-cls-codelist-external") && !ci.taggedValuesForTagList("codeList,vocabulary").isEmpty()) {
            this.resourceByClassInfo.put(ci, this.defaultTypeImplementation);
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 43, ci.name(), "rule-owl-cls-codelist-external");
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullName());
            }
        } else if (ci.matches("rule-owl-cls-codelist-19150-2")) {
            Individual cs;
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 43, ci.name(), "rule-owl-cls-codelist-19150-2");
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullName());
            }
            this.ontmodel.setNsPrefix("skos", "http://www.w3.org/2004/02/skos/core#");
            String classURI = this.computeReference(this.getPrefix(), OntologyModel.normalizedName(ci));
            OntClass c = this.ontmodel.createClass(classURI);
            this.resourceByClassInfo.put(ci, (Resource)c);
            this.applyDescriptorTargets((OntResource)c, ci, DescriptorTarget.AppliesTo.CLASS);
            this.addConstraintDeclarations((OntResource)c, ci);
            c.addSuperClass(SKOS.Concept);
            this.addCustomSubClassOf((OntResource)c, ci);
            OntologyModel ontForIndividuals = this.owliso19150.computeRelevantOntologyForIndividuals(ci);
            OntModel ontmodelIndi = ontForIndividuals.getOntologyModel();
            ontmodelIndi.setNsPrefix("skos", "http://www.w3.org/2004/02/skos/core#");
            ontmodelIndi.setNsPrefix("dct", "http://purl.org/dc/terms/");
            String schemeURI = ontForIndividuals.getRdfNamespace() + OntologyModel.normalizedName(ci) + this.owliso19150.getSkosConceptSchemeSuffix();
            if (ci.matches("rule-owl-cls-codelist-19150-2-conceptSchemeSubclass")) {
                Object css_name = ci.taggedValuesForTag("skosConceptSchemeSubclassName").length > 0 ? ci.taggedValuesForTag("skosConceptSchemeSubclassName")[0] : ontForIndividuals.getRdfNamespace() + OntologyModel.normalizedName(ci) + this.owliso19150.getSkosConceptSchemeSubclassSuffix();
                OntClass css = ontmodelIndi.createClass((String)css_name);
                css.addSuperClass(SKOS.ConceptScheme);
                cs = ontmodelIndi.createIndividual(schemeURI, (Resource)css);
            } else {
                cs = ontmodelIndi.createIndividual(schemeURI, SKOS.ConceptScheme);
            }
            cs.addProperty(DCTerms.isFormatOf, (RDFNode)c);
            this.applyDescriptorTargets((OntResource)cs, ci, DescriptorTarget.AppliesTo.CONCEPT_SCHEME);
            SortedMap<StructuredNumber, PropertyInfo> clPis = ci.properties();
            TreeMap<CallSite, Individual> codesByUri = new TreeMap<CallSite, Individual>();
            TreeMap<String, Individual> codesByPropertyName = new TreeMap<String, Individual>();
            TreeMap<String, String> broaderListedValueByPropertyName = new TreeMap<String, String>();
            String indiBaseURI = ontForIndividuals.getRdfNamespace() + OntologyModel.normalizedName(ci);
            for (PropertyInfo propertyInfo : clPis.values()) {
                String clvUri = indiBaseURI + "/" + propertyInfo.name();
                ontmodelIndi.setNsPrefix(this.prefix, this.rdfNamespace);
                Individual clv = ontmodelIndi.createIndividual(clvUri, (Resource)c);
                codesByUri.put((CallSite)((Object)clvUri), clv);
                if (propertyInfo.matches("rule-owl-prop-code-broader-byBroaderListedValue")) {
                    codesByPropertyName.put(propertyInfo.name(), clv);
                    String broaderListedValue = propertyInfo.taggedValue("broaderListedValue");
                    broaderListedValueByPropertyName.put(propertyInfo.name(), broaderListedValue);
                }
                this.addCommonPropertyPredicates((OntResource)clv, propertyInfo);
                clv.addProperty(SKOS.inScheme, (RDFNode)cs);
            }
            if (!broaderListedValueByPropertyName.isEmpty()) {
                for (Map.Entry entry : broaderListedValueByPropertyName.entrySet()) {
                    String piName = (String)entry.getKey();
                    String broaderListedValue = (String)entry.getValue();
                    Individual indi = (Individual)codesByPropertyName.get(piName);
                    if (broaderListedValue == null) {
                        indi.addProperty(SKOS.topConceptOf, (RDFNode)cs);
                        continue;
                    }
                    if (codesByPropertyName.containsKey(broaderListedValue)) {
                        Individual broader = (Individual)codesByPropertyName.get(broaderListedValue);
                        indi.addProperty(SKOS.broader, (RDFNode)broader);
                        continue;
                    }
                    ShapeChangeResult.MessageContext mc2 = this.result.addWarning(this, 38);
                    if (mc2 != null) {
                        mc2.addDetail(this, 10001, ci.property(piName).fullNameInSchema());
                    }
                    indi.addProperty(SKOS.topConceptOf, (RDFNode)cs);
                }
            }
            if (ci.matches("rule-owl-cls-codelist-19150-2-skos-collection")) {
                String collectionURI = schemeURI + "Collection";
                Individual individual = ontmodelIndi.createIndividual(collectionURI, SKOS.Collection);
                for (Individual code : codesByUri.values()) {
                    individual.addProperty(SKOS.member, (RDFNode)code);
                }
            }
            if (ci.category() == 3 && !ci.properties().isEmpty() && ci.matches("rule-owl-cls-codelist-19150-2-objectOneOfForEnumeration")) {
                c.addProperty(OWL2.oneOf, (RDFNode)this.ontmodel.createList(codesByUri.values().iterator()));
            }
            if (!ci.properties().isEmpty() && ci.matches("rule-owl-cls-codelist-19150-2-differentIndividuals")) {
                ontmodelIndi.createAllDifferent(ontmodelIndi.createList(codesByUri.values().iterator()));
            }
        } else {
            this.resourceByClassInfo.put(ci, this.defaultTypeImplementation);
            ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 44, ci.name());
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullName());
            }
        }
    }

    private String computeReference(String prefix, String name) {
        String rdfns = this.ontmodel.getNsPrefixURI(prefix);
        return rdfns + name;
    }

    private String computeReference(String qname) {
        String reference;
        String[] parts = qname.split(":");
        if (parts.length != 2 || StringUtils.isBlank((CharSequence)parts[0]) || StringUtils.isBlank((CharSequence)parts[1])) {
            reference = "http://example.org/qname/error/" + qname;
            this.result.addError(this, 54, qname, reference);
        } else {
            String rdfns = this.ontmodel.getNsPrefixURI(parts[0]);
            reference = rdfns + parts[1];
        }
        return reference;
    }

    public Resource addEnumeration(ClassInfo ci) {
        if (this.finalized) {
            this.result.addWarning(this, 3, ci.name());
            return null;
        }
        OntResource e = this.ontmodel.createOntResource(this.computeReference(this.getPrefix(), OntologyModel.normalizedName(ci)));
        e.addRDFType(this.ontmodel.createResource("http://www.w3.org/2000/01/rdf-schema#Datatype"));
        this.resourceByClassInfo.put(ci, (Resource)e);
        this.applyDescriptorTargets(e, ci, DescriptorTarget.AppliesTo.CLASS);
        this.addConstraintDeclarations(e, ci);
        this.addCustomSubClassOf(e, ci);
        SortedMap<StructuredNumber, PropertyInfo> enumPis = ci.properties();
        if (!enumPis.isEmpty()) {
            ArrayList<Literal> enums = new ArrayList<Literal>();
            for (PropertyInfo pi : enumPis.values()) {
                Literal en = this.ontmodel.createLiteral(pi.name());
                enums.add(en);
            }
            e.addProperty(OWL2.oneOf, (RDFNode)this.ontmodel.createList(enums.iterator()));
        }
        return e;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrefixForCode() {
        return this.getPrefix() + "code";
    }

    public String getPath() {
        return this.path;
    }

    public OntModel getOntologyModel() {
        return this.ontmodel;
    }

    public void addClass(ClassInfo ci) {
        this.classInfos.add(ci);
    }

    public Resource getResource(ClassInfo ci) {
        return (Resource)this.resourceByClassInfo.get(ci);
    }

    public OntProperty getOntProperty(PropertyInfo pi) {
        OntProperty p = (OntProperty)this.ontPropertyByPropertyInfo.get(pi);
        return p;
    }

    public void addGeneralPropertyDomainByUnionOfSubPropertyDomains() {
        for (Map.Entry<String, OwlGeneralProperty> e : this.generalProperties.entrySet()) {
            String gpIRI = e.getKey();
            OwlGeneralProperty ogp = e.getValue();
            RdfGeneralProperty gp = ogp.gp;
            OntProperty op = ogp.p;
            if (!gp.isDomainByUnionOfSubPropertyDomains()) continue;
            SortedMap<String, OntProperty> subProperties = this.owliso19150.getAllSubproperties(gpIRI);
            if (subProperties.isEmpty()) {
                this.result.addInfo(this, 53, gp.getName());
                continue;
            }
            TreeMap<String, OntResource> subPropertyDomains = new TreeMap<String, OntResource>();
            for (OntProperty subProp : subProperties.values()) {
                ExtendedIterator domains = subProp.listDomain();
                while (domains.hasNext()) {
                    OntResource domain = (OntResource)domains.next();
                    if (!domain.asNode().isURI()) continue;
                    subPropertyDomains.put(domain.getURI(), domain);
                }
            }
            UnionClass unionOfDomains = this.ontmodel.createUnionClass(null, this.ontmodel.createList(subPropertyDomains.values().iterator()));
            op.setDomain((Resource)unionOfDomains);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case -2: {
                return "Context: property '$1$'";
            }
            case -1: {
                return "Context: class '$1$'";
            }
            case 1: {
                return "ParserConfigurationException when creating document for package '$1$'.";
            }
            case 3: {
                return "Ontology document has already been finalized. Cannot add class '$1$'";
            }
            case 4: {
                return "Could not add namespace declaration info for (rdf) namespace '$1$' because no abbreviation/prefix was found for it.";
            }
            case 5: {
                return "Unsupported class category ($1$). Ensure that the encoding rule includes a rule that enables the conversion of this type of class \u2013 unless your intention is to exclude this class category.";
            }
            case 6: {
                return "Could not identify a mapping for the supertype '$1$' of class '$2$'.";
            }
            case 7: {
                return "??Could not find a type mapping and also no class within the model to map class '$1$'.";
            }
            case 8: {
                return "No stereotype mapping defined for class '$1$' (a $2$).";
            }
            case 9: {
                return "Unsupported class category encountered while processing the stereotype '$2$' of class '$1$'.";
            }
            case 10: {
                return "Duplicate property mapping encountered in union (for type named '$1$').";
            }
            case 11: {
                return "In ontology '$1$' the prefix '$2$' is used for multiple URIs: '$3$' and '$4$'.";
            }
            case 12: {
                return "";
            }
            case 13: {
                return "Inverse property of '$1$' not found. The owl:inverseOf property has not been added.";
            }
            case 14: {
                return "??Type '$1$' is not covered by an RdfTypeMapEntry and also not contained in one of the schemas selected for processing. Cannot map or create the class.";
            }
            case 15: {
                return "??Association classes are not supported by this target. Association class '$1$' not represented in the ontology. Use the AssociationClassMapper transformation to convert association classes before executing the ontology target.";
            }
            case 16: {
                return "Property mapping with potentially inconsistent ranges. Type of property 1 is '$1$', while that of property 2 (to which 1 is mapped) is '$2$'.";
            }
            case 17: {
                return "Property mapping with potentially inconsistent definitions. Definition of property 1 is '$1$', while that of property 2 (to which 1 is mapped) is '$2$'.";
            }
            case 18: {
                return "Property mapping with potentially inconsistent descriptions. Description of property 1 is '$1$', while that of property 2 (to which 1 is mapped) is '$2$'.";
            }
            case 19: {
                return "Property mapping with potentially inconsistent alias names. Alias of property 1 is '$1$', while that of property 2 (to which 1 is mapped) is '$2$'.";
            }
            case 20: {
                return "Property '$1$' has been dropped as specified in the configuration.";
            }
            case 21: {
                return "Property '$1$' has been mapped to '$2$' as specified in the configuration.";
            }
            case 22: {
                return "??Class '$1$' has been mapped to '$2$' as specified in the configuration.";
            }
            case 23: {
                return "Property mapping with inconsistent ranges: '$2$' and '$3$'. One is a datatype and one a class.";
            }
            case 24: {
                return "Code list '$1$' is managed separately and the range is represented by the class '$2$'.";
            }
            case 25: {
                return "Cannot compare property specifications, because property 2 was not found in the model.";
            }
            case 26: {
                return "Rule $1$ is in effect, but tagged value '$2$' was not found. Ignoring the rule for computing the ontology name of package '$3$'.";
            }
            case 27: {
                return "The encoding rule does not contain a specific rule for creating the ontology name. Using rule-owl-pkg-ontologyName-iso191502 to construct the ontology name for '$1$'.";
            }
            case 28: {
                return "Could not identify a mapping for the subtype '$1$' of class '$2$'. Cannot create a disjoint classes axiom for this subtype.";
            }
            case 29: {
                return "??The encoding rule contains both '$1$' and '$2$', which are mutually exclusive. Using '$2$'.";
            }
            case 30: {
                return "??No constraint mapping is defined for constraints of type '$1$'. Using defaults (template='[[name]]: [[text]]', noValue='', multiValueConnectorToken=' ').";
            }
            case 31: {
                return "Property shall be mapped to global property '$1$' in schema '$2$', but no applicable ontology was found. The property cannot be mapped.";
            }
            case 32: {
                return "Universal quantification not created for property, because an RdfPropertyMapEntry is defined for it and the map entry does not declare a specific range.";
            }
            case 33: {
                return "Qualified cardinality restrictions cannot be created for property, because no specific range is known. Using a unqualified cardinality restrictions instead.";
            }
            case 34: {
                return "Property '$1$' is mapped to global property '$2$' as specified in the configuration.";
            }
            case 35: {
                return "Range for property is undefined. This is ok if the property is mapped to an RDF/OWL property with global range declaration. Universal quantification is not created for this property.";
            }
            case 36: {
                return "Property shall be mapped to global property '$1$' in schema '$2$', but this global property could not be found. The range will be computed based upon the given property.";
            }
            case 37: {
                return "??No RdfTypeMapEntry is defined for the value type '$1$'. Also, the value type was not found in the model. Cannot map the value type.";
            }
            case 38: {
                return "Property has tagged value 'broaderListedValue' which does not identify another property of the class the property is in. Setting skos:topConceptOf for this property.";
            }
            case 39: {
                return "??No namespace configured for namespace abbreviation '$1$'. Cannot create an import and namespace declaration.";
            }
            case 40: {
                return "??The default type implementation is '$1$'.";
            }
            case 41: {
                return "??Default type implementation is used to implement type '$1$'.";
            }
            case 42: {
                return "Default type implementation is used as range of property '$1$'.";
            }
            case 43: {
                return "??Code list '$1$' is encoded according to $2$.";
            }
            case 44: {
                return "??None of the code list conversion rules applies to code list '$1$'. The default type implementation is used to implement the code list.";
            }
            case 45: {
                return "General property '$1$' defines property with full name (in schema) '$2$' as '$3$'. No property with that full name was found in the model.";
            }
            case 46: {
                return "General property '$1$' defines property with full name (in schema) '$2$' as '$3$'. The property was found in the model, but no OWL implementation is available.";
            }
            case 47: {
                return "Property '$1$' defines property with full name (in schema) '$2$' as '$3$'. No property with that full name was found in the model.";
            }
            case 48: {
                return "Property '$1$' defines property with full name (in schema) '$2$' as '$3$'. The property was found in the model, but no OWL implementation is available.";
            }
            case 49: {
                return "Property '$1$' is defined to be both functional and inverse-functional. These property axioms are mutually exclusive. Since there is no way to tell what is correct, both axioms will be encoded.";
            }
            case 50: {
                return "Property '$1$' is defined to be both reflexive and irreflexive. These property axioms are mutually exclusive. Since there is no way to tell what is correct, both axioms will be encoded.";
            }
            case 51: {
                return "Property '$1$' is defined to be both symmetric and asymmetric. These property axioms are mutually exclusive. Since there is no way to tell what is correct, both axioms will be encoded.";
            }
            case 52: {
                return "Component '$1$' of tagged value 'owlLogicalCharacteristics' from property '$2$' was not recognized and will be ignored.";
            }
            case 53: {
                return "Domain of general property '$1$' shall be defined as a union of the domains of its direct and indirect sub properties. No sub property was found, therefore no domain will be specified for '$1$'";
            }
            case 54: {
                return "??Expected QName, but found '$1$'. Mapping to '$2$'. Fix the QName (typically in the configuration, but potentially also in a tagged value). Check configuration entries and tagged values where a QName is expected (search for '$1$'). Look in the output for occurrences of '$2$' (keep in mind that this URI may have been turned into a QName itself when searching for it in the output files); that may give you a hint on the origin of the non-QName '$1$'.";
            }
            case 55: {
                return "??Could not find a namespace for prefix '$1$' of QName '$2$'. Fix the QName. Check configuration entries and tagged values where a QName is expected (search for '$2$').";
            }
            case 10000: {
                return "--- Context - Class: $1$";
            }
            case 10001: {
                return "--- Context - Property: $1$";
            }
            case 10003: {
                return "--- Context - Property 1: $1$";
            }
            case 10004: {
                return "--- Context - Property 2: $1$";
            }
        }
        return "(" + OntologyModel.class.getName() + ") Unknown message with number: " + mnr;
    }

    class OwlGeneralProperty {
        protected RdfGeneralProperty gp;
        protected OntProperty p;

        public OwlGeneralProperty(RdfGeneralProperty gp, OntProperty p) {
            this.gp = gp;
            this.p = p;
        }
    }

    class OwlProperty {
        protected PropertyInfo pi;
        protected OntProperty p;

        public OwlProperty(PropertyInfo pi, OntProperty p) {
            this.pi = pi;
            this.p = p;
        }
    }
}

