/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ontology;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.ConstraintMapping;
import de.interactive_instruments.ShapeChange.DescriptorTarget;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.PropertyConversionParameter;
import de.interactive_instruments.ShapeChange.RdfPropertyMapEntry;
import de.interactive_instruments.ShapeChange.RdfTypeMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StereotypeConversionParameter;
import de.interactive_instruments.ShapeChange.Target.Ontology.GeneralObjectProperty;
import de.interactive_instruments.ShapeChange.Target.Ontology.RdfGeneralProperty;
import de.interactive_instruments.ShapeChange.TargetOwlConfiguration;
import de.interactive_instruments.ShapeChange.TypeConversionParameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OWLISO19150ConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("codeListOwlClassNamespace", "codeListOwlClassNamespaceForEnumerations", "codeNamespace", "codeNamespaceForEnumerations", "defaultTypeImplementation", "generalPropertyNamespaceAbbreviation", "language", "ontologyNameCode", "ontologyNameTaggedValue", "outputFormat", "propExternalReference_targetProperty", "rdfNamespaceSeparator", "rdfXmlWriterBlockRules", "skosConceptSchemeSubclassSuffix", "skosConceptSchemeSuffix", "source", "sourceTaggedValueName", "suppressMessagesForUnsupportedCategoryOfClasses", "URIbase").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        SortedSet<String> invalidQNames;
        Object target;
        String propExternalReference_targetProperty;
        String defaultTypeImplementation;
        TargetOwlConfiguration config = (TargetOwlConfiguration)pConfig;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        String generalPropertyNamespaceAbbreviation = config.getParameterValue("generalPropertyNamespaceAbbreviation");
        if (StringUtils.isNotBlank((CharSequence)generalPropertyNamespaceAbbreviation) && !config.hasNamespaceWithAbbreviation(generalPropertyNamespaceAbbreviation)) {
            result.addError(this, 100, generalPropertyNamespaceAbbreviation);
            isValid = false;
        }
        if ((defaultTypeImplementation = config.parameterAsString("defaultTypeImplementation", null, false, true)) != null && !this.isValidQName(defaultTypeImplementation, config)) {
            result.addError(this, 101, "defaultTypeImplementation", defaultTypeImplementation);
            isValid = false;
        }
        if (!this.isValidQName(propExternalReference_targetProperty = config.parameterAsString("propExternalReference_targetProperty", "rdfs:seeAlso", false, true), config)) {
            result.addError(this, 101, "propExternalReference_targetProperty", propExternalReference_targetProperty);
            isValid = false;
        }
        Pattern descriptorTargetTaggedValuePattern = Pattern.compile("TV(\\(.+?\\))?:(.+)");
        Pattern templatePattern = Pattern.compile("\\[\\[(.+?)\\]\\]");
        for (DescriptorTarget dt : config.getDescriptorTargets()) {
            Iterator matcher = templatePattern.matcher(dt.getTemplate());
            while (((Matcher)((Object)matcher)).find()) {
                Matcher m;
                String desc = ((Matcher)((Object)matcher)).group(1).trim();
                if (!desc.startsWith("TV") || (m = descriptorTargetTaggedValuePattern.matcher(desc)).matches()) continue;
                result.addError(this, 110, desc, dt.getTarget());
                isValid = false;
            }
            String target2 = dt.getTarget();
            if (this.isValidQName(target2, config)) continue;
            result.addError(this, 102, target2);
            isValid = false;
        }
        HashMap<String, Set<String>> existingSchemaNameByTypeName = new HashMap<String, Set<String>>();
        TreeMap<String, SortedSet<String>> duplicateSchemaNameByTypeName = new TreeMap<String, SortedSet<String>>();
        for (RdfTypeMapEntry me : config.getRdfTypeMapEntries().values()) {
            String target3 = me.getTarget();
            if (!this.isValidQName(target3, config)) {
                result.addError(this, 103, me.getType(), (String)StringUtils.defaultIfBlank((CharSequence)me.getSchema(), (CharSequence)""), target3);
                isValid = false;
            }
            this.gatherInfoOnDuplicateSchema(me.getType(), me.getSchema(), existingSchemaNameByTypeName, duplicateSchemaNameByTypeName);
        }
        for (String type : duplicateSchemaNameByTypeName.keySet()) {
            for (String string : (SortedSet)duplicateSchemaNameByTypeName.get(type)) {
                result.addError(this, 111, type, string);
                isValid = false;
            }
        }
        HashMap<String, Set<String>> existingSchemaNameByPropertyName = new HashMap<String, Set<String>>();
        TreeMap<String, SortedSet<String>> duplicateSchemaNameByPropertyName = new TreeMap<String, SortedSet<String>>();
        for (RdfPropertyMapEntry rdfPropertyMapEntry : config.getRdfPropertyMapEntries().values()) {
            String range;
            if (!this.isValidPropertyReferenceWithOptionalClassName(rdfPropertyMapEntry.getProperty())) {
                result.addError(this, 112, rdfPropertyMapEntry.getProperty(), rdfPropertyMapEntry.hasSchema() ? rdfPropertyMapEntry.getSchema() : "");
                isValid = false;
            }
            if (!this.isValidQName((String)(target = rdfPropertyMapEntry.getTarget()), config)) {
                result.addError(this, 104, rdfPropertyMapEntry.getProperty(), (String)StringUtils.defaultIfBlank((CharSequence)rdfPropertyMapEntry.getSchema(), (CharSequence)""), (String)target);
                isValid = false;
            }
            if (rdfPropertyMapEntry.hasRange() && !this.isValidQName(range = rdfPropertyMapEntry.getRange(), config)) {
                result.addError(this, 105, rdfPropertyMapEntry.getProperty(), (String)StringUtils.defaultIfBlank((CharSequence)rdfPropertyMapEntry.getSchema(), (CharSequence)""), range);
                isValid = false;
            }
            this.gatherInfoOnDuplicateSchema(rdfPropertyMapEntry.getProperty(), rdfPropertyMapEntry.getSchema(), existingSchemaNameByPropertyName, duplicateSchemaNameByPropertyName);
        }
        for (String string : duplicateSchemaNameByPropertyName.keySet()) {
            for (String schema : (SortedSet)duplicateSchemaNameByPropertyName.get(string)) {
                result.addError(this, 113, string, schema);
                isValid = false;
            }
        }
        for (List list : config.getStereotypeConversionParameters().values()) {
            for (StereotypeConversionParameter scp : list) {
                SortedSet<String> invalidQNames2 = this.identifyInvalidQNames(scp.getSubClassOf(), config);
                if (invalidQNames2.isEmpty()) continue;
                result.addError(this, 106, scp.getWellknown(), StringUtils.join(invalidQNames2, (String)", "));
                isValid = false;
            }
        }
        for (TypeConversionParameter typeConversionParameter : config.getTypeConversionParameters().values()) {
            invalidQNames = this.identifyInvalidQNames(typeConversionParameter.getSubClassOf(), config);
            if (invalidQNames.isEmpty()) continue;
            result.addError(this, 107, typeConversionParameter.getType(), (String)StringUtils.defaultIfBlank((CharSequence)typeConversionParameter.getSchema(), (CharSequence)""), StringUtils.join(invalidQNames, (String)", "));
            isValid = false;
        }
        for (PropertyConversionParameter propertyConversionParameter : config.getPropertyConversionParameters().values()) {
            if (!this.isValidPropertyReferenceWithOptionalClassName(propertyConversionParameter.getProperty())) {
                result.addError(this, 115, propertyConversionParameter.getProperty(), propertyConversionParameter.hasSchema() ? propertyConversionParameter.getSchema() : "");
                isValid = false;
            }
            if (propertyConversionParameter.hasTarget()) {
                target = propertyConversionParameter.getTarget();
                if (((String)target).isEmpty() || !((String)target).contains("::")) {
                    result.addError(this, 116, (String)target, propertyConversionParameter.getProperty(), propertyConversionParameter.hasSchema() ? propertyConversionParameter.getSchema() : "");
                    isValid = false;
                }
                if (!propertyConversionParameter.hasTargetSchema()) {
                    result.addError(this, 116, propertyConversionParameter.getProperty(), propertyConversionParameter.hasSchema() ? propertyConversionParameter.getSchema() : "");
                    isValid = false;
                }
            }
            if (propertyConversionParameter.hasSubPropertyOf() && !(invalidQNames = this.identifyInvalidQNames(propertyConversionParameter.getSubPropertyOf(), config)).isEmpty()) {
                result.addError(this, 108, propertyConversionParameter.getProperty(), (String)StringUtils.defaultIfBlank((CharSequence)propertyConversionParameter.getSchema(), (CharSequence)""), StringUtils.join(invalidQNames, (String)", "));
                isValid = false;
            }
            if (!propertyConversionParameter.isGlobal() || propertyConversionParameter.hasSchema() && !propertyConversionParameter.getSchema().trim().isEmpty() && propertyConversionParameter.getProperty().contains("::")) continue;
            result.addError(this, 114, propertyConversionParameter.getProperty(), propertyConversionParameter.hasSchema() ? propertyConversionParameter.getSchema() : "");
            isValid = false;
        }
        for (ConstraintMapping constraintMapping : config.getConstraintMappings().values()) {
            target = constraintMapping.getTarget();
            if (this.isValidQName((String)target, config)) continue;
            result.addError(this, 109, constraintMapping.getConstraintType().name(), (String)target);
            isValid = false;
        }
        for (RdfGeneralProperty rdfGeneralProperty : config.getGeneralProperties()) {
            if (rdfGeneralProperty.hasDomain() && !this.isValidQName(rdfGeneralProperty.getDomain(), config)) {
                result.addError(this, 118, rdfGeneralProperty.getName(), rdfGeneralProperty.getDomain());
                isValid = false;
            }
            if (rdfGeneralProperty.hasRange() && !this.isValidQName(rdfGeneralProperty.getRange(), config)) {
                result.addError(this, 119, rdfGeneralProperty.getName(), rdfGeneralProperty.getRange());
                isValid = false;
            }
            isValid = isValid && this.checkPropertyIdentifiers(result, rdfGeneralProperty.getName(), rdfGeneralProperty.getEquivalentProperty(), "equivalentProperty");
            isValid = isValid && this.checkPropertyIdentifiers(result, rdfGeneralProperty.getName(), rdfGeneralProperty.getDisjointProperty(), "disjointProperty");
            boolean bl = isValid = isValid && this.checkPropertyIdentifiers(result, rdfGeneralProperty.getName(), rdfGeneralProperty.getSubPropertyOf(), "subPropertyOf");
            if (rdfGeneralProperty instanceof GeneralObjectProperty) {
                GeneralObjectProperty gop = (GeneralObjectProperty)rdfGeneralProperty;
                isValid = isValid && this.checkPropertyIdentifiers(result, gop.getName(), gop.getInverseProperty(), "inverseProperty");
            }
            for (String apQName : rdfGeneralProperty.getAdditionalProperties().keySet()) {
                if (this.isValidQNameSyntax(apQName)) continue;
                result.addError(this, 121, rdfGeneralProperty.getName(), apQName);
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean isValidQNameSyntax(String qname) {
        String[] qnameParts = qname.split(":");
        if (qnameParts.length != 2) {
            return false;
        }
        String prefix = qnameParts[0];
        String resourceName = qnameParts[1];
        return !StringUtils.isBlank((CharSequence)prefix) && !StringUtils.isBlank((CharSequence)resourceName);
    }

    private boolean checkPropertyIdentifiers(ShapeChangeResult result, String name, SortedSet<String> propertyIdentifiers, String sourceElementName) {
        boolean isValid = true;
        for (String propertyIdentifier : propertyIdentifiers) {
            if (propertyIdentifier.contains("::")) {
                if (this.isValidPropertyFullName(propertyIdentifier)) continue;
                result.addError(this, 120, name, sourceElementName, propertyIdentifier);
                isValid = false;
                continue;
            }
            if (propertyIdentifier.contains(":")) {
                if (this.isValidQNameSyntax(propertyIdentifier)) continue;
                result.addError(this, 122, name, sourceElementName, propertyIdentifier);
                isValid = false;
                continue;
            }
            result.addError(this, 123, name, sourceElementName, propertyIdentifier);
            isValid = false;
        }
        return isValid;
    }

    private boolean isValidPropertyReferenceWithOptionalClassName(String propertyReference) {
        String[] parts;
        return !propertyReference.contains("::") || (parts = propertyReference.split("::")).length == 2 && parts[0].trim().length() != 0 && parts[1].trim().length() != 0;
    }

    private boolean isValidPropertyFullName(String propertyIdentifier) {
        int countSeparators = StringUtils.countMatches((CharSequence)propertyIdentifier, (CharSequence)"::");
        String[] parts = propertyIdentifier.split("::");
        return countSeparators >= 2 && parts.length == countSeparators + 1 && !Arrays.stream(parts).anyMatch(part -> StringUtils.isBlank((CharSequence)part));
    }

    private void gatherInfoOnDuplicateSchema(String relevantName, String schemaIn, Map<String, Set<String>> existingSchemaNameByRelevantName, SortedMap<String, SortedSet<String>> duplicateSchemaNameByRelevantName) {
        String schema;
        String string = schema = StringUtils.isNotBlank((CharSequence)schemaIn) ? schemaIn : "<all>";
        if (existingSchemaNameByRelevantName.containsKey(relevantName)) {
            Set<String> existingSchemaNames = existingSchemaNameByRelevantName.get(relevantName);
            if (existingSchemaNames.contains(schema)) {
                if (duplicateSchemaNameByRelevantName.containsKey(relevantName)) {
                    existingSchemaNameByRelevantName.get(relevantName).add(schema);
                } else {
                    TreeSet<String> duplicateSchemaNames = new TreeSet<String>();
                    duplicateSchemaNames.add(schema);
                    existingSchemaNameByRelevantName.put(relevantName, duplicateSchemaNames);
                }
            } else {
                existingSchemaNames.add(schema);
            }
        } else {
            HashSet<String> existingSchemaNames = new HashSet<String>();
            existingSchemaNames.add(schema);
            existingSchemaNameByRelevantName.put(relevantName, existingSchemaNames);
        }
    }

    private SortedSet<String> identifyInvalidQNames(Set<String> qnames, TargetOwlConfiguration config) {
        TreeSet<String> invalidQNames = new TreeSet<String>();
        for (String qname : qnames) {
            if (this.isValidQName(qname, config)) continue;
            invalidQNames.add(qname);
        }
        return invalidQNames;
    }

    private boolean isValidQName(String qname, TargetOwlConfiguration config) {
        String[] qnameParts = qname.split(":");
        if (qnameParts.length != 2) {
            return false;
        }
        String prefix = qnameParts[0];
        String resourceName = qnameParts[1];
        return !StringUtils.isBlank((CharSequence)prefix) && !StringUtils.isBlank((CharSequence)resourceName) && config.hasNamespaceWithAbbreviation(prefix);
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: OWLISO19150 target configuration element with 'inputs'='$1$'.";
            }
            case 100: {
                return "Configuration parameter 'generalPropertyNamespaceAbbreviation' is set, with value '$1$'. However, no namespace is configured with that abbreviation.";
            }
            case 101: {
                return "Configuration parameter '$1$' is set (maybe using the default), with invalid value '$2$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 102: {
                return "??Found DescriptorTarget with invalid @target value '$1$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 103: {
                return "??RdfTypeMapEntry with @type '$1$' and @schema '$2$' has invalid @target value '$3$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 104: {
                return "??RdfPropertyMapEntry with @property '$1$' and @schema '$2$' has invalid @target value '$3$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 105: {
                return "??RdfPropertyMapEntry with @property '$1$' and @schema '$2$' has invalid @range value '$3$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 106: {
                return "??StereotypeConversionParameter with @wellknown '$1$' has invalid QName(s) in its @subClassOf, namely: '$2$'. Each value in @subClassOf must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 107: {
                return "??TypeConversionParameter with @type '$1$' and @schema '$2$' has invalid QName(s) in its @subClassOf, namely: '$3$'. Each value in @subClassOf must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 108: {
                return "??PropertyConversionParameter with @property '$1$' and @schema '$2$' has invalid QName(s) in its @subPropertyOf, namely: '$3$'. Each value in @subPropertyOf must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 109: {
                return "??ConstraintMapping with @constraintType '$1$' has invalid (maybe using the default) @target value '$2$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 110: {
                return "Value of field [[$1$]] in @template of DescriptorTarget configuration element for 'target' $2$ does not match regular expression TV(\\(.+?\\))?:(.+)";
            }
            case 111: {
                return "Multiple RdfTypeMapEntry elements with @type '$1$' and @schema '$2$' encountered. The combination of type and schema must be unique.";
            }
            case 112: {
                return "Value '$1$' of @property in the RdfPropertyMapEntry configuration element (for @property '$1$' and @schema '$2$') is not well-formed.";
            }
            case 113: {
                return "Multiple RdfPropertyMapEntry elements with @property '$1$' and @schema '$2$' encountered. The combination of property and schema must be unique.";
            }
            case 114: {
                return "The PropertyConversionParameter (for @property '$1$' and @schema '$2$')' with 'global' set to true is not well-formed. The 'property' must be scoped to a class and a schema must be given so that the parameter identifies a single property from the model.";
            }
            case 115: {
                return "Value '$1$' of @property in the PropertyConversionParameter configuration element (for @property '$1$' and @schema '$2$') is not well-formed.";
            }
            case 116: {
                return "Value '$1$' of @target in the PropertyConversionParameter configuration element (for @property '$2$' and @schema '$3$') is not well-formed. It must not be empty and must include '::' (because it shall identify a global property, scoped to a specific class, and from a specific schema).";
            }
            case 117: {
                return "The PropertyConversionParameter configuration element (for @property '$1$' and schema '$2$') has a value for @target but does not have a value for @targetSchema - both must be set or none of them.";
            }
            case 118: {
                return "??General property configuration element with name '$1$' has invalid domain value '$2$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 119: {
                return "??General property configuration element with name '$1$' has invalid range value '$2$'. The value must be a QName of the form '{prefix}:{name}', where {prefix} matches the abbreviation of one of the namespaces defined in the target configuration.";
            }
            case 120: {
                return "??General property configuration element with name '$1$' has invalid $2$ value '$3$'. The value contains '::' and therefore denotes the full name of a UML property (i.e. the package qualified name of the UML property, starting with the application schema package, and using '::' as separator). The full name is malformed (either it has less than three parts [example: A::B], or at least one of the parts does not represent a name [examples: A::B::::C, A::B::]).";
            }
            case 121: {
                return "??General property configuration element with name '$1$' has additionalProperty with invalid property identifier value '$2$'. The value must be a QName of the form '{prefix}:{name}'.";
            }
            case 122: {
                return "??General property configuration element with name '$1$' has invalid $2$ value '$3$'. The value contains ':' (and not '::') and therefore denotes a QName, but the value is not of the required form '{prefix}:{name}'.";
            }
            case 123: {
                return "??General property configuration element with name '$1$' has invalid $2$ value '$3$'. The value neither contains ':' nor '::' and is therefore not of the required format (either a QName or the full name of a UML property).";
            }
        }
        return "(" + OWLISO19150ConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

