/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ontology;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.PropertyConversionParameter;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Ontology.OntologyModel;
import de.interactive_instruments.ShapeChange.Target.Ontology.RdfGeneralProperty;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.TargetUtil;
import de.interactive_instruments.ShapeChange.TargetOwlConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class OWLISO19150
implements SingleTarget,
MessageSource {
    public static final String RDF_NS_W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema#";
    public static final String RDF_NS_W3C_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_NS_W3C_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String RDF_NS_W3C_OWL = "http://www.w3.org/2002/07/owl#";
    public static final String RDF_NS_DC = "http://purl.org/dc/elements/1.1/";
    public static final String RDF_NS_DCT = "http://purl.org/dc/terms/";
    public static final String RDF_NS_W3C_SKOS = "http://www.w3.org/2004/02/skos/core#";
    public static final String RDF_NS_ISO_19150_2 = "http://def.isotc211.org/iso19150/-2/2012/base#";
    public static final String RDF_NS_OGC_GEOSPARQL = "http://www.opengis.net/ont/geosparql#";
    public static final String RDF_NS_ISO_GFM = "http://def.isotc211.org/iso19109/2013/GeneralFeatureModel#";
    public static final String PREFIX_ISO_19150_2 = "iso19150-2";
    public static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String NS_QNAME_ERROR = "http://example.org/qname/error/";
    public static final String NS_QNAME_ERROR_PREFIX = "qnerr";
    public static final String TV_UNION_SET = "SC_UNION_SET";
    public static final String TV_SKOS_CONCEPT_SCHEME_SUBCLASS_NAME = "skosConceptSchemeSubclassName";
    public static final String TV_BROADER_LISTED_VALUE = "broaderListedValue";
    public static final String RULE_OWL_PKG_SINGLE_ONTOLOGY_PER_SCHEMA = "rule-owl-pkg-singleOntologyPerSchema";
    public static final String RULE_OWL_PKG_ONTOLOGY_NAME_BY_TAGGED_VALUE = "rule-owl-pkg-ontologyName-byTaggedValue";
    public static final String RULE_OWL_PKG_ONTOLOGY_NAME_WITH_PATH = "rule-owl-pkg-ontologyName-withPath";
    public static final String RULE_OWL_PKG_ONTOLOGY_NAME_CODE = "rule-owl-pkg-ontologyName-code";
    public static final String RULE_OWL_PKG_ONTOLOGY_NAME_ISO191502 = "rule-owl-pkg-ontologyName-iso191502";
    public static final String RULE_OWL_PKG_ONTOLOGY_NAME_APPEND_VERSION = "rule-owl-pkg-ontologyName-appendVersion";
    public static final String RULE_OWL_PKG_VERSION_IRI_AVOID_DUPLICATE_VERSION = "rule-owl-pkg-versionIRI-avoid-duplicate-version";
    public static final String RULE_OWL_PKG_VERSION_IRI = "rule-owl-pkg-versionIRI";
    public static final String RULE_OWL_PKG_VERSION_INFO = "rule-owl-pkg-versionInfo";
    public static final String RULE_OWL_ALL_CONSTRAINTS_HUMAN_READABLE_TEXT_ONLY = "rule-owl-all-constraints-humanReadableTextOnly";
    public static final String RULE_OWL_ALL_CONSTRAINTS_BY_CONSTRAINT_MAPPING = "rule-owl-all-constraints-byConstraintMapping";
    public static final String RULE_OWL_CLS_19150_2_ISABSTRACT = "rule-owl-cls-iso191502IsAbstract";
    public static final String RULE_OWL_PROP_PROPERTYENRICHMENT = "rule-owl-prop-propertyEnrichment";
    public static final String RULE_OWL_PKG_IMPORT_191502BASE = "rule-owl-pkg-importISO191502Base";
    public static final String RULE_OWL_PROP_GENERAL = "rule-owl-prop-general";
    public static final String RULE_OWL_PROP_RANGE_LOCAL_UNIVERSAL_QUANTIFICATION = "rule-owl-prop-range-local-withUniversalQuantification";
    public static final String RULE_OWL_PROP_RANGE_GLOBAL = "rule-owl-prop-range-global";
    public static final String RULE_OWL_PROP_GLOBAL_SCOPE_ATTRIBUTES = "rule-owl-prop-globalScopeAttributes";
    public static final String RULE_OWL_PROP_LOCAL_SCOPE_ALL = "rule-owl-prop-localScopeAll";
    public static final String RULE_OWL_PROP_GLOBAL_SCOPE_BY_CONVERSION_PARAMETER = "rule-owl-prop-globalScopeByConversionParameter";
    public static final String RULE_OWL_PROP_GLOBAL_SCOPE_BY_UNIQUE_PROPERTY_NAME = "rule-owl-prop-globalScopeByUniquePropertyName";
    public static final String RULE_OWL_PROP_MULTIPLICITY_QUALIFIED_RESTRICTION = "rule-owl-prop-multiplicityAsQualifiedCardinalityRestriction";
    public static final String RULE_OWL_PROP_MULTIPLICITY_UNQUALIFIED_RESTRICTION = "rule-owl-prop-multiplicityAsUnqualifiedCardinalityRestriction";
    public static final String RULE_OWL_PROP_VOIDABLE_AS_MINCARDINALITY0 = "rule-owl-prop-voidable-as-minCardinality0";
    public static final String RULE_OWL_PROP_MAPPING_COMPARE_SPECIFICATIONS = "rule-owl-prop-mapping-compare-specifications";
    public static final String RULE_OWL_PROP_ISO191502_ASSOCIATION_NAME = "rule-owl-prop-iso191502AssociationName";
    public static final String RULE_OWL_PROP_INVERSEOF = "rule-owl-prop-inverseOf";
    public static final String RULE_OWL_PROP_ISO191502_AGGREGATION = "rule-owl-prop-iso191502Aggregation";
    public static final String RULE_OWL_PROP_ISO191502_NAMING = "rule-owl-prop-iso191502-naming";
    public static final String RULE_OWL_PROP_EXTERNAL_REFERENCE = "rule-owl-prop-external-reference";
    public static final String RULE_OWL_PKG_DCT_SOURCE_TITLE = "rule-owl-pkg-dctSourceTitle";
    public static final String RULE_OWL_CLS_CODELIST_EXTERNAL = "rule-owl-cls-codelist-external";
    public static final String RULE_OWL_CLS_CODELIST_191502 = "rule-owl-cls-codelist-19150-2";
    public static final String RULE_OWL_CLS_CODELIST_191502_CONCEPTSCHEMESUBCLASS = "rule-owl-cls-codelist-19150-2-conceptSchemeSubclass";
    public static final String RULE_OWL_CLS_CODELIST_191502_DIFFERENTINDIVIDUALS = "rule-owl-cls-codelist-19150-2-differentIndividuals";
    public static final String RULE_OWL_CLS_CODELIST_191502_CLASSINDIFFERENTNAMESPACE = "rule-owl-cls-codelist-19150-2-owlClassInDifferentNamespace";
    public static final String RULE_OWL_CLS_CODELIST_191502_SKOS_COLLECTION = "rule-owl-cls-codelist-19150-2-skos-collection";
    public static final String RULE_OWL_CLS_CODELIST_191502_OBJECTONEOFFORENUMERATION = "rule-owl-cls-codelist-19150-2-objectOneOfForEnumeration";
    public static final String RULE_OWL_PROP_CODE_BROADER_BY_BROADER_LISTED_VALUE = "rule-owl-prop-code-broader-byBroaderListedValue";
    public static final String RULE_OWL_CLS_ENUMERATION_AS_CODELIST = "rule-owl-cls-enumerationAsCodelist";
    public static final String RULE_OWL_CLS_ISO191502_ENUMERATION = "rule-owl-cls-iso191502Enumeration";
    public static final String RULE_OWL_CLS_GENERALIZATION = "rule-owl-cls-generalization";
    public static final String RULE_OWL_CLS_DISJOINT_CLASSES = "rule-owl-cls-disjoint-classes";
    public static final String RULE_OWL_CLS_ENCODE_FEATURETYPES = "rule-owl-cls-encode-featuretypes";
    public static final String RULE_OWL_CLS_ENCODE_OBJECTTYPES = "rule-owl-cls-encode-objecttypes";
    public static final String RULE_OWL_CLS_ENCODE_MIXINTYPES = "rule-owl-cls-encode-mixintypes";
    public static final String RULE_OWL_CLS_ENCODE_DATATYPES = "rule-owl-cls-encode-datatypes";
    public static final String RULE_OWL_CLS_ENCODE_BASICTYPES = "rule-owl-cls-encode-basictypes";
    public static final String RULE_OWL_CLS_UNION = "rule-owl-cls-union";
    public static final String RULE_OWL_CLS_UNION_SETS = "rule-owl-cls-unionSets";
    public static final String PARAM_SOURCE = "source";
    public static final String PARAM_DEFAULT_TYPE_IMPL = "defaultTypeImplementation";
    public static final String PARAM_CODE_NAMESPACE = "codeNamespace";
    public static final String PARAM_CODE_NAMESPACE_FOR_ENUMERATIONS = "codeNamespaceForEnumerations";
    public static final String PARAM_CODE_LIST_OWL_CLASS_NAMESPACE = "codeListOwlClassNamespace";
    public static final String PARAM_CODE_LIST_OWL_CLASS_NAMESPACE_FOR_ENUMERATIONS = "codeListOwlClassNamespaceForEnumerations";
    public static final String PARAM_GENERAL_PROPERTY_NSABR = "generalPropertyNamespaceAbbreviation";
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_OUTPUTFORMAT = "outputFormat";
    public static final String PARAM_SOURCE_TAGGED_VALUE_NAME = "sourceTaggedValueName";
    public static final String PARAM_SKOS_CONCEPT_SCHEME_SUFFIX = "skosConceptSchemeSuffix";
    public static final String PARAM_SKOS_CONCEPT_SCHEME_SUBCLASS_NAME_SUFFIX = "skosConceptSchemeSubclassSuffix";
    public static final String PARAM_URIBASE = "URIbase";
    public static final String PARAM_RDFXMLWRITER_BLOCKRULES = "rdfXmlWriterBlockRules";
    public static final String DEFAULT_RDFXMLWRITER_BLOCKRULES = "idAttr,propertyAttr";
    public static final String PARAM_RDF_NAMESPACE_SEPARATOR = "rdfNamespaceSeparator";
    public static final String PARAM_ONTOLOGYNAME_TAGGED_VALUE_NAME = "ontologyNameTaggedValue";
    public static final String PARAM_ONTOLOGYNAME_CODE_NAME = "ontologyNameCode";
    public static final String PARAM_PROP_EXTERNAL_REFERENCE_TARGET_PROPERTY = "propExternalReference_targetProperty";
    public static final String PARAM_SUPPRESS_MESSAGES_FOR_UNSUPPORTED_CLASS_CATEGORY = "suppressMessagesForUnsupportedCategoryOfClasses";
    protected static SortedMap<PackageInfo, OntologyModel> ontologyByPiMap = new TreeMap<PackageInfo, OntologyModel>();
    protected static SortedMap<String, OntologyModel> ontologyByRdfNs = new TreeMap<String, OntologyModel>();
    protected static SortedMap<ClassInfo, OntologyModel> ontologyByCi = new TreeMap<ClassInfo, OntologyModel>();
    protected static SortedMap<String, Integer> counterByXmlprefix = new TreeMap<String, Integer>();
    protected static SortedMap<String, String> rdfNsByPrefix = new TreeMap<String, String>();
    protected static String codeNamespace = null;
    protected static String codeNamespaceForEnumerations = null;
    protected static String codeListOwlClassNamespace = null;
    protected static String codeListOwlClassNamespaceForEnumerations = null;
    protected static String prefixCodeNamespace = "c";
    protected static String prefixCodeNamespaceForEnumerations = "e";
    protected static String prefixCodeListOwlClassNamespace = "cc";
    protected static String prefixCodeListOwlClassNamespaceForEnumerations = "ce";
    protected static String propExternalReference_targetProperty = "rdfs:seeAlso";
    private static boolean error = false;
    private static boolean printed = false;
    private static String outputDirectory = null;
    private Options options = null;
    private static TargetOwlConfiguration config = null;
    private static ShapeChangeResult result = null;
    private static Model model = null;
    private static PackageInfo mainAppSchema = null;
    private static String mainAppSchemaNamespace = null;
    private static String skosConceptSchemeSuffix = "";
    private static String skosConceptSchemeSubclassSuffix = "";
    private static String source = null;
    private static String sourceTaggedValue = null;
    private static String uriBase = null;
    private static String rdfXmlWriterBlockRules = null;
    private static String rdfNamespaceSeparator = "#";
    private static String language = "en";
    private static String outputFormat = "TURTLE";
    private static RDFFormat rdfFormat = RDFFormat.TURTLE;
    private static String fileNameExtension = ".ttl";
    private static String ontologyNameTaggedValue = "ontologyName";
    private static String ontologyNameCode = null;
    private static String defaultTypeImplementation = null;
    private static boolean suppressMessagesForUnsupportedCategoryOfClasses = false;
    private static String generalPropertyNamespaceAbbreviation = null;
    private static SortedMap<String, OntologyModel> ontologyByPropertyConversionTargetReference = null;
    private static SortedMap<String, List<OntProperty>> subPropertyByURIOfSuperProperty = new TreeMap<String, List<OntProperty>>();

    @Override
    public String getTargetName() {
        return "ISO 19150-2 OWL Ontology";
    }

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String propExternalReference_targetProperty_tmp;
        String codeListOwlClassNamespaceForEnumerations_tmp;
        String codeListOwlClassNamespace_tmp;
        String codeNamespaceForEnumerations_tmp;
        String codeNamespace_tmp;
        String defaultTypeImplementation_tmp;
        String ontologyNameCodeFromConfig;
        String ontologyNameTaggedValueNameFromConfig;
        String langFromConfig;
        String uriBaseFromConfig;
        String sourceTaggedValueNameFromConfig;
        String skosConceptSchemeSubclassSuffixFromConfig;
        String outputFormatFromConfig;
        this.options = o;
        result = r;
        model = m;
        mainAppSchema = TargetUtil.findMainSchemaForSingleTargets(model.selectedSchemas(), o, r);
        ProcessConfiguration tmp = o.getCurrentProcessConfig();
        if (!(tmp instanceof TargetOwlConfiguration)) {
            result.addError(this, 6);
            throw new ShapeChangeAbortException();
        }
        config = (TargetOwlConfiguration)tmp;
        outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = this.options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
        }
        if ((outputFormatFromConfig = config.getParameterValue(PARAM_OUTPUTFORMAT)) != null) {
            outputFormat = outputFormatFromConfig;
        }
        if (outputFormat.equalsIgnoreCase("NTRIPLES")) {
            rdfFormat = RDFFormat.NTRIPLES;
            fileNameExtension = ".nt";
        } else if (outputFormat.equalsIgnoreCase("RDFXML")) {
            rdfFormat = RDFFormat.RDFXML;
            fileNameExtension = ".rdf";
        } else if (outputFormat.equalsIgnoreCase("JSONLD")) {
            rdfFormat = RDFFormat.JSONLD;
            fileNameExtension = ".jsonld";
        } else if (outputFormat.equalsIgnoreCase("RDFJSON")) {
            rdfFormat = RDFFormat.RDFJSON;
            fileNameExtension = ".rj";
        } else if (outputFormat.equalsIgnoreCase("TRIG")) {
            rdfFormat = RDFFormat.TRIG;
            fileNameExtension = ".trig";
        } else if (outputFormat.equalsIgnoreCase("NQUADS")) {
            rdfFormat = RDFFormat.NQUADS;
            fileNameExtension = ".nq";
        } else if (outputFormat.equalsIgnoreCase("TRIX")) {
            rdfFormat = RDFFormat.TRIX;
            fileNameExtension = ".trix";
        } else if (outputFormat.equalsIgnoreCase("RDFTHRFIT")) {
            rdfFormat = RDFFormat.RDF_THRIFT;
            fileNameExtension = ".trdf";
        } else {
            rdfFormat = RDFFormat.TURTLE;
            fileNameExtension = ".ttl";
        }
        String sourceFromConfig = config.getParameterValue(PARAM_SOURCE);
        if (sourceFromConfig != null) {
            source = sourceFromConfig;
        }
        generalPropertyNamespaceAbbreviation = config.getParameterValue(PARAM_GENERAL_PROPERTY_NSABR);
        String skosConceptSchemeSuffixFromConfig = config.getParameterValue(PARAM_SKOS_CONCEPT_SCHEME_SUFFIX);
        if (skosConceptSchemeSuffixFromConfig != null) {
            skosConceptSchemeSuffix = skosConceptSchemeSuffixFromConfig;
        }
        if ((skosConceptSchemeSubclassSuffixFromConfig = config.getParameterValue(PARAM_SKOS_CONCEPT_SCHEME_SUBCLASS_NAME_SUFFIX)) != null) {
            skosConceptSchemeSubclassSuffix = skosConceptSchemeSubclassSuffixFromConfig;
        }
        if ((sourceTaggedValueNameFromConfig = config.getParameterValue(PARAM_SOURCE_TAGGED_VALUE_NAME)) != null) {
            sourceTaggedValue = sourceTaggedValueNameFromConfig;
        }
        if ((uriBaseFromConfig = config.getParameterValue(PARAM_URIBASE)) != null) {
            uriBase = uriBaseFromConfig;
        }
        rdfXmlWriterBlockRules = this.options.parameterAsString(this.getClass().getName(), PARAM_RDFXMLWRITER_BLOCKRULES, DEFAULT_RDFXMLWRITER_BLOCKRULES, false, true);
        String rdfNamespaceSeparatorFromConfig = config.getParameterValue(PARAM_RDF_NAMESPACE_SEPARATOR);
        if (rdfNamespaceSeparatorFromConfig != null) {
            rdfNamespaceSeparator = rdfNamespaceSeparatorFromConfig.trim();
        }
        if ((langFromConfig = config.getParameterValue(PARAM_LANGUAGE)) != null) {
            language = langFromConfig;
        }
        if ((ontologyNameTaggedValueNameFromConfig = config.getParameterValue(PARAM_ONTOLOGYNAME_TAGGED_VALUE_NAME)) != null) {
            ontologyNameTaggedValue = ontologyNameTaggedValueNameFromConfig;
        }
        if ((ontologyNameCodeFromConfig = config.getParameterValue(PARAM_ONTOLOGYNAME_CODE_NAME)) != null) {
            ontologyNameCode = ontologyNameCodeFromConfig;
        }
        if ((defaultTypeImplementation_tmp = config.getParameterValue(PARAM_DEFAULT_TYPE_IMPL)) != null && defaultTypeImplementation_tmp.contains(":")) {
            defaultTypeImplementation = defaultTypeImplementation_tmp;
        }
        if ((codeNamespace_tmp = config.getParameterValue(PARAM_CODE_NAMESPACE)) != null && codeNamespace_tmp.trim().length() > 0) {
            codeNamespace = codeNamespace_tmp.trim();
        }
        if ((codeNamespaceForEnumerations_tmp = config.getParameterValue(PARAM_CODE_NAMESPACE_FOR_ENUMERATIONS)) != null && codeNamespaceForEnumerations_tmp.trim().length() > 0) {
            codeNamespaceForEnumerations = codeNamespaceForEnumerations_tmp.trim();
        }
        if ((codeListOwlClassNamespace_tmp = config.getParameterValue(PARAM_CODE_LIST_OWL_CLASS_NAMESPACE)) != null && codeListOwlClassNamespace_tmp.trim().length() > 0) {
            codeListOwlClassNamespace = codeListOwlClassNamespace_tmp.trim();
        }
        if ((codeListOwlClassNamespaceForEnumerations_tmp = config.getParameterValue(PARAM_CODE_LIST_OWL_CLASS_NAMESPACE_FOR_ENUMERATIONS)) != null && codeListOwlClassNamespaceForEnumerations_tmp.trim().length() > 0) {
            codeListOwlClassNamespaceForEnumerations = codeListOwlClassNamespaceForEnumerations_tmp.trim();
        }
        if ((propExternalReference_targetProperty_tmp = config.getParameterValue(PARAM_PROP_EXTERNAL_REFERENCE_TARGET_PROPERTY)) != null && propExternalReference_targetProperty_tmp.contains(":")) {
            propExternalReference_targetProperty = propExternalReference_targetProperty_tmp.trim();
        }
        suppressMessagesForUnsupportedCategoryOfClasses = this.options.parameterAsBoolean(this.getClass().getName(), PARAM_SUPPRESS_MESSAGES_FOR_UNSUPPORTED_CLASS_CATEGORY, false);
        String xmlPrefixOfMainSchema = p.xmlns();
        OntologyModel od = new OntologyModel(p, m, o, r, xmlPrefixOfMainSchema, this);
        if (ontologyByRdfNs.containsKey(od.getRdfNamespace())) {
            od = (OntologyModel)ontologyByRdfNs.get(od.getRdfNamespace());
        }
        ontologyByPiMap.put(p, od);
        ontologyByRdfNs.put(od.getRdfNamespace(), od);
        if (mainAppSchema != null && mainAppSchema == p) {
            mainAppSchemaNamespace = od.getRdfNamespace();
        }
        if (p.matches(RULE_OWL_PKG_SINGLE_ONTOLOGY_PER_SCHEMA)) {
            TreeSet<ClassInfo> ontclasses = new TreeSet<ClassInfo>();
            ontclasses.addAll(model.classes(p));
            this.createAdditionalOntologyModels(ontclasses, od.getPrefix(), od.getRdfNamespace(), od.getName(), od.getPath(), od.getFileName(), p.version());
        } else {
            SortedSet<PackageInfo> subPkgsInSameTNS = this.subPackagesInSameTNS(p);
            int counter = 1;
            for (PackageInfo subPi : subPkgsInSameTNS) {
                String xmlprefix = xmlPrefixOfMainSchema + counter;
                ++counter;
                OntologyModel odSub = new OntologyModel(subPi, m, o, r, xmlprefix, this);
                ontologyByPiMap.put(subPi, odSub);
                ontologyByRdfNs.put(odSub.getRdfNamespace(), odSub);
                TreeSet<ClassInfo> ontclasses = new TreeSet<ClassInfo>();
                ontclasses.addAll(subPi.containedClasses());
                this.createAdditionalOntologyModels(ontclasses, odSub.getPrefix(), odSub.getRdfNamespace(), odSub.getName(), odSub.getPath(), odSub.getFileName(), subPi.version());
            }
        }
    }

    private void createAdditionalOntologyModels(SortedSet<ClassInfo> classes, String basePrefix, String baseRdfns, String baseName, String path, String baseFileName, String version) throws ShapeChangeAbortException {
        for (ClassInfo ci : classes) {
            OntologyModel om;
            String rdfns;
            Object fileNameOntIndividuals;
            String pathOntIndividuals;
            Object nameOntIndividuals;
            Object prefixOntIndividuals;
            if (!this.isEncodedAsCodeList(ci)) continue;
            if (ci.category() == 3 && codeNamespaceForEnumerations != null) {
                prefixOntIndividuals = prefixCodeNamespaceForEnumerations;
                nameOntIndividuals = codeNamespaceForEnumerations;
                pathOntIndividuals = "";
                fileNameOntIndividuals = "enums";
            } else if (codeNamespace != null) {
                prefixOntIndividuals = prefixCodeNamespace;
                nameOntIndividuals = codeNamespace;
                pathOntIndividuals = "";
                fileNameOntIndividuals = "codes";
            } else {
                prefixOntIndividuals = basePrefix + "code";
                nameOntIndividuals = baseName + "/code";
                pathOntIndividuals = path;
                fileNameOntIndividuals = baseFileName + "_codes";
            }
            String rdfnsOntIndividuals = (String)nameOntIndividuals + this.getRdfNamespaceSeparator();
            if (!ontologyByRdfNs.containsKey(rdfnsOntIndividuals)) {
                OntologyModel om2 = new OntologyModel(model, this.options, result, (String)prefixOntIndividuals, rdfnsOntIndividuals, (String)nameOntIndividuals, pathOntIndividuals, (String)fileNameOntIndividuals, this);
                ontologyByRdfNs.put(rdfnsOntIndividuals, om2);
            }
            if (!ci.matches(RULE_OWL_CLS_CODELIST_191502_CLASSINDIFFERENTNAMESPACE)) continue;
            if (codeListOwlClassNamespace == null && codeListOwlClassNamespaceForEnumerations == null) {
                result.addWarning(this, 9);
            }
            if (ci.category() == 3 && codeListOwlClassNamespaceForEnumerations != null) {
                rdfns = codeListOwlClassNamespaceForEnumerations + this.getRdfNamespaceSeparator();
                if (ontologyByRdfNs.containsKey(rdfns)) continue;
                om = new OntologyModel(model, this.options, result, prefixCodeListOwlClassNamespaceForEnumerations, rdfns, codeListOwlClassNamespaceForEnumerations, "", "enumerations", this);
                ontologyByRdfNs.put(rdfns, om);
                continue;
            }
            if (codeListOwlClassNamespace == null || ontologyByRdfNs.containsKey(rdfns = codeListOwlClassNamespace + this.getRdfNamespaceSeparator())) continue;
            om = new OntologyModel(model, this.options, result, prefixCodeListOwlClassNamespace, rdfns, codeListOwlClassNamespace, "", "code_lists", this);
            ontologyByRdfNs.put(rdfns, om);
        }
    }

    private SortedSet<PackageInfo> subPackagesInSameTNS(PackageInfo pi) {
        TreeSet<PackageInfo> result = new TreeSet<PackageInfo>();
        SortedSet<PackageInfo> childPis = pi.containedPackages();
        if (childPis != null) {
            for (PackageInfo childPi : childPis) {
                if (!childPi.targetNamespace().equals(pi.targetNamespace())) continue;
                result.add(childPi);
                result.addAll(this.subPackagesInSameTNS(childPi));
            }
        }
        return result;
    }

    @Override
    public void process(ClassInfo ci) {
        if (error) {
            return;
        }
        OntologyModel om = this.computeRelevantOntology(ci);
        if (om == null) {
            ShapeChangeResult.MessageContext mc = result.addError(this, 2, ci.name());
            if (mc != null) {
                mc.addDetail(this, 10000, ci.fullName());
            }
        } else {
            ontologyByCi.put(ci, om);
            om.addClass(ci);
        }
    }

    public OntologyModel computeRelevantOntologyForIndividuals(ClassInfo ci) {
        PackageInfo pCi = ci.pkg();
        PackageInfo relevantPi = pCi.matches(RULE_OWL_PKG_SINGLE_ONTOLOGY_PER_SCHEMA) ? model.schemaPackage(ci) : pCi;
        OntologyModel om = (OntologyModel)ontologyByPiMap.get(relevantPi);
        if (this.isEncodedAsCodeList(ci)) {
            Object nameOntIndividuals = ci.category() == 3 && codeNamespaceForEnumerations != null ? codeNamespaceForEnumerations : (codeNamespace != null ? codeNamespace : om.getName() + "/code");
            String rdfnsOntIndividuals = (String)nameOntIndividuals + this.getRdfNamespaceSeparator();
            return (OntologyModel)ontologyByRdfNs.get(rdfnsOntIndividuals);
        }
        return null;
    }

    public OntologyModel computeRelevantOntology(String prefix) {
        for (OntologyModel om : ontologyByRdfNs.values()) {
            if (!om.getPrefix().equals(prefix)) continue;
            return om;
        }
        return null;
    }

    public OntologyModel computeRelevantOntology(ClassInfo ci) {
        PackageInfo relevantPi;
        if (ontologyByCi.containsKey(ci)) {
            return (OntologyModel)ontologyByCi.get(ci);
        }
        PackageInfo pCi = ci.pkg();
        if (pCi.matches(RULE_OWL_PKG_SINGLE_ONTOLOGY_PER_SCHEMA)) {
            relevantPi = model.schemaPackage(ci);
            if (relevantPi == null) {
                return null;
            }
        } else {
            relevantPi = pCi;
        }
        OntologyModel om = (OntologyModel)ontologyByPiMap.get(relevantPi);
        if (this.isEncodedAsCodeList(ci) && ci.matches(RULE_OWL_CLS_CODELIST_191502_CLASSINDIFFERENTNAMESPACE)) {
            if (ci.category() == 3 && codeListOwlClassNamespaceForEnumerations != null) {
                String rdfns = codeListOwlClassNamespaceForEnumerations + this.getRdfNamespaceSeparator();
                om = (OntologyModel)ontologyByRdfNs.get(rdfns);
            } else if (codeListOwlClassNamespace != null) {
                String rdfns = codeListOwlClassNamespace + this.getRdfNamespaceSeparator();
                om = (OntologyModel)ontologyByRdfNs.get(rdfns);
            }
        }
        return om;
    }

    private boolean isEncodedAsCodeList(ClassInfo ci) {
        boolean result = ci.matches(RULE_OWL_CLS_CODELIST_191502) && (ci.category() == 2 && config.getTypeMapEntry(ci) == null || ci.category() == 3 && config.getTypeMapEntry(ci) == null && ci.matches(RULE_OWL_CLS_ENUMERATION_AS_CODELIST)) && (!ci.matches(RULE_OWL_CLS_CODELIST_EXTERNAL) || ci.taggedValuesForTagList("codeList,vocabulary").isEmpty());
        return result;
    }

    public OntologyModel computeRelevantOntologyForTargetMapping(PropertyConversionParameter pcp) {
        if (pcp == null || !pcp.hasTarget()) {
            return null;
        }
        return (OntologyModel)ontologyByPropertyConversionTargetReference.get(pcp.getTarget() + "#" + pcp.getTargetSchema());
    }

    @Override
    public void write() {
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        if (error || printed) {
            return;
        }
        ontologyByPropertyConversionTargetReference = new TreeMap<String, OntologyModel>();
        block0: for (PackageInfo packageInfo : model.selectedSchemas()) {
            for (ClassInfo ci : model.classes(packageInfo)) {
                if (ci.category() != 1 && ci.category() != 6 && ci.category() != 5 && ci.category() != 4 && ci.category() != 7) continue;
                for (PropertyInfo prop : ci.properties().values()) {
                    if (!prop.matches(RULE_OWL_PROP_GLOBAL_SCOPE_BY_CONVERSION_PARAMETER) || !prop.matches(RULE_OWL_PROP_GENERAL)) break block0;
                    PropertyConversionParameter pcp = config.getPropertyConversionParameter(prop);
                    if (pcp == null || !pcp.isGlobal() || pcp.hasTarget()) continue;
                    OntologyModel om = this.computeRelevantOntology(prop.inClass());
                    ontologyByPropertyConversionTargetReference.put(pcp.getProperty() + "#" + pcp.getSchema(), om);
                }
            }
        }
        for (OntologyModel ontologyModel : ontologyByRdfNs.values()) {
            ontologyModel.createClasses();
        }
        this.addGeneralProperties();
        for (OntologyModel ontologyModel : ontologyByRdfNs.values()) {
            ontologyModel.createProperties();
        }
        for (OntologyModel ontologyModel : ontologyByRdfNs.values()) {
            ontologyModel.createAdditionalClassDetails();
        }
        for (OntologyModel ontologyModel : ontologyByRdfNs.values()) {
            ontologyModel.createAdditionalPropertyDetails();
        }
        for (OntologyModel ontologyModel : ontologyByRdfNs.values()) {
            ontologyModel.addGeneralPropertyDomainByUnionOfSubPropertyDomains();
        }
        for (OntologyModel ontologyModel : ontologyByRdfNs.values()) {
            this.print(ontologyModel, outputDirectory, r);
        }
        printed = true;
    }

    private void addGeneralProperties() {
        for (RdfGeneralProperty gp : this.getConfig().getGeneralProperties()) {
            String nsabr = gp.getNamespaceAbbreviation();
            String namespace = null;
            if (nsabr == null) {
                if (StringUtils.isNotBlank((CharSequence)generalPropertyNamespaceAbbreviation)) {
                    nsabr = generalPropertyNamespaceAbbreviation;
                    namespace = config.fullNamespace(nsabr);
                } else if (StringUtils.isBlank((CharSequence)mainAppSchemaNamespace)) {
                    result.addError(this, 100, gp.getName());
                } else {
                    namespace = mainAppSchemaNamespace;
                }
            } else if (config.hasNamespaceWithAbbreviation(nsabr)) {
                namespace = config.fullNamespace(nsabr);
            } else {
                for (OntologyModel om : ontologyByRdfNs.values()) {
                    if (!om.getPrefix().equals(nsabr)) continue;
                    namespace = om.getRdfNamespace();
                    break;
                }
                if (namespace == null) {
                    result.addError(this, 101, gp.getName(), nsabr);
                }
            }
            if (namespace == null) continue;
            gp.setNamespace(namespace);
            OntologyModel om = null;
            if (ontologyByRdfNs.containsKey(namespace)) {
                om = (OntologyModel)ontologyByRdfNs.get(namespace);
            } else {
                String fileName;
                String ontologyName = StringUtils.endsWithAny((CharSequence)namespace, (CharSequence[])new String[]{"#", "/"}) ? namespace.substring(0, namespace.length() - 1) : namespace;
                String path = "";
                String location = config.locationOfNamespace(namespace);
                if (StringUtils.isNotBlank((CharSequence)location)) {
                    fileName = FilenameUtils.getBaseName((String)location);
                } else {
                    fileName = namespace.replaceAll("[^a-zA-Z]", "_");
                    fileName = fileName.replaceAll("_+", "_");
                }
                try {
                    om = new OntologyModel(model, this.options, result, nsabr, namespace, ontologyName, path, fileName, this);
                    ontologyByRdfNs.put(namespace, om);
                }
                catch (ShapeChangeAbortException e) {
                    result.addError(this, 102, gp.getName(), e.getMessage());
                    continue;
                }
            }
            om.createGeneralProperty(nsabr, namespace, gp);
        }
    }

    public void print(OntologyModel om, String outputDirectory, ShapeChangeResult r) {
        String outDirForOntology;
        File outputDirectoryFile;
        boolean exi;
        OntModel ontmodel = om.getOntologyModel();
        String ontName = om.getName();
        String path = om.getPath();
        String filenameWithoutExtension = om.getFileName();
        ValidityReport report = ontmodel.validate();
        if (report != null && !report.isValid()) {
            result.addError(this, 7, ontName, r.toString());
        }
        if (!(exi = (outputDirectoryFile = new File(outDirForOntology = outputDirectory + path)).exists())) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            r.addFatalError(this, 8, ontName, outDirForOntology);
            return;
        }
        String filename = filenameWithoutExtension + fileNameExtension;
        String fname = outDirForOntology + "/" + filename;
        File outFile = new File(outputDirectoryFile, filename);
        try (FileOutputStream fout = new FileOutputStream(outFile);
             BufferedOutputStream bout = new BufferedOutputStream(fout);){
            String canpath = new File(fname).getCanonicalPath();
            r.addDebug(this, 20000, ontName, canpath);
            if (rdfFormat.equals((Object)RDFFormat.RDFXML)) {
                RDFWriter writer = ontmodel.getWriter("RDF/XML");
                writer.setProperty("xmlbase", (Object)om.getName());
                writer.setProperty("blockRules", (Object)rdfXmlWriterBlockRules);
                writer.setProperty("relativeURIs", (Object)"");
                writer.write((org.apache.jena.rdf.model.Model)ontmodel, (OutputStream)bout, null);
            } else {
                RDFDataMgr.write((OutputStream)bout, (org.apache.jena.rdf.model.Model)ontmodel, (RDFFormat)rdfFormat);
            }
            r.addResult(this.getTargetName(), outDirForOntology, filename, ontName);
        }
        catch (Exception e) {
            r.addError(this, 5, fname);
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void reset() {
        ontologyByPiMap = new TreeMap<PackageInfo, OntologyModel>();
        ontologyByRdfNs = new TreeMap<String, OntologyModel>();
        ontologyByCi = new TreeMap<ClassInfo, OntologyModel>();
        counterByXmlprefix = new TreeMap<String, Integer>();
        rdfNsByPrefix = new TreeMap<String, String>();
        codeNamespace = null;
        codeNamespaceForEnumerations = null;
        codeListOwlClassNamespace = null;
        codeListOwlClassNamespaceForEnumerations = null;
        prefixCodeNamespace = "c";
        prefixCodeNamespaceForEnumerations = "e";
        prefixCodeListOwlClassNamespace = "cc";
        prefixCodeListOwlClassNamespaceForEnumerations = "ce";
        propExternalReference_targetProperty = "rdfs:seeAlso";
        error = false;
        printed = false;
        outputDirectory = null;
        config = null;
        result = null;
        model = null;
        mainAppSchema = null;
        mainAppSchemaNamespace = null;
        skosConceptSchemeSuffix = "";
        skosConceptSchemeSubclassSuffix = "";
        source = null;
        sourceTaggedValue = null;
        uriBase = null;
        rdfXmlWriterBlockRules = null;
        rdfNamespaceSeparator = "#";
        language = "en";
        outputFormat = "TURTLE";
        rdfFormat = RDFFormat.TURTLE;
        fileNameExtension = ".ttl";
        ontologyNameTaggedValue = "ontologyName";
        ontologyNameCode = null;
        defaultTypeImplementation = null;
        suppressMessagesForUnsupportedCategoryOfClasses = false;
        ontologyByPropertyConversionTargetReference = null;
        generalPropertyNamespaceAbbreviation = null;
        subPropertyByURIOfSuperProperty = new TreeMap<String, List<OntProperty>>();
    }

    public String computeSource(Info i) {
        String sourceTV;
        if (sourceTaggedValue != null && StringUtils.isNotBlank((CharSequence)(sourceTV = i.taggedValue(sourceTaggedValue)))) {
            return sourceTV;
        }
        if (source != null) {
            return source;
        }
        return "FIXME";
    }

    public String getSkosConceptSchemeSuffix() {
        return skosConceptSchemeSuffix;
    }

    public String getSkosConceptSchemeSubclassSuffix() {
        return skosConceptSchemeSubclassSuffix;
    }

    public String computePrefixForRdfNamespace(String rdfns) {
        if (NS_QNAME_ERROR.equals(rdfns)) {
            return NS_QNAME_ERROR_PREFIX;
        }
        String nsabr = config.nsabrForNamespace(rdfns);
        if (nsabr == null && ontologyByRdfNs.containsKey(rdfns)) {
            nsabr = ((OntologyModel)ontologyByRdfNs.get(rdfns)).getPrefix();
        }
        return nsabr;
    }

    public TargetOwlConfiguration getConfig() {
        return config;
    }

    public String getUriBase() {
        return uriBase;
    }

    public boolean isSuppressMessagesForUnsupportedCategoryOfClasses() {
        return suppressMessagesForUnsupportedCategoryOfClasses;
    }

    public String getRdfNamespaceSeparator() {
        return rdfNamespaceSeparator;
    }

    public String getLanguage() {
        return language;
    }

    public String getOutputFormat() {
        return outputFormat;
    }

    public String getOutputFileNameExtension() {
        return fileNameExtension;
    }

    public RDFFormat getRDFFormat() {
        return rdfFormat;
    }

    public String getOntologyNameTaggedValue() {
        return ontologyNameTaggedValue;
    }

    public String getOntologyNameCodeParameterValue() {
        return ontologyNameCode;
    }

    public String getDefaultTypeImplementation() {
        return defaultTypeImplementation;
    }

    public String getPropExternalReferenceTargetProperty() {
        return propExternalReference_targetProperty;
    }

    public static String getCodeNamespace() {
        return codeNamespace;
    }

    public static String getCodeNamespaceForEnumerations() {
        return codeNamespaceForEnumerations;
    }

    public static String getCodeListOwlClassNamespace() {
        return codeListOwlClassNamespace;
    }

    public static String getCodeListOwlClassNamespaceForEnumerations() {
        return codeListOwlClassNamespaceForEnumerations;
    }

    @Override
    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "OWL ISO 19150 Target: " + mess;
    }

    public void registerSubPropertyOfRelationship(String superPropertyURI, OntProperty subProperty) {
        List<OntProperty> subProps;
        if (subPropertyByURIOfSuperProperty.containsKey(superPropertyURI)) {
            subProps = (List)subPropertyByURIOfSuperProperty.get(superPropertyURI);
        } else {
            subProps = new ArrayList();
            subPropertyByURIOfSuperProperty.put(superPropertyURI, subProps);
        }
        if (!subProps.contains(subProperty)) {
            subProps.add(subProperty);
        }
    }

    public SortedMap<String, OntProperty> getAllSubproperties(String propertyURI) {
        TreeMap<String, OntProperty> result = new TreeMap<String, OntProperty>();
        HashSet<String> visitedSuperProperties = new HashSet<String>();
        Set<OntProperty> subProperties = this.getAllSubproperties(propertyURI, visitedSuperProperties);
        for (OntProperty subProp : subProperties) {
            result.put(subProp.getURI(), subProp);
        }
        return result;
    }

    private Set<OntProperty> getAllSubproperties(String propertyURI, Set<String> visitedSuperProperties) {
        HashSet<OntProperty> subProperties = new HashSet<OntProperty>();
        if (!visitedSuperProperties.contains(propertyURI)) {
            visitedSuperProperties.add(propertyURI);
            List directSubProperties = (List)subPropertyByURIOfSuperProperty.get(propertyURI);
            if (directSubProperties != null) {
                subProperties.addAll(directSubProperties);
                for (OntProperty subProp : directSubProperties) {
                    subProperties.addAll(this.getAllSubproperties(subProp.getURI(), visitedSuperProperties));
                }
            }
        }
        return subProperties;
    }

    @Override
    public String getTargetIdentifier() {
        return "owl";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "iso19150_2014";
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        ProcessRuleSet iso19150_2014Prs = new ProcessRuleSet("iso19150_2014", "*");
        r.addRuleSet(iso19150_2014Prs);
        r.addRule(RULE_OWL_ALL_CONSTRAINTS_BY_CONSTRAINT_MAPPING);
        r.addRule(RULE_OWL_ALL_CONSTRAINTS_HUMAN_READABLE_TEXT_ONLY);
        r.addRule(RULE_OWL_PKG_IMPORT_191502BASE);
        r.addRule(RULE_OWL_PKG_DCT_SOURCE_TITLE);
        r.addRule(RULE_OWL_PKG_ONTOLOGY_NAME_APPEND_VERSION);
        r.addRule(RULE_OWL_PKG_ONTOLOGY_NAME_BY_TAGGED_VALUE);
        r.addRule(RULE_OWL_PKG_ONTOLOGY_NAME_CODE);
        r.addRule(RULE_OWL_PKG_ONTOLOGY_NAME_WITH_PATH);
        r.addRule(RULE_OWL_PKG_ONTOLOGY_NAME_ISO191502);
        r.addRule(RULE_OWL_PKG_VERSION_INFO);
        r.addRule(RULE_OWL_PKG_VERSION_IRI);
        r.addRule(RULE_OWL_PKG_VERSION_IRI_AVOID_DUPLICATE_VERSION);
        r.addRule(RULE_OWL_PKG_SINGLE_ONTOLOGY_PER_SCHEMA);
        r.addRule(RULE_OWL_CLS_CODELIST_EXTERNAL);
        r.addRule(RULE_OWL_CLS_CODELIST_191502);
        r.addRule(RULE_OWL_CLS_CODELIST_191502_CONCEPTSCHEMESUBCLASS);
        r.addRule(RULE_OWL_CLS_CODELIST_191502_DIFFERENTINDIVIDUALS);
        r.addRule(RULE_OWL_CLS_CODELIST_191502_CLASSINDIFFERENTNAMESPACE);
        r.addRule(RULE_OWL_CLS_CODELIST_191502_OBJECTONEOFFORENUMERATION);
        r.addRule(RULE_OWL_CLS_CODELIST_191502_SKOS_COLLECTION);
        r.addRule(RULE_OWL_CLS_DISJOINT_CLASSES);
        r.addRule(RULE_OWL_CLS_ISO191502_ENUMERATION);
        r.addRule(RULE_OWL_CLS_ENCODE_FEATURETYPES);
        r.addRule(RULE_OWL_CLS_ENCODE_BASICTYPES);
        r.addRule(RULE_OWL_CLS_ENCODE_DATATYPES);
        r.addRule(RULE_OWL_CLS_ENCODE_MIXINTYPES);
        r.addRule(RULE_OWL_CLS_ENCODE_OBJECTTYPES);
        r.addRule(RULE_OWL_CLS_ENUMERATION_AS_CODELIST);
        r.addRule(RULE_OWL_CLS_GENERALIZATION);
        r.addRule(RULE_OWL_CLS_19150_2_ISABSTRACT);
        r.addRule(RULE_OWL_CLS_UNION);
        r.addRule(RULE_OWL_CLS_UNION_SETS);
        r.addRule(RULE_OWL_PROP_CODE_BROADER_BY_BROADER_LISTED_VALUE);
        r.addRule(RULE_OWL_PROP_EXTERNAL_REFERENCE);
        r.addRule(RULE_OWL_PROP_GENERAL);
        r.addRule(RULE_OWL_PROP_GLOBAL_SCOPE_ATTRIBUTES);
        r.addRule(RULE_OWL_PROP_GLOBAL_SCOPE_BY_CONVERSION_PARAMETER);
        r.addRule(RULE_OWL_PROP_GLOBAL_SCOPE_BY_UNIQUE_PROPERTY_NAME);
        r.addRule(RULE_OWL_PROP_INVERSEOF);
        r.addRule(RULE_OWL_PROP_ISO191502_AGGREGATION);
        r.addRule(RULE_OWL_PROP_ISO191502_ASSOCIATION_NAME);
        r.addRule(RULE_OWL_PROP_ISO191502_NAMING);
        r.addRule("rule-owl-prop-labelFromLocalName");
        r.addRule(RULE_OWL_PROP_LOCAL_SCOPE_ALL);
        r.addRule(RULE_OWL_PROP_MAPPING_COMPARE_SPECIFICATIONS);
        r.addRule(RULE_OWL_PROP_MULTIPLICITY_QUALIFIED_RESTRICTION);
        r.addRule(RULE_OWL_PROP_MULTIPLICITY_UNQUALIFIED_RESTRICTION);
        r.addRule(RULE_OWL_PROP_PROPERTYENRICHMENT);
        r.addRule(RULE_OWL_PROP_RANGE_GLOBAL);
        r.addRule(RULE_OWL_PROP_RANGE_LOCAL_UNIVERSAL_QUANTIFICATION);
        r.addRule(RULE_OWL_PROP_VOIDABLE_AS_MINCARDINALITY0);
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 1: {
                return "Could not find an ontology document for package '$1$', which was determined to be the relevant one for class '$2$'.";
            }
            case 2: {
                return "Rule 'rule-owl-pkg-singleOntologyPerSchema' is in effect, but no schema package was found for class '$1$'.";
            }
            case 3: {
                return "Unsupported class category ($1$).";
            }
            case 4: {
                return "Output directory is not accessible.";
            }
            case 5: {
                return "Ontology document with name '$1$' could not be created.";
            }
            case 6: {
                return "Target configuration type is incorrect. Expected a TargetOwl(Configuration).";
            }
            case 7: {
                return "Ontology '$1$' is not valid: $2$";
            }
            case 8: {
                return "Cannot print ontology '$1$' in directory '$2$'.";
            }
            case 9: {
                return "??rule-owl-cls-codelist-19150-2-owlClassInDifferentNamespace is enabled, but neither the configuration parameter 'codeListOwlClassNamespace' nor the parameter 'codeListOwlClassNamespaceForEnumerations' are set to a specific value. The rule does not have any effect.";
            }
            case 10: {
                return "??";
            }
            case 100: {
                return "No namespace abbreviation is defined for general property '$1$'. Parameter 'generalPropertyNamespaceAbbreviation' is not set, and a main schema that would define the namespace of the property could not be identified. The property will be ignored.";
            }
            case 101: {
                return "Namespace abbreviation for general property '$1$' is '$2$'. The configuration does not define a namespace with that abbreviation, and none of the ontologies created by the target has that abbreviation, either. The general property will be ignored.";
            }
            case 102: {
                return "Exception encountered while creating new ontology model for general property '$1$'. The property will be ignored. Exception message is: $2$";
            }
            case 10000: {
                return "--- Context - class: '$1$'";
            }
            case 20000: {
                return "Writing ontology '$1$' to file '$2$'.";
            }
        }
        return null;
    }
}

