/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ModelExport;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.ModelExport.ModelExport;
import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelExportConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("exportProfilesFromWholeModel", "ignoreTaggedValuesRegex", "includeConstraintDescriptions", "profilesInModelSetExplicitly", "profilesForClassesWithoutExplicitProfileAssignments", "profilesToExport", "schemaLocation", "suppressCodeAndEnumCharacteristicsWithoutSemanticMeaning", "zipOutput").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        List<String> profilesForClassesWithoutExplicitProfiles;
        File outputDirectoryFile;
        boolean exi;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, pConfig.getParameters().keySet(), result) && isValid;
        String outputDirectory = pConfig.getParameterValue("outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
        }
        if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            isValid = false;
            result.addError(this, 2, outputDirectory);
        }
        if (pConfig.hasParameter("profilesForClassesWithoutExplicitProfileAssignments") && (profilesForClassesWithoutExplicitProfiles = options.parameterAsStringList(ModelExport.class.getName(), "profilesForClassesWithoutExplicitProfileAssignments", null, true, true)).isEmpty()) {
            result.addWarning(this, 1, "profilesForClassesWithoutExplicitProfileAssignments");
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'.";
            }
            case 2: {
                return "Output directory '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "Target parameter '$1$' is set in the configuration. However, it does not define any profiles, and thus will be ignored. To avoid this warning, set at least one profile via the parameter, or remove it from the configuration.";
            }
        }
        return "(ModelExport.java) Unknown message with number: " + mnr;
    }
}

