/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ModelExport;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Qualifier;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TextConstraint;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.Profile.ProfileIdentifier;
import de.interactive_instruments.ShapeChange.Profile.ProfileUtil;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.Profile.VersionRange;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Util.XMLWriter;
import de.interactive_instruments.ShapeChange.Util.ZipHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModelExport
implements SingleTarget,
MessageSource {
    public static final String NS = "http://shapechange.net/model";
    private static boolean initialised = false;
    private static String outputDirectory = null;
    private static String outputFilename = null;
    private static String encoding = null;
    private static XMLWriter writer = null;
    private static File outputXmlFile = null;
    private static Model model = null;
    private static SortedSet<PackageInfo> allSelectedSchemaPackages = null;
    private static Set<String> profilesToExport = null;
    private static boolean omitExistingProfiles = false;
    private static Pattern ignoreTaggedValuesPattern = null;
    private static boolean exportProfilesFromWholeModel = false;
    private static boolean includeConstraintDescriptions = false;
    private static boolean suppressCodeAndEnumCharacteristicsWithoutSemanticMeaning = false;
    private static boolean zipOutput = false;
    private static String schemaLocation = "http://shapechange.net/resources/schema/ShapeChangeExportedModel.xsd";
    private Options options = null;
    private ShapeChangeResult result = null;
    private int streamBufferSize = 8336;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        block14: {
            this.options = o;
            this.result = r;
            try {
                if (initialised) break block14;
                initialised = true;
                model = m;
                allSelectedSchemaPackages = model.allPackagesFromSelectedSchemas();
                outputDirectory = this.options.parameter(ModelExport.class.getName(), "outputDirectory");
                if (outputDirectory == null) {
                    outputDirectory = this.options.parameter("outputDirectory");
                }
                if (outputDirectory == null) {
                    outputDirectory = ".";
                }
                if ((outputFilename = this.options.parameter(ModelExport.class.getName(), "outputFilename")) == null) {
                    outputFilename = "ModelExport";
                }
                encoding = m.characterEncoding();
                String xmlName = outputFilename + ".xml";
                File outputDirectoryFile = new File(outputDirectory);
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 12, outputDirectory);
                    throw new ShapeChangeAbortException();
                }
                String encoding_ = encoding == null ? "UTF-8" : m.characterEncoding();
                outputXmlFile = new File(outputDirectory + "/" + xmlName);
                FileOutputStream fout = new FileOutputStream(outputXmlFile);
                BufferedOutputStream bout = new BufferedOutputStream(fout, this.streamBufferSize);
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, encoding_);
                writer = new XMLWriter(outputXML, encoding_);
                if (p.matches("rule-exp-all-restrictExistingProfiles")) {
                    profilesToExport = new HashSet<String>(this.options.parameterAsStringList(ModelExport.class.getName(), "profilesToExport", null, true, true));
                }
                omitExistingProfiles = p.matches("rule-exp-all-omitExistingProfiles");
                try {
                    ignoreTaggedValuesPattern = Pattern.compile(this.options.parameterAsString(ModelExport.class.getName(), "ignoreTaggedValuesRegex", "(profiles)", true, false));
                }
                catch (PatternSyntaxException e) {
                    this.result.addError(this, 11, "ignoreTaggedValuesRegex", e.getMessage());
                    ignoreTaggedValuesPattern = Pattern.compile("(profiles)");
                }
                exportProfilesFromWholeModel = this.options.parameterAsBoolean(ModelExport.class.getName(), "exportProfilesFromWholeModel", false);
                includeConstraintDescriptions = this.options.parameterAsBoolean(ModelExport.class.getName(), "includeConstraintDescriptions", false);
                suppressCodeAndEnumCharacteristicsWithoutSemanticMeaning = this.options.parameterAsBoolean(ModelExport.class.getName(), "suppressCodeAndEnumCharacteristicsWithoutSemanticMeaning", false);
                zipOutput = this.options.parameterAsBoolean(ModelExport.class.getName(), "zipOutput", false);
                schemaLocation = this.options.parameterAsString(ModelExport.class.getName(), "schemaLocation", "http://shapechange.net/resources/schema/ShapeChangeExportedModel.xsd", false, true);
                boolean profilesInModelSetExplicitly = this.options.parameterAsBoolean(ModelExport.class.getName(), "profilesInModelSetExplicitly", true);
                if (!omitExistingProfiles && !profilesInModelSetExplicitly) {
                    SortedSet<String> profilesForClassesWithoutExplicitProfiles = null;
                    profilesForClassesWithoutExplicitProfiles = this.options.hasParameter(ModelExport.class.getName(), "profilesForClassesWithoutExplicitProfileAssignments") ? new TreeSet<String>(this.options.parameterAsStringList(ModelExport.class.getName(), "profilesForClassesWithoutExplicitProfileAssignments", null, true, true)) : ProfileUtil.findNamesOfAllProfiles(m, exportProfilesFromWholeModel);
                    if (!profilesForClassesWithoutExplicitProfiles.isEmpty()) {
                        Profiles profilesForClassesBelongingToAllProfiles = new Profiles();
                        for (String profileName : profilesForClassesWithoutExplicitProfiles) {
                            profilesForClassesBelongingToAllProfiles.put(profileName);
                        }
                        GenericModel genModel = new GenericModel(m);
                        ProfileUtil.convertToExplicitProfileDefinitions(genModel, profilesForClassesBelongingToAllProfiles, null, exportProfilesFromWholeModel);
                        model = genModel;
                    }
                }
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg != null) {
                    this.result.addError(msg);
                }
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void reset() {
        initialised = false;
        writer = null;
        model = null;
        allSelectedSchemaPackages = null;
        outputDirectory = null;
        outputFilename = null;
        outputXmlFile = null;
        encoding = null;
        profilesToExport = null;
        omitExistingProfiles = false;
        ignoreTaggedValuesPattern = null;
        exportProfilesFromWholeModel = false;
        includeConstraintDescriptions = false;
        suppressCodeAndEnumCharacteristicsWithoutSemanticMeaning = false;
        zipOutput = false;
        schemaLocation = "http://shapechange.net/resources/schema/ShapeChangeExportedModel.xsd";
    }

    @Override
    public void process(ClassInfo ci) {
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "Model Export";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAll(ShapeChangeResult r) {
        String m;
        this.result = r;
        this.options = r.options();
        try {
            writer.forceNSDecl("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            writer.forceNSDecl(NS, "sc");
            writer.startDocument();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi:schemaLocation", "CDATA", "http://shapechange.net/model " + schemaLocation);
            atts.addAttribute("", "encoding", "", "string", model.characterEncoding());
            String scversion = "[dev]";
            String scunittesting = System.getProperty("scunittesting");
            if ("true".equalsIgnoreCase(scunittesting)) {
                scversion = "unittest";
            } else {
                InputStream stream = this.getClass().getResourceAsStream("/sc.properties");
                if (stream != null) {
                    Iterator properties = new Properties();
                    ((Properties)((Object)properties)).load(stream);
                    scversion = ((Properties)((Object)properties)).getProperty("sc.version");
                }
            }
            atts.addAttribute("", "scxmlProducer", "", "string", "ShapeChange");
            atts.addAttribute("", "scxmlProducerVersion", "", "string", scversion);
            writer.startElement(NS, "Model", "", atts);
            TreeSet<PackageInfo> packagesToPrint = new TreeSet<PackageInfo>();
            for (PackageInfo packageInfo : model.packages()) {
                if (packageInfo.owner() != null) continue;
                packagesToPrint.add(packageInfo);
            }
            writer.startElement(NS, "packages");
            for (PackageInfo packageInfo : packagesToPrint) {
                this.printPackage(packageInfo);
            }
            writer.endElement(NS, "packages");
            SortedSet<AssociationInfo> associations = model.associations();
            if (!associations.isEmpty()) {
                writer.startElement(NS, "associations");
                for (AssociationInfo ai : associations) {
                    this.printAssociation(ai);
                }
                writer.endElement(NS, "associations");
            }
            writer.endElement(NS, "Model");
            writer.endDocument();
            writer.close();
            if (zipOutput) {
                File file = new File(outputDirectory + "/" + outputFilename + ".zip");
                ZipHandler.zipFile(outputXmlFile, file);
            }
        }
        catch (Exception e) {
            m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
            model = null;
        }
    }

    private void printAssociation(AssociationInfo ai) throws Exception {
        if (ai != null && ai.end1() != null && ai.end2() != null) {
            writer.startElement(NS, "Association");
            this.printInfoFields(ai);
            if (ai.assocClass() != null) {
                writer.dataElement(NS, "assocClassId", ai.assocClass().id());
            }
            this.printAssociationRole(ai.end1(), "end1");
            this.printAssociationRole(ai.end2(), "end2");
            writer.endElement(NS, "Association");
        }
    }

    private void printAssociationRole(PropertyInfo pi, String tag) throws SAXException {
        if (!pi.isAttribute()) {
            if (pi.isNavigable()) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "ref", "", "string", pi.id());
                writer.emptyElement(NS, tag, "", atts);
            } else {
                writer.startElement(NS, tag);
                this.printProperty(pi, true);
                writer.endElement(NS, tag);
            }
        }
    }

    private void printPackage(PackageInfo pi) throws Exception {
        if (pi.matches("rule-exp-pkg-allPackagesAreEditable") || allSelectedSchemaPackages.contains(pi)) {
            writer.startElement(NS, "Package");
        } else {
            writer.startElement(NS, "Package", "editable", "false");
        }
        this.printInfoFields(pi);
        if (pi.supplierIds() != null && !pi.supplierIds().isEmpty()) {
            writer.startElement(NS, "supplierIds");
            for (String supplierId : pi.supplierIds()) {
                writer.dataElement(NS, "SupplierId", supplierId);
            }
            writer.endElement(NS, "supplierIds");
        }
        if (pi.containedClasses() != null && !pi.containedClasses().isEmpty()) {
            writer.startElement(NS, "classes");
            for (ClassInfo ci : pi.containedClasses()) {
                this.printClass(ci);
            }
            writer.endElement(NS, "classes");
        }
        if (pi.containedPackages() != null && !pi.containedPackages().isEmpty()) {
            writer.startElement(NS, "packages");
            for (PackageInfo pi2 : pi.containedPackages()) {
                this.printPackage(pi2);
            }
            writer.endElement(NS, "packages");
        }
        this.printDiagrams(pi.getDiagrams());
        writer.endElement(NS, "Package");
    }

    private void printDataElement(String elementName, boolean value, boolean defaultValue) throws SAXException {
        if (value ^ defaultValue) {
            this.printDataElement(elementName, "" + value);
        }
    }

    private void printDataElement(String elementName, String value, String defaultValue) throws SAXException {
        if (value != null && value.length() > 0 && !value.equalsIgnoreCase(defaultValue)) {
            writer.dataElement(NS, elementName, value);
        }
    }

    private void printDiagrams(List<ImageMetadata> diagrams) throws SAXException {
        if (diagrams != null && !diagrams.isEmpty()) {
            writer.startElement(NS, "diagrams");
            for (ImageMetadata im : diagrams) {
                writer.startElement(NS, "ImageMetadata");
                writer.dataElement(NS, "id", im.getId());
                writer.dataElement(NS, "name", im.getName());
                writer.dataElement(NS, "relPathToFile", im.getRelPathToFile());
                writer.dataElement(NS, "width", "" + im.getWidth());
                writer.dataElement(NS, "height", "" + im.getHeight());
                writer.endElement(NS, "ImageMetadata");
            }
            writer.endElement(NS, "diagrams");
        }
    }

    private void printClass(ClassInfo ci) throws Exception {
        writer.startElement(NS, "Class");
        this.printInfoFields(ci);
        this.printDiagrams(ci.getDiagrams());
        this.printDataElement("isAbstract", ci.isAbstract(), false);
        this.printDataElement("isLeaf", ci.isLeaf(), false);
        if (ci.isAssocClass() != null) {
            this.printDataElement("associationId", ci.isAssocClass().id());
        }
        if (ci.getLinkedDocument() != null) {
            File linkedDoc = ci.getLinkedDocument();
            File linkedDocsDir = this.options.linkedDocumentsTmpDir();
            String relativePath = linkedDocsDir.toPath().relativize(linkedDoc.toPath()).toString();
            this.printDataElement("linkedDocument", relativePath);
        }
        if (exportProfilesFromWholeModel || allSelectedSchemaPackages.contains(ci.pkg())) {
            this.printProfiles(ci.profiles());
        }
        if (!ci.supertypes().isEmpty()) {
            writer.startElement(NS, "supertypes");
            for (String sid : ci.supertypes()) {
                writer.dataElement(NS, "SupertypeId", sid);
            }
            writer.endElement(NS, "supertypes");
        }
        if (!ci.subtypes().isEmpty()) {
            writer.startElement(NS, "subtypes");
            for (String sid : ci.subtypes()) {
                writer.dataElement(NS, "SubtypeId", sid);
            }
            writer.endElement(NS, "subtypes");
        }
        this.printConstraints(ci.directConstraints());
        if (!ci.properties().isEmpty() && ci.properties().values().stream().anyMatch(property -> property.isNavigable())) {
            writer.startElement(NS, "properties");
            for (PropertyInfo pi : ci.properties().values()) {
                if (!pi.isNavigable()) continue;
                this.printProperty(pi, false);
            }
            writer.endElement(NS, "properties");
        }
        writer.endElement(NS, "Class");
    }

    private void printProfiles(Profiles profiles) throws SAXException {
        if (!omitExistingProfiles && !profiles.isEmpty()) {
            HashSet<String> ptexp = new HashSet<String>(profiles.getProfileIdentifiersByName().keySet());
            if (profilesToExport != null) {
                ptexp.retainAll(profilesToExport);
            }
            if (!ptexp.isEmpty()) {
                writer.startElement(NS, "profiles");
                for (ProfileIdentifier pi : profiles.getProfileIdentifiersByName().values()) {
                    if (!ptexp.contains(pi.getName())) continue;
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "name", "", "string", pi.getName());
                    if (pi.hasVersionIndicator() || pi.hasParameters()) {
                        writer.startElement(NS, "Profile", "", atts);
                        if (pi.hasVersionIndicator()) {
                            writer.startElement(NS, "versionIdentifier");
                            for (VersionRange versionRange : pi.getVersionIndicator().getVersionInfos()) {
                                AttributesImpl attsVersionRange = new AttributesImpl();
                                attsVersionRange.addAttribute("", "begin", "", "string", versionRange.getBegin().toString());
                                attsVersionRange.addAttribute("", "end", "", "string", versionRange.getEnd().toString());
                                writer.emptyElement(NS, "VersionRange", "", attsVersionRange);
                            }
                            writer.endElement(NS, "versionIdentifier");
                        }
                        if (pi.hasParameters()) {
                            writer.startElement(NS, "parameter");
                            for (Map.Entry entry : pi.getParameter().entrySet()) {
                                AttributesImpl attsParameter = new AttributesImpl();
                                attsParameter.addAttribute("", "name", "", "string", (String)entry.getKey());
                                if (entry.getValue() != null) {
                                    attsParameter.addAttribute("", "value", "", "string", (String)entry.getValue());
                                }
                                writer.emptyElement(NS, "ProfileParameter", "", attsParameter);
                            }
                            writer.endElement(NS, "parameter");
                        }
                        writer.endElement(NS, "Profile");
                        continue;
                    }
                    writer.emptyElement(NS, "Profile", "", atts);
                }
                writer.endElement(NS, "profiles");
            }
        }
    }

    private void printConstraints(List<Constraint> constraints) throws SAXException {
        if (constraints != null && !constraints.isEmpty()) {
            writer.startElement(NS, "constraints");
            for (Constraint con : constraints) {
                String elementName;
                String type = null;
                String sourceType = null;
                String[] comments = null;
                if (con instanceof FolConstraint) {
                    elementName = "FolConstraint";
                    sourceType = ((FolConstraint)con).sourceType();
                    comments = ((FolConstraint)con).comments();
                } else if (con instanceof OclConstraint) {
                    elementName = "OclConstraint";
                    comments = ((OclConstraint)con).comments();
                } else {
                    elementName = "TextConstraint";
                    type = ((TextConstraint)con).type();
                }
                writer.startElement(NS, elementName);
                this.printDataElement("name", con.name());
                this.printDataElement("status", con.status());
                this.printDataElement("text", con.text());
                this.printDataElement("type", type);
                this.printDataElement("sourceType", sourceType);
                if (includeConstraintDescriptions) {
                    this.printDataElements("description", comments);
                }
                writer.endElement(NS, elementName);
            }
            writer.endElement(NS, "constraints");
        }
    }

    private void printProperty(PropertyInfo pi, boolean printInClass) throws SAXException {
        writer.startElement(NS, "Property");
        this.printInfoFields(pi);
        if (exportProfilesFromWholeModel || allSelectedSchemaPackages.contains(pi.inClass().pkg())) {
            this.printProfiles(pi.profiles());
        }
        if (pi.cardinality().minOccurs != 1 || pi.cardinality().maxOccurs != 1) {
            this.printDataElement("cardinality", pi.cardinality().toString());
        }
        if (!pi.matches("rule-exp-prop-suppressIsNavigable")) {
            this.printDataElement("isNavigable", pi.isNavigable(), true);
        }
        if (pi.sequenceNumber() == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 100, pi.name());
            if (mc != null) {
                mc.addDetail(this, 0, pi.fullName());
            }
            this.printDataElement("sequenceNumber", "0");
        } else {
            this.printDataElement("sequenceNumber", pi.sequenceNumber().getString());
        }
        Type ti = pi.typeInfo();
        if (ti != null) {
            ClassInfo ci = pi.model().classById(ti.id);
            if (ci != null) {
                this.printDataElement("typeId", ti.id);
            }
            if (StringUtils.isNotBlank((CharSequence)ti.name)) {
                this.printDataElement("typeName", ti.name);
            }
        }
        this.printDataElement("isDerived", pi.isDerived(), false);
        this.printDataElement("isReadOnly", pi.isReadOnly(), false);
        this.printDataElement("isAttribute", pi.isAttribute(), true);
        if (suppressCodeAndEnumCharacteristicsWithoutSemanticMeaning && (pi.inClass().category() == 3 || pi.inClass().category() == 2)) {
            if (pi.isOrdered()) {
                this.result.addDebug(this, 13, "isOrdered", "true", pi.fullNameInSchema());
            }
            if (!pi.isUnique()) {
                this.result.addDebug(this, 13, "isUnique", "false", pi.fullNameInSchema());
            }
            if (pi.isComposition()) {
                this.result.addDebug(this, 13, "isComposition", "true", pi.fullNameInSchema());
            }
            if (pi.isAggregation()) {
                this.result.addDebug(this, 13, "isAggregation", "true", pi.fullNameInSchema());
            }
            if (pi.isOwned()) {
                this.result.addDebug(this, 13, "isOwned", "true", pi.fullNameInSchema());
            }
        } else {
            this.printDataElement("isOrdered", pi.isOrdered(), false);
            this.printDataElement("isUnique", pi.isUnique(), true);
            this.printDataElement("isComposition", pi.isComposition(), false);
            this.printDataElement("isAggregation", pi.isAggregation(), false);
            this.printDataElement("isOwned", pi.isOwned(), false);
        }
        this.printDataElement("initialValue", pi.initialValue());
        this.printDataElement("inlineOrByReference", pi.inlineOrByReference(), "inlineOrByReference");
        if (pi.qualifiers() != null && !pi.qualifiers().isEmpty()) {
            writer.startElement(NS, "qualifiers");
            for (Qualifier qualifier : pi.qualifiers()) {
                writer.startElement(NS, "Qualifier");
                this.printDataElement("name", qualifier.name);
                this.printDataElement("type", qualifier.type);
                writer.endElement(NS, "Qualifier");
            }
            writer.endElement(NS, "qualifiers");
        }
        if (printInClass && pi.inClass() != null) {
            this.printDataElement("inClassId", pi.inClass().id());
        }
        if (pi.association() != null) {
            this.printDataElement("associationId", pi.association().id());
        }
        this.printConstraints(pi.constraints());
        writer.endElement(NS, "Property");
    }

    private void printInfoFields(Info i) throws SAXException {
        Descriptors descriptors;
        this.printDataElement("name", i.name());
        writer.dataElement(NS, "id", i.id());
        Stereotypes st = i.stereotypes();
        if (st != null && !st.isEmpty()) {
            writer.startElement(NS, "stereotypes");
            for (String s : st.asArray()) {
                writer.dataElement(NS, "Stereotype", s);
            }
            writer.endElement(NS, "stereotypes");
        }
        if (!(descriptors = i.descriptors()).isEmpty() && !i.matches("rule-exp-all-omitDescriptors")) {
            writer.startElement(NS, "descriptors");
            this.printDescriptorElement(Descriptor.ALIAS, descriptors);
            this.printDescriptorElement(Descriptor.PRIMARYCODE, descriptors);
            this.printDescriptorElement(Descriptor.GLOBALIDENTIFIER, descriptors);
            this.printDescriptorElement(Descriptor.DEFINITION, descriptors);
            this.printDescriptorElement(Descriptor.DESCRIPTION, descriptors);
            this.printDescriptorElement(Descriptor.DOCUMENTATION, descriptors);
            this.printDescriptorElement(Descriptor.LEGALBASIS, descriptors);
            this.printDescriptorElement(Descriptor.LANGUAGE, descriptors);
            this.printDescriptorElement(Descriptor.EXAMPLE, descriptors);
            this.printDescriptorElement(Descriptor.DATACAPTURESTATEMENT, descriptors);
            writer.endElement(NS, "descriptors");
        }
        TaggedValues tvs = i.taggedValuesAll();
        TaggedValues tvsToExport = this.options.taggedValueFactory();
        for (String tagName : tvs.keySet()) {
            if (ignoreTaggedValuesPattern.matcher(tagName).matches()) continue;
            tvsToExport.put(tagName, tvs.get(tagName));
        }
        if (!tvsToExport.isEmpty()) {
            writer.startElement(NS, "taggedValues");
            for (String tagName : tvsToExport.keySet()) {
                String[] values = tvsToExport.get(tagName);
                if (values == null || values.length <= 0) continue;
                writer.startElement(NS, "TaggedValue");
                writer.dataElement(NS, "name", tagName);
                if (values.length != 1 || values[0] != null && values[0].length() != 0) {
                    writer.startElement(NS, "values");
                    for (String value : values) {
                        writer.dataElement(NS, "Value", value);
                    }
                    writer.endElement(NS, "values");
                }
                writer.endElement(NS, "TaggedValue");
            }
            writer.endElement(NS, "taggedValues");
        }
    }

    private void printDescriptorElement(Descriptor descriptor, Descriptors descriptors) throws SAXException {
        List<LangString> descriptorValues_tmp = descriptors.values(descriptor);
        ArrayList<LangString> descriptorValues = new ArrayList<LangString>();
        for (LangString dv : descriptorValues_tmp) {
            if (dv.getValue().trim().length() <= 0) continue;
            descriptorValues.add(dv);
        }
        if (!descriptorValues.isEmpty()) {
            writer.startElement(NS, descriptor.getName());
            writer.startElement(NS, "descriptorValues");
            for (LangString dv : descriptorValues) {
                if (dv.hasLang()) {
                    this.printDataElement("DescriptorValue", dv.getValue(), "lang", dv.getLang());
                    continue;
                }
                this.printDataElement("DescriptorValue", dv.getValue());
            }
            writer.endElement(NS, "descriptorValues");
            writer.endElement(NS, descriptor.getName());
        }
    }

    private void printDataElement(String elementName, String s) throws SAXException {
        if (s != null && s.length() > 0) {
            writer.dataElement(NS, elementName, s);
        }
    }

    private void printDataElements(String elementName, String[] strings) throws SAXException {
        if (strings != null) {
            for (String s : strings) {
                this.printDataElement(elementName, s);
            }
        }
    }

    private void printDataElement(String elementName, String elementContent, String attributeName, String attributeValue) throws SAXException {
        if (elementContent != null && elementContent.length() > 0) {
            writer.dataElement(NS, elementName, elementContent, attributeName, attributeValue);
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-exp-all-omitDescriptors");
        r.addRule("rule-exp-all-omitExistingProfiles");
        r.addRule("rule-exp-all-restrictExistingProfiles");
        r.addRule("rule-exp-pkg-allPackagesAreEditable");
        r.addRule("rule-exp-prop-suppressIsNavigable");
    }

    @Override
    public String getTargetIdentifier() {
        return "exp";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 11: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'. The default will be used.";
            }
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 13: {
                return "Suppressing semantically meaningless characteristic '$1$' (with value '$2$') of code/enum '$3$'.";
            }
            case 100: {
                return "Sequence number is undefined for property '$1$'. Using '0'.";
            }
        }
        return "(ModelExport.java) Unknown message with number: " + mnr;
    }
}

