/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Metadata;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Metadata.ApplicationSchemaMetadata;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationSchemaMetadataConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("inheritedProperties", "tagNameRegex", "tagValueRegex", "typesForTypeUsageIdentification").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        HashSet<String> typesForTypeUsage;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (config.getAllRules().contains("rule-asm-all-identifyTypeUsage") && (typesForTypeUsage = new HashSet<String>(options.parameterAsStringList(ApplicationSchemaMetadata.class.getName(), "typesForTypeUsageIdentification", null, true, true))).isEmpty()) {
            isValid = false;
            result.addError(this, 3, "rule-asm-all-identifyTypeUsage", "typesForTypeUsageIdentification");
        }
        if (config.getAllRules().contains("rule-asm-all-identifyPropertiesWithSpecificTaggedValues")) {
            try {
                Pattern tagNamePattern = config.parameterAsRegexPattern("tagNameRegex", null);
                if (tagNamePattern == null) {
                    isValid = false;
                    result.addError(this, 100, "tagNameRegex", "rule-asm-all-identifyPropertiesWithSpecificTaggedValues");
                }
            }
            catch (PatternSyntaxException e) {
                isValid = false;
                result.addError(this, 1, "tagNameRegex", e.getMessage());
            }
            try {
                config.parameterAsRegexPattern("tagValueRegex", null);
            }
            catch (PatternSyntaxException e) {
                isValid = false;
                result.addError(this, 1, "tagValueRegex", e.getMessage());
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'.";
            }
            case 2: {
                return "Output directory '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "Rule '$1$' is contained in the target configuration. Parameter '$2$' required by that rule was not provided or is invalid. Provide a valid value for this parameter.";
            }
            case 100: {
                return "Parameter '$1$' is required for rule '$2$' but no actual value was found in the configuration.";
            }
        }
        return "(ApplicationSchemaMetadata.java) Unknown message with number: " + mnr;
    }
}

