/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Metadata;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationSchemaMetadata
implements SingleTarget,
MessageSource {
    public static final String NS = "http://shapechange.net/targets/ApplicationSchemaMetadata";
    public static int STATUS_RULE_ALL_IDENTIFY_PROFILES = 301500;
    public static int STATUS_RULE_ALL_IDENTIFY_TYPE_USAGE = 301501;
    public static int STATUS_RULE_ALL_IDENTIFY_PROPERTIES_WITH_SPECIFIC_TAGGED_VALUES = 301502;
    public static final String PARAM_TYPES_FOR_TYPE_USAGE_IDENTIFICATION = "typesForTypeUsageIdentification";
    public static final String RULE_ALL_IDENTIFY_PROFILES = "rule-asm-all-identify-profiles";
    public static final String RULE_ALL_IDENTIFY_TYPE_USAGE = "rule-asm-all-identifyTypeUsage";
    public static final String RULE_ALL_IDENTIFY_PROPERTIES_WITH_SPECIFIC_TAGGED_VALUES = "rule-asm-all-identifyPropertiesWithSpecificTaggedValues";
    public static final String PARAM_INHERITED_PROPERTIES = "inheritedProperties";
    public static final String PARAM_TAG_NAME_REGEX = "tagNameRegex";
    public static final String PARAM_TAG_VALUE_REGEX = "tagValueRegex";
    private static boolean initialised = false;
    protected static Document document = null;
    protected static Element root = null;
    protected static Map<String, ProcessMapEntry> mapEntryByType = new HashMap<String, ProcessMapEntry>();
    private static File outputDirectoryFile;
    private static String outputDirectory;
    private static String outputFilename;
    private static boolean printed;
    private static boolean diagnosticsOnly;
    private static String schemaTargetNamespace;
    private ShapeChangeResult result = null;
    private PackageInfo schemaPi = null;
    private Model model = null;
    private Options options = null;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schemaPi = p;
        schemaTargetNamespace = p.targetNamespace();
        this.model = m;
        this.options = o;
        this.result = r;
        diagnosticsOnly = diagOnly;
        this.result.addDebug(this, 1, this.schemaPi.name());
        if (!initialised) {
            DocumentBuilder db;
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            outputFilename = "schema_metadata.xml";
            outputDirectoryFile = new File(outputDirectory);
            boolean exi = outputDirectoryFile.exists();
            if (!exi) {
                try {
                    FileUtils.forceMkdir((File)outputDirectoryFile);
                }
                catch (IOException e) {
                    this.result.addError(null, 600, e.getMessage());
                    e.printStackTrace(System.err);
                }
                exi = outputDirectoryFile.exists();
            }
            boolean dir = outputDirectoryFile.isDirectory();
            boolean wrt = outputDirectoryFile.canWrite();
            boolean rea = outputDirectoryFile.canRead();
            if (!(exi && dir && wrt && rea)) {
                this.result.addFatalError(null, 601, outputDirectory);
                throw new ShapeChangeAbortException();
            }
            File outputFile = new File(outputDirectoryFile, outputFilename);
            exi = outputFile.exists();
            if (exi) {
                this.result.addInfo(this, 3, outputFilename, outputDirectory);
                try {
                    FileUtils.forceDelete((File)outputFile);
                    this.result.addInfo(this, 4);
                }
                catch (IOException e) {
                    this.result.addInfo(null, 600, e.getMessage());
                    e.printStackTrace(System.err);
                }
            }
            List<ProcessMapEntry> mapEntries = this.options.getCurrentProcessConfig().getMapEntries();
            for (ProcessMapEntry pme : mapEntries) {
                mapEntryByType.put(pme.getType(), pme);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                this.result.addFatalError(null, 2);
                throw new ShapeChangeAbortException();
            }
            document = db.newDocument();
            root = document.createElementNS(NS, "ApplicationSchemaMetadata");
            document.appendChild(root);
            this.addAttribute(root, "xmlns", NS);
            if (this.options.getCurrentProcessConfig().parameterAsString("processOutput_addComment", null, false, true) == null) {
                Comment generationComment = document.createComment("Created by ShapeChange - http://shapechange.net/");
                root.appendChild(generationComment);
            }
        }
        Element e_name = document.createElement("name");
        e_name.setTextContent(this.schemaPi.name());
        Element e_tns = document.createElement("targetNamespace");
        e_tns.setTextContent(this.schemaPi.targetNamespace());
        Element e_as = document.createElement("ApplicationSchema");
        e_as.appendChild(e_name);
        e_as.appendChild(e_tns);
        Element e_schema = document.createElement("schema");
        e_schema.appendChild(e_as);
        root.appendChild(e_schema);
        this.processMetadata(e_as);
    }

    protected void processMetadata(Element appSchemaElement) {
        if (this.schemaPi != null) {
            if (this.schemaPi.matches(RULE_ALL_IDENTIFY_PROFILES)) {
                StatusBoard.getStatusBoard().statusChanged(STATUS_RULE_ALL_IDENTIFY_PROFILES);
                this.processProfilesMetadata(appSchemaElement);
            }
            if (this.schemaPi.matches(RULE_ALL_IDENTIFY_TYPE_USAGE)) {
                StatusBoard.getStatusBoard().statusChanged(STATUS_RULE_ALL_IDENTIFY_TYPE_USAGE);
                this.identifyTypeUsage(appSchemaElement);
            }
            if (this.schemaPi.matches(RULE_ALL_IDENTIFY_PROPERTIES_WITH_SPECIFIC_TAGGED_VALUES)) {
                StatusBoard.getStatusBoard().statusChanged(STATUS_RULE_ALL_IDENTIFY_PROPERTIES_WITH_SPECIFIC_TAGGED_VALUES);
                this.identifyPropertiesWithSpecificTaggedValues(appSchemaElement);
            }
        }
    }

    private void identifyPropertiesWithSpecificTaggedValues(Element appSchemaElement) {
        ProcessConfiguration config = this.options.getCurrentProcessConfig();
        Pattern tagNamePattern = null;
        try {
            tagNamePattern = config.parameterAsRegexPattern(PARAM_TAG_NAME_REGEX, null);
            if (tagNamePattern == null) {
                this.result.addError(this, 10, PARAM_TAG_NAME_REGEX, RULE_ALL_IDENTIFY_PROPERTIES_WITH_SPECIFIC_TAGGED_VALUES);
                return;
            }
        }
        catch (PatternSyntaxException e) {
            this.result.addError(this, 9, PARAM_TAG_NAME_REGEX, e.getMessage());
        }
        Pattern tagValuePattern = null;
        try {
            tagValuePattern = config.parameterAsRegexPattern(PARAM_TAG_VALUE_REGEX, null);
        }
        catch (PatternSyntaxException e) {
            this.result.addError(this, 9, PARAM_TAG_VALUE_REGEX, e.getMessage());
        }
        boolean inheritedProperties = config.parameterAsBoolean(PARAM_INHERITED_PROPERTIES, false);
        Element e_pwstv = document.createElement("PropertiesWithSpecificTaggedValues");
        appSchemaElement.appendChild(e_pwstv);
        SortedSet<ClassInfo> schemaClasses = this.model.classes(this.schemaPi);
        for (ClassInfo ci : schemaClasses) {
            Element e_class = document.createElement("Class");
            e_class.setAttribute("name", ci.name());
            e_pwstv.appendChild(e_class);
            Collection<PropertyInfo> properties = inheritedProperties ? ci.propertiesAll() : ci.properties().values();
            for (PropertyInfo pi : properties) {
                SortedMap<String, List<String>> tvs = pi.taggedValuesAll().asMap();
                TreeMap<String, List> matchingTvs = new TreeMap<String, List>();
                for (String tag : tvs.keySet()) {
                    if (!tagNamePattern.matcher(tag).matches()) continue;
                    List values = (List)tvs.get(tag);
                    boolean relevantTag = true;
                    if (tagValuePattern != null) {
                        if (values == null || values.isEmpty()) {
                            relevantTag = false;
                        } else {
                            boolean valuesOk = true;
                            for (String value : values) {
                                if (tagValuePattern.matcher(value).matches()) continue;
                                valuesOk = false;
                                break;
                            }
                            relevantTag = valuesOk;
                        }
                    }
                    if (!relevantTag) continue;
                    matchingTvs.put(tag, values);
                }
                if (matchingTvs.isEmpty()) continue;
                Element e_prop = document.createElement("Property");
                e_prop.setAttribute("name", pi.name());
                e_class.appendChild(e_prop);
                for (Map.Entry entry : matchingTvs.entrySet()) {
                    String tag = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    Element e_tag = document.createElement("Tag");
                    e_tag.setAttribute("name", tag);
                    e_prop.appendChild(e_tag);
                    if (values == null || values.isEmpty()) continue;
                    for (String value : values) {
                        Element e_val = document.createElement("Value");
                        e_val.setTextContent(value);
                        e_tag.appendChild(e_val);
                    }
                }
            }
        }
    }

    private void identifyTypeUsage(Element appSchemaElement) {
        TreeSet<String> typesForTypeUsage = new TreeSet<String>(this.options.parameterAsStringList(this.getClass().getName(), PARAM_TYPES_FOR_TYPE_USAGE_IDENTIFICATION, null, true, true));
        SortedSet<ClassInfo> schemaClasses = this.model.classes(this.schemaPi);
        if (schemaClasses != null) {
            TreeMap resultMap = new TreeMap();
            for (ClassInfo classInfo : schemaClasses) {
                if (classInfo.category() != 1 && classInfo.category() != 6) continue;
                TreeSet<ClassInfo> foundDataOrUnionTypes = new TreeSet<ClassInfo>();
                this.searchTypeUses(classInfo, foundDataOrUnionTypes);
                Set namesOfFoundDataOrUnionTypes = foundDataOrUnionTypes.stream().map(type -> type.name()).filter(type -> typesForTypeUsage.contains(type)).collect(Collectors.toSet());
                if (namesOfFoundDataOrUnionTypes.isEmpty()) continue;
                resultMap.put(classInfo, namesOfFoundDataOrUnionTypes);
            }
            Element e_tum = document.createElement("TypesUsageMetadata");
            if (resultMap.isEmpty()) {
                this.result.addInfo(this, 200, String.join((CharSequence)", ", typesForTypeUsage));
            } else {
                this.result.addInfo(this, 201, String.join((CharSequence)", ", typesForTypeUsage));
                for (String type2 : typesForTypeUsage) {
                    TreeSet<String> classesUsingType = new TreeSet<String>();
                    for (Map.Entry e : resultMap.entrySet()) {
                        if (!((Set)e.getValue()).contains(type2)) continue;
                        classesUsingType.add(((ClassInfo)e.getKey()).name());
                    }
                    if (classesUsingType.isEmpty()) continue;
                    String classes = String.join((CharSequence)", ", classesUsingType);
                    this.result.addInfo(this, 202, type2, classes);
                    Element e_tu = document.createElement("typeUsage");
                    e_tu.setAttribute("type", type2);
                    e_tu.setAttribute("directlyOrIndirectlyUsedBy", classes);
                    e_tum.appendChild(e_tu);
                }
            }
            Element element = document.createElement("metadata");
            element.appendChild(e_tum);
            appSchemaElement.appendChild(element);
        }
    }

    private void searchTypeUses(ClassInfo ci, SortedSet<ClassInfo> foundDataOrUnionTypes) {
        for (PropertyInfo pi : ci.properties().values()) {
            ClassInfo type = this.model.classByIdOrName(pi.typeInfo());
            if (type == null || foundDataOrUnionTypes.contains(type)) continue;
            foundDataOrUnionTypes.add(type);
            if (type.category() != 5 && type.category() != 8) continue;
            this.searchTypeUses(type, foundDataOrUnionTypes);
        }
    }

    protected void processProfilesMetadata(Element appSchemaElement) {
        TreeSet<Info> schemaElements = new TreeSet<Info>();
        SortedSet<ClassInfo> schemaClasses = this.model.classes(this.schemaPi);
        if (schemaClasses != null) {
            for (ClassInfo classInfo : schemaClasses) {
                schemaElements.add(classInfo);
                for (PropertyInfo pi : classInfo.properties().values()) {
                    schemaElements.add(pi);
                }
            }
        }
        TreeSet<String> profileNames = new TreeSet<String>();
        for (Object i : schemaElements) {
            String[] profilesTVs;
            for (String profilesTV : profilesTVs = i.taggedValuesForTag("profiles")) {
                if (profilesTV.trim().length() <= 0) continue;
                try {
                    Profiles piMap = Profiles.parse(profilesTV, false);
                    profileNames.addAll(piMap.getProfileIdentifiersByName().keySet());
                }
                catch (MalformedProfileIdentifierException e) {
                    ShapeChangeResult.MessageContext mc = this.result.addWarning(null, 20201);
                    if (mc == null) continue;
                    mc.addDetail(null, 20216, i.fullNameInSchema());
                    mc.addDetail(null, 20217, e.getMessage());
                    mc.addDetail(null, 20218, profilesTV);
                }
            }
        }
        Element element = document.createElement("ProfilesMetadata");
        for (String name : profileNames) {
            Element e_cp = document.createElement("containedProfile");
            e_cp.setTextContent(name);
            element.appendChild(e_cp);
        }
        Element e_m = document.createElement("metadata");
        e_m.appendChild(element);
        appSchemaElement.appendChild(e_m);
    }

    protected void addAttribute(Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    @Override
    public void process(ClassInfo ci) {
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "Application Schema Metadata";
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        if (printed || diagnosticsOnly) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File repXsd = new File(outputDirectoryFile, outputFilename);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repXsd), "UTF-8"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)writer);
            serializer.asDOMSerializer().serialize((Node)document);
            writer.close();
            r.addResult(this.getTargetName(), outputDirectory, outputFilename, schemaTargetNamespace);
        }
        catch (IOException ioe) {
            r.addError(this, 3, outputFilename, ioe.getMessage());
        }
        printed = true;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule(RULE_ALL_IDENTIFY_PROFILES);
        r.addRule(RULE_ALL_IDENTIFY_TYPE_USAGE);
        r.addRule(RULE_ALL_IDENTIFY_PROPERTIES_WITH_SPECIFIC_TAGGED_VALUES);
    }

    @Override
    public String getTargetIdentifier() {
        return "asm";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public void reset() {
        initialised = false;
        schemaTargetNamespace = null;
        outputDirectoryFile = null;
        outputDirectory = null;
        outputFilename = null;
        printed = false;
        diagnosticsOnly = false;
        document = null;
        root = null;
        mapEntryByType = new HashMap<String, ProcessMapEntry>();
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class ApplicationSchemaMetadata";
            }
            case 1: {
                return "Retrieving metadata for application schema '$1$'.";
            }
            case 2: {
                return "XML Schema document with name '$1$' could not be created, invalid filename.";
            }
            case 3: {
                return "Could not write output to file '$1$'. Exception message is: $2$.";
            }
            case 4: {
                return "File has been deleted.";
            }
            case 5: {
                return "";
            }
            case 6: {
                return "Processing class '$1$'.";
            }
            case 7: {
                return "Class '$1$' is a $2$ which is not supported by this target. The class will be ignored.";
            }
            case 8: {
                return "Number format exception while converting the value of configuration parameter '$1$' to an integer. Exception message: $2$. The parameter will be ignored.";
            }
            case 9: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'.";
            }
            case 10: {
                return "Parameter '$1$' required by rule '$2$' was not set. The rule will be ignored.";
            }
            case 100: {
                return "Context: property '$1$' in class '$2$'.";
            }
            case 200: {
                return "No classes with direct or indirect use of the type(s) $1$.";
            }
            case 201: {
                return "One or more classes with direct or indirect use of the type(s) $1$ was found.";
            }
            case 202: {
                return "Type '$1$' directly or indirectly used by the following class(es): $2$";
            }
        }
        return "(" + ApplicationSchemaMetadata.class.getName() + ") Unknown message with number: " + mnr;
    }

    static {
        printed = false;
        diagnosticsOnly = false;
        schemaTargetNamespace = null;
    }
}

